/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.stats;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.discovery.DiscoveryStats;
import org.elasticsearch.http.HttpStats;
import org.elasticsearch.index.stats.IndexingPressureStats;
import org.elasticsearch.indices.NodeIndicesStats;
import org.elasticsearch.indices.breaker.AllCircuitBreakerStats;
import org.elasticsearch.ingest.IngestStats;
import org.elasticsearch.monitor.fs.FsInfo;
import org.elasticsearch.monitor.jvm.JvmStats;
import org.elasticsearch.monitor.os.OsStats;
import org.elasticsearch.monitor.process.ProcessStats;
import org.elasticsearch.node.AdaptiveSelectionStats;
import org.elasticsearch.script.ScriptCacheStats;
import org.elasticsearch.script.ScriptStats;
import org.elasticsearch.threadpool.ThreadPoolStats;
import org.elasticsearch.transport.TransportStats;

public class NodeStats
extends BaseNodeResponse
implements ToXContentFragment {
    private long timestamp;
    @Nullable
    private NodeIndicesStats indices;
    @Nullable
    private OsStats os;
    @Nullable
    private ProcessStats process;
    @Nullable
    private JvmStats jvm;
    @Nullable
    private ThreadPoolStats threadPool;
    @Nullable
    private FsInfo fs;
    @Nullable
    private TransportStats transport;
    @Nullable
    private HttpStats http;
    @Nullable
    private AllCircuitBreakerStats breaker;
    @Nullable
    private ScriptStats scriptStats;
    @Nullable
    private ScriptCacheStats scriptCacheStats;
    @Nullable
    private DiscoveryStats discoveryStats;
    @Nullable
    private IngestStats ingestStats;
    @Nullable
    private AdaptiveSelectionStats adaptiveSelectionStats;
    @Nullable
    private IndexingPressureStats indexingPressureStats;

    public NodeStats(StreamInput in) throws IOException {
        super(in);
        this.timestamp = in.readVLong();
        if (in.readBoolean()) {
            this.indices = new NodeIndicesStats(in);
        }
        this.os = in.readOptionalWriteable(OsStats::new);
        this.process = in.readOptionalWriteable(ProcessStats::new);
        this.jvm = in.readOptionalWriteable(JvmStats::new);
        this.threadPool = in.readOptionalWriteable(ThreadPoolStats::new);
        this.fs = in.readOptionalWriteable(FsInfo::new);
        this.transport = in.readOptionalWriteable(TransportStats::new);
        this.http = in.readOptionalWriteable(HttpStats::new);
        this.breaker = in.readOptionalWriteable(AllCircuitBreakerStats::new);
        this.scriptStats = in.readOptionalWriteable(ScriptStats::new);
        this.discoveryStats = in.readOptionalWriteable(DiscoveryStats::new);
        this.ingestStats = in.readOptionalWriteable(IngestStats::new);
        this.adaptiveSelectionStats = in.getVersion().onOrAfter(Version.V_6_1_0) ? in.readOptionalWriteable(AdaptiveSelectionStats::new) : null;
        this.scriptCacheStats = null;
        if (in.getVersion().onOrAfter(Version.V_7_8_0)) {
            if (in.getVersion().before(Version.V_7_9_0)) {
                this.scriptCacheStats = in.readOptionalWriteable(ScriptCacheStats::new);
            } else if (this.scriptStats != null) {
                this.scriptCacheStats = this.scriptStats.toScriptCacheStats();
            }
        }
        this.indexingPressureStats = in.getVersion().onOrAfter(Version.V_7_9_0) ? in.readOptionalWriteable(IndexingPressureStats::new) : null;
    }

    public NodeStats(DiscoveryNode node, long timestamp, @Nullable NodeIndicesStats indices, @Nullable OsStats os, @Nullable ProcessStats process, @Nullable JvmStats jvm, @Nullable ThreadPoolStats threadPool, @Nullable FsInfo fs, @Nullable TransportStats transport, @Nullable HttpStats http, @Nullable AllCircuitBreakerStats breaker, @Nullable ScriptStats scriptStats, @Nullable DiscoveryStats discoveryStats, @Nullable IngestStats ingestStats, @Nullable AdaptiveSelectionStats adaptiveSelectionStats, @Nullable ScriptCacheStats scriptCacheStats, @Nullable IndexingPressureStats indexingPressureStats) {
        super(node);
        this.timestamp = timestamp;
        this.indices = indices;
        this.os = os;
        this.process = process;
        this.jvm = jvm;
        this.threadPool = threadPool;
        this.fs = fs;
        this.transport = transport;
        this.http = http;
        this.breaker = breaker;
        this.scriptStats = scriptStats;
        this.discoveryStats = discoveryStats;
        this.ingestStats = ingestStats;
        this.adaptiveSelectionStats = adaptiveSelectionStats;
        this.scriptCacheStats = scriptCacheStats;
        this.indexingPressureStats = indexingPressureStats;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public String getHostname() {
        return this.getNode().getHostName();
    }

    @Nullable
    public NodeIndicesStats getIndices() {
        return this.indices;
    }

    @Nullable
    public OsStats getOs() {
        return this.os;
    }

    @Nullable
    public ProcessStats getProcess() {
        return this.process;
    }

    @Nullable
    public JvmStats getJvm() {
        return this.jvm;
    }

    @Nullable
    public ThreadPoolStats getThreadPool() {
        return this.threadPool;
    }

    @Nullable
    public FsInfo getFs() {
        return this.fs;
    }

    @Nullable
    public TransportStats getTransport() {
        return this.transport;
    }

    @Nullable
    public HttpStats getHttp() {
        return this.http;
    }

    @Nullable
    public AllCircuitBreakerStats getBreaker() {
        return this.breaker;
    }

    @Nullable
    public ScriptStats getScriptStats() {
        return this.scriptStats;
    }

    @Nullable
    public DiscoveryStats getDiscoveryStats() {
        return this.discoveryStats;
    }

    @Nullable
    public IngestStats getIngestStats() {
        return this.ingestStats;
    }

    @Nullable
    public AdaptiveSelectionStats getAdaptiveSelectionStats() {
        return this.adaptiveSelectionStats;
    }

    @Nullable
    public ScriptCacheStats getScriptCacheStats() {
        return this.scriptCacheStats;
    }

    @Nullable
    public IndexingPressureStats getIndexingPressureStats() {
        return this.indexingPressureStats;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.timestamp);
        if (this.indices == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.indices.writeTo(out);
        }
        out.writeOptionalWriteable(this.os);
        out.writeOptionalWriteable(this.process);
        out.writeOptionalWriteable(this.jvm);
        out.writeOptionalWriteable(this.threadPool);
        out.writeOptionalWriteable(this.fs);
        out.writeOptionalWriteable(this.transport);
        out.writeOptionalWriteable(this.http);
        out.writeOptionalWriteable(this.breaker);
        out.writeOptionalWriteable(this.scriptStats);
        out.writeOptionalWriteable(this.discoveryStats);
        out.writeOptionalWriteable(this.ingestStats);
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            out.writeOptionalWriteable(this.adaptiveSelectionStats);
        }
        if (out.getVersion().onOrAfter(Version.V_7_8_0) && out.getVersion().before(Version.V_7_9_0)) {
            out.writeOptionalWriteable(this.scriptCacheStats);
        }
        if (out.getVersion().onOrAfter(Version.V_7_9_0)) {
            out.writeOptionalWriteable(this.indexingPressureStats);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("name", this.getNode().getName());
        builder.field("transport_address", this.getNode().getAddress().toString());
        builder.field("host", this.getNode().getHostName());
        builder.field("ip", this.getNode().getAddress());
        builder.startArray("roles");
        for (DiscoveryNodeRole discoveryNodeRole : this.getNode().getRoles()) {
            builder.value(discoveryNodeRole.roleName());
        }
        builder.endArray();
        if (!this.getNode().getAttributes().isEmpty()) {
            builder.startObject("attributes");
            for (Map.Entry entry : this.getNode().getAttributes().entrySet()) {
                builder.field((String)entry.getKey(), (String)entry.getValue());
            }
            builder.endObject();
        }
        if (this.getIndices() != null) {
            this.getIndices().toXContent(builder, params);
        }
        if (this.getOs() != null) {
            this.getOs().toXContent(builder, params);
        }
        if (this.getProcess() != null) {
            this.getProcess().toXContent(builder, params);
        }
        if (this.getJvm() != null) {
            this.getJvm().toXContent(builder, params);
        }
        if (this.getThreadPool() != null) {
            this.getThreadPool().toXContent(builder, params);
        }
        if (this.getFs() != null) {
            this.getFs().toXContent(builder, params);
        }
        if (this.getTransport() != null) {
            this.getTransport().toXContent(builder, params);
        }
        if (this.getHttp() != null) {
            this.getHttp().toXContent(builder, params);
        }
        if (this.getBreaker() != null) {
            this.getBreaker().toXContent(builder, params);
        }
        if (this.getScriptStats() != null) {
            this.getScriptStats().toXContent(builder, params);
        }
        if (this.getDiscoveryStats() != null) {
            this.getDiscoveryStats().toXContent(builder, params);
        }
        if (this.getIngestStats() != null) {
            this.getIngestStats().toXContent(builder, params);
        }
        if (this.getAdaptiveSelectionStats() != null) {
            this.getAdaptiveSelectionStats().toXContent(builder, params);
        }
        if (this.getScriptCacheStats() != null) {
            this.getScriptCacheStats().toXContent(builder, params);
        }
        if (this.getIndexingPressureStats() != null) {
            this.getIndexingPressureStats().toXContent(builder, params);
        }
        return builder;
    }
}

