/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class ClosePointInTimeRequest
extends ActionRequest
implements ToXContentObject {
    private static final ParseField ID = new ParseField("id", new String[0]);
    private final String id;

    public ClosePointInTimeRequest(StreamInput in) throws IOException {
        super(in);
        this.id = in.readString();
    }

    public ClosePointInTimeRequest(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public ActionRequestValidationException validate() {
        if (Strings.isEmpty(this.id)) {
            throw new IllegalArgumentException("reader id must be specified");
        }
        return null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID.getPreferredName(), this.id);
        builder.endObject();
        return builder;
    }

    public static ClosePointInTimeRequest fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("Malformed content, must start with an object");
        }
        String id = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME && parser.currentName().equals(ID.getPreferredName())) {
                token = parser.nextToken();
                if (!token.isValue()) {
                    throw new IllegalArgumentException("the request must contain only [" + ID.getPreferredName() + " field");
                }
                id = parser.text();
                continue;
            }
            throw new IllegalArgumentException("Unknown parameter [" + parser.currentName() + "] in request body or parameter is of the wrong type[" + (Object)((Object)token) + "] ");
        }
        if (Strings.isNullOrEmpty(id)) {
            throw new IllegalArgumentException("search context id is is not provided");
        }
        return new ClosePointInTimeRequest(id);
    }
}

