/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class NodeShutdownComponentStatus
extends AbstractDiffable<NodeShutdownComponentStatus>
implements ToXContentFragment {
    private final SingleNodeShutdownMetadata.Status status;
    @Nullable
    private final Long startedAtMillis;
    @Nullable
    private final String errorMessage;
    private static final ParseField STATUS_FIELD = new ParseField("status", new String[0]);
    private static final ParseField TIME_STARTED_FIELD = new ParseField("time_started_millis", new String[0]);
    private static final ParseField ERROR_FIELD = new ParseField("error", new String[0]);
    private static final ConstructingObjectParser<NodeShutdownComponentStatus, Void> PARSER = new ConstructingObjectParser("node_shutdown_component", a -> new NodeShutdownComponentStatus(SingleNodeShutdownMetadata.Status.valueOf((String)a[0]), (Long)a[1], (String)a[2]));

    public static NodeShutdownComponentStatus parse(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public NodeShutdownComponentStatus() {
        this(SingleNodeShutdownMetadata.Status.NOT_STARTED, null, null);
    }

    public NodeShutdownComponentStatus(SingleNodeShutdownMetadata.Status status, @Nullable Long startedAtMillis, @Nullable String errorMessage) {
        this.status = status;
        this.startedAtMillis = startedAtMillis;
        this.errorMessage = errorMessage;
    }

    public NodeShutdownComponentStatus(StreamInput in) throws IOException {
        this.status = in.readEnum(SingleNodeShutdownMetadata.Status.class);
        this.startedAtMillis = in.readOptionalVLong();
        this.errorMessage = in.readOptionalString();
    }

    public SingleNodeShutdownMetadata.Status getStatus() {
        return this.status;
    }

    @Nullable
    public Long getStartedAtMillis() {
        return this.startedAtMillis;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(STATUS_FIELD.getPreferredName(), (Object)this.status);
        if (this.startedAtMillis != null) {
            builder.timeField(TIME_STARTED_FIELD.getPreferredName(), "time_started", this.startedAtMillis);
        }
        if (this.errorMessage != null) {
            builder.field(ERROR_FIELD.getPreferredName(), this.errorMessage);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this.status);
        out.writeOptionalVLong(this.startedAtMillis);
        out.writeOptionalString(this.errorMessage);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeShutdownComponentStatus)) {
            return false;
        }
        NodeShutdownComponentStatus that = (NodeShutdownComponentStatus)o;
        return this.getStatus() == that.getStatus() && Objects.equals(this.getStartedAtMillis(), that.getStartedAtMillis()) && Objects.equals(this.getErrorMessage(), that.getErrorMessage());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getStatus(), this.getStartedAtMillis(), this.getErrorMessage()});
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), STATUS_FIELD);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), TIME_STARTED_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), ERROR_FIELD);
    }
}

