/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.command;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RerouteExplanation;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommand;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class MoveAllocationCommand
implements AllocationCommand {
    public static final String NAME = "move";
    public static final ParseField COMMAND_NAME_FIELD = new ParseField("move", new String[0]);
    private final String index;
    private final int shardId;
    private final String fromNode;
    private final String toNode;

    public MoveAllocationCommand(String index, int shardId, String fromNode, String toNode) {
        this.index = index;
        this.shardId = shardId;
        this.fromNode = fromNode;
        this.toNode = toNode;
    }

    public MoveAllocationCommand(StreamInput in) throws IOException {
        this.index = in.readString();
        this.shardId = in.readVInt();
        this.fromNode = in.readString();
        this.toNode = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeVInt(this.shardId);
        out.writeString(this.fromNode);
        out.writeString(this.toNode);
    }

    @Override
    public String name() {
        return NAME;
    }

    public String index() {
        return this.index;
    }

    public int shardId() {
        return this.shardId;
    }

    public String fromNode() {
        return this.fromNode;
    }

    public String toNode() {
        return this.toNode;
    }

    @Override
    public RerouteExplanation execute(RoutingAllocation allocation, boolean explain) {
        DiscoveryNode fromDiscoNode = allocation.nodes().resolveNode(this.fromNode);
        DiscoveryNode toDiscoNode = allocation.nodes().resolveNode(this.toNode);
        Decision decision = null;
        boolean found = false;
        RoutingNode fromRoutingNode = allocation.routingNodes().node(fromDiscoNode.getId());
        if (fromRoutingNode == null && !fromDiscoNode.canContainData()) {
            throw new IllegalArgumentException("[move_allocation] can't move [" + this.index + "][" + this.shardId + "] from " + fromDiscoNode + " to " + toDiscoNode + ": source [" + fromDiscoNode.getName() + "] is not a data node.");
        }
        RoutingNode toRoutingNode = allocation.routingNodes().node(toDiscoNode.getId());
        if (toRoutingNode == null && !toDiscoNode.canContainData()) {
            throw new IllegalArgumentException("[move_allocation] can't move [" + this.index + "][" + this.shardId + "] from " + fromDiscoNode + " to " + toDiscoNode + ": source [" + toDiscoNode.getName() + "] is not a data node.");
        }
        for (ShardRouting shardRouting : fromRoutingNode) {
            if (!shardRouting.shardId().getIndexName().equals(this.index) || shardRouting.shardId().id() != this.shardId) continue;
            found = true;
            if (!shardRouting.started()) {
                if (explain) {
                    return new RerouteExplanation(this, allocation.decision(Decision.NO, "move_allocation_command", "shard " + this.shardId + " has not been started", new Object[0]));
                }
                throw new IllegalArgumentException("[move_allocation] can't move " + this.shardId + ", shard is not started (state = " + (Object)((Object)shardRouting.state()) + "]");
            }
            decision = allocation.deciders().canAllocate(shardRouting, toRoutingNode, allocation);
            if (decision.type() == Decision.Type.NO) {
                if (explain) {
                    return new RerouteExplanation(this, decision);
                }
                throw new IllegalArgumentException("[move_allocation] can't move " + this.shardId + ", from " + fromDiscoNode + ", to " + toDiscoNode + ", since its not allowed, reason: " + decision);
            }
            if (decision.type() == Decision.Type.THROTTLE) {
                // empty if block
            }
            allocation.routingNodes().relocateShard(shardRouting, toRoutingNode.nodeId(), allocation.clusterInfo().getShardSize(shardRouting, -1L), allocation.changes());
        }
        if (!found) {
            if (explain) {
                return new RerouteExplanation(this, allocation.decision(Decision.NO, "move_allocation_command", "shard " + this.shardId + " not found", new Object[0]));
            }
            throw new IllegalArgumentException("[move_allocation] can't move " + this.shardId + ", failed to find it on node " + fromDiscoNode);
        }
        return new RerouteExplanation(this, decision);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("index", this.index());
        builder.field("shard", this.shardId());
        builder.field("from_node", this.fromNode());
        builder.field("to_node", this.toNode());
        return builder.endObject();
    }

    public static MoveAllocationCommand fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String index = null;
        int shardId = -1;
        String fromNode = null;
        String toNode = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if ("index".equals(currentFieldName)) {
                    index = parser.text();
                    continue;
                }
                if ("shard".equals(currentFieldName)) {
                    shardId = parser.intValue();
                    continue;
                }
                if ("from_node".equals(currentFieldName) || "fromNode".equals(currentFieldName)) {
                    fromNode = parser.text();
                    continue;
                }
                if ("to_node".equals(currentFieldName) || "toNode".equals(currentFieldName)) {
                    toNode = parser.text();
                    continue;
                }
                throw new ElasticsearchParseException("[{}] command does not support field [{}]", NAME, currentFieldName);
            }
            throw new ElasticsearchParseException("[{}] command does not support complex json tokens [{}]", new Object[]{NAME, token});
        }
        if (index == null) {
            throw new ElasticsearchParseException("[{}] command missing the index parameter", NAME);
        }
        if (shardId == -1) {
            throw new ElasticsearchParseException("[{}] command missing the shard parameter", NAME);
        }
        if (fromNode == null) {
            throw new ElasticsearchParseException("[{}] command missing the from_node parameter", NAME);
        }
        if (toNode == null) {
            throw new ElasticsearchParseException("[{}] command missing the to_node parameter", NAME);
        }
        return new MoveAllocationCommand(index, shardId, fromNode, toNode);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MoveAllocationCommand other = (MoveAllocationCommand)obj;
        return Objects.equals(this.index, other.index) && Objects.equals(this.shardId, other.shardId) && Objects.equals(this.fromNode, other.fromNode) && Objects.equals(this.toNode, other.toNode);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.shardId, this.fromNode, this.toNode);
    }
}

