/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;

public abstract class AbstractShapeGeometryFieldMapper<T>
extends AbstractGeometryFieldMapper<T> {
    protected Explicit<Boolean> coerce;
    protected Explicit<ShapeBuilder.Orientation> orientation;

    public static FieldMapper.Parameter<Explicit<Boolean>> coerceParam(Function<FieldMapper, Explicit<Boolean>> initializer, boolean coerceByDefault) {
        return FieldMapper.Parameter.explicitBoolParam("coerce", true, initializer, coerceByDefault);
    }

    public static FieldMapper.Parameter<Explicit<ShapeBuilder.Orientation>> orientationParam(Function<FieldMapper, Explicit<ShapeBuilder.Orientation>> initializer) {
        return new FieldMapper.Parameter<Explicit<ShapeBuilder.Orientation>>("orientation", true, () -> new Explicit<ShapeBuilder.Orientation>(ShapeBuilder.Orientation.RIGHT, false), (n, c, o) -> new Explicit<ShapeBuilder.Orientation>(ShapeBuilder.Orientation.fromString(o.toString()), true), initializer).setSerializer((b, f, v) -> b.field(f, v.value()), v -> ((ShapeBuilder.Orientation)((Object)((Object)v.value()))).toString());
    }

    protected AbstractShapeGeometryFieldMapper(String simpleName, MappedFieldType mappedFieldType, Map<String, NamedAnalyzer> indexAnalyzers, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Explicit<Boolean> ignoreZValue, Explicit<ShapeBuilder.Orientation> orientation, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, AbstractGeometryFieldMapper.Parser<T> parser) {
        super(simpleName, mappedFieldType, indexAnalyzers, ignoreMalformed, ignoreZValue, multiFields, copyTo, parser);
        this.coerce = coerce;
        this.orientation = orientation;
    }

    protected AbstractShapeGeometryFieldMapper(String simpleName, MappedFieldType mappedFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Explicit<Boolean> ignoreZValue, Explicit<ShapeBuilder.Orientation> orientation, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, AbstractGeometryFieldMapper.Parser<T> parser) {
        this(simpleName, mappedFieldType, Collections.emptyMap(), ignoreMalformed, coerce, ignoreZValue, orientation, multiFields, copyTo, parser);
    }

    @Override
    public final boolean parsesArrayValue() {
        return false;
    }

    public boolean coerce() {
        return this.coerce.value();
    }

    public ShapeBuilder.Orientation orientation() {
        return this.orientation.value();
    }

    public static abstract class AbstractShapeGeometryFieldType
    extends AbstractGeometryFieldMapper.AbstractGeometryFieldType {
        private final ShapeBuilder.Orientation orientation;

        protected AbstractShapeGeometryFieldType(String name, boolean isSearchable, boolean isStored, boolean hasDocValues, boolean parsesArrayValue, AbstractGeometryFieldMapper.Parser<?> parser, ShapeBuilder.Orientation orientation, Map<String, String> meta) {
            super(name, isSearchable, isStored, hasDocValues, parsesArrayValue, parser, meta);
            this.orientation = orientation;
        }

        public ShapeBuilder.Orientation orientation() {
            return this.orientation;
        }
    }
}

