/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Collections;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.index.mapper.CustomTermFreqField;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;

public class DocCountFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_doc_count";
    public static final String CONTENT_TYPE = "_doc_count";
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.FixedTypeParser(c -> new DocCountFieldMapper());

    private DocCountFieldMapper() {
        super(DocCountFieldType.INSTANCE);
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        XContentParser parser = context.parser();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, parser.currentToken(), parser);
        if (context.doc().getByKey("_doc_count") != null) {
            throw new IllegalArgumentException("Arrays are not allowed for field [" + this.fieldType().name() + "].");
        }
        int value = parser.intValue(false);
        if (value <= 0) {
            throw new IllegalArgumentException("Field [" + this.fieldType().name() + "] must be a positive integer. Value [" + value + "] is not allowed.");
        }
        context.doc().addWithKey("_doc_count", new CustomTermFreqField("_doc_count", (CharSequence)"_doc_count", value));
    }

    @Override
    public DocCountFieldType fieldType() {
        return (DocCountFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return "_doc_count";
    }

    public static final class DocCountFieldType
    extends MappedFieldType {
        public static final DocCountFieldType INSTANCE = new DocCountFieldType();
        public static final int DEFAULT_VALUE = 1;

        public DocCountFieldType() {
            super("_doc_count", false, false, false, TextSearchInfo.NONE, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return "_doc_count";
        }

        @Override
        public String familyTypeName() {
            return NumberFieldMapper.NumberType.INTEGER.typeName();
        }

        @Override
        public Query existsQuery(SearchExecutionContext context) {
            throw new QueryShardException(context, "Field [" + this.name() + "] of type [" + this.typeName() + "] does not support exists queries", new Object[0]);
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new QueryShardException(context, "Field [" + this.name() + "] of type [" + this.typeName() + "] is not searchable", new Object[0]);
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this.name(), context, 1){

                @Override
                protected Object parseSourceValue(Object value) {
                    if ("".equals(value)) {
                        return 1;
                    }
                    return NumberFieldMapper.NumberType.INTEGER.parse(value, false);
                }
            };
        }
    }
}

