/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.LongSet;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.fielddata.DoubleScriptFieldData;
import org.elasticsearch.index.mapper.AbstractScriptFieldType;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.DoubleFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.runtime.DoubleScriptFieldExistsQuery;
import org.elasticsearch.search.runtime.DoubleScriptFieldRangeQuery;
import org.elasticsearch.search.runtime.DoubleScriptFieldTermQuery;
import org.elasticsearch.search.runtime.DoubleScriptFieldTermsQuery;

public final class DoubleScriptFieldType
extends AbstractScriptFieldType<DoubleFieldScript.LeafFactory> {
    static final DoubleFieldScript.Factory PARSE_FROM_SOURCE = (field, params, lookup) -> ctx -> new DoubleFieldScript(field, params, lookup, ctx){

        @Override
        public void execute() {
            for (Object v : this.extractFromSource(field)) {
                if (v instanceof Number) {
                    this.emit(((Number)v).doubleValue());
                    continue;
                }
                if (!(v instanceof String)) continue;
                try {
                    this.emit(Double.parseDouble((String)v));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    };
    public static final RuntimeField.Parser PARSER = new RuntimeField.Parser(name -> new AbstractScriptFieldType.Builder<DoubleFieldScript.Factory>(name, DoubleFieldScript.CONTEXT, PARSE_FROM_SOURCE){

        @Override
        RuntimeField newRuntimeField(DoubleFieldScript.Factory scriptFactory) {
            return new DoubleScriptFieldType(this.name, scriptFactory, this.getScript(), this.meta(), (ToXContent)this);
        }
    });

    public DoubleScriptFieldType(String name) {
        this(name, PARSE_FROM_SOURCE, null, Collections.emptyMap(), (XContentBuilder builder, ToXContent.Params params) -> builder);
    }

    DoubleScriptFieldType(String name, DoubleFieldScript.Factory scriptFactory, Script script, Map<String, String> meta, ToXContent toXContent) {
        super(name, (SearchLookup searchLookup) -> scriptFactory.newFactory(name, script.getParams(), (SearchLookup)searchLookup), script, meta, toXContent);
    }

    @Override
    public String typeName() {
        return NumberFieldMapper.NumberType.DOUBLE.typeName();
    }

    @Override
    public Object valueForDisplay(Object value) {
        return value;
    }

    @Override
    public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
        if (timeZone != null) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
        }
        if (format == null) {
            return DocValueFormat.RAW;
        }
        return new DocValueFormat.Decimal(format);
    }

    @Override
    public DoubleScriptFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
        return new DoubleScriptFieldData.Builder(this.name(), (DoubleFieldScript.LeafFactory)this.leafFactory(searchLookup.get()));
    }

    @Override
    public Query existsQuery(SearchExecutionContext context) {
        this.checkAllowExpensiveQueries(context);
        return new DoubleScriptFieldExistsQuery(this.script, (DoubleFieldScript.LeafFactory)this.leafFactory(context), this.name());
    }

    @Override
    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ZoneId timeZone, DateMathParser parser, SearchExecutionContext context) {
        this.checkAllowExpensiveQueries(context);
        return NumberFieldMapper.NumberType.doubleRangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, (l, u) -> new DoubleScriptFieldRangeQuery(this.script, (DoubleFieldScript.LeafFactory)this.leafFactory(context), this.name(), (double)l, (double)u));
    }

    @Override
    public Query termQuery(Object value, SearchExecutionContext context) {
        this.checkAllowExpensiveQueries(context);
        return new DoubleScriptFieldTermQuery(this.script, (DoubleFieldScript.LeafFactory)this.leafFactory(context), this.name(), NumberFieldMapper.NumberType.objectToDouble(value));
    }

    @Override
    public Query termsQuery(Collection<?> values, SearchExecutionContext context) {
        if (values.isEmpty()) {
            return Queries.newMatchAllQuery();
        }
        LongHashSet terms = new LongHashSet(values.size());
        for (Object value : values) {
            terms.add(Double.doubleToLongBits(NumberFieldMapper.NumberType.objectToDouble(value)));
        }
        this.checkAllowExpensiveQueries(context);
        return new DoubleScriptFieldTermsQuery(this.script, (DoubleFieldScript.LeafFactory)this.leafFactory(context), this.name(), (LongSet)terms);
    }
}

