/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.text.ParseException;
import java.util.function.Consumer;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.geo.GeometryParser;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;

public class GeoShapeParser
extends AbstractGeometryFieldMapper.Parser<Geometry> {
    private final GeometryParser geometryParser;

    public GeoShapeParser(GeometryParser geometryParser) {
        this.geometryParser = geometryParser;
    }

    @Override
    public void parse(XContentParser parser, CheckedConsumer<Geometry, IOException> consumer, Consumer<Exception> onMalformed) throws IOException {
        try {
            consumer.accept(this.geometryParser.parse(parser));
        }
        catch (IllegalArgumentException | ParseException | ElasticsearchParseException e) {
            onMalformed.accept(e);
        }
    }

    @Override
    public Object format(Geometry value, String format) {
        return this.geometryParser.geometryFormat(format).toXContentAsObject(value);
    }
}

