/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.flattened;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.AbstractSortedSetDocValues;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.LeafOrdinalsFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.plain.AbstractLeafOrdinalsFieldData;
import org.elasticsearch.index.mapper.flattened.FlattenedFieldParser;

public class KeyedFlattenedLeafFieldData
implements LeafOrdinalsFieldData {
    private final String key;
    private final LeafOrdinalsFieldData delegate;

    KeyedFlattenedLeafFieldData(String key, LeafOrdinalsFieldData delegate) {
        this.key = key;
        this.delegate = delegate;
    }

    @Override
    public long ramBytesUsed() {
        return this.delegate.ramBytesUsed();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return this.delegate.getChildResources();
    }

    @Override
    public SortedSetDocValues getOrdinalsValues() {
        long maxOrd;
        long minOrd;
        BytesRef keyBytes = new BytesRef(this.key);
        SortedSetDocValues values = this.delegate.getOrdinalsValues();
        try {
            minOrd = KeyedFlattenedLeafFieldData.findMinOrd(keyBytes, values);
            if (minOrd < 0L) {
                return DocValues.emptySortedSet();
            }
            maxOrd = KeyedFlattenedLeafFieldData.findMaxOrd(keyBytes, values);
            assert (maxOrd >= 0L);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new KeyedJsonDocValues(keyBytes, values, minOrd, maxOrd);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public ScriptDocValues<?> getScriptValues() {
        return AbstractLeafOrdinalsFieldData.DEFAULT_SCRIPT_FUNCTION.apply(this.getOrdinalsValues());
    }

    @Override
    public SortedBinaryDocValues getBytesValues() {
        return FieldData.toString(this.getOrdinalsValues());
    }

    static long findMinOrd(BytesRef key, SortedSetDocValues delegate) throws IOException {
        long low = 0L;
        long high = delegate.getValueCount() - 1L;
        long result = -1L;
        while (low <= high) {
            long mid = low + high >>> 1;
            BytesRef term = delegate.lookupOrd(mid);
            int cmp = KeyedFlattenedLeafFieldData.compare(key, term);
            if (cmp == 0) {
                result = mid;
                high = mid - 1L;
                continue;
            }
            if (cmp < 0) {
                high = mid - 1L;
                continue;
            }
            low = mid + 1L;
        }
        return result;
    }

    static long findMaxOrd(BytesRef key, SortedSetDocValues delegate) throws IOException {
        long low = 0L;
        long high = delegate.getValueCount() - 1L;
        long result = -1L;
        while (low <= high) {
            long mid = low + high >>> 1;
            BytesRef term = delegate.lookupOrd(mid);
            int cmp = KeyedFlattenedLeafFieldData.compare(key, term);
            if (cmp == 0) {
                result = mid;
                low = mid + 1L;
                continue;
            }
            if (cmp < 0) {
                high = mid - 1L;
                continue;
            }
            low = mid + 1L;
        }
        return result;
    }

    private static int compare(BytesRef key, BytesRef term) {
        BytesRef extractedKey = FlattenedFieldParser.extractKey(term);
        return key.compareTo(extractedKey);
    }

    private static class KeyedJsonDocValues
    extends AbstractSortedSetDocValues {
        private final BytesRef key;
        private final SortedSetDocValues delegate;
        private final long minOrd;
        private final long maxOrd;
        private long cachedNextOrd;

        private KeyedJsonDocValues(BytesRef key, SortedSetDocValues delegate, long minOrd, long maxOrd) {
            assert (minOrd >= 0L && maxOrd >= 0L);
            this.key = key;
            this.delegate = delegate;
            this.minOrd = minOrd;
            this.maxOrd = maxOrd;
            this.cachedNextOrd = -1L;
        }

        @Override
        public long getValueCount() {
            return this.maxOrd - this.minOrd + 1L;
        }

        @Override
        public BytesRef lookupOrd(long ord) throws IOException {
            long delegateOrd = this.unmapOrd(ord);
            BytesRef keyedValue = this.delegate.lookupOrd(delegateOrd);
            int prefixLength = this.key.length + 1;
            int valueLength = keyedValue.length - prefixLength;
            return new BytesRef(keyedValue.bytes, prefixLength, valueLength);
        }

        @Override
        public long nextOrd() throws IOException {
            if (this.cachedNextOrd >= 0L) {
                long nextOrd = this.cachedNextOrd;
                this.cachedNextOrd = -1L;
                return this.mapOrd(nextOrd);
            }
            long ord = this.delegate.nextOrd();
            if (ord != -1L && ord <= this.maxOrd) {
                assert (ord >= this.minOrd);
                return this.mapOrd(ord);
            }
            return -1L;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            if (this.delegate.advanceExact(target)) {
                long ord;
                while ((ord = this.delegate.nextOrd()) != -1L && ord <= this.maxOrd) {
                    if (ord < this.minOrd) continue;
                    this.cachedNextOrd = ord;
                    return true;
                }
            }
            this.cachedNextOrd = -1L;
            return false;
        }

        private long mapOrd(long ord) {
            assert (this.minOrd <= ord && ord <= this.maxOrd);
            return ord - this.minOrd;
        }

        private long unmapOrd(long ord) {
            assert (0L <= ord && ord <= this.maxOrd - this.minOrd);
            return ord + this.minOrd;
        }
    }
}

