/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParseException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.index.reindex.LeaderBulkByScrollTaskState;
import org.elasticsearch.index.reindex.SuccessfullyProcessed;
import org.elasticsearch.index.reindex.WorkerBulkByScrollTaskState;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskInfo;

public class BulkByScrollTask
extends CancellableTask {
    private volatile LeaderBulkByScrollTaskState leaderState;
    private volatile WorkerBulkByScrollTaskState workerState;

    public BulkByScrollTask(long id, String type, String action, String description, TaskId parentTaskId, Map<String, String> headers) {
        super(id, type, action, description, parentTaskId, headers);
    }

    @Override
    public Status getStatus() {
        if (this.isLeader()) {
            return this.leaderState.getStatus();
        }
        if (this.isWorker()) {
            return this.workerState.getStatus();
        }
        return this.emptyStatus();
    }

    public TaskInfo taskInfoGivenSubtaskInfo(String localNodeId, List<TaskInfo> sliceInfo) {
        if (!this.isLeader()) {
            throw new IllegalStateException("This task is not set to be a leader of other slice subtasks");
        }
        List<StatusOrException> sliceStatuses = Arrays.asList(new StatusOrException[this.leaderState.getSlices()]);
        for (TaskInfo t : sliceInfo) {
            Status status = (Status)t.getStatus();
            sliceStatuses.set(status.getSliceId(), new StatusOrException(status));
        }
        Status status = this.leaderState.getStatus(sliceStatuses);
        return this.taskInfo(localNodeId, this.getDescription(), status);
    }

    private Status emptyStatus() {
        return new Status(Collections.emptyList(), this.getReasonCancelled());
    }

    public boolean isLeader() {
        return this.leaderState != null;
    }

    public void setWorkerCount(int slices) {
        if (this.isLeader()) {
            throw new IllegalStateException("This task is already a leader for other slice subtasks");
        }
        if (this.isWorker()) {
            throw new IllegalStateException("This task is already a worker");
        }
        this.leaderState = new LeaderBulkByScrollTaskState(this, slices);
    }

    public LeaderBulkByScrollTaskState getLeaderState() {
        if (!this.isLeader()) {
            throw new IllegalStateException("This task is not set to be a leader for other slice subtasks");
        }
        return this.leaderState;
    }

    public boolean isWorker() {
        return this.workerState != null;
    }

    public void setWorker(float requestsPerSecond, @Nullable Integer sliceId) {
        if (this.isWorker()) {
            throw new IllegalStateException("This task is already a worker");
        }
        if (this.isLeader()) {
            throw new IllegalStateException("This task is already a leader for other slice subtasks");
        }
        this.workerState = new WorkerBulkByScrollTaskState(this, sliceId, requestsPerSecond);
        if (this.isCancelled()) {
            this.workerState.handleCancel();
        }
    }

    public WorkerBulkByScrollTaskState getWorkerState() {
        if (!this.isWorker()) {
            throw new IllegalStateException("This task is not set to be a worker");
        }
        return this.workerState;
    }

    @Override
    public void onCancelled() {
        if (this.isWorker()) {
            this.workerState.handleCancel();
        }
    }

    public static class Status
    implements Task.Status,
    SuccessfullyProcessed {
        public static final String NAME = "bulk-by-scroll";
        public static final String INCLUDE_CREATED = "include_created";
        public static final String INCLUDE_UPDATED = "include_updated";
        public static final String SLICE_ID_FIELD = "slice_id";
        public static final String TOTAL_FIELD = "total";
        public static final String UPDATED_FIELD = "updated";
        public static final String CREATED_FIELD = "created";
        public static final String DELETED_FIELD = "deleted";
        public static final String BATCHES_FIELD = "batches";
        public static final String VERSION_CONFLICTS_FIELD = "version_conflicts";
        public static final String NOOPS_FIELD = "noops";
        public static final String RETRIES_FIELD = "retries";
        public static final String RETRIES_BULK_FIELD = "bulk";
        public static final String RETRIES_SEARCH_FIELD = "search";
        public static final String THROTTLED_RAW_FIELD = "throttled_millis";
        public static final String THROTTLED_HR_FIELD = "throttled";
        public static final String REQUESTS_PER_SEC_FIELD = "requests_per_second";
        public static final String CANCELED_FIELD = "canceled";
        public static final String THROTTLED_UNTIL_RAW_FIELD = "throttled_until_millis";
        public static final String THROTTLED_UNTIL_HR_FIELD = "throttled_until";
        public static final String SLICES_FIELD = "slices";
        public static Set<String> FIELDS_SET = new HashSet<String>();
        static final ConstructingObjectParser<Tuple<Long, Long>, Void> RETRIES_PARSER;
        private final Integer sliceId;
        private final long total;
        private final long updated;
        private final long created;
        private final long deleted;
        private final int batches;
        private final long versionConflicts;
        private final long noops;
        private final long bulkRetries;
        private final long searchRetries;
        private final TimeValue throttled;
        private final float requestsPerSecond;
        private final String reasonCancelled;
        private final TimeValue throttledUntil;
        private final List<StatusOrException> sliceStatuses;

        public static void declareFields(ObjectParser<? extends StatusBuilder, Void> parser) {
            parser.declareInt(StatusBuilder::setSliceId, new ParseField(SLICE_ID_FIELD, new String[0]));
            parser.declareLong(StatusBuilder::setTotal, new ParseField(TOTAL_FIELD, new String[0]));
            parser.declareLong(StatusBuilder::setUpdated, new ParseField(UPDATED_FIELD, new String[0]));
            parser.declareLong(StatusBuilder::setCreated, new ParseField(CREATED_FIELD, new String[0]));
            parser.declareLong(StatusBuilder::setDeleted, new ParseField(DELETED_FIELD, new String[0]));
            parser.declareInt(StatusBuilder::setBatches, new ParseField(BATCHES_FIELD, new String[0]));
            parser.declareLong(StatusBuilder::setVersionConflicts, new ParseField(VERSION_CONFLICTS_FIELD, new String[0]));
            parser.declareLong(StatusBuilder::setNoops, new ParseField(NOOPS_FIELD, new String[0]));
            parser.declareObject(StatusBuilder::setRetries, RETRIES_PARSER, new ParseField(RETRIES_FIELD, new String[0]));
            parser.declareLong(StatusBuilder::setThrottled, new ParseField(THROTTLED_RAW_FIELD, new String[0]));
            parser.declareFloat(StatusBuilder::setRequestsPerSecond, new ParseField(REQUESTS_PER_SEC_FIELD, new String[0]));
            parser.declareString(StatusBuilder::setReasonCancelled, new ParseField(CANCELED_FIELD, new String[0]));
            parser.declareLong(StatusBuilder::setThrottledUntil, new ParseField(THROTTLED_UNTIL_RAW_FIELD, new String[0]));
            parser.declareObjectArray(StatusBuilder::setSliceStatuses, (p, c) -> StatusOrException.fromXContent(p), new ParseField(SLICES_FIELD, new String[0]));
        }

        public Status(Integer sliceId, long total, long updated, long created, long deleted, int batches, long versionConflicts, long noops, long bulkRetries, long searchRetries, TimeValue throttled, float requestsPerSecond, @Nullable String reasonCancelled, TimeValue throttledUntil) {
            this.sliceId = sliceId == null ? null : Integer.valueOf(this.checkPositive(sliceId, "sliceId"));
            this.total = this.checkPositive(total, TOTAL_FIELD);
            this.updated = this.checkPositive(updated, UPDATED_FIELD);
            this.created = this.checkPositive(created, CREATED_FIELD);
            this.deleted = this.checkPositive(deleted, DELETED_FIELD);
            this.batches = this.checkPositive(batches, BATCHES_FIELD);
            this.versionConflicts = this.checkPositive(versionConflicts, "versionConflicts");
            this.noops = this.checkPositive(noops, NOOPS_FIELD);
            this.bulkRetries = this.checkPositive(bulkRetries, "bulkRetries");
            this.searchRetries = this.checkPositive(searchRetries, "searchRetries");
            this.throttled = throttled;
            this.requestsPerSecond = requestsPerSecond;
            this.reasonCancelled = reasonCancelled;
            this.throttledUntil = throttledUntil;
            this.sliceStatuses = Collections.emptyList();
        }

        public Status(List<StatusOrException> sliceStatuses, @Nullable String reasonCancelled) {
            this.sliceId = null;
            this.reasonCancelled = reasonCancelled;
            long mergedTotal = 0L;
            long mergedUpdated = 0L;
            long mergedCreated = 0L;
            long mergedDeleted = 0L;
            int mergedBatches = 0;
            long mergedVersionConflicts = 0L;
            long mergedNoops = 0L;
            long mergedBulkRetries = 0L;
            long mergedSearchRetries = 0L;
            long mergedThrottled = 0L;
            float mergedRequestsPerSecond = 0.0f;
            long mergedThrottledUntil = Long.MAX_VALUE;
            for (StatusOrException slice : sliceStatuses) {
                if (slice == null || slice.status == null) continue;
                mergedTotal += slice.status.getTotal();
                mergedUpdated += slice.status.getUpdated();
                mergedCreated += slice.status.getCreated();
                mergedDeleted += slice.status.getDeleted();
                mergedBatches += slice.status.getBatches();
                mergedVersionConflicts += slice.status.getVersionConflicts();
                mergedNoops += slice.status.getNoops();
                mergedBulkRetries += slice.status.getBulkRetries();
                mergedSearchRetries += slice.status.getSearchRetries();
                mergedThrottled += slice.status.getThrottled().nanos();
                mergedRequestsPerSecond += slice.status.getRequestsPerSecond();
                mergedThrottledUntil = Math.min(mergedThrottledUntil, slice.status.getThrottledUntil().nanos());
            }
            this.total = mergedTotal;
            this.updated = mergedUpdated;
            this.created = mergedCreated;
            this.deleted = mergedDeleted;
            this.batches = mergedBatches;
            this.versionConflicts = mergedVersionConflicts;
            this.noops = mergedNoops;
            this.bulkRetries = mergedBulkRetries;
            this.searchRetries = mergedSearchRetries;
            this.throttled = TimeValue.timeValueNanos(mergedThrottled);
            this.requestsPerSecond = mergedRequestsPerSecond;
            this.throttledUntil = TimeValue.timeValueNanos(mergedThrottledUntil == Long.MAX_VALUE ? 0L : mergedThrottledUntil);
            this.sliceStatuses = sliceStatuses;
        }

        public Status(StreamInput in) throws IOException {
            this.sliceId = in.readOptionalVInt();
            this.total = in.readVLong();
            this.updated = in.readVLong();
            this.created = in.readVLong();
            this.deleted = in.readVLong();
            this.batches = in.readVInt();
            this.versionConflicts = in.readVLong();
            this.noops = in.readVLong();
            this.bulkRetries = in.readVLong();
            this.searchRetries = in.readVLong();
            this.throttled = in.readTimeValue();
            this.requestsPerSecond = in.readFloat();
            this.reasonCancelled = in.readOptionalString();
            this.throttledUntil = in.readTimeValue();
            this.sliceStatuses = in.readList(stream -> stream.readOptionalWriteable(StatusOrException::new));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalVInt(this.sliceId);
            out.writeVLong(this.total);
            out.writeVLong(this.updated);
            out.writeVLong(this.created);
            out.writeVLong(this.deleted);
            out.writeVInt(this.batches);
            out.writeVLong(this.versionConflicts);
            out.writeVLong(this.noops);
            out.writeVLong(this.bulkRetries);
            out.writeVLong(this.searchRetries);
            out.writeTimeValue(this.throttled);
            out.writeFloat(this.requestsPerSecond);
            out.writeOptionalString(this.reasonCancelled);
            out.writeTimeValue(this.throttledUntil);
            out.writeVInt(this.sliceStatuses.size());
            for (StatusOrException sliceStatus : this.sliceStatuses) {
                out.writeOptionalWriteable(sliceStatus);
            }
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.innerXContent(builder, params);
            return builder.endObject();
        }

        public XContentBuilder innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.sliceId != null) {
                builder.field(SLICE_ID_FIELD, this.sliceId);
            }
            builder.field(TOTAL_FIELD, this.total);
            if (params.paramAsBoolean(INCLUDE_UPDATED, true)) {
                builder.field(UPDATED_FIELD, this.updated);
            }
            if (params.paramAsBoolean(INCLUDE_CREATED, true)) {
                builder.field(CREATED_FIELD, this.created);
            }
            builder.field(DELETED_FIELD, this.deleted);
            builder.field(BATCHES_FIELD, this.batches);
            builder.field(VERSION_CONFLICTS_FIELD, this.versionConflicts);
            builder.field(NOOPS_FIELD, this.noops);
            builder.startObject(RETRIES_FIELD);
            builder.field(RETRIES_BULK_FIELD, this.bulkRetries);
            builder.field(RETRIES_SEARCH_FIELD, this.searchRetries);
            builder.endObject();
            builder.humanReadableField(THROTTLED_RAW_FIELD, THROTTLED_HR_FIELD, this.throttled);
            builder.field(REQUESTS_PER_SEC_FIELD, this.requestsPerSecond == Float.POSITIVE_INFINITY ? -1.0f : this.requestsPerSecond);
            if (this.reasonCancelled != null) {
                builder.field(CANCELED_FIELD, this.reasonCancelled);
            }
            builder.humanReadableField(THROTTLED_UNTIL_RAW_FIELD, THROTTLED_UNTIL_HR_FIELD, this.throttledUntil);
            if (!this.sliceStatuses.isEmpty()) {
                builder.startArray(SLICES_FIELD);
                for (StatusOrException slice : this.sliceStatuses) {
                    if (slice == null) {
                        builder.nullValue();
                        continue;
                    }
                    slice.toXContent(builder, params);
                }
                builder.endArray();
            }
            return builder;
        }

        public static Status fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.currentToken() == XContentParser.Token.START_OBJECT ? parser.nextToken() : parser.nextToken();
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
            token = parser.nextToken();
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
            return Status.innerFromXContent(parser);
        }

        public static Status innerFromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.currentToken();
            String fieldName = parser.currentName();
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
            StatusBuilder builder = new StatusBuilder();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    fieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if (fieldName.equals(RETRIES_FIELD)) {
                        builder.setRetries(RETRIES_PARSER.parse(parser, null));
                        continue;
                    }
                    parser.skipChildren();
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if (fieldName.equals(SLICES_FIELD)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            builder.addToSliceStatuses(StatusOrException.fromXContent(parser));
                        }
                        continue;
                    }
                    parser.skipChildren();
                    continue;
                }
                switch (fieldName) {
                    case "slice_id": {
                        builder.setSliceId(parser.intValue());
                        break;
                    }
                    case "total": {
                        builder.setTotal(parser.longValue());
                        break;
                    }
                    case "updated": {
                        builder.setUpdated(parser.longValue());
                        break;
                    }
                    case "created": {
                        builder.setCreated(parser.longValue());
                        break;
                    }
                    case "deleted": {
                        builder.setDeleted(parser.longValue());
                        break;
                    }
                    case "batches": {
                        builder.setBatches(parser.intValue());
                        break;
                    }
                    case "version_conflicts": {
                        builder.setVersionConflicts(parser.longValue());
                        break;
                    }
                    case "noops": {
                        builder.setNoops(parser.longValue());
                        break;
                    }
                    case "throttled_millis": {
                        builder.setThrottled(parser.longValue());
                        break;
                    }
                    case "requests_per_second": {
                        builder.setRequestsPerSecond(Float.valueOf(parser.floatValue()));
                        break;
                    }
                    case "canceled": {
                        builder.setReasonCancelled(parser.text());
                        break;
                    }
                    case "throttled_until_millis": {
                        builder.setThrottledUntil(parser.longValue());
                        break;
                    }
                }
            }
            return builder.buildStatus();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("BulkIndexByScrollResponse[");
            this.innerToString(builder);
            return builder.append(']').toString();
        }

        public void innerToString(StringBuilder builder) {
            builder.append("sliceId=").append(this.sliceId);
            builder.append(",updated=").append(this.updated);
            builder.append(",created=").append(this.created);
            builder.append(",deleted=").append(this.deleted);
            builder.append(",batches=").append(this.batches);
            builder.append(",versionConflicts=").append(this.versionConflicts);
            builder.append(",noops=").append(this.noops);
            builder.append(",retries=").append(this.bulkRetries);
            if (this.reasonCancelled != null) {
                builder.append(",canceled=").append(this.reasonCancelled);
            }
            builder.append(",throttledUntil=").append(this.throttledUntil);
            if (!this.sliceStatuses.isEmpty()) {
                builder.append(",workers=").append(this.sliceStatuses);
            }
        }

        Integer getSliceId() {
            return this.sliceId;
        }

        public long getTotal() {
            return this.total;
        }

        @Override
        public long getUpdated() {
            return this.updated;
        }

        @Override
        public long getCreated() {
            return this.created;
        }

        @Override
        public long getDeleted() {
            return this.deleted;
        }

        public int getBatches() {
            return this.batches;
        }

        public long getVersionConflicts() {
            return this.versionConflicts;
        }

        public long getNoops() {
            return this.noops;
        }

        public long getBulkRetries() {
            return this.bulkRetries;
        }

        public long getSearchRetries() {
            return this.searchRetries;
        }

        public TimeValue getThrottled() {
            return this.throttled;
        }

        public float getRequestsPerSecond() {
            return this.requestsPerSecond;
        }

        public String getReasonCancelled() {
            return this.reasonCancelled;
        }

        public TimeValue getThrottledUntil() {
            return this.throttledUntil;
        }

        public List<StatusOrException> getSliceStatuses() {
            return this.sliceStatuses;
        }

        public int hashCode() {
            return Objects.hash(this.sliceId, this.total, this.updated, this.created, this.deleted, this.batches, this.versionConflicts, this.noops, this.searchRetries, this.bulkRetries, this.throttled, Float.valueOf(this.requestsPerSecond), this.reasonCancelled, this.throttledUntil, this.sliceStatuses);
        }

        public boolean equalsWithoutSliceStatus(Object o, boolean includeUpdated, boolean includeCreated) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status other = (Status)o;
            return !(!Objects.equals(this.sliceId, other.sliceId) || this.total != other.total || includeUpdated && this.updated != other.updated || includeCreated && this.created != other.created || this.deleted != other.deleted || this.batches != other.batches || this.versionConflicts != other.versionConflicts || this.noops != other.noops || this.searchRetries != other.searchRetries || this.bulkRetries != other.bulkRetries || !Objects.equals(this.throttled, other.throttled) || this.requestsPerSecond != other.requestsPerSecond || !Objects.equals(this.reasonCancelled, other.reasonCancelled) || !Objects.equals(this.throttledUntil, other.throttledUntil));
        }

        public boolean equals(Object o) {
            if (this.equalsWithoutSliceStatus(o, true, true)) {
                return Objects.equals(this.sliceStatuses, ((Status)o).sliceStatuses);
            }
            return false;
        }

        private int checkPositive(int value, String name) {
            if (value < 0) {
                throw new IllegalArgumentException(name + " must be greater than 0 but was [" + value + "]");
            }
            return value;
        }

        private long checkPositive(long value, String name) {
            if (value < 0L) {
                throw new IllegalArgumentException(name + " must be greater than 0 but was [" + value + "]");
            }
            return value;
        }

        static {
            FIELDS_SET.add(SLICE_ID_FIELD);
            FIELDS_SET.add(TOTAL_FIELD);
            FIELDS_SET.add(UPDATED_FIELD);
            FIELDS_SET.add(CREATED_FIELD);
            FIELDS_SET.add(DELETED_FIELD);
            FIELDS_SET.add(BATCHES_FIELD);
            FIELDS_SET.add(VERSION_CONFLICTS_FIELD);
            FIELDS_SET.add(NOOPS_FIELD);
            FIELDS_SET.add(RETRIES_FIELD);
            FIELDS_SET.add(THROTTLED_RAW_FIELD);
            FIELDS_SET.add(THROTTLED_HR_FIELD);
            FIELDS_SET.add(REQUESTS_PER_SEC_FIELD);
            FIELDS_SET.add(CANCELED_FIELD);
            FIELDS_SET.add(THROTTLED_UNTIL_RAW_FIELD);
            FIELDS_SET.add(THROTTLED_UNTIL_HR_FIELD);
            FIELDS_SET.add(SLICES_FIELD);
            RETRIES_PARSER = new ConstructingObjectParser("bulk_by_scroll_task_status_retries", true, a -> new Tuple<Object, Object>(a[0], a[1]));
            RETRIES_PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField(RETRIES_BULK_FIELD, new String[0]));
            RETRIES_PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField(RETRIES_SEARCH_FIELD, new String[0]));
        }
    }

    public static class StatusOrException
    implements Writeable,
    ToXContentObject {
        private final Status status;
        private final Exception exception;
        public static Set<String> EXPECTED_EXCEPTION_FIELDS = new HashSet<String>();

        public StatusOrException(Status status) {
            this.status = status;
            this.exception = null;
        }

        public StatusOrException(Exception exception) {
            this.status = null;
            this.exception = exception;
        }

        public StatusOrException(StreamInput in) throws IOException {
            if (in.readBoolean()) {
                this.status = new Status(in);
                this.exception = null;
            } else {
                this.status = null;
                this.exception = in.readException();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (this.exception == null) {
                out.writeBoolean(true);
                this.status.writeTo(out);
            } else {
                out.writeBoolean(false);
                out.writeException(this.exception);
            }
        }

        public Status getStatus() {
            return this.status;
        }

        public Exception getException() {
            return this.exception;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.exception == null) {
                this.status.toXContent(builder, params);
            } else {
                builder.startObject();
                ElasticsearchException.generateThrowableXContent(builder, params, this.exception);
                builder.endObject();
            }
            return builder;
        }

        public static StatusOrException fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.currentToken();
            if (token == null) {
                token = parser.nextToken();
            }
            if (token == XContentParser.Token.VALUE_NULL) {
                return null;
            }
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
            token = parser.nextToken();
            while (token != XContentParser.Token.END_OBJECT) {
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
                String fieldName = parser.currentName();
                if (Status.FIELDS_SET.contains(fieldName)) {
                    return new StatusOrException(Status.innerFromXContent(parser));
                }
                if (EXPECTED_EXCEPTION_FIELDS.contains(fieldName)) {
                    return new StatusOrException(ElasticsearchException.innerFromXContent(parser, false));
                }
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT || token == XContentParser.Token.START_ARRAY) {
                    parser.skipChildren();
                }
                token = parser.nextToken();
            }
            throw new XContentParseException("Unable to parse StatusFromException. Expected fields not found.");
        }

        public String toString() {
            if (this.exception != null) {
                return "BulkByScrollTask{error=" + Strings.toString(this) + "}";
            }
            return "BulkByScrollTask{status=" + Strings.toString(this) + "}";
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != StatusOrException.class) {
                return false;
            }
            StatusOrException other = (StatusOrException)obj;
            return Objects.equals(this.status, other.status) && Objects.equals(this.exception, other.exception);
        }

        public int hashCode() {
            return Objects.hash(this.status, this.exception);
        }

        static {
            EXPECTED_EXCEPTION_FIELDS.add("type");
            EXPECTED_EXCEPTION_FIELDS.add("reason");
            EXPECTED_EXCEPTION_FIELDS.add("caused_by");
            EXPECTED_EXCEPTION_FIELDS.add("suppressed");
            EXPECTED_EXCEPTION_FIELDS.add("stack_trace");
            EXPECTED_EXCEPTION_FIELDS.add("header");
            EXPECTED_EXCEPTION_FIELDS.add("error");
            EXPECTED_EXCEPTION_FIELDS.add("root_cause");
        }
    }

    public static class StatusBuilder {
        private Integer sliceId = null;
        private Long total = null;
        private long updated = 0L;
        private long created = 0L;
        private Long deleted = null;
        private Integer batches = null;
        private Long versionConflicts = null;
        private Long noops = null;
        private Long bulkRetries = null;
        private Long searchRetries = null;
        private TimeValue throttled = null;
        private Float requestsPerSecond = null;
        private String reasonCancelled = null;
        private TimeValue throttledUntil = null;
        private List<StatusOrException> sliceStatuses = new ArrayList<StatusOrException>();

        public void setSliceId(Integer sliceId) {
            this.sliceId = sliceId;
        }

        public void setTotal(Long total) {
            this.total = total;
        }

        public void setUpdated(Long updated) {
            this.updated = updated;
        }

        public void setCreated(Long created) {
            this.created = created;
        }

        public void setDeleted(Long deleted) {
            this.deleted = deleted;
        }

        public void setBatches(Integer batches) {
            this.batches = batches;
        }

        public void setVersionConflicts(Long versionConflicts) {
            this.versionConflicts = versionConflicts;
        }

        public void setNoops(Long noops) {
            this.noops = noops;
        }

        public void setRetries(Tuple<Long, Long> retries) {
            if (retries != null) {
                this.setBulkRetries(retries.v1());
                this.setSearchRetries(retries.v2());
            }
        }

        public void setBulkRetries(Long bulkRetries) {
            this.bulkRetries = bulkRetries;
        }

        public void setSearchRetries(Long searchRetries) {
            this.searchRetries = searchRetries;
        }

        public void setThrottled(Long throttled) {
            if (throttled != null) {
                this.throttled = new TimeValue(throttled, TimeUnit.MILLISECONDS);
            }
        }

        public void setRequestsPerSecond(Float requestsPerSecond) {
            if (requestsPerSecond != null) {
                this.requestsPerSecond = requestsPerSecond = Float.valueOf(requestsPerSecond.floatValue() == -1.0f ? Float.POSITIVE_INFINITY : requestsPerSecond.floatValue());
            }
        }

        public void setReasonCancelled(String reasonCancelled) {
            this.reasonCancelled = reasonCancelled;
        }

        public void setThrottledUntil(Long throttledUntil) {
            if (throttledUntil != null) {
                this.throttledUntil = new TimeValue(throttledUntil, TimeUnit.MILLISECONDS);
            }
        }

        public void setSliceStatuses(List<StatusOrException> sliceStatuses) {
            if (sliceStatuses != null) {
                this.sliceStatuses.addAll(sliceStatuses);
            }
        }

        public void addToSliceStatuses(StatusOrException statusOrException) {
            this.sliceStatuses.add(statusOrException);
        }

        public Status buildStatus() {
            if (this.sliceStatuses.isEmpty()) {
                try {
                    return new Status(this.sliceId, this.total, this.updated, this.created, this.deleted, this.batches, this.versionConflicts, this.noops, this.bulkRetries, this.searchRetries, this.throttled, this.requestsPerSecond.floatValue(), this.reasonCancelled, this.throttledUntil);
                }
                catch (NullPointerException npe) {
                    throw new IllegalArgumentException("a required field is null when building Status");
                }
            }
            return new Status(this.sliceStatuses, this.reasonCancelled);
        }
    }
}

