/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;

public class SystemDataStreamDescriptor {
    private final String dataStreamName;
    private final String description;
    private final Type type;
    private final ComposableIndexTemplate composableIndexTemplate;
    private final Map<String, ComponentTemplate> componentTemplates;
    private final List<String> allowedElasticProductOrigins;

    public SystemDataStreamDescriptor(String dataStreamName, String description, Type type, ComposableIndexTemplate composableIndexTemplate, Map<String, ComponentTemplate> componentTemplates, List<String> allowedElasticProductOrigins) {
        this.dataStreamName = Objects.requireNonNull(dataStreamName, "dataStreamName must be specified");
        this.description = Objects.requireNonNull(description, "description must be specified");
        this.type = Objects.requireNonNull(type, "type must be specified");
        this.composableIndexTemplate = Objects.requireNonNull(composableIndexTemplate, "composableIndexTemplate must be provided");
        this.componentTemplates = componentTemplates == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, ComponentTemplate>(componentTemplates));
        this.allowedElasticProductOrigins = Objects.requireNonNull(allowedElasticProductOrigins, "allowedElasticProductOrigins must not be null");
        if (type == Type.EXTERNAL && allowedElasticProductOrigins.isEmpty()) {
            throw new IllegalArgumentException("External system data stream without allowed products is not a valid combination");
        }
    }

    public String getDataStreamName() {
        return this.dataStreamName;
    }

    public String getDescription() {
        return this.description;
    }

    public ComposableIndexTemplate getComposableIndexTemplate() {
        return this.composableIndexTemplate;
    }

    public boolean isExternal() {
        return this.type == Type.EXTERNAL;
    }

    public String getBackingIndexPattern() {
        return ".ds-" + this.getDataStreamName() + "-*";
    }

    public List<String> getAllowedElasticProductOrigins() {
        return this.allowedElasticProductOrigins;
    }

    public Map<String, ComponentTemplate> getComponentTemplates() {
        return this.componentTemplates;
    }

    public static enum Type {
        INTERNAL,
        EXTERNAL;

    }
}

