/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;

final class MethodHandlers {
    private final String path;
    private final Map<RestRequest.Method, RestHandler> methodHandlers;

    MethodHandlers(String path) {
        this.path = path;
        this.methodHandlers = new HashMap<RestRequest.Method, RestHandler>(2, 1.0f);
    }

    MethodHandlers addMethod(RestRequest.Method method, RestHandler handler) {
        RestHandler existing = this.methodHandlers.putIfAbsent(method, handler);
        if (existing != null) {
            throw new IllegalArgumentException("Cannot replace existing handler for [" + this.path + "] for method: " + (Object)((Object)method));
        }
        return this;
    }

    @Nullable
    RestHandler getHandler(RestRequest.Method method) {
        return this.methodHandlers.get((Object)method);
    }

    Set<RestRequest.Method> getValidMethods() {
        return this.methodHandlers.keySet();
    }
}

