/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.BitSet;
import org.elasticsearch.Version;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.search.LeafNestedDocuments;
import org.elasticsearch.search.SearchHit;

public class NestedDocuments {
    private final Map<String, BitSetProducer> parentObjectFilters = new HashMap<String, BitSetProducer>();
    private final Map<String, Weight> childObjectFilters = new HashMap<String, Weight>();
    private final Map<String, ObjectMapper> childObjectMappers = new HashMap<String, ObjectMapper>();
    private final BitSetProducer parentDocumentFilter;
    private final MappingLookup mappingLookup;
    private final Version indexVersionCreated;

    public NestedDocuments(MappingLookup mappingLookup, Version indexVersionCreated, Function<Query, BitSetProducer> filterProducer) {
        this.mappingLookup = mappingLookup;
        this.indexVersionCreated = indexVersionCreated;
        if (!mappingLookup.hasNested()) {
            this.parentDocumentFilter = null;
        } else {
            this.parentDocumentFilter = filterProducer.apply(Queries.newNonNestedFilter(indexVersionCreated));
            for (ObjectMapper mapper : mappingLookup.getNestedParentMappers()) {
                this.parentObjectFilters.put(mapper.name(), filterProducer.apply(mapper.nestedTypeFilter()));
            }
            for (ObjectMapper mapper : mappingLookup.getNestedMappers()) {
                this.childObjectFilters.put(mapper.name(), null);
                this.childObjectMappers.put(mapper.name(), mapper);
            }
        }
    }

    public LeafNestedDocuments getLeafNestedDocuments(LeafReaderContext ctx) throws IOException {
        if (this.parentDocumentFilter == null) {
            return LeafNestedDocuments.NO_NESTED_MAPPERS;
        }
        return new HasNestedDocuments(ctx);
    }

    private Weight getNestedChildWeight(LeafReaderContext ctx, String path) throws IOException {
        if (!this.childObjectFilters.containsKey(path) || !this.childObjectMappers.containsKey(path)) {
            throw new IllegalStateException("Cannot find object mapper for path " + path);
        }
        if (this.childObjectFilters.get(path) == null) {
            IndexSearcher searcher = new IndexSearcher(ReaderUtil.getTopLevelContext(ctx));
            ObjectMapper childMapper = this.childObjectMappers.get(path);
            this.childObjectFilters.put(path, searcher.createWeight(searcher.rewrite(childMapper.nestedTypeFilter()), ScoreMode.COMPLETE_NO_SCORES, 1.0f));
        }
        return this.childObjectFilters.get(path);
    }

    public boolean hasNonNestedParent(String path) {
        return this.mappingLookup.hasNonNestedParent(path);
    }

    private class HasNestedDocuments
    implements LeafNestedDocuments {
        final LeafReaderContext ctx;
        final BitSet parentFilter;
        final Map<String, BitSet> objectFilters = new HashMap<String, BitSet>();
        final Map<String, Scorer> childScorers = new HashMap<String, Scorer>();
        int doc = -1;
        int rootDoc = -1;
        SearchHit.NestedIdentity nestedIdentity = null;

        private HasNestedDocuments(LeafReaderContext ctx) throws IOException {
            this.ctx = ctx;
            this.parentFilter = NestedDocuments.this.parentDocumentFilter.getBitSet(ctx);
            for (Map.Entry filter : NestedDocuments.this.parentObjectFilters.entrySet()) {
                BitSet bits = ((BitSetProducer)filter.getValue()).getBitSet(ctx);
                if (bits == null) continue;
                this.objectFilters.put((String)filter.getKey(), bits);
            }
            for (Map.Entry childFilter : NestedDocuments.this.childObjectFilters.entrySet()) {
                Scorer scorer = NestedDocuments.this.getNestedChildWeight(ctx, (String)childFilter.getKey()).scorer(ctx);
                if (scorer == null) continue;
                this.childScorers.put((String)childFilter.getKey(), scorer);
            }
        }

        @Override
        public SearchHit.NestedIdentity advance(int doc) throws IOException {
            assert (doc >= 0 && doc < this.ctx.reader().maxDoc());
            if (this.parentFilter.get(doc)) {
                this.nestedIdentity = null;
                this.doc = doc;
                this.rootDoc = doc;
                return null;
            }
            this.doc = doc;
            this.rootDoc = this.parentFilter.nextSetBit(doc);
            this.nestedIdentity = this.loadNestedIdentity();
            return this.nestedIdentity;
        }

        @Override
        public int doc() {
            assert (this.doc != -1) : "Called doc() when unpositioned";
            return this.doc;
        }

        @Override
        public int rootDoc() {
            assert (this.doc != -1) : "Called rootDoc() when unpositioned";
            return this.rootDoc;
        }

        @Override
        public SearchHit.NestedIdentity nestedIdentity() {
            assert (this.doc != -1) : "Called nestedIdentity() when unpositioned";
            return this.nestedIdentity;
        }

        private String findObjectPath(int doc) throws IOException {
            String path = null;
            for (Map.Entry<String, Scorer> objectFilter : this.childScorers.entrySet()) {
                DocIdSetIterator it = objectFilter.getValue().iterator();
                if (it.docID() != doc && (it.docID() >= doc || it.advance(doc) != doc) || path != null && path.length() <= objectFilter.getKey().length()) continue;
                path = objectFilter.getKey();
            }
            if (path == null) {
                throw new IllegalStateException("Cannot find object path for document " + doc);
            }
            return path;
        }

        private SearchHit.NestedIdentity loadNestedIdentity() throws IOException {
            SearchHit.NestedIdentity ni = null;
            int currentLevelDoc = this.doc;
            String path = this.findObjectPath(this.doc);
            while (path != null) {
                int parentNameLength;
                BitSet parentBitSet;
                String parent = NestedDocuments.this.mappingLookup.getNestedParent(path);
                Scorer childScorer = NestedDocuments.this.getNestedChildWeight(this.ctx, path).scorer(this.ctx);
                if (childScorer == null) {
                    throw new IllegalStateException("Cannot find object mapper for path " + path + " in doc " + this.doc);
                }
                if (parent == null) {
                    parentBitSet = this.parentFilter;
                    parentNameLength = 0;
                } else {
                    if (!this.objectFilters.containsKey(parent)) {
                        throw new IllegalStateException("Cannot find parent mapper for path " + path + " in doc " + this.doc);
                    }
                    parentBitSet = this.objectFilters.get(parent);
                    parentNameLength = parent.length() + 1;
                }
                int offset = 0;
                DocIdSetIterator childIt = childScorer.iterator();
                if (NestedDocuments.this.indexVersionCreated.onOrAfter(Version.V_6_5_0)) {
                    int lastParent = parentBitSet.prevSetBit(currentLevelDoc);
                    int i = childIt.advance(lastParent + 1);
                    while (i < currentLevelDoc) {
                        ++offset;
                        i = childIt.nextDoc();
                    }
                } else {
                    int nextParent = parentBitSet.nextSetBit(currentLevelDoc);
                    int docId = childIt.advance(currentLevelDoc + 1);
                    while (docId < nextParent) {
                        ++offset;
                        docId = childIt.nextDoc();
                    }
                }
                ni = new SearchHit.NestedIdentity(path.substring(parentNameLength), offset, ni);
                path = parent;
                currentLevelDoc = parentBitSet.nextSetBit(currentLevelDoc);
            }
            return ni;
        }
    }
}

