/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.sampler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.MultiBucketCollector;
import org.elasticsearch.search.aggregations.bucket.DeferringBucketCollector;

public class BestDocsDeferringCollector
extends DeferringBucketCollector
implements Releasable {
    private final List<PerSegmentCollects> entries = new ArrayList<PerSegmentCollects>();
    private BucketCollector deferred;
    private ObjectArray<PerParentBucketSamples> perBucketSamples;
    private int shardSize;
    private PerSegmentCollects perSegCollector;
    private final BigArrays bigArrays;
    private final Consumer<Long> circuitBreakerConsumer;
    private static final long SENTINEL_SIZE = RamUsageEstimator.shallowSizeOfInstance(Object.class);

    BestDocsDeferringCollector(int shardSize, BigArrays bigArrays, Consumer<Long> circuitBreakerConsumer) {
        this.shardSize = shardSize;
        this.bigArrays = bigArrays;
        this.circuitBreakerConsumer = circuitBreakerConsumer;
        this.perBucketSamples = bigArrays.newObjectArray(1L);
    }

    @Override
    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE;
    }

    @Override
    public void setDeferredCollector(Iterable<BucketCollector> deferredCollectors) {
        this.deferred = MultiBucketCollector.wrap(true, deferredCollectors);
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx) throws IOException {
        this.perSegCollector = new PerSegmentCollects(ctx);
        this.entries.add(this.perSegCollector);
        return new LeafBucketCollector(){

            @Override
            public void setScorer(Scorable scorer) throws IOException {
                BestDocsDeferringCollector.this.perSegCollector.setScorer(scorer);
            }

            @Override
            public void collect(int doc, long bucket) throws IOException {
                BestDocsDeferringCollector.this.perSegCollector.collect(doc, bucket);
            }
        };
    }

    protected TopDocsCollector<? extends ScoreDoc> createTopDocsCollector(int size) throws IOException {
        return TopScoreDocCollector.create(size, Integer.MAX_VALUE);
    }

    protected long getPriorityQueueSlotSize() {
        return SENTINEL_SIZE;
    }

    @Override
    public void preCollection() throws IOException {
        this.deferred.preCollection();
    }

    @Override
    public void postCollection() throws IOException {
        this.runDeferredAggs();
    }

    @Override
    public void prepareSelectedBuckets(long ... selectedBuckets) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDeferredAggs() throws IOException {
        this.circuitBreakerConsumer.accept(12L * (long)this.shardSize);
        try {
            ArrayList<ScoreDoc> allDocs = new ArrayList<ScoreDoc>(this.shardSize);
            int i = 0;
            while ((long)i < this.perBucketSamples.size()) {
                PerParentBucketSamples perBucketSample = this.perBucketSamples.get(i);
                if (perBucketSample != null) {
                    perBucketSample.getMatches(allDocs);
                }
                ++i;
            }
            allDocs.sort((o1, o2) -> {
                if (o1.doc == o2.doc) {
                    return o1.shardIndex - o2.shardIndex;
                }
                return o1.doc - o2.doc;
            });
            try {
                for (PerSegmentCollects perSegDocs : this.entries) {
                    perSegDocs.replayRelatedMatches(allDocs);
                }
            }
            catch (IOException e) {
                throw new ElasticsearchException("IOException collecting best scoring results", (Throwable)e, new Object[0]);
            }
        }
        finally {
            this.circuitBreakerConsumer.accept(-12L * (long)this.shardSize);
        }
        this.deferred.postCollection();
    }

    public int getDocCount(long parentBucket) {
        if (this.perBucketSamples.size() <= parentBucket) {
            return 0;
        }
        PerParentBucketSamples sampler = this.perBucketSamples.get((int)parentBucket);
        if (sampler == null) {
            return 0;
        }
        return sampler.getDocCount();
    }

    @Override
    public void close() throws ElasticsearchException {
        Releasables.close(this.perBucketSamples);
    }

    class PerSegmentCollects
    extends Scorable {
        private LeafReaderContext readerContext;
        int maxDocId = Integer.MIN_VALUE;
        private float currentScore;
        private int currentDocId = -1;
        private Scorable currentScorer;

        PerSegmentCollects(LeafReaderContext readerContext) throws IOException {
            this.readerContext = readerContext;
            int i = 0;
            while ((long)i < BestDocsDeferringCollector.this.perBucketSamples.size()) {
                PerParentBucketSamples perBucketSample = (PerParentBucketSamples)BestDocsDeferringCollector.this.perBucketSamples.get(i);
                if (perBucketSample != null) {
                    perBucketSample.changeSegment(readerContext);
                }
                ++i;
            }
        }

        public void setScorer(Scorable scorer) throws IOException {
            this.currentScorer = scorer;
            int i = 0;
            while ((long)i < BestDocsDeferringCollector.this.perBucketSamples.size()) {
                PerParentBucketSamples perBucketSample = (PerParentBucketSamples)BestDocsDeferringCollector.this.perBucketSamples.get(i);
                if (perBucketSample != null) {
                    perBucketSample.setScorer(scorer);
                }
                ++i;
            }
        }

        public void replayRelatedMatches(List<ScoreDoc> sd) throws IOException {
            try {
                LeafBucketCollector leafCollector = BestDocsDeferringCollector.this.deferred.getLeafCollector(this.readerContext);
                leafCollector.setScorer(this);
                this.currentScore = 0.0f;
                this.currentDocId = -1;
                if (this.maxDocId < 0) {
                    return;
                }
                for (ScoreDoc scoreDoc : sd) {
                    int rebased = scoreDoc.doc - this.readerContext.docBase;
                    if (rebased < 0 || rebased > this.maxDocId) continue;
                    this.currentScore = scoreDoc.score;
                    this.currentDocId = rebased;
                    leafCollector.collect(rebased, scoreDoc.shardIndex);
                }
            }
            catch (CollectionTerminatedException collectionTerminatedException) {
                // empty catch block
            }
        }

        @Override
        public float score() throws IOException {
            return this.currentScore;
        }

        @Override
        public int docID() {
            return this.currentDocId;
        }

        public void collect(int docId, long parentBucket) throws IOException {
            BestDocsDeferringCollector.this.perBucketSamples = BestDocsDeferringCollector.this.bigArrays.grow(BestDocsDeferringCollector.this.perBucketSamples, parentBucket + 1L);
            PerParentBucketSamples sampler = (PerParentBucketSamples)BestDocsDeferringCollector.this.perBucketSamples.get((int)parentBucket);
            if (sampler == null) {
                sampler = new PerParentBucketSamples(parentBucket, this.currentScorer, this.readerContext);
                BestDocsDeferringCollector.this.perBucketSamples.set((int)parentBucket, sampler);
            }
            sampler.collect(docId);
            this.maxDocId = Math.max(this.maxDocId, docId);
        }
    }

    class PerParentBucketSamples {
        private LeafCollector currentLeafCollector;
        private TopDocsCollector<? extends ScoreDoc> tdc;
        private long parentBucket;
        private int matchedDocs;

        PerParentBucketSamples(long parentBucket, Scorable scorer, LeafReaderContext readerContext) {
            try {
                this.parentBucket = parentBucket;
                BestDocsDeferringCollector.this.circuitBreakerConsumer.accept((long)BestDocsDeferringCollector.this.shardSize * BestDocsDeferringCollector.this.getPriorityQueueSlotSize());
                this.tdc = BestDocsDeferringCollector.this.createTopDocsCollector(BestDocsDeferringCollector.this.shardSize);
                this.currentLeafCollector = this.tdc.getLeafCollector(readerContext);
                this.setScorer(scorer);
            }
            catch (IOException e) {
                throw new ElasticsearchException("IO error creating collector", (Throwable)e, new Object[0]);
            }
        }

        public void getMatches(List<ScoreDoc> allDocs) {
            TopDocs topDocs = this.tdc.topDocs();
            ScoreDoc[] sd = topDocs.scoreDocs;
            this.matchedDocs = sd.length;
            for (ScoreDoc scoreDoc : sd) {
                scoreDoc.shardIndex = (int)this.parentBucket;
            }
            allDocs.addAll(Arrays.asList(sd));
        }

        public void collect(int doc) throws IOException {
            this.currentLeafCollector.collect(doc);
        }

        public void setScorer(Scorable scorer) throws IOException {
            this.currentLeafCollector.setScorer(scorer);
        }

        public void changeSegment(LeafReaderContext readerContext) throws IOException {
            this.currentLeafCollector = this.tdc.getLeafCollector(readerContext);
        }

        public int getDocCount() {
            return this.matchedDocs;
        }
    }
}

