/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.transport.Header;

public class InboundMessage
implements Releasable {
    private final Header header;
    private final ReleasableBytesReference content;
    private final Exception exception;
    private final boolean isPing;
    private Releasable breakerRelease;
    private StreamInput streamInput;

    public InboundMessage(Header header, ReleasableBytesReference content, Releasable breakerRelease) {
        this.header = header;
        this.content = content;
        this.breakerRelease = breakerRelease;
        this.exception = null;
        this.isPing = false;
    }

    public InboundMessage(Header header, Exception exception) {
        this.header = header;
        this.content = null;
        this.breakerRelease = null;
        this.exception = exception;
        this.isPing = false;
    }

    public InboundMessage(Header header, boolean isPing) {
        this.header = header;
        this.content = null;
        this.breakerRelease = null;
        this.exception = null;
        this.isPing = isPing;
    }

    public Header getHeader() {
        return this.header;
    }

    public int getContentLength() {
        if (this.content == null) {
            return 0;
        }
        return this.content.length();
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean isPing() {
        return this.isPing;
    }

    public boolean isShortCircuit() {
        return this.exception != null;
    }

    public Releasable takeBreakerReleaseControl() {
        Releasable toReturn = this.breakerRelease;
        this.breakerRelease = null;
        if (toReturn != null) {
            return toReturn;
        }
        return () -> {};
    }

    public StreamInput openOrGetStreamInput() throws IOException {
        assert (!this.isPing && this.content != null);
        if (this.streamInput == null) {
            this.streamInput = this.content.streamInput();
            this.streamInput.setVersion(this.header.getVersion());
        }
        return this.streamInput;
    }

    @Override
    public void close() {
        try {
            IOUtils.close(this.streamInput, this.content, this.breakerRelease);
        }
        catch (Exception e) {
            assert (false) : e;
            throw new ElasticsearchException(e);
        }
    }

    public String toString() {
        return "InboundMessage{" + this.header + "}";
    }
}

