// Copyright 2020 The TensorFlow Runtime Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This test is auto generated by: //utils/eigen:gen_max_pooling_tests

// RUN: bef_executor %s.bef | FileCheck %s --dump-input=always
// RUN: bef_executor %s.bef --work_queue_type=mstd:1 | FileCheck %s --dump-input=always
// RUN: bef_executor %s.bef --work_queue_type=mstd:2 | FileCheck %s --dump-input=always
// RUN: bef_executor %s.bef --work_queue_type=mstd:4 | FileCheck %s --dump-input=always
// RUN: bef_executor %s.bef --work_queue_type=mstd:8 | FileCheck %s --dump-input=always

// CHECK-LABEL: --- Running 'test_max_pooling2d_in_1x9x9x8_padding_valid_p_3x3_s_2x2'
func.func @test_max_pooling2d_in_1x9x9x8_padding_valid_p_3x3_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/max_pooling_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 0
  %expected_index = tfrt.constant.i32 1

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.max_pooling_2d.f32"(%input, %output, %ch0)
    { padding = "valid",
       pool_size = [3 : i64, 3 : i64],
       strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch3

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_max_pooling2d_in_1x9x9x8_padding_valid_p_2x3_s_2x2'
func.func @test_max_pooling2d_in_1x9x9x8_padding_valid_p_2x3_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/max_pooling_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2
  %expected_index = tfrt.constant.i32 3

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.max_pooling_2d.f32"(%input, %output, %ch0)
    { padding = "valid",
       pool_size = [2 : i64, 3 : i64],
       strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch3

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_max_pooling2d_in_1x9x9x8_padding_valid_p_3x2_s_2x2'
func.func @test_max_pooling2d_in_1x9x9x8_padding_valid_p_3x2_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/max_pooling_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 4
  %expected_index = tfrt.constant.i32 5

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.max_pooling_2d.f32"(%input, %output, %ch0)
    { padding = "valid",
       pool_size = [3 : i64, 2 : i64],
       strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch3

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_max_pooling2d_in_1x9x9x8_padding_valid_p_3x3_s_3x2'
func.func @test_max_pooling2d_in_1x9x9x8_padding_valid_p_3x3_s_3x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/max_pooling_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 6
  %expected_index = tfrt.constant.i32 7

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.max_pooling_2d.f32"(%input, %output, %ch0)
    { padding = "valid",
       pool_size = [3 : i64, 3 : i64],
       strides = [3 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch3

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_max_pooling2d_in_1x9x9x8_padding_valid_p_3x3_s_2x3'
func.func @test_max_pooling2d_in_1x9x9x8_padding_valid_p_3x3_s_2x3() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/max_pooling_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 8
  %expected_index = tfrt.constant.i32 9

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.max_pooling_2d.f32"(%input, %output, %ch0)
    { padding = "valid",
       pool_size = [3 : i64, 3 : i64],
       strides = [2 : i64, 3 : i64] }
    : (!t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch3

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_max_pooling2d_in_1x9x9x8_padding_same_p_3x3_s_2x2'
func.func @test_max_pooling2d_in_1x9x9x8_padding_same_p_3x3_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/max_pooling_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 10
  %expected_index = tfrt.constant.i32 11

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.max_pooling_2d.f32"(%input, %output, %ch0)
    { padding = "same",
       pool_size = [3 : i64, 3 : i64],
       strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch3

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_max_pooling2d_in_1x9x9x8_padding_same_p_2x3_s_2x2'
func.func @test_max_pooling2d_in_1x9x9x8_padding_same_p_2x3_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/max_pooling_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 12
  %expected_index = tfrt.constant.i32 13

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.max_pooling_2d.f32"(%input, %output, %ch0)
    { padding = "same",
       pool_size = [2 : i64, 3 : i64],
       strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch3

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_max_pooling2d_in_1x9x9x8_padding_same_p_3x2_s_2x2'
func.func @test_max_pooling2d_in_1x9x9x8_padding_same_p_3x2_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/max_pooling_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 14
  %expected_index = tfrt.constant.i32 15

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.max_pooling_2d.f32"(%input, %output, %ch0)
    { padding = "same",
       pool_size = [3 : i64, 2 : i64],
       strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch3

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_max_pooling2d_in_1x9x9x8_padding_same_p_3x3_s_3x2'
func.func @test_max_pooling2d_in_1x9x9x8_padding_same_p_3x3_s_3x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/max_pooling_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 16
  %expected_index = tfrt.constant.i32 17

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.max_pooling_2d.f32"(%input, %output, %ch0)
    { padding = "same",
       pool_size = [3 : i64, 3 : i64],
       strides = [3 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch3

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_max_pooling2d_in_1x9x9x8_padding_same_p_3x3_s_2x3'
func.func @test_max_pooling2d_in_1x9x9x8_padding_same_p_3x3_s_2x3() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/max_pooling_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 18
  %expected_index = tfrt.constant.i32 19

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 3 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.max_pooling_2d.f32"(%input, %output, %ch0)
    { padding = "same",
       pool_size = [3 : i64, 3 : i64],
       strides = [2 : i64, 3 : i64] }
    : (!t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch3

  tfrt.return
}
