/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.crmf;

import java.io.IOException;
import java.io.InputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.asn1.UTF8String;
import org.mozilla.jss.pkix.crmf.PKIArchiveOptions;
import org.mozilla.jss.pkix.crmf.PKIPublicationInfo;
import org.mozilla.jss.pkix.primitive.AVA;

public class Control
extends AVA {
    public static final OBJECT_IDENTIFIER id_pkix = new OBJECT_IDENTIFIER(new long[]{1L, 3L, 6L, 1L, 5L, 5L, 7L});
    public static final OBJECT_IDENTIFIER id_pkip = id_pkix.subBranch(5L);
    public static final OBJECT_IDENTIFIER id_regCtrl = id_pkip.subBranch(1L);
    public static final OBJECT_IDENTIFIER id_regCtrl_regToken = id_regCtrl.subBranch(1L);
    public static final OBJECT_IDENTIFIER id_regCtrl_authenticator = id_regCtrl.subBranch(2L);
    public static final OBJECT_IDENTIFIER id_regCtrl_pkiPublicationInfo = id_regCtrl.subBranch(3L);
    public static final OBJECT_IDENTIFIER id_regCtrl_pkiArchiveOptions = id_regCtrl.subBranch(4L);
    public static final OBJECT_IDENTIFIER id_regCtrl_oldCertID = id_regCtrl.subBranch(5L);
    public static final OBJECT_IDENTIFIER id_regCtrl_protocolEncrKey = id_regCtrl.subBranch(6L);

    public Control(OBJECT_IDENTIFIER oid, ASN1Value value) {
        super(oid, value);
    }

    public UTF8String getUTF8String() throws InvalidBERException {
        return (UTF8String)this.getValue().decodeWith(UTF8String.getTemplate());
    }

    public PKIArchiveOptions getPKIArchiveOptions() throws InvalidBERException {
        return (PKIArchiveOptions)this.getValue().decodeWith(PKIArchiveOptions.getTemplate());
    }

    public PKIPublicationInfo getPKIPublicationInfo() throws InvalidBERException {
        return (PKIPublicationInfo)this.getValue().decodeWith(PKIPublicationInfo.getTemplate());
    }

    public static class Template
    extends AVA.Template {
        private SEQUENCE.Template seqTemplate = new SEQUENCE.Template();

        public Template() {
            this.seqTemplate.addElement(new OBJECT_IDENTIFIER.Template());
            this.seqTemplate.addElement(new ANY.Template());
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(AVA.TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqTemplate.decode(implicit, istream);
            OBJECT_IDENTIFIER oid = (OBJECT_IDENTIFIER)seq.elementAt(0);
            ANY any = (ANY)seq.elementAt(1);
            return new Control(oid, any);
        }
    }
}

