; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=gfx700 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX7 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx803 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX8 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX9 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx906 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX9-DL %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1011 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10-DL-XNACK %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1012 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10-DL-XNACK %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1030 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10-DL-NOXNACK %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1031 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10-DL-NOXNACK %s

define amdgpu_kernel void @idot8_acc32(ptr addrspace(1) %src1,
; GFX7-LABEL: idot8_acc32:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX7-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s14, -1
; GFX7-NEXT:    s_mov_b32 s15, 0xe8f000
; GFX7-NEXT:    s_add_u32 s12, s12, s3
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_addc_u32 s13, s13, 0
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_bfe_i32 v1, v2, 0, 4
; GFX7-NEXT:    v_bfe_i32 v3, v2, 4, 4
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_i32 v9, v0, 0, 4
; GFX7-NEXT:    v_bfe_i32 v10, v0, 4, 4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_i32_i24 v1, v1, v9, s4
; GFX7-NEXT:    v_bfe_i32 v4, v2, 8, 4
; GFX7-NEXT:    v_bfe_i32 v11, v0, 8, 4
; GFX7-NEXT:    v_mad_i32_i24 v1, v3, v10, v1
; GFX7-NEXT:    v_bfe_i32 v5, v2, 12, 4
; GFX7-NEXT:    v_bfe_i32 v12, v0, 12, 4
; GFX7-NEXT:    v_mad_i32_i24 v1, v4, v11, v1
; GFX7-NEXT:    v_bfe_i32 v6, v2, 16, 4
; GFX7-NEXT:    v_bfe_i32 v13, v0, 16, 4
; GFX7-NEXT:    v_mad_i32_i24 v1, v5, v12, v1
; GFX7-NEXT:    v_bfe_i32 v7, v2, 20, 4
; GFX7-NEXT:    v_bfe_i32 v14, v0, 20, 4
; GFX7-NEXT:    v_mad_i32_i24 v1, v6, v13, v1
; GFX7-NEXT:    v_bfe_i32 v8, v2, 24, 4
; GFX7-NEXT:    v_bfe_i32 v15, v0, 24, 4
; GFX7-NEXT:    v_mad_i32_i24 v1, v7, v14, v1
; GFX7-NEXT:    v_ashrrev_i32_e32 v2, 28, v2
; GFX7-NEXT:    v_ashrrev_i32_e32 v0, 28, v0
; GFX7-NEXT:    v_mad_i32_i24 v1, v8, v15, v1
; GFX7-NEXT:    v_mad_i32_i24 v0, v2, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot8_acc32:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX8-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    s_mov_b32 s11, 0xe80000
; GFX8-NEXT:    s_add_u32 s8, s8, s3
; GFX8-NEXT:    s_addc_u32 s9, s9, 0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_bfe_i32 v1, v3, 0, 4
; GFX8-NEXT:    v_bfe_i32 v4, v3, 4, 4
; GFX8-NEXT:    v_bfe_i32 v6, v3, 8, 4
; GFX8-NEXT:    v_bfe_i32 v8, v3, 12, 4
; GFX8-NEXT:    v_bfe_i32 v10, v3, 16, 4
; GFX8-NEXT:    v_bfe_i32 v12, v3, 20, 4
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_bfe_i32 v2, v0, 0, 4
; GFX8-NEXT:    v_bfe_i32 v5, v0, 4, 4
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_i32_i24 v1, v1, v2, s2
; GFX8-NEXT:    v_bfe_i32 v7, v0, 8, 4
; GFX8-NEXT:    v_mad_i32_i24 v1, v4, v5, v1
; GFX8-NEXT:    v_bfe_i32 v9, v0, 12, 4
; GFX8-NEXT:    v_mad_i32_i24 v1, v6, v7, v1
; GFX8-NEXT:    v_bfe_i32 v11, v0, 16, 4
; GFX8-NEXT:    v_mad_i32_i24 v1, v8, v9, v1
; GFX8-NEXT:    v_bfe_i32 v13, v0, 20, 4
; GFX8-NEXT:    v_mad_i32_i24 v1, v10, v11, v1
; GFX8-NEXT:    v_bfe_i32 v14, v3, 24, 4
; GFX8-NEXT:    v_bfe_i32 v15, v0, 24, 4
; GFX8-NEXT:    v_mad_i32_i24 v1, v12, v13, v1
; GFX8-NEXT:    v_ashrrev_i32_e32 v3, 28, v3
; GFX8-NEXT:    v_ashrrev_i32_e32 v0, 28, v0
; GFX8-NEXT:    v_mad_i32_i24 v1, v14, v15, v1
; GFX8-NEXT:    v_mad_i32_i24 v2, v3, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: idot8_acc32:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-NEXT:    s_add_u32 s8, s8, s3
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_bfe_i32 v3, v1, 0, 4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_bfe_i32 v4, v2, 0, 4
; GFX9-NEXT:    v_bfe_i32 v5, v1, 4, 4
; GFX9-NEXT:    v_bfe_i32 v6, v2, 4, 4
; GFX9-NEXT:    v_bfe_i32 v7, v1, 8, 4
; GFX9-NEXT:    v_bfe_i32 v8, v2, 8, 4
; GFX9-NEXT:    v_bfe_i32 v9, v1, 12, 4
; GFX9-NEXT:    v_bfe_i32 v10, v2, 12, 4
; GFX9-NEXT:    v_bfe_i32 v11, v1, 16, 4
; GFX9-NEXT:    v_bfe_i32 v12, v2, 16, 4
; GFX9-NEXT:    v_bfe_i32 v13, v1, 20, 4
; GFX9-NEXT:    v_bfe_i32 v14, v2, 20, 4
; GFX9-NEXT:    v_bfe_i32 v15, v1, 24, 4
; GFX9-NEXT:    v_bfe_i32 v16, v2, 24, 4
; GFX9-NEXT:    v_ashrrev_i32_e32 v1, 28, v1
; GFX9-NEXT:    v_ashrrev_i32_e32 v2, 28, v2
; GFX9-NEXT:    v_mul_i32_i24_e32 v3, v3, v4
; GFX9-NEXT:    v_mul_i32_i24_e32 v4, v5, v6
; GFX9-NEXT:    v_mul_i32_i24_e32 v5, v7, v8
; GFX9-NEXT:    v_mul_i32_i24_e32 v6, v9, v10
; GFX9-NEXT:    v_mul_i32_i24_e32 v1, v1, v2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add3_u32 v2, v3, s0, v4
; GFX9-NEXT:    v_mul_i32_i24_e32 v7, v11, v12
; GFX9-NEXT:    v_mul_i32_i24_e32 v8, v13, v14
; GFX9-NEXT:    v_add3_u32 v2, v2, v5, v6
; GFX9-NEXT:    v_mul_i32_i24_e32 v9, v15, v16
; GFX9-NEXT:    v_add3_u32 v2, v2, v7, v8
; GFX9-NEXT:    v_add3_u32 v1, v2, v9, v1
; GFX9-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot8_acc32:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-DL-NEXT:    s_mov_b32 s10, -1
; GFX9-DL-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-DL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-DL-NEXT:    v_dot8_i32_i4 v1, v1, v2, s0
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-XNACK-LABEL: idot8_acc32:
; GFX10-DL-XNACK:       ; %bb.0: ; %entry
; GFX10-DL-XNACK-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-XNACK-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-XNACK-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10-DL-XNACK-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10-DL-XNACK-NEXT:    s_mov_b32 s10, -1
; GFX10-DL-XNACK-NEXT:    s_mov_b32 s11, 0x31c16000
; GFX10-DL-XNACK-NEXT:    s_add_u32 s8, s8, s3
; GFX10-DL-XNACK-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-DL-XNACK-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-XNACK-NEXT:    s_clause 0x1
; GFX10-DL-XNACK-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-XNACK-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-XNACK-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-XNACK-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-XNACK-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-DL-XNACK-NEXT:    v_dot8_i32_i4 v1, v1, v2, s2
; GFX10-DL-XNACK-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-DL-XNACK-NEXT:    s_endpgm
;
; GFX10-DL-NOXNACK-LABEL: idot8_acc32:
; GFX10-DL-NOXNACK:       ; %bb.0: ; %entry
; GFX10-DL-NOXNACK-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NOXNACK-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NOXNACK-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10-DL-NOXNACK-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NOXNACK-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10-DL-NOXNACK-NEXT:    s_mov_b32 s10, -1
; GFX10-DL-NOXNACK-NEXT:    s_mov_b32 s11, 0x31c16000
; GFX10-DL-NOXNACK-NEXT:    s_add_u32 s8, s8, s3
; GFX10-DL-NOXNACK-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-DL-NOXNACK-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NOXNACK-NEXT:    s_clause 0x1
; GFX10-DL-NOXNACK-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NOXNACK-NEXT:    global_load_dword v0, v0, s[6:7]
; GFX10-DL-NOXNACK-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NOXNACK-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-DL-NOXNACK-NEXT:    v_dot8_i32_i4 v0, v1, v0, s2
; GFX10-DL-NOXNACK-NEXT:    global_store_dword v2, v0, s[0:1]
; GFX10-DL-NOXNACK-NEXT:    s_endpgm
; GFX10-DL-LABEL: idot8_acc32:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10-DL-NEXT:    s_mov_b32 s10, -1
; GFX10-DL-NEXT:    s_mov_b32 s11, 0x31c16000
; GFX10-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x34
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_load_dword s6, s[4:5], 0x0
; GFX10-DL-NEXT:    s_load_dword s0, s[0:1], 0x0
; GFX10-DL-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-DL-NEXT:    v_dot8_i32_i4 v0, s0, s1, v0
; GFX10-DL-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX10-DL-NEXT:    s_endpgm
                                       ptr addrspace(1) %src2,
                                       ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <8 x i4>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <8 x i4>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <8 x i4>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <8 x i4>, ptr addrspace(1) %gep2

  %v1e0 = extractelement <8 x i4> %vec1, i64 0
  %cv1e0 = sext i4 %v1e0 to i32
  %v2e0 = extractelement <8 x i4> %vec2, i64 0
  %cv2e0 = sext i4 %v2e0 to i32
  %mul0 = mul nuw nsw i32 %cv1e0, %cv2e0

  %v1e1 = extractelement <8 x i4> %vec1, i64 1
  %cv1e1 = sext i4 %v1e1 to i32
  %v2e1 = extractelement <8 x i4> %vec2, i64 1
  %cv2e1 = sext i4 %v2e1 to i32
  %mul1 = mul nuw nsw i32 %cv1e1, %cv2e1

  %v1e2 = extractelement <8 x i4> %vec1, i64 2
  %cv1e2 = sext i4 %v1e2 to i32
  %v2e2 = extractelement <8 x i4> %vec2, i64 2
  %cv2e2 = sext i4 %v2e2 to i32
  %mul2 = mul nuw nsw i32 %cv1e2, %cv2e2

  %v1e3 = extractelement <8 x i4> %vec1, i64 3
  %cv1e3 = sext i4 %v1e3 to i32
  %v2e3 = extractelement <8 x i4> %vec2, i64 3
  %cv2e3 = sext i4 %v2e3 to i32
  %mul3 = mul nuw nsw i32 %cv1e3, %cv2e3

  %v1e4 = extractelement <8 x i4> %vec1, i64 4
  %cv1e4 = sext i4 %v1e4 to i32
  %v2e4 = extractelement <8 x i4> %vec2, i64 4
  %cv2e4 = sext i4 %v2e4 to i32
  %mul4 = mul nuw nsw i32 %cv1e4, %cv2e4

  %v1e5 = extractelement <8 x i4> %vec1, i64 5
  %cv1e5 = sext i4 %v1e5 to i32
  %v2e5 = extractelement <8 x i4> %vec2, i64 5
  %cv2e5 = sext i4 %v2e5 to i32
  %mul5 = mul nuw nsw i32 %cv1e5, %cv2e5

  %v1e6 = extractelement <8 x i4> %vec1, i64 6
  %cv1e6 = sext i4 %v1e6 to i32
  %v2e6 = extractelement <8 x i4> %vec2, i64 6
  %cv2e6 = sext i4 %v2e6 to i32
  %mul6 = mul nuw nsw i32 %cv1e6, %cv2e6

  %v1e7 = extractelement <8 x i4> %vec1, i64 7
  %cv1e7 = sext i4 %v1e7 to i32
  %v2e7 = extractelement <8 x i4> %vec2, i64 7
  %cv2e7 = sext i4 %v2e7 to i32
  %mul7 = mul nuw nsw i32 %cv1e7, %cv2e7

  %acc = load i32, ptr addrspace(1) %dst, align 4
  %add1 = add i32 %mul0, %acc
  %add2 = add i32 %add1, %mul1
  %add3 = add i32 %add2, %mul2
  %add4 = add i32 %add3, %mul3
  %add5 = add i32 %add4, %mul4
  %add6 = add i32 %add5, %mul5
  %add7 = add i32 %add6, %mul6
  %add8 = add i32 %add7, %mul7

  store i32 %add8, ptr addrspace(1) %dst, align 4
  ret void
}

; TODO: Once the unnecessary zero extentions of the elements are removed;
; pattern recognizer will kick in.
define amdgpu_kernel void @idot8_acc16(ptr addrspace(1) %src1,
; GFX7-LABEL: idot8_acc16:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX7-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s14, -1
; GFX7-NEXT:    s_mov_b32 s15, 0xe8f000
; GFX7-NEXT:    s_add_u32 s12, s12, s3
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    buffer_load_ushort v1, off, s[0:3], 0
; GFX7-NEXT:    s_addc_u32 s13, s13, 0
; GFX7-NEXT:    s_waitcnt vmcnt(2)
; GFX7-NEXT:    v_bfe_i32 v3, v2, 0, 4
; GFX7-NEXT:    v_bfe_i32 v4, v2, 4, 4
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_bfe_i32 v10, v0, 0, 4
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX7-NEXT:    v_bfe_i32 v11, v0, 4, 4
; GFX7-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; GFX7-NEXT:    v_bfe_i32 v5, v2, 8, 4
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX7-NEXT:    v_bfe_i32 v12, v0, 8, 4
; GFX7-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v3, v10, v1
; GFX7-NEXT:    v_bfe_i32 v6, v2, 12, 4
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX7-NEXT:    v_bfe_i32 v13, v0, 12, 4
; GFX7-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; GFX7-NEXT:    v_mad_u32_u24 v1, v4, v11, v1
; GFX7-NEXT:    v_bfe_i32 v7, v2, 16, 4
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX7-NEXT:    v_bfe_i32 v14, v0, 16, 4
; GFX7-NEXT:    v_and_b32_e32 v13, 0xffff, v13
; GFX7-NEXT:    v_mad_u32_u24 v1, v5, v12, v1
; GFX7-NEXT:    v_bfe_i32 v8, v2, 20, 4
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX7-NEXT:    v_bfe_i32 v15, v0, 20, 4
; GFX7-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; GFX7-NEXT:    v_mad_u32_u24 v1, v6, v13, v1
; GFX7-NEXT:    v_bfe_i32 v9, v2, 24, 4
; GFX7-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; GFX7-NEXT:    v_bfe_i32 v16, v0, 24, 4
; GFX7-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; GFX7-NEXT:    v_mad_u32_u24 v1, v7, v14, v1
; GFX7-NEXT:    v_ashrrev_i32_e32 v2, 28, v2
; GFX7-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; GFX7-NEXT:    v_ashrrev_i32_e32 v0, 28, v0
; GFX7-NEXT:    v_and_b32_e32 v16, 0xffff, v16
; GFX7-NEXT:    v_mad_u32_u24 v1, v8, v15, v1
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7-NEXT:    v_mad_u32_u24 v1, v9, v16, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot8_acc16:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    v_mov_b32_e32 v5, 12
; GFX8-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_load_ushort v4, v[0:1]
; GFX8-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    s_mov_b32 s11, 0xe80000
; GFX8-NEXT:    s_add_u32 s8, s8, s3
; GFX8-NEXT:    s_addc_u32 s9, s9, 0
; GFX8-NEXT:    s_waitcnt vmcnt(2)
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 4, v3
; GFX8-NEXT:    v_lshlrev_b16_e32 v16, 12, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 28, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 20, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 12, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 8, v3
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_lshrrev_b32_e32 v15, 4, v2
; GFX8-NEXT:    v_lshlrev_b16_e32 v17, 12, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 28, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v12, 20, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v13, 12, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v14, 8, v2
; GFX8-NEXT:    v_lshlrev_b16_sdwa v18, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_lshlrev_b16_sdwa v19, v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_lshlrev_b16_sdwa v3, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
; GFX8-NEXT:    v_lshlrev_b16_sdwa v2, v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
; GFX8-NEXT:    v_ashrrev_i16_e32 v5, 12, v16
; GFX8-NEXT:    v_ashrrev_i16_e32 v16, 12, v17
; GFX8-NEXT:    v_lshlrev_b16_e32 v10, 12, v10
; GFX8-NEXT:    v_lshlrev_b16_e32 v15, 12, v15
; GFX8-NEXT:    v_lshlrev_b16_e32 v9, 12, v9
; GFX8-NEXT:    v_lshlrev_b16_e32 v14, 12, v14
; GFX8-NEXT:    v_ashrrev_i16_e32 v10, 12, v10
; GFX8-NEXT:    v_ashrrev_i16_e32 v15, 12, v15
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mad_u16 v4, v5, v16, v4
; GFX8-NEXT:    v_lshlrev_b16_e32 v8, 12, v8
; GFX8-NEXT:    v_lshlrev_b16_e32 v13, 12, v13
; GFX8-NEXT:    v_ashrrev_i16_e32 v9, 12, v9
; GFX8-NEXT:    v_ashrrev_i16_e32 v14, 12, v14
; GFX8-NEXT:    v_mad_u16 v4, v10, v15, v4
; GFX8-NEXT:    v_ashrrev_i16_e32 v8, 12, v8
; GFX8-NEXT:    v_ashrrev_i16_e32 v13, 12, v13
; GFX8-NEXT:    v_mad_u16 v4, v9, v14, v4
; GFX8-NEXT:    v_ashrrev_i16_e32 v17, 12, v18
; GFX8-NEXT:    v_ashrrev_i16_e32 v18, 12, v19
; GFX8-NEXT:    v_lshlrev_b16_e32 v7, 12, v7
; GFX8-NEXT:    v_lshlrev_b16_e32 v12, 12, v12
; GFX8-NEXT:    v_mad_u16 v4, v8, v13, v4
; GFX8-NEXT:    v_ashrrev_i16_e32 v7, 12, v7
; GFX8-NEXT:    v_ashrrev_i16_e32 v12, 12, v12
; GFX8-NEXT:    v_mad_u16 v4, v17, v18, v4
; GFX8-NEXT:    v_ashrrev_i16_e32 v3, 12, v3
; GFX8-NEXT:    v_ashrrev_i16_e32 v2, 12, v2
; GFX8-NEXT:    v_lshlrev_b16_e32 v6, 12, v6
; GFX8-NEXT:    v_lshlrev_b16_e32 v11, 12, v11
; GFX8-NEXT:    v_mad_u16 v4, v7, v12, v4
; GFX8-NEXT:    v_ashrrev_i16_e32 v6, 12, v6
; GFX8-NEXT:    v_ashrrev_i16_e32 v11, 12, v11
; GFX8-NEXT:    v_mad_u16 v2, v3, v2, v4
; GFX8-NEXT:    v_mad_u16 v2, v6, v11, v2
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: idot8_acc16:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-NEXT:    s_add_u32 s8, s8, s3
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v4, 12
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    global_load_ushort v3, v0, s[2:3]
; GFX9-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 4, v1
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_lshrrev_b32_e32 v14, 4, v2
; GFX9-NEXT:    v_lshlrev_b16_e32 v15, 12, v1
; GFX9-NEXT:    v_lshlrev_b16_e32 v16, 12, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 28, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 20, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 12, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 8, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 28, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 20, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 12, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v13, 8, v2
; GFX9-NEXT:    v_lshlrev_b16_sdwa v17, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_lshlrev_b16_sdwa v18, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_lshlrev_b16_sdwa v1, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
; GFX9-NEXT:    v_lshlrev_b16_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
; GFX9-NEXT:    v_ashrrev_i16_e32 v4, 12, v15
; GFX9-NEXT:    v_ashrrev_i16_e32 v15, 12, v16
; GFX9-NEXT:    v_lshlrev_b16_e32 v9, 12, v9
; GFX9-NEXT:    v_lshlrev_b16_e32 v14, 12, v14
; GFX9-NEXT:    v_lshlrev_b16_e32 v8, 12, v8
; GFX9-NEXT:    v_lshlrev_b16_e32 v13, 12, v13
; GFX9-NEXT:    v_ashrrev_i16_e32 v9, 12, v9
; GFX9-NEXT:    v_ashrrev_i16_e32 v14, 12, v14
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mad_legacy_u16 v3, v4, v15, v3
; GFX9-NEXT:    v_lshlrev_b16_e32 v7, 12, v7
; GFX9-NEXT:    v_lshlrev_b16_e32 v12, 12, v12
; GFX9-NEXT:    v_ashrrev_i16_e32 v8, 12, v8
; GFX9-NEXT:    v_ashrrev_i16_e32 v13, 12, v13
; GFX9-NEXT:    v_mad_legacy_u16 v3, v9, v14, v3
; GFX9-NEXT:    v_ashrrev_i16_e32 v7, 12, v7
; GFX9-NEXT:    v_ashrrev_i16_e32 v12, 12, v12
; GFX9-NEXT:    v_mad_legacy_u16 v3, v8, v13, v3
; GFX9-NEXT:    v_ashrrev_i16_e32 v16, 12, v17
; GFX9-NEXT:    v_ashrrev_i16_e32 v17, 12, v18
; GFX9-NEXT:    v_lshlrev_b16_e32 v6, 12, v6
; GFX9-NEXT:    v_lshlrev_b16_e32 v11, 12, v11
; GFX9-NEXT:    v_mad_legacy_u16 v3, v7, v12, v3
; GFX9-NEXT:    v_ashrrev_i16_e32 v6, 12, v6
; GFX9-NEXT:    v_ashrrev_i16_e32 v11, 12, v11
; GFX9-NEXT:    v_mad_legacy_u16 v3, v16, v17, v3
; GFX9-NEXT:    v_ashrrev_i16_e32 v1, 12, v1
; GFX9-NEXT:    v_ashrrev_i16_e32 v2, 12, v2
; GFX9-NEXT:    v_lshlrev_b16_e32 v5, 12, v5
; GFX9-NEXT:    v_lshlrev_b16_e32 v10, 12, v10
; GFX9-NEXT:    v_mad_legacy_u16 v3, v6, v11, v3
; GFX9-NEXT:    v_ashrrev_i16_e32 v5, 12, v5
; GFX9-NEXT:    v_ashrrev_i16_e32 v10, 12, v10
; GFX9-NEXT:    v_mad_legacy_u16 v1, v1, v2, v3
; GFX9-NEXT:    v_mad_legacy_u16 v1, v5, v10, v1
; GFX9-NEXT:    global_store_short v0, v1, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot8_acc16:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-DL-NEXT:    s_mov_b32 s10, -1
; GFX9-DL-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    v_mov_b32_e32 v4, 12
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    global_load_ushort v3, v0, s[2:3]
; GFX9-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v9, 4, v1
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v14, 4, v2
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v15, 12, v1
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v16, 12, v2
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v5, 28, v1
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v6, 20, v1
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v7, 12, v1
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v8, 8, v1
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v10, 28, v2
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v11, 20, v2
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v12, 12, v2
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v13, 8, v2
; GFX9-DL-NEXT:    v_lshlrev_b16_sdwa v17, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-DL-NEXT:    v_lshlrev_b16_sdwa v18, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-DL-NEXT:    v_lshlrev_b16_sdwa v1, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
; GFX9-DL-NEXT:    v_lshlrev_b16_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v4, 12, v15
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v15, 12, v16
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v9, 12, v9
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v14, 12, v14
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v8, 12, v8
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v13, 12, v13
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v9, 12, v9
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v14, 12, v14
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_mad_legacy_u16 v3, v4, v15, v3
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v7, 12, v7
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v12, 12, v12
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v8, 12, v8
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v13, 12, v13
; GFX9-DL-NEXT:    v_mad_legacy_u16 v3, v9, v14, v3
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v7, 12, v7
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v12, 12, v12
; GFX9-DL-NEXT:    v_mad_legacy_u16 v3, v8, v13, v3
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v16, 12, v17
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v17, 12, v18
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v6, 12, v6
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v11, 12, v11
; GFX9-DL-NEXT:    v_mad_legacy_u16 v3, v7, v12, v3
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v6, 12, v6
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v11, 12, v11
; GFX9-DL-NEXT:    v_mad_legacy_u16 v3, v16, v17, v3
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v1, 12, v1
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v2, 12, v2
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v5, 12, v5
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v10, 12, v10
; GFX9-DL-NEXT:    v_mad_legacy_u16 v3, v6, v11, v3
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v5, 12, v5
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v10, 12, v10
; GFX9-DL-NEXT:    v_mad_legacy_u16 v1, v1, v2, v3
; GFX9-DL-NEXT:    v_mad_legacy_u16 v1, v5, v10, v1
; GFX9-DL-NEXT:    global_store_short v0, v1, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-XNACK-LABEL: idot8_acc16:
; GFX10-DL-XNACK:       ; %bb.0: ; %entry
; GFX10-DL-XNACK-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-XNACK-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-XNACK-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10-DL-XNACK-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10-DL-XNACK-NEXT:    s_mov_b32 s10, -1
; GFX10-DL-XNACK-NEXT:    s_mov_b32 s11, 0x31c16000
; GFX10-DL-XNACK-NEXT:    s_add_u32 s8, s8, s3
; GFX10-DL-XNACK-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-DL-XNACK-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-XNACK-NEXT:    s_clause 0x1
; GFX10-DL-XNACK-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-XNACK-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-XNACK-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-XNACK-NEXT:    global_load_ushort v3, v0, s[0:1]
; GFX10-DL-XNACK-NEXT:    s_waitcnt vmcnt(2)
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v4, 28, v1
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v6, 20, v1
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v7, 16, v1
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v8, 12, v1
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v9, 8, v1
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v10, 4, v1
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v1, 12, v1
; GFX10-DL-XNACK-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v16, 4, v2
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v17, 12, v2
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v11, 28, v2
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v12, 24, v2
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v13, 20, v2
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v14, 16, v2
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v15, 12, v2
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v2, 8, v2
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v1, 12, v1
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v10, 12, v10
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v16, 12, v16
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v17, 12, v17
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v9, 12, v9
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v2, 12, v2
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v10, 12, v10
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v16, 12, v16
; GFX10-DL-XNACK-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-XNACK-NEXT:    v_mad_u16 v1, v1, v17, v3
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v3, 12, v9
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v2, 12, v2
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v8, 12, v8
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v9, 12, v15
; GFX10-DL-XNACK-NEXT:    v_mad_u16 v1, v10, v16, v1
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v7, 12, v7
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v10, 12, v14
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v8, 12, v8
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v9, 12, v9
; GFX10-DL-XNACK-NEXT:    v_mad_u16 v1, v3, v2, v1
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v2, 12, v7
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v3, 12, v10
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v6, 12, v6
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v7, 12, v13
; GFX10-DL-XNACK-NEXT:    v_mad_u16 v1, v8, v9, v1
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v5, 12, v5
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v8, 12, v12
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v6, 12, v6
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v7, 12, v7
; GFX10-DL-XNACK-NEXT:    v_mad_u16 v1, v2, v3, v1
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v2, 12, v5
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v3, 12, v8
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v4, 12, v4
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v5, 12, v11
; GFX10-DL-XNACK-NEXT:    v_mad_u16 v1, v6, v7, v1
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v4, 12, v4
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v5, 12, v5
; GFX10-DL-XNACK-NEXT:    v_mad_u16 v1, v2, v3, v1
; GFX10-DL-XNACK-NEXT:    v_mad_u16 v1, v4, v5, v1
; GFX10-DL-XNACK-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-DL-XNACK-NEXT:    s_endpgm
;
; GFX10-DL-NOXNACK-LABEL: idot8_acc16:
; GFX10-DL-NOXNACK:       ; %bb.0: ; %entry
; GFX10-DL-NOXNACK-NEXT:    s_clause 0x1
; GFX10-DL-NOXNACK-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NOXNACK-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NOXNACK-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NOXNACK-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10-DL-NOXNACK-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10-DL-NOXNACK-NEXT:    s_mov_b32 s10, -1
; GFX10-DL-NOXNACK-NEXT:    s_mov_b32 s11, 0x31c16000
; GFX10-DL-NOXNACK-NEXT:    s_add_u32 s8, s8, s3
; GFX10-DL-NOXNACK-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-DL-NOXNACK-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NOXNACK-NEXT:    s_clause 0x1
; GFX10-DL-NOXNACK-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NOXNACK-NEXT:    global_load_dword v0, v0, s[6:7]
; GFX10-DL-NOXNACK-NEXT:    global_load_ushort v3, v2, s[0:1]
; GFX10-DL-NOXNACK-NEXT:    s_waitcnt vmcnt(2)
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v4, 28, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v6, 20, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v7, 16, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v8, 12, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v9, 8, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v10, 4, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v1, 12, v1
; GFX10-DL-NOXNACK-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v16, 4, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v17, 12, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v11, 28, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v12, 24, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v13, 20, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v14, 16, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v15, 12, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v1, 12, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v10, 12, v10
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v16, 12, v16
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v17, 12, v17
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v9, 12, v9
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v0, 12, v0
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v10, 12, v10
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v16, 12, v16
; GFX10-DL-NOXNACK-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NOXNACK-NEXT:    v_mad_u16 v1, v1, v17, v3
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v3, 12, v9
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v0, 12, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v8, 12, v8
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v9, 12, v15
; GFX10-DL-NOXNACK-NEXT:    v_mad_u16 v1, v10, v16, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v7, 12, v7
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v10, 12, v14
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v8, 12, v8
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v9, 12, v9
; GFX10-DL-NOXNACK-NEXT:    v_mad_u16 v0, v3, v0, v1
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v1, 12, v7
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v3, 12, v10
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v6, 12, v6
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v7, 12, v13
; GFX10-DL-NOXNACK-NEXT:    v_mad_u16 v0, v8, v9, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v5, 12, v5
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v8, 12, v12
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v6, 12, v6
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v7, 12, v7
; GFX10-DL-NOXNACK-NEXT:    v_mad_u16 v0, v1, v3, v0
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v1, 12, v5
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v3, 12, v8
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v4, 12, v4
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v5, 12, v11
; GFX10-DL-NOXNACK-NEXT:    v_mad_u16 v0, v6, v7, v0
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v4, 12, v4
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v5, 12, v5
; GFX10-DL-NOXNACK-NEXT:    v_mad_u16 v0, v1, v3, v0
; GFX10-DL-NOXNACK-NEXT:    v_mad_u16 v0, v4, v5, v0
; GFX10-DL-NOXNACK-NEXT:    global_store_short v2, v0, s[0:1]
; GFX10-DL-NOXNACK-NEXT:    s_endpgm
; GFX10-DL-LABEL: idot8_acc16:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x34
; GFX10-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX10-DL-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX10-DL-NEXT:    s_mov_b32 s14, -1
; GFX10-DL-NEXT:    s_mov_b32 s15, 0x31c16000
; GFX10-DL-NEXT:    s_add_u32 s12, s12, s3
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-DL-NEXT:    s_addc_u32 s13, s13, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    global_load_ushort v1, v0, s[4:5]
; GFX10-DL-NEXT:    s_load_dword s0, s[0:1], 0x0
; GFX10-DL-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_lshr_b32 s2, s0, 12
; GFX10-DL-NEXT:    s_lshr_b32 s3, s1, 12
; GFX10-DL-NEXT:    s_bfe_i32 s6, s0, 0x40000
; GFX10-DL-NEXT:    s_bfe_i32 s7, s1, 0x40000
; GFX10-DL-NEXT:    v_lshlrev_b16_e64 v2, 12, s2
; GFX10-DL-NEXT:    v_lshlrev_b16_e64 v3, 12, s3
; GFX10-DL-NEXT:    s_bfe_i32 s8, s0, 0x40004
; GFX10-DL-NEXT:    s_bfe_i32 s9, s0, 0x40008
; GFX10-DL-NEXT:    s_bfe_i32 s10, s1, 0x40008
; GFX10-DL-NEXT:    s_bfe_i32 s2, s1, 0x40004
; GFX10-DL-NEXT:    v_mul_i32_i24_e64 v4, s9, s10
; GFX10-DL-NEXT:    v_ashrrev_i16_e64 v2, 12, v2
; GFX10-DL-NEXT:    v_ashrrev_i16_e64 v3, 12, v3
; GFX10-DL-NEXT:    s_bfe_i32 s3, s1, 0x40010
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_mad_i32_i24 v1, s6, s7, v1
; GFX10-DL-NEXT:    v_mad_i32_i24 v1, s8, s2, v1
; GFX10-DL-NEXT:    s_mov_b32 s2, 0xffff
; GFX10-DL-NEXT:    v_and_b32_e32 v2, s2, v2
; GFX10-DL-NEXT:    v_and_b32_e32 v3, s2, v3
; GFX10-DL-NEXT:    v_add_nc_u32_sdwa v1, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX10-DL-NEXT:    s_bfe_i32 s2, s0, 0x40010
; GFX10-DL-NEXT:    v_mad_u32_u24 v1, v2, v3, v1
; GFX10-DL-NEXT:    v_mad_i32_i24 v1, s2, s3, v1
; GFX10-DL-NEXT:    s_bfe_i32 s2, s0, 0x40014
; GFX10-DL-NEXT:    s_bfe_i32 s3, s1, 0x40014
; GFX10-DL-NEXT:    v_mad_i32_i24 v1, s2, s3, v1
; GFX10-DL-NEXT:    s_bfe_i32 s2, s0, 0x40018
; GFX10-DL-NEXT:    s_bfe_i32 s3, s1, 0x40018
; GFX10-DL-NEXT:    s_ashr_i32 s0, s0, 28
; GFX10-DL-NEXT:    s_ashr_i32 s1, s1, 28
; GFX10-DL-NEXT:    v_mad_i32_i24 v1, s2, s3, v1
; GFX10-DL-NEXT:    v_mad_i32_i24 v1, s0, s1, v1
; GFX10-DL-NEXT:    global_store_short v0, v1, s[4:5]
; GFX10-DL-NEXT:    s_endpgm
                                       ptr addrspace(1) %src2,
                                       ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <8 x i4>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <8 x i4>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <8 x i4>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <8 x i4>, ptr addrspace(1) %gep2

  %v1e0 = extractelement <8 x i4> %vec1, i64 0
  %cv1e0 = sext i4 %v1e0 to i16
  %v2e0 = extractelement <8 x i4> %vec2, i64 0
  %cv2e0 = sext i4 %v2e0 to i16
  %mul0 = mul nuw nsw i16 %cv1e0, %cv2e0

  %v1e1 = extractelement <8 x i4> %vec1, i64 1
  %cv1e1 = sext i4 %v1e1 to i16
  %v2e1 = extractelement <8 x i4> %vec2, i64 1
  %cv2e1 = sext i4 %v2e1 to i16
  %mul1 = mul nuw nsw i16 %cv1e1, %cv2e1

  %v1e2 = extractelement <8 x i4> %vec1, i64 2
  %cv1e2 = sext i4 %v1e2 to i16
  %v2e2 = extractelement <8 x i4> %vec2, i64 2
  %cv2e2 = sext i4 %v2e2 to i16
  %mul2 = mul nuw nsw i16 %cv1e2, %cv2e2

  %v1e3 = extractelement <8 x i4> %vec1, i64 3
  %cv1e3 = sext i4 %v1e3 to i16
  %v2e3 = extractelement <8 x i4> %vec2, i64 3
  %cv2e3 = sext i4 %v2e3 to i16
  %mul3 = mul nuw nsw i16 %cv1e3, %cv2e3

  %v1e4 = extractelement <8 x i4> %vec1, i64 4
  %cv1e4 = sext i4 %v1e4 to i16
  %v2e4 = extractelement <8 x i4> %vec2, i64 4
  %cv2e4 = sext i4 %v2e4 to i16
  %mul4 = mul nuw nsw i16 %cv1e4, %cv2e4

  %v1e5 = extractelement <8 x i4> %vec1, i64 5
  %cv1e5 = sext i4 %v1e5 to i16
  %v2e5 = extractelement <8 x i4> %vec2, i64 5
  %cv2e5 = sext i4 %v2e5 to i16
  %mul5 = mul nuw nsw i16 %cv1e5, %cv2e5

  %v1e6 = extractelement <8 x i4> %vec1, i64 6
  %cv1e6 = sext i4 %v1e6 to i16
  %v2e6 = extractelement <8 x i4> %vec2, i64 6
  %cv2e6 = sext i4 %v2e6 to i16
  %mul6 = mul nuw nsw i16 %cv1e6, %cv2e6

  %v1e7 = extractelement <8 x i4> %vec1, i64 7
  %cv1e7 = sext i4 %v1e7 to i16
  %v2e7 = extractelement <8 x i4> %vec2, i64 7
  %cv2e7 = sext i4 %v2e7 to i16
  %mul7 = mul nuw nsw i16 %cv1e7, %cv2e7

  %acc = load i16, ptr addrspace(1) %dst, align 4
  %add1 = add i16 %mul0, %acc
  %add2 = add i16 %add1, %mul1
  %add3 = add i16 %add2, %mul2
  %add4 = add i16 %add3, %mul3
  %add5 = add i16 %add4, %mul4
  %add6 = add i16 %add5, %mul5
  %add7 = add i16 %add6, %mul6
  %add8 = add i16 %add7, %mul7

  store i16 %add8, ptr addrspace(1) %dst, align 4
  ret void
}

; TODO: Support this pattern.
define amdgpu_kernel void @idot8_acc8(ptr addrspace(1) %src1,
; GFX7-LABEL: idot8_acc8:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX7-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s14, -1
; GFX7-NEXT:    s_mov_b32 s15, 0xe8f000
; GFX7-NEXT:    s_add_u32 s12, s12, s3
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    buffer_load_ubyte v1, off, s[0:3], 0
; GFX7-NEXT:    s_addc_u32 s13, s13, 0
; GFX7-NEXT:    s_waitcnt vmcnt(2)
; GFX7-NEXT:    v_bfe_i32 v3, v2, 0, 4
; GFX7-NEXT:    v_bfe_i32 v4, v2, 4, 4
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_bfe_i32 v10, v0, 0, 4
; GFX7-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX7-NEXT:    v_bfe_i32 v11, v0, 4, 4
; GFX7-NEXT:    v_and_b32_e32 v10, 0xff, v10
; GFX7-NEXT:    v_bfe_i32 v5, v2, 8, 4
; GFX7-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX7-NEXT:    v_bfe_i32 v12, v0, 8, 4
; GFX7-NEXT:    v_and_b32_e32 v11, 0xff, v11
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v3, v10, v1
; GFX7-NEXT:    v_bfe_i32 v6, v2, 12, 4
; GFX7-NEXT:    v_and_b32_e32 v5, 0xff, v5
; GFX7-NEXT:    v_bfe_i32 v13, v0, 12, 4
; GFX7-NEXT:    v_and_b32_e32 v12, 0xff, v12
; GFX7-NEXT:    v_mad_u32_u24 v1, v4, v11, v1
; GFX7-NEXT:    v_bfe_i32 v7, v2, 16, 4
; GFX7-NEXT:    v_and_b32_e32 v6, 0xff, v6
; GFX7-NEXT:    v_bfe_i32 v14, v0, 16, 4
; GFX7-NEXT:    v_and_b32_e32 v13, 0xff, v13
; GFX7-NEXT:    v_mad_u32_u24 v1, v5, v12, v1
; GFX7-NEXT:    v_bfe_i32 v8, v2, 20, 4
; GFX7-NEXT:    v_and_b32_e32 v7, 0xff, v7
; GFX7-NEXT:    v_bfe_i32 v15, v0, 20, 4
; GFX7-NEXT:    v_and_b32_e32 v14, 0xff, v14
; GFX7-NEXT:    v_mad_u32_u24 v1, v6, v13, v1
; GFX7-NEXT:    v_bfe_i32 v9, v2, 24, 4
; GFX7-NEXT:    v_and_b32_e32 v8, 0xff, v8
; GFX7-NEXT:    v_bfe_i32 v16, v0, 24, 4
; GFX7-NEXT:    v_and_b32_e32 v15, 0xff, v15
; GFX7-NEXT:    v_mad_u32_u24 v1, v7, v14, v1
; GFX7-NEXT:    v_ashrrev_i32_e32 v2, 28, v2
; GFX7-NEXT:    v_and_b32_e32 v9, 0xff, v9
; GFX7-NEXT:    v_ashrrev_i32_e32 v0, 28, v0
; GFX7-NEXT:    v_and_b32_e32 v16, 0xff, v16
; GFX7-NEXT:    v_mad_u32_u24 v1, v8, v15, v1
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_mad_u32_u24 v1, v9, v16, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot8_acc8:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    v_mov_b32_e32 v5, 12
; GFX8-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_load_ubyte v4, v[0:1]
; GFX8-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    s_mov_b32 s11, 0xe80000
; GFX8-NEXT:    s_add_u32 s8, s8, s3
; GFX8-NEXT:    s_addc_u32 s9, s9, 0
; GFX8-NEXT:    s_waitcnt vmcnt(2)
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 4, v3
; GFX8-NEXT:    v_lshlrev_b16_e32 v16, 12, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 28, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 20, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 12, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 8, v3
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_lshrrev_b32_e32 v15, 4, v2
; GFX8-NEXT:    v_lshlrev_b16_e32 v17, 12, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 28, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v12, 20, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v13, 12, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v14, 8, v2
; GFX8-NEXT:    v_lshlrev_b16_sdwa v18, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_lshlrev_b16_sdwa v19, v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_lshlrev_b16_sdwa v3, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
; GFX8-NEXT:    v_lshlrev_b16_sdwa v2, v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
; GFX8-NEXT:    v_ashrrev_i16_e32 v5, 12, v16
; GFX8-NEXT:    v_ashrrev_i16_e32 v16, 12, v17
; GFX8-NEXT:    v_lshlrev_b16_e32 v10, 12, v10
; GFX8-NEXT:    v_lshlrev_b16_e32 v15, 12, v15
; GFX8-NEXT:    v_lshlrev_b16_e32 v9, 12, v9
; GFX8-NEXT:    v_lshlrev_b16_e32 v14, 12, v14
; GFX8-NEXT:    v_ashrrev_i16_e32 v10, 12, v10
; GFX8-NEXT:    v_ashrrev_i16_e32 v15, 12, v15
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mad_u16 v4, v5, v16, v4
; GFX8-NEXT:    v_lshlrev_b16_e32 v8, 12, v8
; GFX8-NEXT:    v_lshlrev_b16_e32 v13, 12, v13
; GFX8-NEXT:    v_ashrrev_i16_e32 v9, 12, v9
; GFX8-NEXT:    v_ashrrev_i16_e32 v14, 12, v14
; GFX8-NEXT:    v_mad_u16 v4, v10, v15, v4
; GFX8-NEXT:    v_ashrrev_i16_e32 v8, 12, v8
; GFX8-NEXT:    v_ashrrev_i16_e32 v13, 12, v13
; GFX8-NEXT:    v_mad_u16 v4, v9, v14, v4
; GFX8-NEXT:    v_ashrrev_i16_e32 v17, 12, v18
; GFX8-NEXT:    v_ashrrev_i16_e32 v18, 12, v19
; GFX8-NEXT:    v_lshlrev_b16_e32 v7, 12, v7
; GFX8-NEXT:    v_lshlrev_b16_e32 v12, 12, v12
; GFX8-NEXT:    v_mad_u16 v4, v8, v13, v4
; GFX8-NEXT:    v_ashrrev_i16_e32 v7, 12, v7
; GFX8-NEXT:    v_ashrrev_i16_e32 v12, 12, v12
; GFX8-NEXT:    v_mad_u16 v4, v17, v18, v4
; GFX8-NEXT:    v_ashrrev_i16_e32 v3, 12, v3
; GFX8-NEXT:    v_ashrrev_i16_e32 v2, 12, v2
; GFX8-NEXT:    v_lshlrev_b16_e32 v6, 12, v6
; GFX8-NEXT:    v_lshlrev_b16_e32 v11, 12, v11
; GFX8-NEXT:    v_mad_u16 v4, v7, v12, v4
; GFX8-NEXT:    v_ashrrev_i16_e32 v6, 12, v6
; GFX8-NEXT:    v_ashrrev_i16_e32 v11, 12, v11
; GFX8-NEXT:    v_mad_u16 v2, v3, v2, v4
; GFX8-NEXT:    v_mad_u16 v2, v6, v11, v2
; GFX8-NEXT:    flat_store_byte v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: idot8_acc8:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-NEXT:    s_add_u32 s8, s8, s3
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v4, 12
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    global_load_ubyte v3, v0, s[2:3]
; GFX9-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 4, v1
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_lshrrev_b32_e32 v14, 4, v2
; GFX9-NEXT:    v_lshlrev_b16_e32 v15, 12, v1
; GFX9-NEXT:    v_lshlrev_b16_e32 v16, 12, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 28, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 20, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 12, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 8, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 28, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 20, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 12, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v13, 8, v2
; GFX9-NEXT:    v_lshlrev_b16_sdwa v17, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_lshlrev_b16_sdwa v18, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_lshlrev_b16_sdwa v1, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
; GFX9-NEXT:    v_lshlrev_b16_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
; GFX9-NEXT:    v_ashrrev_i16_e32 v4, 12, v15
; GFX9-NEXT:    v_ashrrev_i16_e32 v15, 12, v16
; GFX9-NEXT:    v_lshlrev_b16_e32 v9, 12, v9
; GFX9-NEXT:    v_lshlrev_b16_e32 v14, 12, v14
; GFX9-NEXT:    v_lshlrev_b16_e32 v8, 12, v8
; GFX9-NEXT:    v_lshlrev_b16_e32 v13, 12, v13
; GFX9-NEXT:    v_ashrrev_i16_e32 v9, 12, v9
; GFX9-NEXT:    v_ashrrev_i16_e32 v14, 12, v14
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mad_legacy_u16 v3, v4, v15, v3
; GFX9-NEXT:    v_lshlrev_b16_e32 v7, 12, v7
; GFX9-NEXT:    v_lshlrev_b16_e32 v12, 12, v12
; GFX9-NEXT:    v_ashrrev_i16_e32 v8, 12, v8
; GFX9-NEXT:    v_ashrrev_i16_e32 v13, 12, v13
; GFX9-NEXT:    v_mad_legacy_u16 v3, v9, v14, v3
; GFX9-NEXT:    v_ashrrev_i16_e32 v7, 12, v7
; GFX9-NEXT:    v_ashrrev_i16_e32 v12, 12, v12
; GFX9-NEXT:    v_mad_legacy_u16 v3, v8, v13, v3
; GFX9-NEXT:    v_ashrrev_i16_e32 v16, 12, v17
; GFX9-NEXT:    v_ashrrev_i16_e32 v17, 12, v18
; GFX9-NEXT:    v_lshlrev_b16_e32 v6, 12, v6
; GFX9-NEXT:    v_lshlrev_b16_e32 v11, 12, v11
; GFX9-NEXT:    v_mad_legacy_u16 v3, v7, v12, v3
; GFX9-NEXT:    v_ashrrev_i16_e32 v6, 12, v6
; GFX9-NEXT:    v_ashrrev_i16_e32 v11, 12, v11
; GFX9-NEXT:    v_mad_legacy_u16 v3, v16, v17, v3
; GFX9-NEXT:    v_ashrrev_i16_e32 v1, 12, v1
; GFX9-NEXT:    v_ashrrev_i16_e32 v2, 12, v2
; GFX9-NEXT:    v_lshlrev_b16_e32 v5, 12, v5
; GFX9-NEXT:    v_lshlrev_b16_e32 v10, 12, v10
; GFX9-NEXT:    v_mad_legacy_u16 v3, v6, v11, v3
; GFX9-NEXT:    v_ashrrev_i16_e32 v5, 12, v5
; GFX9-NEXT:    v_ashrrev_i16_e32 v10, 12, v10
; GFX9-NEXT:    v_mad_legacy_u16 v1, v1, v2, v3
; GFX9-NEXT:    v_mad_legacy_u16 v1, v5, v10, v1
; GFX9-NEXT:    global_store_byte v0, v1, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot8_acc8:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-DL-NEXT:    s_mov_b32 s10, -1
; GFX9-DL-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    v_mov_b32_e32 v4, 12
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    global_load_ubyte v3, v0, s[2:3]
; GFX9-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v9, 4, v1
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v14, 4, v2
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v15, 12, v1
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v16, 12, v2
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v5, 28, v1
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v6, 20, v1
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v7, 12, v1
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v8, 8, v1
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v10, 28, v2
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v11, 20, v2
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v12, 12, v2
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v13, 8, v2
; GFX9-DL-NEXT:    v_lshlrev_b16_sdwa v17, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-DL-NEXT:    v_lshlrev_b16_sdwa v18, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-DL-NEXT:    v_lshlrev_b16_sdwa v1, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
; GFX9-DL-NEXT:    v_lshlrev_b16_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v4, 12, v15
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v15, 12, v16
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v9, 12, v9
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v14, 12, v14
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v8, 12, v8
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v13, 12, v13
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v9, 12, v9
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v14, 12, v14
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_mad_legacy_u16 v3, v4, v15, v3
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v7, 12, v7
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v12, 12, v12
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v8, 12, v8
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v13, 12, v13
; GFX9-DL-NEXT:    v_mad_legacy_u16 v3, v9, v14, v3
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v7, 12, v7
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v12, 12, v12
; GFX9-DL-NEXT:    v_mad_legacy_u16 v3, v8, v13, v3
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v16, 12, v17
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v17, 12, v18
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v6, 12, v6
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v11, 12, v11
; GFX9-DL-NEXT:    v_mad_legacy_u16 v3, v7, v12, v3
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v6, 12, v6
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v11, 12, v11
; GFX9-DL-NEXT:    v_mad_legacy_u16 v3, v16, v17, v3
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v1, 12, v1
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v2, 12, v2
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v5, 12, v5
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v10, 12, v10
; GFX9-DL-NEXT:    v_mad_legacy_u16 v3, v6, v11, v3
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v5, 12, v5
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v10, 12, v10
; GFX9-DL-NEXT:    v_mad_legacy_u16 v1, v1, v2, v3
; GFX9-DL-NEXT:    v_mad_legacy_u16 v1, v5, v10, v1
; GFX9-DL-NEXT:    global_store_byte v0, v1, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-XNACK-LABEL: idot8_acc8:
; GFX10-DL-XNACK:       ; %bb.0: ; %entry
; GFX10-DL-XNACK-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-XNACK-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-XNACK-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10-DL-XNACK-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10-DL-XNACK-NEXT:    s_mov_b32 s10, -1
; GFX10-DL-XNACK-NEXT:    s_mov_b32 s11, 0x31c16000
; GFX10-DL-XNACK-NEXT:    s_add_u32 s8, s8, s3
; GFX10-DL-XNACK-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-DL-XNACK-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-XNACK-NEXT:    s_clause 0x1
; GFX10-DL-XNACK-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-XNACK-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-XNACK-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-XNACK-NEXT:    global_load_ubyte v3, v0, s[0:1]
; GFX10-DL-XNACK-NEXT:    s_waitcnt vmcnt(2)
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v4, 28, v1
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v6, 20, v1
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v7, 16, v1
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v8, 12, v1
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v9, 8, v1
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v10, 4, v1
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v1, 12, v1
; GFX10-DL-XNACK-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v16, 4, v2
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v17, 12, v2
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v11, 28, v2
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v12, 24, v2
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v13, 20, v2
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v14, 16, v2
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v15, 12, v2
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v2, 8, v2
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v1, 12, v1
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v10, 12, v10
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v16, 12, v16
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v17, 12, v17
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v9, 12, v9
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v2, 12, v2
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v10, 12, v10
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v16, 12, v16
; GFX10-DL-XNACK-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-XNACK-NEXT:    v_mad_u16 v1, v1, v17, v3
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v3, 12, v9
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v2, 12, v2
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v8, 12, v8
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v9, 12, v15
; GFX10-DL-XNACK-NEXT:    v_mad_u16 v1, v10, v16, v1
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v7, 12, v7
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v10, 12, v14
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v8, 12, v8
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v9, 12, v9
; GFX10-DL-XNACK-NEXT:    v_mad_u16 v1, v3, v2, v1
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v2, 12, v7
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v3, 12, v10
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v6, 12, v6
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v7, 12, v13
; GFX10-DL-XNACK-NEXT:    v_mad_u16 v1, v8, v9, v1
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v5, 12, v5
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v8, 12, v12
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v6, 12, v6
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v7, 12, v7
; GFX10-DL-XNACK-NEXT:    v_mad_u16 v1, v2, v3, v1
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v2, 12, v5
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v3, 12, v8
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v4, 12, v4
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v5, 12, v11
; GFX10-DL-XNACK-NEXT:    v_mad_u16 v1, v6, v7, v1
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v4, 12, v4
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v5, 12, v5
; GFX10-DL-XNACK-NEXT:    v_mad_u16 v1, v2, v3, v1
; GFX10-DL-XNACK-NEXT:    v_mad_u16 v1, v4, v5, v1
; GFX10-DL-XNACK-NEXT:    global_store_byte v0, v1, s[0:1]
; GFX10-DL-XNACK-NEXT:    s_endpgm
;
; GFX10-DL-NOXNACK-LABEL: idot8_acc8:
; GFX10-DL-NOXNACK:       ; %bb.0: ; %entry
; GFX10-DL-NOXNACK-NEXT:    s_clause 0x1
; GFX10-DL-NOXNACK-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NOXNACK-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NOXNACK-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NOXNACK-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10-DL-NOXNACK-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10-DL-NOXNACK-NEXT:    s_mov_b32 s10, -1
; GFX10-DL-NOXNACK-NEXT:    s_mov_b32 s11, 0x31c16000
; GFX10-DL-NOXNACK-NEXT:    s_add_u32 s8, s8, s3
; GFX10-DL-NOXNACK-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-DL-NOXNACK-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NOXNACK-NEXT:    s_clause 0x1
; GFX10-DL-NOXNACK-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NOXNACK-NEXT:    global_load_dword v0, v0, s[6:7]
; GFX10-DL-NOXNACK-NEXT:    global_load_ubyte v3, v2, s[0:1]
; GFX10-DL-NOXNACK-NEXT:    s_waitcnt vmcnt(2)
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v4, 28, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v6, 20, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v7, 16, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v8, 12, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v9, 8, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v10, 4, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v1, 12, v1
; GFX10-DL-NOXNACK-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v16, 4, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v17, 12, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v11, 28, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v12, 24, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v13, 20, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v14, 16, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v15, 12, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v1, 12, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v10, 12, v10
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v16, 12, v16
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v17, 12, v17
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v9, 12, v9
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v0, 12, v0
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v10, 12, v10
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v16, 12, v16
; GFX10-DL-NOXNACK-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NOXNACK-NEXT:    v_mad_u16 v1, v1, v17, v3
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v3, 12, v9
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v0, 12, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v8, 12, v8
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v9, 12, v15
; GFX10-DL-NOXNACK-NEXT:    v_mad_u16 v1, v10, v16, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v7, 12, v7
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v10, 12, v14
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v8, 12, v8
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v9, 12, v9
; GFX10-DL-NOXNACK-NEXT:    v_mad_u16 v0, v3, v0, v1
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v1, 12, v7
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v3, 12, v10
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v6, 12, v6
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v7, 12, v13
; GFX10-DL-NOXNACK-NEXT:    v_mad_u16 v0, v8, v9, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v5, 12, v5
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v8, 12, v12
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v6, 12, v6
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v7, 12, v7
; GFX10-DL-NOXNACK-NEXT:    v_mad_u16 v0, v1, v3, v0
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v1, 12, v5
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v3, 12, v8
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v4, 12, v4
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v5, 12, v11
; GFX10-DL-NOXNACK-NEXT:    v_mad_u16 v0, v6, v7, v0
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v4, 12, v4
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v5, 12, v5
; GFX10-DL-NOXNACK-NEXT:    v_mad_u16 v0, v1, v3, v0
; GFX10-DL-NOXNACK-NEXT:    v_mad_u16 v0, v4, v5, v0
; GFX10-DL-NOXNACK-NEXT:    global_store_byte v2, v0, s[0:1]
; GFX10-DL-NOXNACK-NEXT:    s_endpgm
; GFX10-DL-LABEL: idot8_acc8:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x34
; GFX10-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX10-DL-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX10-DL-NEXT:    s_mov_b32 s14, -1
; GFX10-DL-NEXT:    s_mov_b32 s15, 0x31c16000
; GFX10-DL-NEXT:    s_add_u32 s12, s12, s3
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-DL-NEXT:    s_addc_u32 s13, s13, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    global_load_ubyte v1, v0, s[4:5]
; GFX10-DL-NEXT:    s_load_dword s0, s[0:1], 0x0
; GFX10-DL-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_lshr_b32 s2, s0, 12
; GFX10-DL-NEXT:    s_lshr_b32 s3, s1, 12
; GFX10-DL-NEXT:    s_bfe_i32 s6, s0, 0x40000
; GFX10-DL-NEXT:    s_bfe_i32 s7, s1, 0x40000
; GFX10-DL-NEXT:    v_lshlrev_b16_e64 v2, 12, s2
; GFX10-DL-NEXT:    v_lshlrev_b16_e64 v3, 12, s3
; GFX10-DL-NEXT:    s_bfe_i32 s8, s0, 0x40004
; GFX10-DL-NEXT:    s_bfe_i32 s9, s0, 0x40008
; GFX10-DL-NEXT:    s_bfe_i32 s10, s1, 0x40008
; GFX10-DL-NEXT:    s_bfe_i32 s2, s1, 0x40004
; GFX10-DL-NEXT:    v_mul_i32_i24_e64 v4, s9, s10
; GFX10-DL-NEXT:    v_ashrrev_i16_e64 v2, 12, v2
; GFX10-DL-NEXT:    v_ashrrev_i16_e64 v3, 12, v3
; GFX10-DL-NEXT:    s_bfe_i32 s3, s1, 0x40010
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_mad_i32_i24 v1, s6, s7, v1
; GFX10-DL-NEXT:    v_mad_i32_i24 v1, s8, s2, v1
; GFX10-DL-NEXT:    s_movk_i32 s2, 0xff
; GFX10-DL-NEXT:    v_and_b32_e32 v2, s2, v2
; GFX10-DL-NEXT:    v_and_b32_e32 v3, s2, v3
; GFX10-DL-NEXT:    v_add_nc_u32_sdwa v1, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX10-DL-NEXT:    s_bfe_i32 s2, s0, 0x40010
; GFX10-DL-NEXT:    v_mad_u32_u24 v1, v2, v3, v1
; GFX10-DL-NEXT:    v_mad_i32_i24 v1, s2, s3, v1
; GFX10-DL-NEXT:    s_bfe_i32 s2, s0, 0x40014
; GFX10-DL-NEXT:    s_bfe_i32 s3, s1, 0x40014
; GFX10-DL-NEXT:    v_mad_i32_i24 v1, s2, s3, v1
; GFX10-DL-NEXT:    s_bfe_i32 s2, s0, 0x40018
; GFX10-DL-NEXT:    s_bfe_i32 s3, s1, 0x40018
; GFX10-DL-NEXT:    s_ashr_i32 s0, s0, 28
; GFX10-DL-NEXT:    s_ashr_i32 s1, s1, 28
; GFX10-DL-NEXT:    v_mad_i32_i24 v1, s2, s3, v1
; GFX10-DL-NEXT:    v_mad_i32_i24 v1, s0, s1, v1
; GFX10-DL-NEXT:    global_store_byte v0, v1, s[4:5]
; GFX10-DL-NEXT:    s_endpgm
                                       ptr addrspace(1) %src2,
                                       ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <8 x i4>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <8 x i4>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <8 x i4>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <8 x i4>, ptr addrspace(1) %gep2

  %v1e0 = extractelement <8 x i4> %vec1, i64 0
  %cv1e0 = sext i4 %v1e0 to i8
  %v2e0 = extractelement <8 x i4> %vec2, i64 0
  %cv2e0 = sext i4 %v2e0 to i8
  %mul0 = mul nuw nsw i8 %cv1e0, %cv2e0

  %v1e1 = extractelement <8 x i4> %vec1, i64 1
  %cv1e1 = sext i4 %v1e1 to i8
  %v2e1 = extractelement <8 x i4> %vec2, i64 1
  %cv2e1 = sext i4 %v2e1 to i8
  %mul1 = mul nuw nsw i8 %cv1e1, %cv2e1

  %v1e2 = extractelement <8 x i4> %vec1, i64 2
  %cv1e2 = sext i4 %v1e2 to i8
  %v2e2 = extractelement <8 x i4> %vec2, i64 2
  %cv2e2 = sext i4 %v2e2 to i8
  %mul2 = mul nuw nsw i8 %cv1e2, %cv2e2

  %v1e3 = extractelement <8 x i4> %vec1, i64 3
  %cv1e3 = sext i4 %v1e3 to i8
  %v2e3 = extractelement <8 x i4> %vec2, i64 3
  %cv2e3 = sext i4 %v2e3 to i8
  %mul3 = mul nuw nsw i8 %cv1e3, %cv2e3

  %v1e4 = extractelement <8 x i4> %vec1, i64 4
  %cv1e4 = sext i4 %v1e4 to i8
  %v2e4 = extractelement <8 x i4> %vec2, i64 4
  %cv2e4 = sext i4 %v2e4 to i8
  %mul4 = mul nuw nsw i8 %cv1e4, %cv2e4

  %v1e5 = extractelement <8 x i4> %vec1, i64 5
  %cv1e5 = sext i4 %v1e5 to i8
  %v2e5 = extractelement <8 x i4> %vec2, i64 5
  %cv2e5 = sext i4 %v2e5 to i8
  %mul5 = mul nuw nsw i8 %cv1e5, %cv2e5

  %v1e6 = extractelement <8 x i4> %vec1, i64 6
  %cv1e6 = sext i4 %v1e6 to i8
  %v2e6 = extractelement <8 x i4> %vec2, i64 6
  %cv2e6 = sext i4 %v2e6 to i8
  %mul6 = mul nuw nsw i8 %cv1e6, %cv2e6

  %v1e7 = extractelement <8 x i4> %vec1, i64 7
  %cv1e7 = sext i4 %v1e7 to i8
  %v2e7 = extractelement <8 x i4> %vec2, i64 7
  %cv2e7 = sext i4 %v2e7 to i8
  %mul7 = mul nuw nsw i8 %cv1e7, %cv2e7

  %acc = load i8, ptr addrspace(1) %dst, align 4
  %add1 = add i8 %mul0, %acc
  %add2 = add i8 %add1, %mul1
  %add3 = add i8 %add2, %mul2
  %add4 = add i8 %add3, %mul3
  %add5 = add i8 %add4, %mul4
  %add6 = add i8 %add5, %mul5
  %add7 = add i8 %add6, %mul6
  %add8 = add i8 %add7, %mul7

  store i8 %add8, ptr addrspace(1) %dst, align 4
  ret void
}

; Make sure the pattern is not recognized if there are multiple uses of the
; intermediate multiplications.
define amdgpu_kernel void @idot8_multiuses_mul1(ptr addrspace(1) %src1,
; GFX7-LABEL: idot8_multiuses_mul1:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX7-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s14, -1
; GFX7-NEXT:    s_mov_b32 s15, 0xe8f000
; GFX7-NEXT:    s_add_u32 s12, s12, s3
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_addc_u32 s13, s13, 0
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_bfe_i32 v1, v2, 0, 4
; GFX7-NEXT:    v_bfe_i32 v3, v2, 4, 4
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_i32 v9, v0, 0, 4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_i32_i24 v16, v1, v9, s4
; GFX7-NEXT:    v_bfe_i32 v10, v0, 4, 4
; GFX7-NEXT:    v_mad_i32_i24 v1, v1, v9, v16
; GFX7-NEXT:    v_bfe_i32 v4, v2, 8, 4
; GFX7-NEXT:    v_bfe_i32 v11, v0, 8, 4
; GFX7-NEXT:    v_mad_i32_i24 v1, v3, v10, v1
; GFX7-NEXT:    v_bfe_i32 v5, v2, 12, 4
; GFX7-NEXT:    v_bfe_i32 v12, v0, 12, 4
; GFX7-NEXT:    v_mad_i32_i24 v1, v4, v11, v1
; GFX7-NEXT:    v_bfe_i32 v6, v2, 16, 4
; GFX7-NEXT:    v_bfe_i32 v13, v0, 16, 4
; GFX7-NEXT:    v_mad_i32_i24 v1, v5, v12, v1
; GFX7-NEXT:    v_bfe_i32 v7, v2, 20, 4
; GFX7-NEXT:    v_bfe_i32 v14, v0, 20, 4
; GFX7-NEXT:    v_mad_i32_i24 v1, v6, v13, v1
; GFX7-NEXT:    v_bfe_i32 v8, v2, 24, 4
; GFX7-NEXT:    v_bfe_i32 v15, v0, 24, 4
; GFX7-NEXT:    v_mad_i32_i24 v1, v7, v14, v1
; GFX7-NEXT:    v_ashrrev_i32_e32 v2, 28, v2
; GFX7-NEXT:    v_ashrrev_i32_e32 v0, 28, v0
; GFX7-NEXT:    v_mad_i32_i24 v1, v8, v15, v1
; GFX7-NEXT:    v_mad_i32_i24 v0, v2, v0, v1
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, v16, v0
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot8_multiuses_mul1:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX8-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    s_mov_b32 s11, 0xe80000
; GFX8-NEXT:    s_add_u32 s8, s8, s3
; GFX8-NEXT:    s_addc_u32 s9, s9, 0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_bfe_i32 v1, v3, 0, 4
; GFX8-NEXT:    v_bfe_i32 v4, v3, 4, 4
; GFX8-NEXT:    v_bfe_i32 v6, v3, 8, 4
; GFX8-NEXT:    v_bfe_i32 v8, v3, 12, 4
; GFX8-NEXT:    v_bfe_i32 v10, v3, 16, 4
; GFX8-NEXT:    v_bfe_i32 v12, v3, 20, 4
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_bfe_i32 v2, v0, 0, 4
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_i32_i24 v16, v1, v2, s2
; GFX8-NEXT:    v_bfe_i32 v5, v0, 4, 4
; GFX8-NEXT:    v_mad_i32_i24 v1, v1, v2, v16
; GFX8-NEXT:    v_bfe_i32 v7, v0, 8, 4
; GFX8-NEXT:    v_mad_i32_i24 v1, v4, v5, v1
; GFX8-NEXT:    v_bfe_i32 v9, v0, 12, 4
; GFX8-NEXT:    v_mad_i32_i24 v1, v6, v7, v1
; GFX8-NEXT:    v_bfe_i32 v11, v0, 16, 4
; GFX8-NEXT:    v_mad_i32_i24 v1, v8, v9, v1
; GFX8-NEXT:    v_bfe_i32 v13, v0, 20, 4
; GFX8-NEXT:    v_mad_i32_i24 v1, v10, v11, v1
; GFX8-NEXT:    v_bfe_i32 v14, v3, 24, 4
; GFX8-NEXT:    v_bfe_i32 v15, v0, 24, 4
; GFX8-NEXT:    v_mad_i32_i24 v1, v12, v13, v1
; GFX8-NEXT:    v_ashrrev_i32_e32 v3, 28, v3
; GFX8-NEXT:    v_ashrrev_i32_e32 v0, 28, v0
; GFX8-NEXT:    v_mad_i32_i24 v1, v14, v15, v1
; GFX8-NEXT:    v_mad_i32_i24 v0, v3, v0, v1
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, v16, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: idot8_multiuses_mul1:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-NEXT:    s_add_u32 s8, s8, s3
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_bfe_i32 v3, v1, 0, 4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_bfe_i32 v4, v2, 0, 4
; GFX9-NEXT:    v_bfe_i32 v5, v1, 4, 4
; GFX9-NEXT:    v_bfe_i32 v6, v2, 4, 4
; GFX9-NEXT:    v_bfe_i32 v7, v1, 8, 4
; GFX9-NEXT:    v_bfe_i32 v8, v2, 8, 4
; GFX9-NEXT:    v_bfe_i32 v9, v1, 12, 4
; GFX9-NEXT:    v_bfe_i32 v10, v2, 12, 4
; GFX9-NEXT:    v_bfe_i32 v11, v1, 16, 4
; GFX9-NEXT:    v_bfe_i32 v12, v2, 16, 4
; GFX9-NEXT:    v_bfe_i32 v13, v1, 20, 4
; GFX9-NEXT:    v_bfe_i32 v14, v2, 20, 4
; GFX9-NEXT:    v_bfe_i32 v15, v1, 24, 4
; GFX9-NEXT:    v_bfe_i32 v16, v2, 24, 4
; GFX9-NEXT:    v_ashrrev_i32_e32 v1, 28, v1
; GFX9-NEXT:    v_ashrrev_i32_e32 v2, 28, v2
; GFX9-NEXT:    v_mul_i32_i24_e32 v1, v1, v2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mad_i32_i24 v2, v3, v4, s0
; GFX9-NEXT:    v_mul_i32_i24_e32 v5, v5, v6
; GFX9-NEXT:    v_mul_i32_i24_e32 v6, v7, v8
; GFX9-NEXT:    v_mad_i32_i24 v3, v3, v4, v2
; GFX9-NEXT:    v_mul_i32_i24_e32 v7, v9, v10
; GFX9-NEXT:    v_mul_i32_i24_e32 v8, v11, v12
; GFX9-NEXT:    v_add3_u32 v3, v3, v5, v6
; GFX9-NEXT:    v_mul_i32_i24_e32 v9, v13, v14
; GFX9-NEXT:    v_mul_i32_i24_e32 v10, v15, v16
; GFX9-NEXT:    v_add3_u32 v3, v3, v7, v8
; GFX9-NEXT:    v_add3_u32 v3, v3, v9, v10
; GFX9-NEXT:    v_add3_u32 v1, v3, v1, v2
; GFX9-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot8_multiuses_mul1:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-DL-NEXT:    s_mov_b32 s10, -1
; GFX9-DL-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-DL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_bfe_i32 v3, v1, 0, 4
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_bfe_i32 v4, v2, 0, 4
; GFX9-DL-NEXT:    v_bfe_i32 v5, v1, 4, 4
; GFX9-DL-NEXT:    v_bfe_i32 v6, v2, 4, 4
; GFX9-DL-NEXT:    v_bfe_i32 v7, v1, 8, 4
; GFX9-DL-NEXT:    v_bfe_i32 v8, v2, 8, 4
; GFX9-DL-NEXT:    v_bfe_i32 v9, v1, 12, 4
; GFX9-DL-NEXT:    v_bfe_i32 v10, v2, 12, 4
; GFX9-DL-NEXT:    v_bfe_i32 v11, v1, 16, 4
; GFX9-DL-NEXT:    v_bfe_i32 v12, v2, 16, 4
; GFX9-DL-NEXT:    v_bfe_i32 v13, v1, 20, 4
; GFX9-DL-NEXT:    v_bfe_i32 v14, v2, 20, 4
; GFX9-DL-NEXT:    v_bfe_i32 v15, v1, 24, 4
; GFX9-DL-NEXT:    v_bfe_i32 v16, v2, 24, 4
; GFX9-DL-NEXT:    v_ashrrev_i32_e32 v1, 28, v1
; GFX9-DL-NEXT:    v_ashrrev_i32_e32 v2, 28, v2
; GFX9-DL-NEXT:    v_mul_i32_i24_e32 v1, v1, v2
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_mad_i32_i24 v2, v3, v4, s0
; GFX9-DL-NEXT:    v_mul_i32_i24_e32 v5, v5, v6
; GFX9-DL-NEXT:    v_mul_i32_i24_e32 v6, v7, v8
; GFX9-DL-NEXT:    v_mad_i32_i24 v3, v3, v4, v2
; GFX9-DL-NEXT:    v_mul_i32_i24_e32 v7, v9, v10
; GFX9-DL-NEXT:    v_mul_i32_i24_e32 v8, v11, v12
; GFX9-DL-NEXT:    v_add3_u32 v3, v3, v5, v6
; GFX9-DL-NEXT:    v_mul_i32_i24_e32 v9, v13, v14
; GFX9-DL-NEXT:    v_mul_i32_i24_e32 v10, v15, v16
; GFX9-DL-NEXT:    v_add3_u32 v3, v3, v7, v8
; GFX9-DL-NEXT:    v_add3_u32 v3, v3, v9, v10
; GFX9-DL-NEXT:    v_add3_u32 v1, v3, v1, v2
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-XNACK-LABEL: idot8_multiuses_mul1:
; GFX10-DL-XNACK:       ; %bb.0: ; %entry
; GFX10-DL-XNACK-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-XNACK-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-XNACK-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10-DL-XNACK-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10-DL-XNACK-NEXT:    s_mov_b32 s10, -1
; GFX10-DL-XNACK-NEXT:    s_mov_b32 s11, 0x31c16000
; GFX10-DL-XNACK-NEXT:    s_add_u32 s8, s8, s3
; GFX10-DL-XNACK-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-DL-XNACK-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-XNACK-NEXT:    s_clause 0x1
; GFX10-DL-XNACK-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-XNACK-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-XNACK-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-XNACK-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-XNACK-NEXT:    v_bfe_i32 v0, v1, 0, 4
; GFX10-DL-XNACK-NEXT:    v_bfe_i32 v3, v1, 4, 4
; GFX10-DL-XNACK-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-XNACK-NEXT:    v_bfe_i32 v4, v2, 4, 4
; GFX10-DL-XNACK-NEXT:    v_bfe_i32 v5, v1, 8, 4
; GFX10-DL-XNACK-NEXT:    v_bfe_i32 v6, v2, 8, 4
; GFX10-DL-XNACK-NEXT:    v_bfe_i32 v7, v2, 0, 4
; GFX10-DL-XNACK-NEXT:    v_bfe_i32 v8, v1, 12, 4
; GFX10-DL-XNACK-NEXT:    v_mul_i32_i24_e32 v3, v3, v4
; GFX10-DL-XNACK-NEXT:    v_bfe_i32 v9, v2, 12, 4
; GFX10-DL-XNACK-NEXT:    v_mul_i32_i24_e32 v4, v5, v6
; GFX10-DL-XNACK-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-XNACK-NEXT:    v_mad_i32_i24 v5, v0, v7, s2
; GFX10-DL-XNACK-NEXT:    v_bfe_i32 v6, v1, 16, 4
; GFX10-DL-XNACK-NEXT:    v_bfe_i32 v10, v2, 16, 4
; GFX10-DL-XNACK-NEXT:    v_bfe_i32 v11, v1, 20, 4
; GFX10-DL-XNACK-NEXT:    v_bfe_i32 v12, v2, 20, 4
; GFX10-DL-XNACK-NEXT:    v_mad_i32_i24 v0, v0, v7, v5
; GFX10-DL-XNACK-NEXT:    v_bfe_i32 v7, v1, 24, 4
; GFX10-DL-XNACK-NEXT:    v_bfe_i32 v13, v2, 24, 4
; GFX10-DL-XNACK-NEXT:    v_mul_i32_i24_e32 v8, v8, v9
; GFX10-DL-XNACK-NEXT:    v_mul_i32_i24_e32 v6, v6, v10
; GFX10-DL-XNACK-NEXT:    v_add3_u32 v0, v0, v3, v4
; GFX10-DL-XNACK-NEXT:    v_mul_i32_i24_e32 v3, v11, v12
; GFX10-DL-XNACK-NEXT:    v_mul_i32_i24_e32 v4, v7, v13
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i32_e32 v1, 28, v1
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i32_e32 v2, 28, v2
; GFX10-DL-XNACK-NEXT:    v_add3_u32 v0, v0, v8, v6
; GFX10-DL-XNACK-NEXT:    v_mul_i32_i24_e32 v1, v1, v2
; GFX10-DL-XNACK-NEXT:    v_add3_u32 v0, v0, v3, v4
; GFX10-DL-XNACK-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-XNACK-NEXT:    v_add3_u32 v0, v0, v1, v5
; GFX10-DL-XNACK-NEXT:    global_store_dword v2, v0, s[0:1]
; GFX10-DL-XNACK-NEXT:    s_endpgm
;
; GFX10-DL-NOXNACK-LABEL: idot8_multiuses_mul1:
; GFX10-DL-NOXNACK:       ; %bb.0: ; %entry
; GFX10-DL-NOXNACK-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NOXNACK-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NOXNACK-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10-DL-NOXNACK-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10-DL-NOXNACK-NEXT:    s_mov_b32 s10, -1
; GFX10-DL-NOXNACK-NEXT:    s_mov_b32 s11, 0x31c16000
; GFX10-DL-NOXNACK-NEXT:    s_add_u32 s8, s8, s3
; GFX10-DL-NOXNACK-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-DL-NOXNACK-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NOXNACK-NEXT:    s_clause 0x1
; GFX10-DL-NOXNACK-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NOXNACK-NEXT:    global_load_dword v0, v0, s[6:7]
; GFX10-DL-NOXNACK-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NOXNACK-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NOXNACK-NEXT:    v_bfe_i32 v2, v1, 0, 4
; GFX10-DL-NOXNACK-NEXT:    v_bfe_i32 v3, v1, 4, 4
; GFX10-DL-NOXNACK-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NOXNACK-NEXT:    v_bfe_i32 v4, v0, 4, 4
; GFX10-DL-NOXNACK-NEXT:    v_bfe_i32 v5, v1, 8, 4
; GFX10-DL-NOXNACK-NEXT:    v_bfe_i32 v6, v0, 8, 4
; GFX10-DL-NOXNACK-NEXT:    v_bfe_i32 v7, v0, 0, 4
; GFX10-DL-NOXNACK-NEXT:    v_bfe_i32 v8, v1, 12, 4
; GFX10-DL-NOXNACK-NEXT:    v_mul_i32_i24_e32 v3, v3, v4
; GFX10-DL-NOXNACK-NEXT:    v_bfe_i32 v9, v0, 12, 4
; GFX10-DL-NOXNACK-NEXT:    v_mul_i32_i24_e32 v4, v5, v6
; GFX10-DL-NOXNACK-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NOXNACK-NEXT:    v_mad_i32_i24 v5, v2, v7, s2
; GFX10-DL-NOXNACK-NEXT:    v_bfe_i32 v6, v1, 16, 4
; GFX10-DL-NOXNACK-NEXT:    v_bfe_i32 v10, v0, 16, 4
; GFX10-DL-NOXNACK-NEXT:    v_bfe_i32 v11, v1, 20, 4
; GFX10-DL-NOXNACK-NEXT:    v_bfe_i32 v12, v0, 20, 4
; GFX10-DL-NOXNACK-NEXT:    v_mad_i32_i24 v2, v2, v7, v5
; GFX10-DL-NOXNACK-NEXT:    v_bfe_i32 v7, v1, 24, 4
; GFX10-DL-NOXNACK-NEXT:    v_bfe_i32 v13, v0, 24, 4
; GFX10-DL-NOXNACK-NEXT:    v_mul_i32_i24_e32 v8, v8, v9
; GFX10-DL-NOXNACK-NEXT:    v_mul_i32_i24_e32 v6, v6, v10
; GFX10-DL-NOXNACK-NEXT:    v_add3_u32 v2, v2, v3, v4
; GFX10-DL-NOXNACK-NEXT:    v_mul_i32_i24_e32 v3, v11, v12
; GFX10-DL-NOXNACK-NEXT:    v_mul_i32_i24_e32 v4, v7, v13
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i32_e32 v1, 28, v1
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i32_e32 v0, 28, v0
; GFX10-DL-NOXNACK-NEXT:    v_add3_u32 v2, v2, v8, v6
; GFX10-DL-NOXNACK-NEXT:    v_mul_i32_i24_e32 v0, v1, v0
; GFX10-DL-NOXNACK-NEXT:    v_add3_u32 v1, v2, v3, v4
; GFX10-DL-NOXNACK-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NOXNACK-NEXT:    v_add3_u32 v0, v1, v0, v5
; GFX10-DL-NOXNACK-NEXT:    global_store_dword v2, v0, s[0:1]
; GFX10-DL-NOXNACK-NEXT:    s_endpgm
; GFX10-DL-LABEL: idot8_multiuses_mul1:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10-DL-NEXT:    s_mov_b32 s10, -1
; GFX10-DL-NEXT:    s_mov_b32 s11, 0x31c16000
; GFX10-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x34
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_load_dword s6, s[4:5], 0x0
; GFX10-DL-NEXT:    s_load_dword s0, s[0:1], 0x0
; GFX10-DL-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-DL-NEXT:    s_bfe_i32 s2, s0, 0x40000
; GFX10-DL-NEXT:    s_bfe_i32 s3, s1, 0x40000
; GFX10-DL-NEXT:    v_mad_i32_i24 v0, s2, s3, v0
; GFX10-DL-NEXT:    v_mad_i32_i24 v1, s2, s3, v0
; GFX10-DL-NEXT:    s_bfe_i32 s2, s0, 0x40004
; GFX10-DL-NEXT:    s_bfe_i32 s3, s1, 0x40004
; GFX10-DL-NEXT:    v_mad_i32_i24 v1, s2, s3, v1
; GFX10-DL-NEXT:    s_bfe_i32 s2, s0, 0x40008
; GFX10-DL-NEXT:    s_bfe_i32 s3, s1, 0x40008
; GFX10-DL-NEXT:    v_mad_i32_i24 v1, s2, s3, v1
; GFX10-DL-NEXT:    s_bfe_i32 s2, s0, 0x4000c
; GFX10-DL-NEXT:    s_bfe_i32 s3, s1, 0x4000c
; GFX10-DL-NEXT:    v_mad_i32_i24 v1, s2, s3, v1
; GFX10-DL-NEXT:    s_bfe_i32 s2, s0, 0x40010
; GFX10-DL-NEXT:    s_bfe_i32 s3, s1, 0x40010
; GFX10-DL-NEXT:    v_mad_i32_i24 v1, s2, s3, v1
; GFX10-DL-NEXT:    s_bfe_i32 s2, s0, 0x40014
; GFX10-DL-NEXT:    s_bfe_i32 s3, s1, 0x40014
; GFX10-DL-NEXT:    v_mad_i32_i24 v1, s2, s3, v1
; GFX10-DL-NEXT:    s_bfe_i32 s2, s0, 0x40018
; GFX10-DL-NEXT:    s_bfe_i32 s3, s1, 0x40018
; GFX10-DL-NEXT:    s_ashr_i32 s0, s0, 28
; GFX10-DL-NEXT:    s_ashr_i32 s1, s1, 28
; GFX10-DL-NEXT:    v_mad_i32_i24 v1, s2, s3, v1
; GFX10-DL-NEXT:    v_mad_i32_i24 v1, s0, s1, v1
; GFX10-DL-NEXT:    v_add_nc_u32_e32 v0, v0, v1
; GFX10-DL-NEXT:    global_store_dword v2, v0, s[4:5]
; GFX10-DL-NEXT:    s_endpgm
                                                ptr addrspace(1) %src2,
                                                ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <8 x i4>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <8 x i4>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <8 x i4>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <8 x i4>, ptr addrspace(1) %gep2

  %v1e0 = extractelement <8 x i4> %vec1, i64 0
  %cv1e0 = sext i4 %v1e0 to i32
  %v2e0 = extractelement <8 x i4> %vec2, i64 0
  %cv2e0 = sext i4 %v2e0 to i32
  %mul0 = mul nuw nsw i32 %cv1e0, %cv2e0

  %v1e1 = extractelement <8 x i4> %vec1, i64 1
  %cv1e1 = sext i4 %v1e1 to i32
  %v2e1 = extractelement <8 x i4> %vec2, i64 1
  %cv2e1 = sext i4 %v2e1 to i32
  %mul1 = mul nuw nsw i32 %cv1e1, %cv2e1

  %v1e2 = extractelement <8 x i4> %vec1, i64 2
  %cv1e2 = sext i4 %v1e2 to i32
  %v2e2 = extractelement <8 x i4> %vec2, i64 2
  %cv2e2 = sext i4 %v2e2 to i32
  %mul2 = mul nuw nsw i32 %cv1e2, %cv2e2

  %v1e3 = extractelement <8 x i4> %vec1, i64 3
  %cv1e3 = sext i4 %v1e3 to i32
  %v2e3 = extractelement <8 x i4> %vec2, i64 3
  %cv2e3 = sext i4 %v2e3 to i32
  %mul3 = mul nuw nsw i32 %cv1e3, %cv2e3

  %v1e4 = extractelement <8 x i4> %vec1, i64 4
  %cv1e4 = sext i4 %v1e4 to i32
  %v2e4 = extractelement <8 x i4> %vec2, i64 4
  %cv2e4 = sext i4 %v2e4 to i32
  %mul4 = mul nuw nsw i32 %cv1e4, %cv2e4

  %v1e5 = extractelement <8 x i4> %vec1, i64 5
  %cv1e5 = sext i4 %v1e5 to i32
  %v2e5 = extractelement <8 x i4> %vec2, i64 5
  %cv2e5 = sext i4 %v2e5 to i32
  %mul5 = mul nuw nsw i32 %cv1e5, %cv2e5

  %v1e6 = extractelement <8 x i4> %vec1, i64 6
  %cv1e6 = sext i4 %v1e6 to i32
  %v2e6 = extractelement <8 x i4> %vec2, i64 6
  %cv2e6 = sext i4 %v2e6 to i32
  %mul6 = mul nuw nsw i32 %cv1e6, %cv2e6

  %v1e7 = extractelement <8 x i4> %vec1, i64 7
  %cv1e7 = sext i4 %v1e7 to i32
  %v2e7 = extractelement <8 x i4> %vec2, i64 7
  %cv2e7 = sext i4 %v2e7 to i32
  %mul7 = mul nuw nsw i32 %cv1e7, %cv2e7

  %acc = load i32, ptr addrspace(1) %dst, align 4
  %add =  add i32  %mul0, %acc
  %add1 = add i32 %mul0, %add
  %add2 = add i32 %add1, %mul1
  %add3 = add i32 %add2, %mul2
  %add4 = add i32 %add3, %mul3
  %add5 = add i32 %add4, %mul4
  %add6 = add i32 %add5, %mul5
  %add7 = add i32 %add6, %mul6
  %add8 = add i32 %add7, %mul7

  %res = add i32 %add, %add8
  store i32 %res, ptr addrspace(1) %dst, align 4
  ret void
}

; TODO: Support this pattern.
define amdgpu_kernel void @idot8_acc32_vecMul(ptr addrspace(1) %src1,
; GFX7-LABEL: idot8_acc32_vecMul:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX7-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s14, -1
; GFX7-NEXT:    s_mov_b32 s15, 0xe8f000
; GFX7-NEXT:    s_add_u32 s12, s12, s3
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_addc_u32 s13, s13, 0
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_ashrrev_i32_e32 v1, 28, v2
; GFX7-NEXT:    v_bfe_i32 v3, v2, 24, 4
; GFX7-NEXT:    v_bfe_i32 v4, v2, 20, 4
; GFX7-NEXT:    v_bfe_i32 v5, v2, 16, 4
; GFX7-NEXT:    v_bfe_i32 v6, v2, 12, 4
; GFX7-NEXT:    v_bfe_i32 v7, v2, 8, 4
; GFX7-NEXT:    v_bfe_i32 v8, v2, 4, 4
; GFX7-NEXT:    v_bfe_i32 v2, v2, 0, 4
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_ashrrev_i32_e32 v9, 28, v0
; GFX7-NEXT:    v_bfe_i32 v10, v0, 24, 4
; GFX7-NEXT:    v_bfe_i32 v11, v0, 20, 4
; GFX7-NEXT:    v_bfe_i32 v12, v0, 16, 4
; GFX7-NEXT:    v_bfe_i32 v13, v0, 12, 4
; GFX7-NEXT:    v_bfe_i32 v14, v0, 8, 4
; GFX7-NEXT:    v_bfe_i32 v15, v0, 4, 4
; GFX7-NEXT:    v_bfe_i32 v0, v0, 0, 4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_i32_i24 v0, v2, v0, s4
; GFX7-NEXT:    v_mad_i32_i24 v0, v8, v15, v0
; GFX7-NEXT:    v_mad_i32_i24 v0, v7, v14, v0
; GFX7-NEXT:    v_mad_i32_i24 v0, v6, v13, v0
; GFX7-NEXT:    v_mad_i32_i24 v0, v5, v12, v0
; GFX7-NEXT:    v_mad_i32_i24 v0, v4, v11, v0
; GFX7-NEXT:    v_mad_i32_i24 v0, v3, v10, v0
; GFX7-NEXT:    v_mad_i32_i24 v0, v1, v9, v0
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot8_acc32_vecMul:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX8-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    s_mov_b32 s11, 0xe80000
; GFX8-NEXT:    s_add_u32 s8, s8, s3
; GFX8-NEXT:    s_addc_u32 s9, s9, 0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_ashrrev_i32_e32 v1, 28, v3
; GFX8-NEXT:    v_bfe_i32 v2, v3, 24, 4
; GFX8-NEXT:    v_bfe_i32 v4, v3, 20, 4
; GFX8-NEXT:    v_bfe_i32 v5, v3, 16, 4
; GFX8-NEXT:    v_bfe_i32 v6, v3, 12, 4
; GFX8-NEXT:    v_bfe_i32 v7, v3, 8, 4
; GFX8-NEXT:    v_bfe_i32 v8, v3, 4, 4
; GFX8-NEXT:    v_bfe_i32 v3, v3, 0, 4
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_ashrrev_i32_e32 v9, 28, v0
; GFX8-NEXT:    v_bfe_i32 v10, v0, 24, 4
; GFX8-NEXT:    v_bfe_i32 v11, v0, 20, 4
; GFX8-NEXT:    v_bfe_i32 v12, v0, 16, 4
; GFX8-NEXT:    v_bfe_i32 v13, v0, 12, 4
; GFX8-NEXT:    v_bfe_i32 v14, v0, 8, 4
; GFX8-NEXT:    v_bfe_i32 v15, v0, 4, 4
; GFX8-NEXT:    v_bfe_i32 v0, v0, 0, 4
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_i32_i24 v0, v3, v0, s2
; GFX8-NEXT:    v_mad_i32_i24 v0, v8, v15, v0
; GFX8-NEXT:    v_mad_i32_i24 v0, v7, v14, v0
; GFX8-NEXT:    v_mad_i32_i24 v0, v6, v13, v0
; GFX8-NEXT:    v_mad_i32_i24 v0, v5, v12, v0
; GFX8-NEXT:    v_mad_i32_i24 v0, v4, v11, v0
; GFX8-NEXT:    v_mad_i32_i24 v0, v2, v10, v0
; GFX8-NEXT:    v_mad_i32_i24 v2, v1, v9, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: idot8_acc32_vecMul:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-NEXT:    s_add_u32 s8, s8, s3
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_ashrrev_i32_e32 v3, 28, v1
; GFX9-NEXT:    v_bfe_i32 v4, v1, 24, 4
; GFX9-NEXT:    v_bfe_i32 v5, v1, 20, 4
; GFX9-NEXT:    v_bfe_i32 v6, v1, 16, 4
; GFX9-NEXT:    v_bfe_i32 v7, v1, 12, 4
; GFX9-NEXT:    v_bfe_i32 v8, v1, 8, 4
; GFX9-NEXT:    v_bfe_i32 v9, v1, 4, 4
; GFX9-NEXT:    v_bfe_i32 v1, v1, 0, 4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_ashrrev_i32_e32 v10, 28, v2
; GFX9-NEXT:    v_bfe_i32 v11, v2, 24, 4
; GFX9-NEXT:    v_bfe_i32 v12, v2, 20, 4
; GFX9-NEXT:    v_bfe_i32 v13, v2, 16, 4
; GFX9-NEXT:    v_bfe_i32 v14, v2, 12, 4
; GFX9-NEXT:    v_bfe_i32 v15, v2, 8, 4
; GFX9-NEXT:    v_bfe_i32 v16, v2, 4, 4
; GFX9-NEXT:    v_bfe_i32 v2, v2, 0, 4
; GFX9-NEXT:    v_mul_i32_i24_e32 v1, v1, v2
; GFX9-NEXT:    v_mul_i32_i24_e32 v2, v9, v16
; GFX9-NEXT:    v_mul_i32_i24_e32 v8, v8, v15
; GFX9-NEXT:    v_mul_i32_i24_e32 v7, v7, v14
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add3_u32 v1, v1, s0, v2
; GFX9-NEXT:    v_mul_i32_i24_e32 v6, v6, v13
; GFX9-NEXT:    v_mul_i32_i24_e32 v5, v5, v12
; GFX9-NEXT:    v_add3_u32 v1, v1, v8, v7
; GFX9-NEXT:    v_mul_i32_i24_e32 v4, v4, v11
; GFX9-NEXT:    v_mul_i32_i24_e32 v3, v3, v10
; GFX9-NEXT:    v_add3_u32 v1, v1, v6, v5
; GFX9-NEXT:    v_add3_u32 v1, v1, v4, v3
; GFX9-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot8_acc32_vecMul:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-DL-NEXT:    s_mov_b32 s10, -1
; GFX9-DL-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-DL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-DL-NEXT:    v_dot8_i32_i4 v1, v1, v2, s0
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-XNACK-LABEL: idot8_acc32_vecMul:
; GFX10-DL-XNACK:       ; %bb.0: ; %entry
; GFX10-DL-XNACK-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-XNACK-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-XNACK-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10-DL-XNACK-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10-DL-XNACK-NEXT:    s_mov_b32 s10, -1
; GFX10-DL-XNACK-NEXT:    s_mov_b32 s11, 0x31c16000
; GFX10-DL-XNACK-NEXT:    s_add_u32 s8, s8, s3
; GFX10-DL-XNACK-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-DL-XNACK-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-XNACK-NEXT:    s_clause 0x1
; GFX10-DL-XNACK-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-XNACK-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-XNACK-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-XNACK-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-XNACK-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-DL-XNACK-NEXT:    v_dot8_i32_i4 v1, v1, v2, s2
; GFX10-DL-XNACK-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-DL-XNACK-NEXT:    s_endpgm
;
; GFX10-DL-NOXNACK-LABEL: idot8_acc32_vecMul:
; GFX10-DL-NOXNACK:       ; %bb.0: ; %entry
; GFX10-DL-NOXNACK-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NOXNACK-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NOXNACK-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10-DL-NOXNACK-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NOXNACK-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10-DL-NOXNACK-NEXT:    s_mov_b32 s10, -1
; GFX10-DL-NOXNACK-NEXT:    s_mov_b32 s11, 0x31c16000
; GFX10-DL-NOXNACK-NEXT:    s_add_u32 s8, s8, s3
; GFX10-DL-NOXNACK-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-DL-NOXNACK-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NOXNACK-NEXT:    s_clause 0x1
; GFX10-DL-NOXNACK-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NOXNACK-NEXT:    global_load_dword v0, v0, s[6:7]
; GFX10-DL-NOXNACK-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NOXNACK-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-DL-NOXNACK-NEXT:    v_dot8_i32_i4 v0, v1, v0, s2
; GFX10-DL-NOXNACK-NEXT:    global_store_dword v2, v0, s[0:1]
; GFX10-DL-NOXNACK-NEXT:    s_endpgm
; GFX10-DL-LABEL: idot8_acc32_vecMul:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10-DL-NEXT:    s_mov_b32 s10, -1
; GFX10-DL-NEXT:    s_mov_b32 s11, 0x31c16000
; GFX10-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x34
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_load_dword s6, s[4:5], 0x0
; GFX10-DL-NEXT:    s_load_dword s0, s[0:1], 0x0
; GFX10-DL-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-DL-NEXT:    v_dot8_i32_i4 v0, s0, s1, v0
; GFX10-DL-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX10-DL-NEXT:    s_endpgm
                                              ptr addrspace(1) %src2,
                                              ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <8 x i4>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <8 x i4>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <8 x i4>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <8 x i4>, ptr addrspace(1) %gep2

  %cvec1 = sext <8 x i4> %vec1 to <8 x i32>
  %cvec2 = sext <8 x i4> %vec2 to <8 x i32>

  %mul = mul <8 x i32> %cvec1, %cvec2
  %mul0 = extractelement <8 x i32> %mul, i64 0
  %mul1 = extractelement <8 x i32> %mul, i64 1
  %mul2 = extractelement <8 x i32> %mul, i64 2
  %mul3 = extractelement <8 x i32> %mul, i64 3
  %mul4 = extractelement <8 x i32> %mul, i64 4
  %mul5 = extractelement <8 x i32> %mul, i64 5
  %mul6 = extractelement <8 x i32> %mul, i64 6
  %mul7 = extractelement <8 x i32> %mul, i64 7

  %acc = load i32, ptr addrspace(1) %dst, align 4
  %add1 = add i32 %mul0, %acc
  %add2 = add i32 %add1, %mul1
  %add3 = add i32 %add2, %mul2
  %add4 = add i32 %add3, %mul3
  %add5 = add i32 %add4, %mul4
  %add6 = add i32 %add5, %mul5
  %add7 = add i32 %add6, %mul6
  %add8 = add i32 %add7, %mul7

  store i32 %add8, ptr addrspace(1) %dst, align 4
  ret void
}

; TODO: Support this pattern.
define amdgpu_kernel void @idot8_acc16_vecMul(ptr addrspace(1) %src1,
; GFX7-LABEL: idot8_acc16_vecMul:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX7-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s14, -1
; GFX7-NEXT:    s_mov_b32 s15, 0xe8f000
; GFX7-NEXT:    s_add_u32 s12, s12, s3
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    buffer_load_ushort v1, off, s[0:3], 0
; GFX7-NEXT:    s_addc_u32 s13, s13, 0
; GFX7-NEXT:    s_waitcnt vmcnt(2)
; GFX7-NEXT:    v_bfe_i32 v8, v2, 0, 4
; GFX7-NEXT:    v_bfe_i32 v6, v2, 4, 4
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_bfe_i32 v15, v0, 0, 4
; GFX7-NEXT:    v_bfe_i32 v13, v0, 4, 4
; GFX7-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; GFX7-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; GFX7-NEXT:    v_bfe_i32 v5, v2, 8, 4
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX7-NEXT:    v_bfe_i32 v12, v0, 8, 4
; GFX7-NEXT:    v_and_b32_e32 v13, 0xffff, v13
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v8, v15, v1
; GFX7-NEXT:    v_bfe_i32 v3, v2, 24, 4
; GFX7-NEXT:    v_bfe_i32 v4, v2, 20, 4
; GFX7-NEXT:    v_bfe_i32 v7, v2, 16, 4
; GFX7-NEXT:    v_ashrrev_i32_e32 v9, 28, v2
; GFX7-NEXT:    v_bfe_i32 v2, v2, 12, 4
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX7-NEXT:    v_bfe_i32 v10, v0, 24, 4
; GFX7-NEXT:    v_bfe_i32 v11, v0, 20, 4
; GFX7-NEXT:    v_bfe_i32 v14, v0, 16, 4
; GFX7-NEXT:    v_ashrrev_i32_e32 v16, 28, v0
; GFX7-NEXT:    v_bfe_i32 v0, v0, 12, 4
; GFX7-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; GFX7-NEXT:    v_mad_u32_u24 v1, v6, v13, v1
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7-NEXT:    v_mad_u32_u24 v1, v5, v12, v1
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX7-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX7-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; GFX7-NEXT:    v_mad_u32_u24 v0, v7, v14, v0
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX7-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; GFX7-NEXT:    v_mad_u32_u24 v0, v4, v11, v0
; GFX7-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; GFX7-NEXT:    v_and_b32_e32 v16, 0xffff, v16
; GFX7-NEXT:    v_mad_u32_u24 v0, v3, v10, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v9, v16, v0
; GFX7-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot8_acc16_vecMul:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    v_mov_b32_e32 v5, 12
; GFX8-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_load_ushort v4, v[0:1]
; GFX8-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    s_mov_b32 s11, 0xe80000
; GFX8-NEXT:    s_add_u32 s8, s8, s3
; GFX8-NEXT:    s_addc_u32 s9, s9, 0
; GFX8-NEXT:    s_waitcnt vmcnt(2)
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 28, v3
; GFX8-NEXT:    v_lshlrev_b16_sdwa v7, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 20, v3
; GFX8-NEXT:    v_lshlrev_b16_sdwa v9, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 12, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 8, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v12, 4, v3
; GFX8-NEXT:    v_lshlrev_b16_e32 v3, 12, v3
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_lshrrev_b32_e32 v13, 28, v2
; GFX8-NEXT:    v_lshlrev_b16_sdwa v14, v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
; GFX8-NEXT:    v_lshrrev_b32_e32 v15, 20, v2
; GFX8-NEXT:    v_lshlrev_b16_sdwa v5, v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v16, 12, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v17, 8, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v18, 4, v2
; GFX8-NEXT:    v_lshlrev_b16_e32 v2, 12, v2
; GFX8-NEXT:    v_lshlrev_b16_e32 v12, 12, v12
; GFX8-NEXT:    v_ashrrev_i16_e32 v3, 12, v3
; GFX8-NEXT:    v_lshlrev_b16_e32 v18, 12, v18
; GFX8-NEXT:    v_ashrrev_i16_e32 v2, 12, v2
; GFX8-NEXT:    v_lshlrev_b16_e32 v11, 12, v11
; GFX8-NEXT:    v_lshlrev_b16_e32 v17, 12, v17
; GFX8-NEXT:    v_ashrrev_i16_e32 v12, 12, v12
; GFX8-NEXT:    v_ashrrev_i16_e32 v18, 12, v18
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mad_u16 v2, v3, v2, v4
; GFX8-NEXT:    v_lshlrev_b16_e32 v10, 12, v10
; GFX8-NEXT:    v_lshlrev_b16_e32 v16, 12, v16
; GFX8-NEXT:    v_ashrrev_i16_e32 v11, 12, v11
; GFX8-NEXT:    v_ashrrev_i16_e32 v17, 12, v17
; GFX8-NEXT:    v_mad_u16 v2, v12, v18, v2
; GFX8-NEXT:    v_ashrrev_i16_e32 v10, 12, v10
; GFX8-NEXT:    v_ashrrev_i16_e32 v16, 12, v16
; GFX8-NEXT:    v_mad_u16 v2, v11, v17, v2
; GFX8-NEXT:    v_lshlrev_b16_e32 v8, 12, v8
; GFX8-NEXT:    v_ashrrev_i16_e32 v9, 12, v9
; GFX8-NEXT:    v_lshlrev_b16_e32 v15, 12, v15
; GFX8-NEXT:    v_ashrrev_i16_e32 v5, 12, v5
; GFX8-NEXT:    v_mad_u16 v2, v10, v16, v2
; GFX8-NEXT:    v_ashrrev_i16_e32 v8, 12, v8
; GFX8-NEXT:    v_ashrrev_i16_e32 v15, 12, v15
; GFX8-NEXT:    v_mad_u16 v2, v9, v5, v2
; GFX8-NEXT:    v_lshlrev_b16_e32 v6, 12, v6
; GFX8-NEXT:    v_ashrrev_i16_e32 v7, 12, v7
; GFX8-NEXT:    v_lshlrev_b16_e32 v13, 12, v13
; GFX8-NEXT:    v_ashrrev_i16_e32 v14, 12, v14
; GFX8-NEXT:    v_mad_u16 v2, v8, v15, v2
; GFX8-NEXT:    v_ashrrev_i16_e32 v6, 12, v6
; GFX8-NEXT:    v_ashrrev_i16_e32 v13, 12, v13
; GFX8-NEXT:    v_mad_u16 v2, v7, v14, v2
; GFX8-NEXT:    v_mad_u16 v2, v6, v13, v2
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: idot8_acc16_vecMul:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-NEXT:    s_add_u32 s8, s8, s3
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v4, 12
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    global_load_ushort v3, v0, s[2:3]
; GFX9-NEXT:    s_mov_b32 s0, 0x5040100
; GFX9-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 4, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 8, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 12, v1
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_lshrrev_b32_e32 v13, 4, v2
; GFX9-NEXT:    v_lshlrev_b16_e32 v5, 12, v1
; GFX9-NEXT:    v_lshlrev_b16_e32 v12, 12, v2
; GFX9-NEXT:    v_lshlrev_b16_e32 v6, 12, v6
; GFX9-NEXT:    v_lshlrev_b16_e32 v7, 12, v7
; GFX9-NEXT:    v_lshlrev_b16_e32 v8, 12, v8
; GFX9-NEXT:    v_lshlrev_b16_e32 v13, 12, v13
; GFX9-NEXT:    v_lshlrev_b16_sdwa v9, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 20, v1
; GFX9-NEXT:    v_lshlrev_b16_sdwa v11, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 28, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v14, 8, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v15, 12, v2
; GFX9-NEXT:    v_lshlrev_b16_sdwa v16, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_lshrrev_b32_e32 v17, 20, v2
; GFX9-NEXT:    v_lshlrev_b16_sdwa v4, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 28, v2
; GFX9-NEXT:    v_ashrrev_i16_e32 v5, 12, v5
; GFX9-NEXT:    v_ashrrev_i16_e32 v12, 12, v12
; GFX9-NEXT:    v_ashrrev_i16_e32 v6, 12, v6
; GFX9-NEXT:    v_ashrrev_i16_e32 v7, 12, v7
; GFX9-NEXT:    v_ashrrev_i16_e32 v8, 12, v8
; GFX9-NEXT:    v_ashrrev_i16_e32 v13, 12, v13
; GFX9-NEXT:    v_lshlrev_b16_e32 v10, 12, v10
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 12, v1
; GFX9-NEXT:    v_lshlrev_b16_e32 v14, 12, v14
; GFX9-NEXT:    v_lshlrev_b16_e32 v15, 12, v15
; GFX9-NEXT:    v_lshlrev_b16_e32 v17, 12, v17
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 12, v2
; GFX9-NEXT:    v_perm_b32 v7, v8, v7, s0
; GFX9-NEXT:    v_perm_b32 v8, v13, v12, s0
; GFX9-NEXT:    v_perm_b32 v5, v6, v5, s0
; GFX9-NEXT:    v_ashrrev_i16_e32 v9, 12, v9
; GFX9-NEXT:    v_ashrrev_i16_e32 v11, 12, v11
; GFX9-NEXT:    v_ashrrev_i16_e32 v16, 12, v16
; GFX9-NEXT:    v_ashrrev_i16_e32 v4, 12, v4
; GFX9-NEXT:    v_ashrrev_i16_e32 v10, 12, v10
; GFX9-NEXT:    v_ashrrev_i16_e32 v1, 12, v1
; GFX9-NEXT:    v_ashrrev_i16_e32 v14, 12, v14
; GFX9-NEXT:    v_ashrrev_i16_e32 v15, 12, v15
; GFX9-NEXT:    v_ashrrev_i16_e32 v17, 12, v17
; GFX9-NEXT:    v_ashrrev_i16_e32 v2, 12, v2
; GFX9-NEXT:    v_pk_mul_lo_u16 v5, v5, v8
; GFX9-NEXT:    v_perm_b32 v2, v2, v4, s0
; GFX9-NEXT:    v_perm_b32 v1, v1, v11, s0
; GFX9-NEXT:    v_perm_b32 v4, v17, v16, s0
; GFX9-NEXT:    v_perm_b32 v9, v10, v9, s0
; GFX9-NEXT:    v_perm_b32 v10, v15, v14, s0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v3, v5, v3
; GFX9-NEXT:    v_pk_mul_lo_u16 v1, v1, v2
; GFX9-NEXT:    v_pk_mul_lo_u16 v2, v9, v4
; GFX9-NEXT:    v_pk_mul_lo_u16 v4, v7, v10
; GFX9-NEXT:    v_add_u16_sdwa v3, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_add_u16_e32 v3, v3, v4
; GFX9-NEXT:    v_add_u16_sdwa v3, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_add_u16_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u16_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_add_u16_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    global_store_short v0, v1, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot8_acc16_vecMul:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-DL-NEXT:    s_mov_b32 s10, -1
; GFX9-DL-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    v_mov_b32_e32 v4, 12
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    global_load_ushort v3, v0, s[2:3]
; GFX9-DL-NEXT:    s_mov_b32 s0, 0x5040100
; GFX9-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v6, 4, v1
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v7, 8, v1
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v8, 12, v1
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v13, 4, v2
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v5, 12, v1
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v12, 12, v2
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v6, 12, v6
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v7, 12, v7
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v8, 12, v8
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v13, 12, v13
; GFX9-DL-NEXT:    v_lshlrev_b16_sdwa v9, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v10, 20, v1
; GFX9-DL-NEXT:    v_lshlrev_b16_sdwa v11, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v1, 28, v1
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v14, 8, v2
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v15, 12, v2
; GFX9-DL-NEXT:    v_lshlrev_b16_sdwa v16, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v17, 20, v2
; GFX9-DL-NEXT:    v_lshlrev_b16_sdwa v4, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v2, 28, v2
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v5, 12, v5
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v12, 12, v12
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v6, 12, v6
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v7, 12, v7
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v8, 12, v8
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v13, 12, v13
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v10, 12, v10
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v1, 12, v1
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v14, 12, v14
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v15, 12, v15
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v17, 12, v17
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v2, 12, v2
; GFX9-DL-NEXT:    v_perm_b32 v7, v8, v7, s0
; GFX9-DL-NEXT:    v_perm_b32 v8, v13, v12, s0
; GFX9-DL-NEXT:    v_perm_b32 v5, v6, v5, s0
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v9, 12, v9
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v11, 12, v11
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v16, 12, v16
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v4, 12, v4
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v10, 12, v10
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v1, 12, v1
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v14, 12, v14
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v15, 12, v15
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v17, 12, v17
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v2, 12, v2
; GFX9-DL-NEXT:    v_pk_mul_lo_u16 v5, v5, v8
; GFX9-DL-NEXT:    v_perm_b32 v2, v2, v4, s0
; GFX9-DL-NEXT:    v_perm_b32 v1, v1, v11, s0
; GFX9-DL-NEXT:    v_perm_b32 v4, v17, v16, s0
; GFX9-DL-NEXT:    v_perm_b32 v9, v10, v9, s0
; GFX9-DL-NEXT:    v_perm_b32 v10, v15, v14, s0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_add_u16_e32 v3, v5, v3
; GFX9-DL-NEXT:    v_pk_mul_lo_u16 v1, v1, v2
; GFX9-DL-NEXT:    v_pk_mul_lo_u16 v2, v9, v4
; GFX9-DL-NEXT:    v_pk_mul_lo_u16 v4, v7, v10
; GFX9-DL-NEXT:    v_add_u16_sdwa v3, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-DL-NEXT:    v_add_u16_e32 v3, v3, v4
; GFX9-DL-NEXT:    v_add_u16_sdwa v3, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-DL-NEXT:    v_add_u16_e32 v3, v3, v2
; GFX9-DL-NEXT:    v_add_u16_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-DL-NEXT:    v_add_u16_e32 v2, v2, v1
; GFX9-DL-NEXT:    v_add_u16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-DL-NEXT:    global_store_short v0, v1, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-XNACK-LABEL: idot8_acc16_vecMul:
; GFX10-DL-XNACK:       ; %bb.0: ; %entry
; GFX10-DL-XNACK-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-XNACK-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-XNACK-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10-DL-XNACK-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10-DL-XNACK-NEXT:    s_mov_b32 s10, -1
; GFX10-DL-XNACK-NEXT:    s_mov_b32 s11, 0x31c16000
; GFX10-DL-XNACK-NEXT:    s_add_u32 s8, s8, s3
; GFX10-DL-XNACK-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-DL-XNACK-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-XNACK-NEXT:    s_clause 0x1
; GFX10-DL-XNACK-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-XNACK-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-XNACK-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-XNACK-NEXT:    global_load_ushort v3, v0, s[0:1]
; GFX10-DL-XNACK-NEXT:    s_waitcnt vmcnt(2)
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v5, 4, v1
; GFX10-DL-XNACK-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v12, 4, v2
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v4, 12, v1
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v11, 12, v2
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v6, 8, v1
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v5, 12, v5
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v12, 12, v12
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v7, 12, v1
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v8, 16, v1
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v13, 8, v2
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v14, 12, v2
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v4, 12, v4
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v11, 12, v11
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v12, 12, v12
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v5, 12, v5
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v6, 12, v6
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v7, 12, v7
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v8, 12, v8
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v13, 12, v13
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v14, 12, v14
; GFX10-DL-XNACK-NEXT:    v_perm_b32 v11, v12, v11, 0x5040100
; GFX10-DL-XNACK-NEXT:    v_perm_b32 v4, v5, v4, 0x5040100
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v9, 20, v1
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v15, 16, v2
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v16, 20, v2
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v6, 12, v6
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v7, 12, v7
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v5, 12, v8
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v8, 12, v13
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v12, 12, v14
; GFX10-DL-XNACK-NEXT:    v_pk_mul_lo_u16 v4, v4, v11
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v9, 12, v9
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v15, 12, v15
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v16, 12, v16
; GFX10-DL-XNACK-NEXT:    v_perm_b32 v8, v12, v8, 0x5040100
; GFX10-DL-XNACK-NEXT:    v_perm_b32 v6, v7, v6, 0x5040100
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v7, 16, v4
; GFX10-DL-XNACK-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-XNACK-NEXT:    v_add_nc_u16 v3, v4, v3
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v10, 24, v1
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v1, 28, v1
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v17, 24, v2
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v9, 12, v9
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v11, 12, v15
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v2, 28, v2
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v4, 12, v16
; GFX10-DL-XNACK-NEXT:    v_pk_mul_lo_u16 v6, v6, v8
; GFX10-DL-XNACK-NEXT:    v_add_nc_u16 v3, v3, v7
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v10, 12, v10
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v1, 12, v1
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v12, 12, v17
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v2, 12, v2
; GFX10-DL-XNACK-NEXT:    v_perm_b32 v4, v4, v11, 0x5040100
; GFX10-DL-XNACK-NEXT:    v_perm_b32 v5, v9, v5, 0x5040100
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v7, 16, v6
; GFX10-DL-XNACK-NEXT:    v_add_nc_u16 v3, v3, v6
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v10, 12, v10
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v6, 12, v12
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v2, 12, v2
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v1, 12, v1
; GFX10-DL-XNACK-NEXT:    v_pk_mul_lo_u16 v4, v5, v4
; GFX10-DL-XNACK-NEXT:    v_add_nc_u16 v3, v3, v7
; GFX10-DL-XNACK-NEXT:    v_perm_b32 v2, v2, v6, 0x5040100
; GFX10-DL-XNACK-NEXT:    v_perm_b32 v1, v1, v10, 0x5040100
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v5, 16, v4
; GFX10-DL-XNACK-NEXT:    v_add_nc_u16 v3, v3, v4
; GFX10-DL-XNACK-NEXT:    v_pk_mul_lo_u16 v1, v1, v2
; GFX10-DL-XNACK-NEXT:    v_add_nc_u16 v2, v3, v5
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX10-DL-XNACK-NEXT:    v_add_nc_u16 v1, v2, v1
; GFX10-DL-XNACK-NEXT:    v_add_nc_u16 v1, v1, v3
; GFX10-DL-XNACK-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-DL-XNACK-NEXT:    s_endpgm
;
; GFX10-DL-NOXNACK-LABEL: idot8_acc16_vecMul:
; GFX10-DL-NOXNACK:       ; %bb.0: ; %entry
; GFX10-DL-NOXNACK-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NOXNACK-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NOXNACK-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NOXNACK-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10-DL-NOXNACK-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10-DL-NOXNACK-NEXT:    s_mov_b32 s10, -1
; GFX10-DL-NOXNACK-NEXT:    s_mov_b32 s11, 0x31c16000
; GFX10-DL-NOXNACK-NEXT:    s_add_u32 s8, s8, s3
; GFX10-DL-NOXNACK-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-DL-NOXNACK-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NOXNACK-NEXT:    s_clause 0x1
; GFX10-DL-NOXNACK-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NOXNACK-NEXT:    global_load_dword v0, v0, s[6:7]
; GFX10-DL-NOXNACK-NEXT:    global_load_ushort v3, v2, s[0:1]
; GFX10-DL-NOXNACK-NEXT:    s_waitcnt vmcnt(2)
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v5, 4, v1
; GFX10-DL-NOXNACK-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v12, 4, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v4, 12, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v11, 12, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v6, 8, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v5, 12, v5
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v12, 12, v12
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v7, 12, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v8, 16, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v13, 8, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v14, 12, v0
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v4, 12, v4
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v11, 12, v11
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v12, 12, v12
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v5, 12, v5
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v6, 12, v6
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v7, 12, v7
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v8, 12, v8
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v13, 12, v13
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v14, 12, v14
; GFX10-DL-NOXNACK-NEXT:    v_perm_b32 v11, v12, v11, 0x5040100
; GFX10-DL-NOXNACK-NEXT:    v_perm_b32 v4, v5, v4, 0x5040100
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v9, 20, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v15, 16, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v16, 20, v0
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v6, 12, v6
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v7, 12, v7
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v5, 12, v8
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v8, 12, v13
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v12, 12, v14
; GFX10-DL-NOXNACK-NEXT:    v_pk_mul_lo_u16 v4, v4, v11
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v9, 12, v9
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v15, 12, v15
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v16, 12, v16
; GFX10-DL-NOXNACK-NEXT:    v_perm_b32 v8, v12, v8, 0x5040100
; GFX10-DL-NOXNACK-NEXT:    v_perm_b32 v6, v7, v6, 0x5040100
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v7, 16, v4
; GFX10-DL-NOXNACK-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NOXNACK-NEXT:    v_add_nc_u16 v3, v4, v3
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v10, 24, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v1, 28, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v17, 24, v0
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v9, 12, v9
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v11, 12, v15
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v0, 28, v0
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v4, 12, v16
; GFX10-DL-NOXNACK-NEXT:    v_pk_mul_lo_u16 v6, v6, v8
; GFX10-DL-NOXNACK-NEXT:    v_add_nc_u16 v3, v3, v7
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v10, 12, v10
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v1, 12, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v12, 12, v17
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v0, 12, v0
; GFX10-DL-NOXNACK-NEXT:    v_perm_b32 v4, v4, v11, 0x5040100
; GFX10-DL-NOXNACK-NEXT:    v_perm_b32 v5, v9, v5, 0x5040100
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v7, 16, v6
; GFX10-DL-NOXNACK-NEXT:    v_add_nc_u16 v3, v3, v6
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v10, 12, v10
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v6, 12, v12
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v0, 12, v0
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v1, 12, v1
; GFX10-DL-NOXNACK-NEXT:    v_pk_mul_lo_u16 v4, v5, v4
; GFX10-DL-NOXNACK-NEXT:    v_add_nc_u16 v3, v3, v7
; GFX10-DL-NOXNACK-NEXT:    v_perm_b32 v0, v0, v6, 0x5040100
; GFX10-DL-NOXNACK-NEXT:    v_perm_b32 v1, v1, v10, 0x5040100
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v5, 16, v4
; GFX10-DL-NOXNACK-NEXT:    v_add_nc_u16 v3, v3, v4
; GFX10-DL-NOXNACK-NEXT:    v_pk_mul_lo_u16 v0, v1, v0
; GFX10-DL-NOXNACK-NEXT:    v_add_nc_u16 v1, v3, v5
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX10-DL-NOXNACK-NEXT:    v_add_nc_u16 v0, v1, v0
; GFX10-DL-NOXNACK-NEXT:    v_add_nc_u16 v0, v0, v3
; GFX10-DL-NOXNACK-NEXT:    global_store_short v2, v0, s[0:1]
; GFX10-DL-NOXNACK-NEXT:    s_endpgm
; GFX10-DL-LABEL: idot8_acc16_vecMul:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x34
; GFX10-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX10-DL-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX10-DL-NEXT:    s_mov_b32 s14, -1
; GFX10-DL-NEXT:    s_mov_b32 s15, 0x31c16000
; GFX10-DL-NEXT:    s_add_u32 s12, s12, s3
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-DL-NEXT:    s_addc_u32 s13, s13, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    global_load_ushort v1, v0, s[4:5]
; GFX10-DL-NEXT:    s_load_dword s0, s[0:1], 0x0
; GFX10-DL-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_bfe_u32 s2, s0, 0x40018
; GFX10-DL-NEXT:    s_lshr_b32 s3, s0, 28
; GFX10-DL-NEXT:    s_bfe_u32 s6, s0, 0x40010
; GFX10-DL-NEXT:    s_bfe_u32 s7, s0, 0x40014
; GFX10-DL-NEXT:    s_bfe_u32 s8, s0, 0x40008
; GFX10-DL-NEXT:    s_bfe_u32 s9, s0, 0x4000c
; GFX10-DL-NEXT:    s_and_b32 s10, s0, 15
; GFX10-DL-NEXT:    s_bfe_u32 s0, s0, 0x40004
; GFX10-DL-NEXT:    s_and_b32 s11, s1, 15
; GFX10-DL-NEXT:    s_pack_ll_b32_b16 s0, s10, s0
; GFX10-DL-NEXT:    s_bfe_u32 s10, s1, 0x40004
; GFX10-DL-NEXT:    v_pk_lshlrev_b16 v2, 12, s0 op_sel_hi:[0,1]
; GFX10-DL-NEXT:    s_pack_ll_b32_b16 s0, s11, s10
; GFX10-DL-NEXT:    s_bfe_u32 s11, s1, 0x4000c
; GFX10-DL-NEXT:    v_pk_lshlrev_b16 v3, 12, s0 op_sel_hi:[0,1]
; GFX10-DL-NEXT:    s_bfe_u32 s0, s1, 0x40008
; GFX10-DL-NEXT:    v_pk_ashrrev_i16 v2, 12, v2 op_sel_hi:[0,1]
; GFX10-DL-NEXT:    s_pack_ll_b32_b16 s8, s8, s9
; GFX10-DL-NEXT:    s_pack_ll_b32_b16 s0, s0, s11
; GFX10-DL-NEXT:    v_pk_ashrrev_i16 v3, 12, v3 op_sel_hi:[0,1]
; GFX10-DL-NEXT:    v_pk_lshlrev_b16 v4, 12, s8 op_sel_hi:[0,1]
; GFX10-DL-NEXT:    v_pk_lshlrev_b16 v5, 12, s0 op_sel_hi:[0,1]
; GFX10-DL-NEXT:    s_bfe_u32 s8, s1, 0x40010
; GFX10-DL-NEXT:    s_bfe_u32 s0, s1, 0x40014
; GFX10-DL-NEXT:    v_pk_mul_lo_u16 v2, v2, v3
; GFX10-DL-NEXT:    v_pk_ashrrev_i16 v3, 12, v4 op_sel_hi:[0,1]
; GFX10-DL-NEXT:    v_pk_ashrrev_i16 v4, 12, v5 op_sel_hi:[0,1]
; GFX10-DL-NEXT:    s_pack_ll_b32_b16 s6, s6, s7
; GFX10-DL-NEXT:    s_pack_ll_b32_b16 s0, s8, s0
; GFX10-DL-NEXT:    v_pk_lshlrev_b16 v5, 12, s6 op_sel_hi:[0,1]
; GFX10-DL-NEXT:    v_pk_lshlrev_b16 v6, 12, s0 op_sel_hi:[0,1]
; GFX10-DL-NEXT:    v_pk_mul_lo_u16 v3, v3, v4
; GFX10-DL-NEXT:    s_bfe_u32 s10, s1, 0x40018
; GFX10-DL-NEXT:    s_lshr_b32 s0, s1, 28
; GFX10-DL-NEXT:    s_pack_ll_b32_b16 s1, s2, s3
; GFX10-DL-NEXT:    v_pk_ashrrev_i16 v4, 12, v6 op_sel_hi:[0,1]
; GFX10-DL-NEXT:    s_pack_ll_b32_b16 s0, s10, s0
; GFX10-DL-NEXT:    v_pk_lshlrev_b16 v6, 12, s0 op_sel_hi:[0,1]
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_add_nc_u32_e32 v1, v2, v1
; GFX10-DL-NEXT:    v_add_nc_u32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-DL-NEXT:    v_pk_ashrrev_i16 v2, 12, v5 op_sel_hi:[0,1]
; GFX10-DL-NEXT:    v_pk_lshlrev_b16 v5, 12, s1 op_sel_hi:[0,1]
; GFX10-DL-NEXT:    v_add_nc_u32_sdwa v1, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX10-DL-NEXT:    v_pk_mul_lo_u16 v2, v2, v4
; GFX10-DL-NEXT:    v_pk_ashrrev_i16 v4, 12, v6 op_sel_hi:[0,1]
; GFX10-DL-NEXT:    v_add_nc_u32_sdwa v1, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-DL-NEXT:    v_pk_ashrrev_i16 v3, 12, v5 op_sel_hi:[0,1]
; GFX10-DL-NEXT:    v_add_nc_u32_e32 v1, v1, v2
; GFX10-DL-NEXT:    v_pk_mul_lo_u16 v3, v3, v4
; GFX10-DL-NEXT:    v_add_nc_u32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-DL-NEXT:    v_add_nc_u32_e32 v1, v1, v3
; GFX10-DL-NEXT:    v_add_nc_u32_sdwa v1, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-DL-NEXT:    global_store_short v0, v1, s[4:5]
; GFX10-DL-NEXT:    s_endpgm
                                              ptr addrspace(1) %src2,
                                              ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <8 x i4>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <8 x i4>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <8 x i4>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <8 x i4>, ptr addrspace(1) %gep2

  %cvec1 = sext <8 x i4> %vec1 to <8 x i16>
  %cvec2 = sext <8 x i4> %vec2 to <8 x i16>

  %mul = mul <8 x i16> %cvec1, %cvec2
  %mul0 = extractelement <8 x i16> %mul, i64 0
  %mul1 = extractelement <8 x i16> %mul, i64 1
  %mul2 = extractelement <8 x i16> %mul, i64 2
  %mul3 = extractelement <8 x i16> %mul, i64 3
  %mul4 = extractelement <8 x i16> %mul, i64 4
  %mul5 = extractelement <8 x i16> %mul, i64 5
  %mul6 = extractelement <8 x i16> %mul, i64 6
  %mul7 = extractelement <8 x i16> %mul, i64 7

  %acc = load i16, ptr addrspace(1) %dst, align 4
  %add1 = add i16 %mul0, %acc
  %add2 = add i16 %add1, %mul1
  %add3 = add i16 %add2, %mul2
  %add4 = add i16 %add3, %mul3
  %add5 = add i16 %add4, %mul4
  %add6 = add i16 %add5, %mul5
  %add7 = add i16 %add6, %mul6
  %add8 = add i16 %add7, %mul7

  store i16 %add8, ptr addrspace(1) %dst, align 4
  ret void
}

; TODO: Support this pattern.
define amdgpu_kernel void @idot8_acc8_vecMul(ptr addrspace(1) %src1,
; GFX7-LABEL: idot8_acc8_vecMul:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX7-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s14, -1
; GFX7-NEXT:    s_mov_b32 s15, 0xe8f000
; GFX7-NEXT:    s_add_u32 s12, s12, s3
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    buffer_load_ubyte v1, off, s[0:3], 0
; GFX7-NEXT:    s_addc_u32 s13, s13, 0
; GFX7-NEXT:    s_waitcnt vmcnt(2)
; GFX7-NEXT:    v_bfe_i32 v8, v2, 0, 4
; GFX7-NEXT:    v_ashrrev_i32_e32 v3, 28, v2
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_bfe_i32 v15, v0, 0, 4
; GFX7-NEXT:    v_bfe_i32 v4, v2, 24, 4
; GFX7-NEXT:    v_bfe_i32 v5, v2, 20, 4
; GFX7-NEXT:    v_bfe_i32 v6, v2, 16, 4
; GFX7-NEXT:    v_bfe_i32 v7, v2, 8, 4
; GFX7-NEXT:    v_bfe_i32 v9, v2, 12, 4
; GFX7-NEXT:    v_bfe_i32 v2, v2, 4, 4
; GFX7-NEXT:    v_and_b32_e32 v8, 0xff, v8
; GFX7-NEXT:    v_ashrrev_i32_e32 v10, 28, v0
; GFX7-NEXT:    v_bfe_i32 v11, v0, 24, 4
; GFX7-NEXT:    v_bfe_i32 v12, v0, 20, 4
; GFX7-NEXT:    v_bfe_i32 v13, v0, 16, 4
; GFX7-NEXT:    v_bfe_i32 v14, v0, 8, 4
; GFX7-NEXT:    v_bfe_i32 v16, v0, 12, 4
; GFX7-NEXT:    v_bfe_i32 v0, v0, 4, 4
; GFX7-NEXT:    v_and_b32_e32 v15, 0xff, v15
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v8, v15, v1
; GFX7-NEXT:    v_and_b32_e32 v7, 0xff, v7
; GFX7-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX7-NEXT:    v_and_b32_e32 v14, 0xff, v14
; GFX7-NEXT:    v_lshlrev_b32_e32 v16, 24, v16
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    v_alignbit_b32 v9, 0, v9, 24
; GFX7-NEXT:    v_alignbit_b32 v16, 0, v16, 24
; GFX7-NEXT:    v_mad_u32_u24 v0, v7, v14, v0
; GFX7-NEXT:    v_and_b32_e32 v6, 0xff, v6
; GFX7-NEXT:    v_and_b32_e32 v13, 0xff, v13
; GFX7-NEXT:    v_mad_u32_u24 v0, v9, v16, v0
; GFX7-NEXT:    v_and_b32_e32 v5, 0xff, v5
; GFX7-NEXT:    v_and_b32_e32 v12, 0xff, v12
; GFX7-NEXT:    v_mad_u32_u24 v0, v6, v13, v0
; GFX7-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX7-NEXT:    v_and_b32_e32 v11, 0xff, v11
; GFX7-NEXT:    v_mad_u32_u24 v0, v5, v12, v0
; GFX7-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX7-NEXT:    v_and_b32_e32 v10, 0xff, v10
; GFX7-NEXT:    v_mad_u32_u24 v0, v4, v11, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v3, v10, v0
; GFX7-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot8_acc8_vecMul:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    v_mov_b32_e32 v5, 12
; GFX8-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_load_ubyte v4, v[0:1]
; GFX8-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    s_mov_b32 s11, 0xe80000
; GFX8-NEXT:    s_add_u32 s8, s8, s3
; GFX8-NEXT:    s_addc_u32 s9, s9, 0
; GFX8-NEXT:    s_waitcnt vmcnt(2)
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 20, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 28, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 12, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 8, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 4, v3
; GFX8-NEXT:    v_lshlrev_b16_e32 v16, 12, v3
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 20, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v12, 28, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v13, 12, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v14, 8, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v15, 4, v2
; GFX8-NEXT:    v_lshlrev_b16_sdwa v17, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
; GFX8-NEXT:    v_lshlrev_b16_sdwa v3, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_lshlrev_b16_e32 v18, 12, v2
; GFX8-NEXT:    v_lshlrev_b16_sdwa v19, v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
; GFX8-NEXT:    v_lshlrev_b16_sdwa v2, v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_lshlrev_b16_e32 v5, 12, v10
; GFX8-NEXT:    v_ashrrev_i16_e32 v10, 12, v16
; GFX8-NEXT:    v_ashrrev_i16_e32 v16, 12, v17
; GFX8-NEXT:    v_lshlrev_b16_e32 v7, 12, v7
; GFX8-NEXT:    v_ashrrev_i16_e32 v17, 12, v3
; GFX8-NEXT:    v_lshlrev_b16_e32 v3, 12, v6
; GFX8-NEXT:    v_lshlrev_b16_e32 v6, 12, v15
; GFX8-NEXT:    v_ashrrev_i16_e32 v15, 12, v18
; GFX8-NEXT:    v_ashrrev_i16_e32 v18, 12, v19
; GFX8-NEXT:    v_lshlrev_b16_e32 v12, 12, v12
; GFX8-NEXT:    v_ashrrev_i16_e32 v19, 12, v2
; GFX8-NEXT:    v_lshlrev_b16_e32 v2, 12, v11
; GFX8-NEXT:    v_lshlrev_b16_e32 v9, 12, v9
; GFX8-NEXT:    v_lshlrev_b16_e32 v8, 12, v8
; GFX8-NEXT:    v_lshlrev_b16_e32 v14, 12, v14
; GFX8-NEXT:    v_lshlrev_b16_e32 v13, 12, v13
; GFX8-NEXT:    v_ashrrev_i16_e32 v7, 12, v7
; GFX8-NEXT:    v_ashrrev_i16_e32 v3, 12, v3
; GFX8-NEXT:    v_ashrrev_i16_e32 v12, 12, v12
; GFX8-NEXT:    v_ashrrev_i16_e32 v2, 12, v2
; GFX8-NEXT:    v_ashrrev_i16_e32 v9, 12, v9
; GFX8-NEXT:    v_ashrrev_i16_e32 v8, 12, v8
; GFX8-NEXT:    v_ashrrev_i16_e32 v11, 12, v14
; GFX8-NEXT:    v_ashrrev_i16_e32 v13, 12, v13
; GFX8-NEXT:    v_mul_lo_u16_e32 v20, v16, v18
; GFX8-NEXT:    v_mul_lo_u16_sdwa v2, v3, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_mul_lo_u16_sdwa v3, v7, v12 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_ashrrev_i16_e32 v5, 12, v5
; GFX8-NEXT:    v_ashrrev_i16_e32 v6, 12, v6
; GFX8-NEXT:    v_mul_lo_u16_e32 v14, v17, v19
; GFX8-NEXT:    v_mul_lo_u16_sdwa v7, v8, v13 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_mul_lo_u16_e32 v8, v9, v11
; GFX8-NEXT:    v_or_b32_sdwa v3, v20, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_mul_lo_u16_e32 v10, v10, v15
; GFX8-NEXT:    v_mul_lo_u16_sdwa v5, v5, v6 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v6, v14, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v7, v8, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v9, 16, v3
; GFX8-NEXT:    v_or_b32_sdwa v8, v10, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v7
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 8, v3
; GFX8-NEXT:    v_or_b32_sdwa v3, v6, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v5, v5, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 8, v3
; GFX8-NEXT:    v_lshrrev_b64 v[2:3], 24, v[2:3]
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 8, v5
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_u16_e32 v3, v8, v4
; GFX8-NEXT:    v_add_u16_e32 v3, v3, v5
; GFX8-NEXT:    v_add_u16_e32 v3, v3, v7
; GFX8-NEXT:    v_add_u16_e32 v2, v3, v2
; GFX8-NEXT:    v_mad_u16 v2, v17, v19, v2
; GFX8-NEXT:    v_add_u16_e32 v2, v2, v6
; GFX8-NEXT:    v_mad_u16 v2, v16, v18, v2
; GFX8-NEXT:    v_add_u16_e32 v2, v2, v10
; GFX8-NEXT:    flat_store_byte v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: idot8_acc8_vecMul:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-NEXT:    s_add_u32 s8, s8, s3
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NEXT:    global_load_ubyte v4, v3, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v0, 12
; GFX9-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 20, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 28, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 12, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 8, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 4, v1
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 20, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 28, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 12, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v13, 8, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v14, 4, v2
; GFX9-NEXT:    v_lshlrev_b16_e32 v15, 12, v1
; GFX9-NEXT:    v_lshlrev_b16_sdwa v16, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
; GFX9-NEXT:    v_lshlrev_b16_sdwa v1, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_lshlrev_b16_e32 v17, 12, v2
; GFX9-NEXT:    v_lshlrev_b16_sdwa v18, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
; GFX9-NEXT:    v_lshlrev_b16_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 12, v9
; GFX9-NEXT:    v_ashrrev_i16_e32 v9, 12, v15
; GFX9-NEXT:    v_lshlrev_b16_e32 v8, 12, v8
; GFX9-NEXT:    v_lshlrev_b16_e32 v7, 12, v7
; GFX9-NEXT:    v_ashrrev_i16_e32 v15, 12, v16
; GFX9-NEXT:    v_lshlrev_b16_e32 v6, 12, v6
; GFX9-NEXT:    v_ashrrev_i16_e32 v16, 12, v1
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 12, v5
; GFX9-NEXT:    v_lshlrev_b16_e32 v5, 12, v14
; GFX9-NEXT:    v_ashrrev_i16_e32 v14, 12, v17
; GFX9-NEXT:    v_lshlrev_b16_e32 v13, 12, v13
; GFX9-NEXT:    v_lshlrev_b16_e32 v12, 12, v12
; GFX9-NEXT:    v_ashrrev_i16_e32 v17, 12, v18
; GFX9-NEXT:    v_lshlrev_b16_e32 v11, 12, v11
; GFX9-NEXT:    v_ashrrev_i16_e32 v18, 12, v0
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 12, v10
; GFX9-NEXT:    v_ashrrev_i16_e32 v8, 12, v8
; GFX9-NEXT:    v_ashrrev_i16_e32 v7, 12, v7
; GFX9-NEXT:    v_ashrrev_i16_e32 v6, 12, v6
; GFX9-NEXT:    v_ashrrev_i16_e32 v1, 12, v1
; GFX9-NEXT:    v_ashrrev_i16_e32 v10, 12, v13
; GFX9-NEXT:    v_ashrrev_i16_e32 v12, 12, v12
; GFX9-NEXT:    v_ashrrev_i16_e32 v11, 12, v11
; GFX9-NEXT:    v_ashrrev_i16_e32 v0, 12, v0
; GFX9-NEXT:    v_ashrrev_i16_e32 v2, 12, v2
; GFX9-NEXT:    v_ashrrev_i16_e32 v5, 12, v5
; GFX9-NEXT:    v_mul_lo_u16_e32 v13, v16, v18
; GFX9-NEXT:    v_mul_lo_u16_e32 v19, v15, v17
; GFX9-NEXT:    v_mul_lo_u16_sdwa v0, v1, v0 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_mul_lo_u16_sdwa v1, v6, v11 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_mul_lo_u16_sdwa v6, v7, v12 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_mul_lo_u16_e32 v7, v8, v10
; GFX9-NEXT:    v_mul_lo_u16_sdwa v2, v2, v5 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v13, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v5, v19, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v6, v7, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_mul_lo_u16_e32 v9, v9, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 8, v1
; GFX9-NEXT:    v_or_b32_sdwa v1, v0, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; GFX9-NEXT:    v_or_b32_sdwa v7, v9, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; GFX9-NEXT:    v_or_b32_e32 v2, v2, v0
; GFX9-NEXT:    v_lshrrev_b64 v[0:1], 24, v[0:1]
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v2
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v2, v7, v4
; GFX9-NEXT:    v_add_u16_e32 v1, v2, v1
; GFX9-NEXT:    v_add_u16_e32 v1, v1, v6
; GFX9-NEXT:    v_add_u16_e32 v0, v1, v0
; GFX9-NEXT:    v_mad_legacy_u16 v0, v16, v18, v0
; GFX9-NEXT:    v_add_u16_e32 v0, v0, v5
; GFX9-NEXT:    v_mad_legacy_u16 v0, v15, v17, v0
; GFX9-NEXT:    v_add_u16_e32 v0, v0, v8
; GFX9-NEXT:    global_store_byte v3, v0, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot8_acc8_vecMul:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-DL-NEXT:    s_mov_b32 s10, -1
; GFX9-DL-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-DL-NEXT:    global_load_ubyte v4, v3, s[2:3]
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 12
; GFX9-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v5, 20, v1
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v6, 28, v1
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v7, 12, v1
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v8, 8, v1
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v9, 4, v1
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v10, 20, v2
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v11, 28, v2
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v12, 12, v2
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v13, 8, v2
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v14, 4, v2
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v15, 12, v1
; GFX9-DL-NEXT:    v_lshlrev_b16_sdwa v16, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
; GFX9-DL-NEXT:    v_lshlrev_b16_sdwa v1, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v17, 12, v2
; GFX9-DL-NEXT:    v_lshlrev_b16_sdwa v18, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
; GFX9-DL-NEXT:    v_lshlrev_b16_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v2, 12, v9
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v9, 12, v15
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v8, 12, v8
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v7, 12, v7
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v15, 12, v16
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v6, 12, v6
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v16, 12, v1
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v1, 12, v5
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v5, 12, v14
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v14, 12, v17
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v13, 12, v13
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v12, 12, v12
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v17, 12, v18
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v11, 12, v11
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v18, 12, v0
; GFX9-DL-NEXT:    v_lshlrev_b16_e32 v0, 12, v10
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v8, 12, v8
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v7, 12, v7
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v6, 12, v6
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v1, 12, v1
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v10, 12, v13
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v12, 12, v12
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v11, 12, v11
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v0, 12, v0
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v2, 12, v2
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v5, 12, v5
; GFX9-DL-NEXT:    v_mul_lo_u16_e32 v13, v16, v18
; GFX9-DL-NEXT:    v_mul_lo_u16_e32 v19, v15, v17
; GFX9-DL-NEXT:    v_mul_lo_u16_sdwa v0, v1, v0 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-DL-NEXT:    v_mul_lo_u16_sdwa v1, v6, v11 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-DL-NEXT:    v_mul_lo_u16_sdwa v6, v7, v12 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-DL-NEXT:    v_mul_lo_u16_e32 v7, v8, v10
; GFX9-DL-NEXT:    v_mul_lo_u16_sdwa v2, v2, v5 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-DL-NEXT:    v_or_b32_sdwa v0, v13, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-DL-NEXT:    v_or_b32_sdwa v5, v19, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-DL-NEXT:    v_or_b32_sdwa v6, v7, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-DL-NEXT:    v_mul_lo_u16_e32 v9, v9, v14
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v8, 8, v1
; GFX9-DL-NEXT:    v_or_b32_sdwa v1, v0, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; GFX9-DL-NEXT:    v_or_b32_sdwa v7, v9, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; GFX9-DL-NEXT:    v_or_b32_e32 v2, v2, v0
; GFX9-DL-NEXT:    v_lshrrev_b64 v[0:1], 24, v[0:1]
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v1, 8, v2
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_add_u16_e32 v2, v7, v4
; GFX9-DL-NEXT:    v_add_u16_e32 v1, v2, v1
; GFX9-DL-NEXT:    v_add_u16_e32 v1, v1, v6
; GFX9-DL-NEXT:    v_add_u16_e32 v0, v1, v0
; GFX9-DL-NEXT:    v_mad_legacy_u16 v0, v16, v18, v0
; GFX9-DL-NEXT:    v_add_u16_e32 v0, v0, v5
; GFX9-DL-NEXT:    v_mad_legacy_u16 v0, v15, v17, v0
; GFX9-DL-NEXT:    v_add_u16_e32 v0, v0, v8
; GFX9-DL-NEXT:    global_store_byte v3, v0, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-XNACK-LABEL: idot8_acc8_vecMul:
; GFX10-DL-XNACK:       ; %bb.0: ; %entry
; GFX10-DL-XNACK-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-XNACK-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-XNACK-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-DL-XNACK-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10-DL-XNACK-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10-DL-XNACK-NEXT:    s_mov_b32 s10, -1
; GFX10-DL-XNACK-NEXT:    s_mov_b32 s11, 0x31c16000
; GFX10-DL-XNACK-NEXT:    s_add_u32 s8, s8, s3
; GFX10-DL-XNACK-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-DL-XNACK-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-XNACK-NEXT:    s_clause 0x1
; GFX10-DL-XNACK-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-XNACK-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-XNACK-NEXT:    global_load_ubyte v3, v4, s[0:1]
; GFX10-DL-XNACK-NEXT:    s_waitcnt vmcnt(2)
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v8, 12, v1
; GFX10-DL-XNACK-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v15, 12, v2
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v9, 8, v1
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v16, 8, v2
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v10, 4, v1
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v8, 12, v8
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v15, 12, v15
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v17, 4, v2
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v9, 12, v9
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v16, 12, v16
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v8, 12, v8
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v15, 12, v15
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v0, 20, v1
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v6, 28, v1
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v11, 20, v2
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v13, 28, v2
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v10, 12, v10
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v17, 12, v17
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v9, 12, v9
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v16, 12, v16
; GFX10-DL-XNACK-NEXT:    v_mul_lo_u16 v8, v8, v15
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v5, 16, v1
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v12, 16, v2
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v14, 24, v2
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v1, 12, v1
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v2, 12, v2
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v6, 12, v6
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v0, 12, v0
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v13, 12, v13
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v11, 12, v11
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v10, 12, v10
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v15, 12, v17
; GFX10-DL-XNACK-NEXT:    v_mul_lo_u16 v9, v9, v16
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v8, 8, v8
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v1, 12, v1
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v7, 12, v7
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v5, 12, v5
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v2, 12, v2
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v14, 12, v14
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v12, 12, v12
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v6, 12, v6
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v0, 12, v0
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v13, 12, v13
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v11, 12, v11
; GFX10-DL-XNACK-NEXT:    v_mul_lo_u16 v10, v10, v15
; GFX10-DL-XNACK-NEXT:    v_or_b32_sdwa v8, v9, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v7, 12, v7
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v5, 12, v5
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v14, 12, v14
; GFX10-DL-XNACK-NEXT:    v_ashrrev_i16 v12, 12, v12
; GFX10-DL-XNACK-NEXT:    v_mul_lo_u16 v1, v1, v2
; GFX10-DL-XNACK-NEXT:    v_mul_lo_u16 v2, v0, v11
; GFX10-DL-XNACK-NEXT:    v_mul_lo_u16 v6, v6, v13
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v9, 8, v10
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b32_e32 v0, 16, v8
; GFX10-DL-XNACK-NEXT:    v_mul_lo_u16 v10, v5, v12
; GFX10-DL-XNACK-NEXT:    v_mul_lo_u16 v11, v7, v14
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v2, 8, v2
; GFX10-DL-XNACK-NEXT:    v_lshlrev_b16 v6, 8, v6
; GFX10-DL-XNACK-NEXT:    v_or_b32_sdwa v13, v9, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX10-DL-XNACK-NEXT:    v_or_b32_sdwa v1, v1, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-DL-XNACK-NEXT:    v_or_b32_sdwa v2, v10, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-DL-XNACK-NEXT:    v_or_b32_sdwa v9, v11, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v10, 8, v13
; GFX10-DL-XNACK-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-XNACK-NEXT:    v_add_nc_u16 v3, v1, v3
; GFX10-DL-XNACK-NEXT:    v_or_b32_sdwa v1, v2, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX10-DL-XNACK-NEXT:    v_add_nc_u16 v9, v3, v10
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b64 v[2:3], 24, v[0:1]
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX10-DL-XNACK-NEXT:    v_add_nc_u16 v0, v9, v8
; GFX10-DL-XNACK-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX10-DL-XNACK-NEXT:    v_mad_u16 v0, v5, v12, v0
; GFX10-DL-XNACK-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX10-DL-XNACK-NEXT:    v_lshrrev_b32_e32 v1, 8, v6
; GFX10-DL-XNACK-NEXT:    v_mad_u16 v0, v7, v14, v0
; GFX10-DL-XNACK-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX10-DL-XNACK-NEXT:    global_store_byte v4, v0, s[0:1]
; GFX10-DL-XNACK-NEXT:    s_endpgm
;
; GFX10-DL-NOXNACK-LABEL: idot8_acc8_vecMul:
; GFX10-DL-NOXNACK:       ; %bb.0: ; %entry
; GFX10-DL-NOXNACK-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NOXNACK-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NOXNACK-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-DL-NOXNACK-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10-DL-NOXNACK-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10-DL-NOXNACK-NEXT:    s_mov_b32 s10, -1
; GFX10-DL-NOXNACK-NEXT:    s_mov_b32 s11, 0x31c16000
; GFX10-DL-NOXNACK-NEXT:    s_add_u32 s8, s8, s3
; GFX10-DL-NOXNACK-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-DL-NOXNACK-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NOXNACK-NEXT:    s_clause 0x1
; GFX10-DL-NOXNACK-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NOXNACK-NEXT:    global_load_dword v0, v0, s[6:7]
; GFX10-DL-NOXNACK-NEXT:    global_load_ubyte v2, v4, s[0:1]
; GFX10-DL-NOXNACK-NEXT:    s_waitcnt vmcnt(2)
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v8, 12, v1
; GFX10-DL-NOXNACK-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v15, 12, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v9, 8, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v16, 8, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v10, 4, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v8, 12, v8
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v15, 12, v15
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v17, 4, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v9, 12, v9
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v16, 12, v16
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v8, 12, v8
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v15, 12, v15
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v3, 20, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v6, 28, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v11, 20, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v13, 28, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v10, 12, v10
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v17, 12, v17
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v9, 12, v9
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v16, 12, v16
; GFX10-DL-NOXNACK-NEXT:    v_mul_lo_u16 v8, v8, v15
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v5, 16, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v12, 16, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v14, 24, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v6, 12, v6
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v3, 12, v3
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v13, 12, v13
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v11, 12, v11
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v1, 12, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v0, 12, v0
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v10, 12, v10
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v15, 12, v17
; GFX10-DL-NOXNACK-NEXT:    v_mul_lo_u16 v9, v9, v16
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v8, 8, v8
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v7, 12, v7
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v5, 12, v5
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v14, 12, v14
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v12, 12, v12
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v6, 12, v6
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v3, 12, v3
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v13, 12, v13
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v11, 12, v11
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v1, 12, v1
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v0, 12, v0
; GFX10-DL-NOXNACK-NEXT:    v_mul_lo_u16 v10, v10, v15
; GFX10-DL-NOXNACK-NEXT:    v_or_b32_sdwa v8, v9, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v7, 12, v7
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v5, 12, v5
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v14, 12, v14
; GFX10-DL-NOXNACK-NEXT:    v_ashrrev_i16 v12, 12, v12
; GFX10-DL-NOXNACK-NEXT:    v_mul_lo_u16 v3, v3, v11
; GFX10-DL-NOXNACK-NEXT:    v_mul_lo_u16 v6, v6, v13
; GFX10-DL-NOXNACK-NEXT:    v_mul_lo_u16 v1, v1, v0
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v9, 8, v10
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b32_e32 v0, 16, v8
; GFX10-DL-NOXNACK-NEXT:    v_mul_lo_u16 v10, v5, v12
; GFX10-DL-NOXNACK-NEXT:    v_mul_lo_u16 v11, v7, v14
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v3, 8, v3
; GFX10-DL-NOXNACK-NEXT:    v_lshlrev_b16 v6, 8, v6
; GFX10-DL-NOXNACK-NEXT:    v_or_b32_sdwa v13, v9, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX10-DL-NOXNACK-NEXT:    v_or_b32_sdwa v1, v1, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-DL-NOXNACK-NEXT:    v_or_b32_sdwa v3, v10, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-DL-NOXNACK-NEXT:    v_or_b32_sdwa v9, v11, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v10, 8, v13
; GFX10-DL-NOXNACK-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NOXNACK-NEXT:    v_add_nc_u16 v2, v1, v2
; GFX10-DL-NOXNACK-NEXT:    v_or_b32_sdwa v1, v3, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX10-DL-NOXNACK-NEXT:    v_add_nc_u16 v9, v2, v10
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b64 v[2:3], 24, v[0:1]
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX10-DL-NOXNACK-NEXT:    v_add_nc_u16 v0, v9, v8
; GFX10-DL-NOXNACK-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX10-DL-NOXNACK-NEXT:    v_mad_u16 v0, v5, v12, v0
; GFX10-DL-NOXNACK-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX10-DL-NOXNACK-NEXT:    v_lshrrev_b32_e32 v1, 8, v6
; GFX10-DL-NOXNACK-NEXT:    v_mad_u16 v0, v7, v14, v0
; GFX10-DL-NOXNACK-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX10-DL-NOXNACK-NEXT:    global_store_byte v4, v0, s[0:1]
; GFX10-DL-NOXNACK-NEXT:    s_endpgm
; GFX10-DL-LABEL: idot8_acc8_vecMul:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x34
; GFX10-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-NEXT:    s_mov_b32 s20, SCRATCH_RSRC_DWORD0
; GFX10-DL-NEXT:    s_mov_b32 s21, SCRATCH_RSRC_DWORD1
; GFX10-DL-NEXT:    s_mov_b32 s22, -1
; GFX10-DL-NEXT:    s_mov_b32 s23, 0x31c16000
; GFX10-DL-NEXT:    s_add_u32 s20, s20, s3
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-DL-NEXT:    s_addc_u32 s21, s21, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    global_load_ubyte v1, v0, s[4:5]
; GFX10-DL-NEXT:    s_load_dword s0, s[0:1], 0x0
; GFX10-DL-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX10-DL-NEXT:    s_mov_b32 s2, 0xffff
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_lshr_b32 s9, s0, 4
; GFX10-DL-NEXT:    s_lshr_b32 s16, s1, 4
; GFX10-DL-NEXT:    v_lshlrev_b16_e64 v6, 12, s9
; GFX10-DL-NEXT:    v_lshlrev_b16_e64 v12, 12, s16
; GFX10-DL-NEXT:    s_lshr_b32 s10, s0, 12
; GFX10-DL-NEXT:    s_lshr_b32 s17, s1, 12
; GFX10-DL-NEXT:    v_lshlrev_b16_e64 v2, 12, s0
; GFX10-DL-NEXT:    v_lshlrev_b16_e64 v3, 12, s1
; GFX10-DL-NEXT:    v_lshlrev_b16_e64 v13, 12, s17
; GFX10-DL-NEXT:    v_lshlrev_b16_e64 v5, 12, s10
; GFX10-DL-NEXT:    v_ashrrev_i16_e64 v6, 12, v6
; GFX10-DL-NEXT:    v_ashrrev_i16_e64 v12, 12, v12
; GFX10-DL-NEXT:    s_lshr_b32 s11, s0, 8
; GFX10-DL-NEXT:    s_lshr_b32 s18, s1, 8
; GFX10-DL-NEXT:    v_lshlrev_b16_e64 v4, 12, s11
; GFX10-DL-NEXT:    v_lshlrev_b16_e64 v11, 12, s18
; GFX10-DL-NEXT:    v_ashrrev_i16_e64 v2, 12, v2
; GFX10-DL-NEXT:    v_ashrrev_i16_e64 v3, 12, v3
; GFX10-DL-NEXT:    v_ashrrev_i16_e64 v19, 12, v5
; GFX10-DL-NEXT:    v_mul_lo_u16_e64 v6, v6, v12
; GFX10-DL-NEXT:    v_ashrrev_i16_e64 v13, 12, v13
; GFX10-DL-NEXT:    v_ashrrev_i16_e64 v4, 12, v4
; GFX10-DL-NEXT:    v_ashrrev_i16_e64 v11, 12, v11
; GFX10-DL-NEXT:    v_mul_lo_u16_e64 v2, v2, v3
; GFX10-DL-NEXT:    v_lshlrev_b16_e64 v5, 8, v6
; GFX10-DL-NEXT:    v_mul_lo_u16_e64 v3, v19, v13
; GFX10-DL-NEXT:    s_lshr_b32 s3, s0, 20
; GFX10-DL-NEXT:    s_lshr_b32 s6, s0, 16
; GFX10-DL-NEXT:    s_lshr_b32 s7, s0, 28
; GFX10-DL-NEXT:    s_lshr_b32 s8, s0, 24
; GFX10-DL-NEXT:    s_lshr_b32 s12, s1, 20
; GFX10-DL-NEXT:    v_or_b32_sdwa v2, v2, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-DL-NEXT:    v_lshlrev_b16_e64 v7, 12, s8
; GFX10-DL-NEXT:    v_lshlrev_b16_e64 v8, 12, s7
; GFX10-DL-NEXT:    v_lshlrev_b16_e64 v9, 12, s6
; GFX10-DL-NEXT:    v_lshlrev_b16_e64 v10, 12, s3
; GFX10-DL-NEXT:    v_lshlrev_b16_e64 v12, 12, s12
; GFX10-DL-NEXT:    v_mul_lo_u16_e64 v4, v4, v11
; GFX10-DL-NEXT:    v_lshlrev_b16_e64 v3, 8, v3
; GFX10-DL-NEXT:    s_lshr_b32 s13, s1, 16
; GFX10-DL-NEXT:    s_lshr_b32 s14, s1, 28
; GFX10-DL-NEXT:    v_lshlrev_b16_e64 v6, 12, s13
; GFX10-DL-NEXT:    v_ashrrev_i16_e64 v5, 12, v7
; GFX10-DL-NEXT:    v_ashrrev_i16_e64 v7, 12, v8
; GFX10-DL-NEXT:    v_ashrrev_i16_e64 v8, 12, v9
; GFX10-DL-NEXT:    v_or_b32_sdwa v3, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-DL-NEXT:    v_and_b32_e32 v2, s2, v2
; GFX10-DL-NEXT:    v_lshlrev_b16_e64 v15, 12, s14
; GFX10-DL-NEXT:    v_ashrrev_i16_e64 v4, 12, v10
; GFX10-DL-NEXT:    v_ashrrev_i16_e64 v9, 12, v12
; GFX10-DL-NEXT:    s_lshr_b32 s15, s1, 24
; GFX10-DL-NEXT:    v_ashrrev_i16_e64 v6, 12, v6
; GFX10-DL-NEXT:    v_ashrrev_i16_e64 v10, 12, v15
; GFX10-DL-NEXT:    v_lshlrev_b16_e64 v14, 12, s15
; GFX10-DL-NEXT:    v_or_b32_e32 v3, v2, v3
; GFX10-DL-NEXT:    v_mul_lo_u16_e64 v4, v4, v9
; GFX10-DL-NEXT:    v_mul_lo_u16_e64 v15, v8, v6
; GFX10-DL-NEXT:    v_mul_lo_u16_e64 v7, v7, v10
; GFX10-DL-NEXT:    v_ashrrev_i16_e64 v11, 12, v14
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v8, 8, v3
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_add_nc_u32_e32 v1, v2, v1
; GFX10-DL-NEXT:    v_lshlrev_b16_e64 v2, 8, v4
; GFX10-DL-NEXT:    v_mul_lo_u16_e64 v4, v5, v11
; GFX10-DL-NEXT:    v_lshlrev_b16_e64 v5, 8, v7
; GFX10-DL-NEXT:    v_add_nc_u32_e32 v1, v1, v8
; GFX10-DL-NEXT:    v_or_b32_sdwa v2, v15, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-DL-NEXT:    v_or_b32_sdwa v4, v4, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-DL-NEXT:    v_add_nc_u32_sdwa v1, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_2
; GFX10-DL-NEXT:    v_and_b32_e32 v2, s2, v2
; GFX10-DL-NEXT:    v_add_nc_u32_sdwa v1, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
; GFX10-DL-NEXT:    v_or_b32_e32 v3, v2, v4
; GFX10-DL-NEXT:    v_add_nc_u32_e32 v1, v1, v2
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v2, 8, v3
; GFX10-DL-NEXT:    v_add_nc_u32_e32 v1, v1, v2
; GFX10-DL-NEXT:    v_add_nc_u32_sdwa v1, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-DL-NEXT:    v_add_nc_u32_sdwa v1, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
; GFX10-DL-NEXT:    global_store_byte v0, v1, s[4:5]
; GFX10-DL-NEXT:    s_endpgm
                                             ptr addrspace(1) %src2,
                                             ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <8 x i4>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <8 x i4>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <8 x i4>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <8 x i4>, ptr addrspace(1) %gep2

  %cvec1 = sext <8 x i4> %vec1 to <8 x i8>
  %cvec2 = sext <8 x i4> %vec2 to <8 x i8>

  %mul = mul <8 x i8> %cvec1, %cvec2
  %mul0 = extractelement <8 x i8> %mul, i64 0
  %mul1 = extractelement <8 x i8> %mul, i64 1
  %mul2 = extractelement <8 x i8> %mul, i64 2
  %mul3 = extractelement <8 x i8> %mul, i64 3
  %mul4 = extractelement <8 x i8> %mul, i64 4
  %mul5 = extractelement <8 x i8> %mul, i64 5
  %mul6 = extractelement <8 x i8> %mul, i64 6
  %mul7 = extractelement <8 x i8> %mul, i64 7

  %acc = load i8, ptr addrspace(1) %dst, align 4
  %add1 = add i8 %mul0, %acc
  %add2 = add i8 %add1, %mul1
  %add3 = add i8 %add2, %mul2
  %add4 = add i8 %add3, %mul3
  %add5 = add i8 %add4, %mul4
  %add6 = add i8 %add5, %mul5
  %add7 = add i8 %add6, %mul6
  %add8 = add i8 %add7, %mul7

  store i8 %add8, ptr addrspace(1) %dst, align 4
  ret void
}

declare i32 @llvm.amdgcn.workitem.id.x()
