; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+zfh -verify-machineinstrs \
; RUN:   -target-abi ilp32f < %s | FileCheck -check-prefix=CHECKIZFH %s
; RUN: llc -mtriple=riscv64 -mattr=+zfh -verify-machineinstrs \
; RUN:   -target-abi lp64f < %s | FileCheck -check-prefix=CHECKIZFH %s
; RUN: llc -mtriple=riscv32 -mattr=+zfh -verify-machineinstrs \
; RUN:   < %s | FileCheck -check-prefix=RV32I %s
; RUN: llc -mtriple=riscv64 -mattr=+zfh -verify-machineinstrs \
; RUN:   < %s | FileCheck -check-prefix=RV64I %s
; RUN: llc -mtriple=riscv32 -mattr=+zfhmin -verify-machineinstrs \
; RUN:   -target-abi ilp32f < %s | FileCheck -check-prefix=CHECKIZFHMIN-ILP32F-LP64F %s
; RUN: llc -mtriple=riscv64 -mattr=+zfhmin -verify-machineinstrs \
; RUN:   -target-abi lp64f < %s | FileCheck -check-prefix=CHECKIZFHMIN-ILP32F-LP64F %s
; RUN: llc -mtriple=riscv32 -mattr=+zfhmin -verify-machineinstrs \
; RUN:   < %s | FileCheck -check-prefix=CHECKIZFHMIN %s
; RUN: llc -mtriple=riscv64 -mattr=+zfhmin -verify-machineinstrs \
; RUN:   < %s | FileCheck -check-prefix=CHECKIZFHMIN %s

define i32 @fcmp_false(half %a, half %b) nounwind {
; CHECKIZFH-LABEL: fcmp_false:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    li a0, 0
; CHECKIZFH-NEXT:    ret
;
; RV32I-LABEL: fcmp_false:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a0, 0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcmp_false:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 0
; RV64I-NEXT:    ret
;
; CHECKIZFHMIN-ILP32F-LP64F-LABEL: fcmp_false:
; CHECKIZFHMIN-ILP32F-LP64F:       # %bb.0:
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    li a0, 0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_false:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    li a0, 0
; CHECKIZFHMIN-NEXT:    ret
  %1 = fcmp false half %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_oeq(half %a, half %b) nounwind {
; CHECKIZFH-LABEL: fcmp_oeq:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    feq.h a0, fa0, fa1
; CHECKIZFH-NEXT:    ret
;
; RV32I-LABEL: fcmp_oeq:
; RV32I:       # %bb.0:
; RV32I-NEXT:    fmv.h.x ft0, a1
; RV32I-NEXT:    fmv.h.x ft1, a0
; RV32I-NEXT:    feq.h a0, ft1, ft0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcmp_oeq:
; RV64I:       # %bb.0:
; RV64I-NEXT:    fmv.h.x ft0, a1
; RV64I-NEXT:    fmv.h.x ft1, a0
; RV64I-NEXT:    feq.h a0, ft1, ft0
; RV64I-NEXT:    ret
;
; CHECKIZFHMIN-ILP32F-LP64F-LABEL: fcmp_oeq:
; CHECKIZFHMIN-ILP32F-LP64F:       # %bb.0:
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fcvt.s.h ft0, fa1
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fcvt.s.h ft1, fa0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    feq.s a0, ft1, ft0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_oeq:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fmv.h.x ft0, a0
; CHECKIZFHMIN-NEXT:    fmv.h.x ft1, a1
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft1, ft1
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft0, ft0
; CHECKIZFHMIN-NEXT:    feq.s a0, ft0, ft1
; CHECKIZFHMIN-NEXT:    ret
  %1 = fcmp oeq half %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_ogt(half %a, half %b) nounwind {
; CHECKIZFH-LABEL: fcmp_ogt:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    flt.h a0, fa1, fa0
; CHECKIZFH-NEXT:    ret
;
; RV32I-LABEL: fcmp_ogt:
; RV32I:       # %bb.0:
; RV32I-NEXT:    fmv.h.x ft0, a0
; RV32I-NEXT:    fmv.h.x ft1, a1
; RV32I-NEXT:    flt.h a0, ft1, ft0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcmp_ogt:
; RV64I:       # %bb.0:
; RV64I-NEXT:    fmv.h.x ft0, a0
; RV64I-NEXT:    fmv.h.x ft1, a1
; RV64I-NEXT:    flt.h a0, ft1, ft0
; RV64I-NEXT:    ret
;
; CHECKIZFHMIN-ILP32F-LP64F-LABEL: fcmp_ogt:
; CHECKIZFHMIN-ILP32F-LP64F:       # %bb.0:
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fcvt.s.h ft0, fa0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fcvt.s.h ft1, fa1
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    flt.s a0, ft1, ft0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_ogt:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fmv.h.x ft0, a1
; CHECKIZFHMIN-NEXT:    fmv.h.x ft1, a0
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft1, ft1
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft0, ft0
; CHECKIZFHMIN-NEXT:    flt.s a0, ft0, ft1
; CHECKIZFHMIN-NEXT:    ret
  %1 = fcmp ogt half %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_oge(half %a, half %b) nounwind {
; CHECKIZFH-LABEL: fcmp_oge:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fle.h a0, fa1, fa0
; CHECKIZFH-NEXT:    ret
;
; RV32I-LABEL: fcmp_oge:
; RV32I:       # %bb.0:
; RV32I-NEXT:    fmv.h.x ft0, a0
; RV32I-NEXT:    fmv.h.x ft1, a1
; RV32I-NEXT:    fle.h a0, ft1, ft0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcmp_oge:
; RV64I:       # %bb.0:
; RV64I-NEXT:    fmv.h.x ft0, a0
; RV64I-NEXT:    fmv.h.x ft1, a1
; RV64I-NEXT:    fle.h a0, ft1, ft0
; RV64I-NEXT:    ret
;
; CHECKIZFHMIN-ILP32F-LP64F-LABEL: fcmp_oge:
; CHECKIZFHMIN-ILP32F-LP64F:       # %bb.0:
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fcvt.s.h ft0, fa0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fcvt.s.h ft1, fa1
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fle.s a0, ft1, ft0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_oge:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fmv.h.x ft0, a1
; CHECKIZFHMIN-NEXT:    fmv.h.x ft1, a0
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft1, ft1
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft0, ft0
; CHECKIZFHMIN-NEXT:    fle.s a0, ft0, ft1
; CHECKIZFHMIN-NEXT:    ret
  %1 = fcmp oge half %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_olt(half %a, half %b) nounwind {
; CHECKIZFH-LABEL: fcmp_olt:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    flt.h a0, fa0, fa1
; CHECKIZFH-NEXT:    ret
;
; RV32I-LABEL: fcmp_olt:
; RV32I:       # %bb.0:
; RV32I-NEXT:    fmv.h.x ft0, a1
; RV32I-NEXT:    fmv.h.x ft1, a0
; RV32I-NEXT:    flt.h a0, ft1, ft0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcmp_olt:
; RV64I:       # %bb.0:
; RV64I-NEXT:    fmv.h.x ft0, a1
; RV64I-NEXT:    fmv.h.x ft1, a0
; RV64I-NEXT:    flt.h a0, ft1, ft0
; RV64I-NEXT:    ret
;
; CHECKIZFHMIN-ILP32F-LP64F-LABEL: fcmp_olt:
; CHECKIZFHMIN-ILP32F-LP64F:       # %bb.0:
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fcvt.s.h ft0, fa1
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fcvt.s.h ft1, fa0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    flt.s a0, ft1, ft0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_olt:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fmv.h.x ft0, a0
; CHECKIZFHMIN-NEXT:    fmv.h.x ft1, a1
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft1, ft1
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft0, ft0
; CHECKIZFHMIN-NEXT:    flt.s a0, ft0, ft1
; CHECKIZFHMIN-NEXT:    ret
  %1 = fcmp olt half %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_ole(half %a, half %b) nounwind {
; CHECKIZFH-LABEL: fcmp_ole:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fle.h a0, fa0, fa1
; CHECKIZFH-NEXT:    ret
;
; RV32I-LABEL: fcmp_ole:
; RV32I:       # %bb.0:
; RV32I-NEXT:    fmv.h.x ft0, a1
; RV32I-NEXT:    fmv.h.x ft1, a0
; RV32I-NEXT:    fle.h a0, ft1, ft0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcmp_ole:
; RV64I:       # %bb.0:
; RV64I-NEXT:    fmv.h.x ft0, a1
; RV64I-NEXT:    fmv.h.x ft1, a0
; RV64I-NEXT:    fle.h a0, ft1, ft0
; RV64I-NEXT:    ret
;
; CHECKIZFHMIN-ILP32F-LP64F-LABEL: fcmp_ole:
; CHECKIZFHMIN-ILP32F-LP64F:       # %bb.0:
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fcvt.s.h ft0, fa1
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fcvt.s.h ft1, fa0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fle.s a0, ft1, ft0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_ole:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fmv.h.x ft0, a0
; CHECKIZFHMIN-NEXT:    fmv.h.x ft1, a1
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft1, ft1
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft0, ft0
; CHECKIZFHMIN-NEXT:    fle.s a0, ft0, ft1
; CHECKIZFHMIN-NEXT:    ret
  %1 = fcmp ole half %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_one(half %a, half %b) nounwind {
; CHECKIZFH-LABEL: fcmp_one:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    flt.h a0, fa0, fa1
; CHECKIZFH-NEXT:    flt.h a1, fa1, fa0
; CHECKIZFH-NEXT:    or a0, a1, a0
; CHECKIZFH-NEXT:    ret
;
; RV32I-LABEL: fcmp_one:
; RV32I:       # %bb.0:
; RV32I-NEXT:    fmv.h.x ft0, a1
; RV32I-NEXT:    fmv.h.x ft1, a0
; RV32I-NEXT:    flt.h a0, ft1, ft0
; RV32I-NEXT:    flt.h a1, ft0, ft1
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcmp_one:
; RV64I:       # %bb.0:
; RV64I-NEXT:    fmv.h.x ft0, a1
; RV64I-NEXT:    fmv.h.x ft1, a0
; RV64I-NEXT:    flt.h a0, ft1, ft0
; RV64I-NEXT:    flt.h a1, ft0, ft1
; RV64I-NEXT:    or a0, a1, a0
; RV64I-NEXT:    ret
;
; CHECKIZFHMIN-ILP32F-LP64F-LABEL: fcmp_one:
; CHECKIZFHMIN-ILP32F-LP64F:       # %bb.0:
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fcvt.s.h ft0, fa1
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fcvt.s.h ft1, fa0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    flt.s a0, ft1, ft0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    flt.s a1, ft0, ft1
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    or a0, a1, a0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_one:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fmv.h.x ft0, a0
; CHECKIZFHMIN-NEXT:    fmv.h.x ft1, a1
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft1, ft1
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft0, ft0
; CHECKIZFHMIN-NEXT:    flt.s a0, ft0, ft1
; CHECKIZFHMIN-NEXT:    flt.s a1, ft1, ft0
; CHECKIZFHMIN-NEXT:    or a0, a1, a0
; CHECKIZFHMIN-NEXT:    ret
  %1 = fcmp one half %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_ord(half %a, half %b) nounwind {
; CHECKIZFH-LABEL: fcmp_ord:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    feq.h a0, fa1, fa1
; CHECKIZFH-NEXT:    feq.h a1, fa0, fa0
; CHECKIZFH-NEXT:    and a0, a1, a0
; CHECKIZFH-NEXT:    ret
;
; RV32I-LABEL: fcmp_ord:
; RV32I:       # %bb.0:
; RV32I-NEXT:    fmv.h.x ft0, a0
; RV32I-NEXT:    fmv.h.x ft1, a1
; RV32I-NEXT:    feq.h a0, ft1, ft1
; RV32I-NEXT:    feq.h a1, ft0, ft0
; RV32I-NEXT:    and a0, a1, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcmp_ord:
; RV64I:       # %bb.0:
; RV64I-NEXT:    fmv.h.x ft0, a0
; RV64I-NEXT:    fmv.h.x ft1, a1
; RV64I-NEXT:    feq.h a0, ft1, ft1
; RV64I-NEXT:    feq.h a1, ft0, ft0
; RV64I-NEXT:    and a0, a1, a0
; RV64I-NEXT:    ret
;
; CHECKIZFHMIN-ILP32F-LP64F-LABEL: fcmp_ord:
; CHECKIZFHMIN-ILP32F-LP64F:       # %bb.0:
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fcvt.s.h ft0, fa1
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    feq.s a0, ft0, ft0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fcvt.s.h ft0, fa0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    feq.s a1, ft0, ft0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    and a0, a1, a0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_ord:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fmv.h.x ft0, a0
; CHECKIZFHMIN-NEXT:    fmv.h.x ft1, a1
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft1, ft1
; CHECKIZFHMIN-NEXT:    feq.s a0, ft1, ft1
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft0, ft0
; CHECKIZFHMIN-NEXT:    feq.s a1, ft0, ft0
; CHECKIZFHMIN-NEXT:    and a0, a1, a0
; CHECKIZFHMIN-NEXT:    ret
  %1 = fcmp ord half %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_ueq(half %a, half %b) nounwind {
; CHECKIZFH-LABEL: fcmp_ueq:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    flt.h a0, fa0, fa1
; CHECKIZFH-NEXT:    flt.h a1, fa1, fa0
; CHECKIZFH-NEXT:    or a0, a1, a0
; CHECKIZFH-NEXT:    xori a0, a0, 1
; CHECKIZFH-NEXT:    ret
;
; RV32I-LABEL: fcmp_ueq:
; RV32I:       # %bb.0:
; RV32I-NEXT:    fmv.h.x ft0, a1
; RV32I-NEXT:    fmv.h.x ft1, a0
; RV32I-NEXT:    flt.h a0, ft1, ft0
; RV32I-NEXT:    flt.h a1, ft0, ft1
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcmp_ueq:
; RV64I:       # %bb.0:
; RV64I-NEXT:    fmv.h.x ft0, a1
; RV64I-NEXT:    fmv.h.x ft1, a0
; RV64I-NEXT:    flt.h a0, ft1, ft0
; RV64I-NEXT:    flt.h a1, ft0, ft1
; RV64I-NEXT:    or a0, a1, a0
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
;
; CHECKIZFHMIN-ILP32F-LP64F-LABEL: fcmp_ueq:
; CHECKIZFHMIN-ILP32F-LP64F:       # %bb.0:
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fcvt.s.h ft0, fa1
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fcvt.s.h ft1, fa0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    flt.s a0, ft1, ft0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    flt.s a1, ft0, ft1
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    or a0, a1, a0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    xori a0, a0, 1
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_ueq:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fmv.h.x ft0, a0
; CHECKIZFHMIN-NEXT:    fmv.h.x ft1, a1
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft1, ft1
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft0, ft0
; CHECKIZFHMIN-NEXT:    flt.s a0, ft0, ft1
; CHECKIZFHMIN-NEXT:    flt.s a1, ft1, ft0
; CHECKIZFHMIN-NEXT:    or a0, a1, a0
; CHECKIZFHMIN-NEXT:    xori a0, a0, 1
; CHECKIZFHMIN-NEXT:    ret
  %1 = fcmp ueq half %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_ugt(half %a, half %b) nounwind {
; CHECKIZFH-LABEL: fcmp_ugt:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fle.h a0, fa0, fa1
; CHECKIZFH-NEXT:    xori a0, a0, 1
; CHECKIZFH-NEXT:    ret
;
; RV32I-LABEL: fcmp_ugt:
; RV32I:       # %bb.0:
; RV32I-NEXT:    fmv.h.x ft0, a1
; RV32I-NEXT:    fmv.h.x ft1, a0
; RV32I-NEXT:    fle.h a0, ft1, ft0
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcmp_ugt:
; RV64I:       # %bb.0:
; RV64I-NEXT:    fmv.h.x ft0, a1
; RV64I-NEXT:    fmv.h.x ft1, a0
; RV64I-NEXT:    fle.h a0, ft1, ft0
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
;
; CHECKIZFHMIN-ILP32F-LP64F-LABEL: fcmp_ugt:
; CHECKIZFHMIN-ILP32F-LP64F:       # %bb.0:
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fcvt.s.h ft0, fa1
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fcvt.s.h ft1, fa0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fle.s a0, ft1, ft0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    xori a0, a0, 1
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_ugt:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fmv.h.x ft0, a0
; CHECKIZFHMIN-NEXT:    fmv.h.x ft1, a1
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft1, ft1
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft0, ft0
; CHECKIZFHMIN-NEXT:    fle.s a0, ft0, ft1
; CHECKIZFHMIN-NEXT:    xori a0, a0, 1
; CHECKIZFHMIN-NEXT:    ret
  %1 = fcmp ugt half %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_uge(half %a, half %b) nounwind {
; CHECKIZFH-LABEL: fcmp_uge:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    flt.h a0, fa0, fa1
; CHECKIZFH-NEXT:    xori a0, a0, 1
; CHECKIZFH-NEXT:    ret
;
; RV32I-LABEL: fcmp_uge:
; RV32I:       # %bb.0:
; RV32I-NEXT:    fmv.h.x ft0, a1
; RV32I-NEXT:    fmv.h.x ft1, a0
; RV32I-NEXT:    flt.h a0, ft1, ft0
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcmp_uge:
; RV64I:       # %bb.0:
; RV64I-NEXT:    fmv.h.x ft0, a1
; RV64I-NEXT:    fmv.h.x ft1, a0
; RV64I-NEXT:    flt.h a0, ft1, ft0
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
;
; CHECKIZFHMIN-ILP32F-LP64F-LABEL: fcmp_uge:
; CHECKIZFHMIN-ILP32F-LP64F:       # %bb.0:
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fcvt.s.h ft0, fa1
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fcvt.s.h ft1, fa0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    flt.s a0, ft1, ft0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    xori a0, a0, 1
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_uge:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fmv.h.x ft0, a0
; CHECKIZFHMIN-NEXT:    fmv.h.x ft1, a1
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft1, ft1
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft0, ft0
; CHECKIZFHMIN-NEXT:    flt.s a0, ft0, ft1
; CHECKIZFHMIN-NEXT:    xori a0, a0, 1
; CHECKIZFHMIN-NEXT:    ret
  %1 = fcmp uge half %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_ult(half %a, half %b) nounwind {
; CHECKIZFH-LABEL: fcmp_ult:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fle.h a0, fa1, fa0
; CHECKIZFH-NEXT:    xori a0, a0, 1
; CHECKIZFH-NEXT:    ret
;
; RV32I-LABEL: fcmp_ult:
; RV32I:       # %bb.0:
; RV32I-NEXT:    fmv.h.x ft0, a0
; RV32I-NEXT:    fmv.h.x ft1, a1
; RV32I-NEXT:    fle.h a0, ft1, ft0
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcmp_ult:
; RV64I:       # %bb.0:
; RV64I-NEXT:    fmv.h.x ft0, a0
; RV64I-NEXT:    fmv.h.x ft1, a1
; RV64I-NEXT:    fle.h a0, ft1, ft0
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
;
; CHECKIZFHMIN-ILP32F-LP64F-LABEL: fcmp_ult:
; CHECKIZFHMIN-ILP32F-LP64F:       # %bb.0:
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fcvt.s.h ft0, fa0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fcvt.s.h ft1, fa1
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fle.s a0, ft1, ft0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    xori a0, a0, 1
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_ult:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fmv.h.x ft0, a1
; CHECKIZFHMIN-NEXT:    fmv.h.x ft1, a0
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft1, ft1
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft0, ft0
; CHECKIZFHMIN-NEXT:    fle.s a0, ft0, ft1
; CHECKIZFHMIN-NEXT:    xori a0, a0, 1
; CHECKIZFHMIN-NEXT:    ret
  %1 = fcmp ult half %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_ule(half %a, half %b) nounwind {
; CHECKIZFH-LABEL: fcmp_ule:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    flt.h a0, fa1, fa0
; CHECKIZFH-NEXT:    xori a0, a0, 1
; CHECKIZFH-NEXT:    ret
;
; RV32I-LABEL: fcmp_ule:
; RV32I:       # %bb.0:
; RV32I-NEXT:    fmv.h.x ft0, a0
; RV32I-NEXT:    fmv.h.x ft1, a1
; RV32I-NEXT:    flt.h a0, ft1, ft0
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcmp_ule:
; RV64I:       # %bb.0:
; RV64I-NEXT:    fmv.h.x ft0, a0
; RV64I-NEXT:    fmv.h.x ft1, a1
; RV64I-NEXT:    flt.h a0, ft1, ft0
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
;
; CHECKIZFHMIN-ILP32F-LP64F-LABEL: fcmp_ule:
; CHECKIZFHMIN-ILP32F-LP64F:       # %bb.0:
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fcvt.s.h ft0, fa0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fcvt.s.h ft1, fa1
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    flt.s a0, ft1, ft0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    xori a0, a0, 1
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_ule:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fmv.h.x ft0, a1
; CHECKIZFHMIN-NEXT:    fmv.h.x ft1, a0
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft1, ft1
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft0, ft0
; CHECKIZFHMIN-NEXT:    flt.s a0, ft0, ft1
; CHECKIZFHMIN-NEXT:    xori a0, a0, 1
; CHECKIZFHMIN-NEXT:    ret
  %1 = fcmp ule half %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_une(half %a, half %b) nounwind {
; CHECKIZFH-LABEL: fcmp_une:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    feq.h a0, fa0, fa1
; CHECKIZFH-NEXT:    xori a0, a0, 1
; CHECKIZFH-NEXT:    ret
;
; RV32I-LABEL: fcmp_une:
; RV32I:       # %bb.0:
; RV32I-NEXT:    fmv.h.x ft0, a1
; RV32I-NEXT:    fmv.h.x ft1, a0
; RV32I-NEXT:    feq.h a0, ft1, ft0
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcmp_une:
; RV64I:       # %bb.0:
; RV64I-NEXT:    fmv.h.x ft0, a1
; RV64I-NEXT:    fmv.h.x ft1, a0
; RV64I-NEXT:    feq.h a0, ft1, ft0
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
;
; CHECKIZFHMIN-ILP32F-LP64F-LABEL: fcmp_une:
; CHECKIZFHMIN-ILP32F-LP64F:       # %bb.0:
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fcvt.s.h ft0, fa1
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fcvt.s.h ft1, fa0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    feq.s a0, ft1, ft0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    xori a0, a0, 1
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_une:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fmv.h.x ft0, a0
; CHECKIZFHMIN-NEXT:    fmv.h.x ft1, a1
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft1, ft1
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft0, ft0
; CHECKIZFHMIN-NEXT:    feq.s a0, ft0, ft1
; CHECKIZFHMIN-NEXT:    xori a0, a0, 1
; CHECKIZFHMIN-NEXT:    ret
  %1 = fcmp une half %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_uno(half %a, half %b) nounwind {
; CHECKIZFH-LABEL: fcmp_uno:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    feq.h a0, fa1, fa1
; CHECKIZFH-NEXT:    feq.h a1, fa0, fa0
; CHECKIZFH-NEXT:    and a0, a1, a0
; CHECKIZFH-NEXT:    xori a0, a0, 1
; CHECKIZFH-NEXT:    ret
;
; RV32I-LABEL: fcmp_uno:
; RV32I:       # %bb.0:
; RV32I-NEXT:    fmv.h.x ft0, a0
; RV32I-NEXT:    fmv.h.x ft1, a1
; RV32I-NEXT:    feq.h a0, ft1, ft1
; RV32I-NEXT:    feq.h a1, ft0, ft0
; RV32I-NEXT:    and a0, a1, a0
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcmp_uno:
; RV64I:       # %bb.0:
; RV64I-NEXT:    fmv.h.x ft0, a0
; RV64I-NEXT:    fmv.h.x ft1, a1
; RV64I-NEXT:    feq.h a0, ft1, ft1
; RV64I-NEXT:    feq.h a1, ft0, ft0
; RV64I-NEXT:    and a0, a1, a0
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
;
; CHECKIZFHMIN-ILP32F-LP64F-LABEL: fcmp_uno:
; CHECKIZFHMIN-ILP32F-LP64F:       # %bb.0:
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fcvt.s.h ft0, fa1
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    feq.s a0, ft0, ft0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    fcvt.s.h ft0, fa0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    feq.s a1, ft0, ft0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    and a0, a1, a0
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    xori a0, a0, 1
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_uno:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fmv.h.x ft0, a0
; CHECKIZFHMIN-NEXT:    fmv.h.x ft1, a1
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft1, ft1
; CHECKIZFHMIN-NEXT:    feq.s a0, ft1, ft1
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft0, ft0
; CHECKIZFHMIN-NEXT:    feq.s a1, ft0, ft0
; CHECKIZFHMIN-NEXT:    and a0, a1, a0
; CHECKIZFHMIN-NEXT:    xori a0, a0, 1
; CHECKIZFHMIN-NEXT:    ret
  %1 = fcmp uno half %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_true(half %a, half %b) nounwind {
; CHECKIZFH-LABEL: fcmp_true:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    li a0, 1
; CHECKIZFH-NEXT:    ret
;
; RV32I-LABEL: fcmp_true:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcmp_true:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    ret
;
; CHECKIZFHMIN-ILP32F-LP64F-LABEL: fcmp_true:
; CHECKIZFHMIN-ILP32F-LP64F:       # %bb.0:
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    li a0, 1
; CHECKIZFHMIN-ILP32F-LP64F-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_true:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    li a0, 1
; CHECKIZFHMIN-NEXT:    ret
  %1 = fcmp true half %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}
