; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-linux                  | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: llc < %s -mtriple=x86_64-linux -mattr=+sse4.2   | FileCheck %s --check-prefixes=SSE,SSE42
; RUN: llc < %s -mtriple=x86_64-linux -mattr=+avx      | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: llc < %s -mtriple=x86_64-linux -mattr=+avx2     | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: llc < %s -mtriple=x86_64-linux -mattr=+avx512vl | FileCheck %s --check-prefixes=AVX,AVX512

;
; trunc(abs(sub(sext(a),sext(b)))) -> abds(a,b)
;

define <16 x i8> @abd_ext_v16i8(<16 x i8> %a, <16 x i8> %b) nounwind {
; SSE2-LABEL: abd_ext_v16i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm0[0],xmm4[1],xmm0[1],xmm4[2],xmm0[2],xmm4[3],xmm0[3],xmm4[4],xmm0[4],xmm4[5],xmm0[5],xmm4[6],xmm0[6],xmm4[7],xmm0[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1],xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; SSE2-NEXT:    psrad $24, %xmm3
; SSE2-NEXT:    pxor %xmm9, %xmm9
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm5
; SSE2-NEXT:    movdqa %xmm3, %xmm0
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm5[0],xmm0[1],xmm5[1]
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm3 = xmm3[2],xmm5[2],xmm3[3],xmm5[3]
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4],xmm4[4],xmm5[5],xmm4[5],xmm5[6],xmm4[6],xmm5[7],xmm4[7]
; SSE2-NEXT:    psrad $24, %xmm5
; SSE2-NEXT:    pxor %xmm6, %xmm6
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm6
; SSE2-NEXT:    movdqa %xmm5, %xmm4
; SSE2-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm6[0],xmm4[1],xmm6[1]
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm5 = xmm5[2],xmm6[2],xmm5[3],xmm6[3]
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm7 = xmm7[8],xmm2[8],xmm7[9],xmm2[9],xmm7[10],xmm2[10],xmm7[11],xmm2[11],xmm7[12],xmm2[12],xmm7[13],xmm2[13],xmm7[14],xmm2[14],xmm7[15],xmm2[15]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm6 = xmm6[0],xmm7[0],xmm6[1],xmm7[1],xmm6[2],xmm7[2],xmm6[3],xmm7[3]
; SSE2-NEXT:    psrad $24, %xmm6
; SSE2-NEXT:    pxor %xmm8, %xmm8
; SSE2-NEXT:    pcmpgtd %xmm6, %xmm8
; SSE2-NEXT:    movdqa %xmm6, %xmm2
; SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm8[0],xmm2[1],xmm8[1]
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm6 = xmm6[2],xmm8[2],xmm6[3],xmm8[3]
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm8 = xmm8[4],xmm7[4],xmm8[5],xmm7[5],xmm8[6],xmm7[6],xmm8[7],xmm7[7]
; SSE2-NEXT:    psrad $24, %xmm8
; SSE2-NEXT:    pxor %xmm10, %xmm10
; SSE2-NEXT:    pcmpgtd %xmm8, %xmm10
; SSE2-NEXT:    movdqa %xmm8, %xmm7
; SSE2-NEXT:    punpckldq {{.*#+}} xmm7 = xmm7[0],xmm10[0],xmm7[1],xmm10[1]
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm8 = xmm8[2],xmm10[2],xmm8[3],xmm10[3]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm10 = xmm10[0],xmm1[0],xmm10[1],xmm1[1],xmm10[2],xmm1[2],xmm10[3],xmm1[3],xmm10[4],xmm1[4],xmm10[5],xmm1[5],xmm10[6],xmm1[6],xmm10[7],xmm1[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm11 = xmm11[0],xmm10[0],xmm11[1],xmm10[1],xmm11[2],xmm10[2],xmm11[3],xmm10[3]
; SSE2-NEXT:    psrad $24, %xmm11
; SSE2-NEXT:    pxor %xmm12, %xmm12
; SSE2-NEXT:    pcmpgtd %xmm11, %xmm12
; SSE2-NEXT:    movdqa %xmm11, %xmm13
; SSE2-NEXT:    punpckldq {{.*#+}} xmm13 = xmm13[0],xmm12[0],xmm13[1],xmm12[1]
; SSE2-NEXT:    psubq %xmm13, %xmm0
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm11 = xmm11[2],xmm12[2],xmm11[3],xmm12[3]
; SSE2-NEXT:    psubq %xmm11, %xmm3
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm10 = xmm10[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    psrad $24, %xmm10
; SSE2-NEXT:    pxor %xmm11, %xmm11
; SSE2-NEXT:    pcmpgtd %xmm10, %xmm11
; SSE2-NEXT:    movdqa %xmm10, %xmm12
; SSE2-NEXT:    punpckldq {{.*#+}} xmm12 = xmm12[0],xmm11[0],xmm12[1],xmm11[1]
; SSE2-NEXT:    psubq %xmm12, %xmm4
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm10 = xmm10[2],xmm11[2],xmm10[3],xmm11[3]
; SSE2-NEXT:    psubq %xmm10, %xmm5
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm10 = xmm10[0],xmm1[0],xmm10[1],xmm1[1],xmm10[2],xmm1[2],xmm10[3],xmm1[3]
; SSE2-NEXT:    psrad $24, %xmm10
; SSE2-NEXT:    pxor %xmm11, %xmm11
; SSE2-NEXT:    pcmpgtd %xmm10, %xmm11
; SSE2-NEXT:    movdqa %xmm10, %xmm12
; SSE2-NEXT:    punpckldq {{.*#+}} xmm12 = xmm12[0],xmm11[0],xmm12[1],xmm11[1]
; SSE2-NEXT:    psubq %xmm12, %xmm2
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm10 = xmm10[2],xmm11[2],xmm10[3],xmm11[3]
; SSE2-NEXT:    psubq %xmm10, %xmm6
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    psrad $24, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm9
; SSE2-NEXT:    movdqa %xmm1, %xmm10
; SSE2-NEXT:    punpckldq {{.*#+}} xmm10 = xmm10[0],xmm9[0],xmm10[1],xmm9[1]
; SSE2-NEXT:    psubq %xmm10, %xmm7
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm9[2],xmm1[3],xmm9[3]
; SSE2-NEXT:    psubq %xmm1, %xmm8
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm0
; SSE2-NEXT:    psubq %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm3, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm3
; SSE2-NEXT:    psubq %xmm1, %xmm3
; SSE2-NEXT:    movdqa %xmm4, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm4
; SSE2-NEXT:    psubq %xmm1, %xmm4
; SSE2-NEXT:    movdqa %xmm5, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm5
; SSE2-NEXT:    psubq %xmm1, %xmm5
; SSE2-NEXT:    movdqa %xmm2, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm2
; SSE2-NEXT:    psubq %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm6, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm6
; SSE2-NEXT:    psubq %xmm1, %xmm6
; SSE2-NEXT:    movdqa %xmm7, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm7
; SSE2-NEXT:    psubq %xmm1, %xmm7
; SSE2-NEXT:    movdqa %xmm8, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm8
; SSE2-NEXT:    psubq %xmm1, %xmm8
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0]
; SSE2-NEXT:    pand %xmm1, %xmm8
; SSE2-NEXT:    pand %xmm1, %xmm7
; SSE2-NEXT:    packuswb %xmm8, %xmm7
; SSE2-NEXT:    pand %xmm1, %xmm6
; SSE2-NEXT:    pand %xmm1, %xmm2
; SSE2-NEXT:    packuswb %xmm6, %xmm2
; SSE2-NEXT:    packuswb %xmm7, %xmm2
; SSE2-NEXT:    pand %xmm1, %xmm5
; SSE2-NEXT:    pand %xmm1, %xmm4
; SSE2-NEXT:    packuswb %xmm5, %xmm4
; SSE2-NEXT:    pand %xmm1, %xmm3
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    packuswb %xmm3, %xmm0
; SSE2-NEXT:    packuswb %xmm4, %xmm0
; SSE2-NEXT:    packuswb %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: abd_ext_v16i8:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movdqa %xmm0, %xmm2
; SSE42-NEXT:    psrld $16, %xmm2
; SSE42-NEXT:    pmovsxbq %xmm2, %xmm2
; SSE42-NEXT:    pmovsxbq %xmm0, %xmm9
; SSE42-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[1,1,1,1]
; SSE42-NEXT:    pmovsxbq %xmm3, %xmm3
; SSE42-NEXT:    movdqa %xmm0, %xmm4
; SSE42-NEXT:    psrlq $48, %xmm4
; SSE42-NEXT:    pmovsxbq %xmm4, %xmm5
; SSE42-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[2,3,2,3]
; SSE42-NEXT:    pmovsxbq %xmm4, %xmm4
; SSE42-NEXT:    movdqa %xmm0, %xmm6
; SSE42-NEXT:    psrldq {{.*#+}} xmm6 = xmm6[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE42-NEXT:    pmovsxbq %xmm6, %xmm6
; SSE42-NEXT:    pshufd {{.*#+}} xmm7 = xmm0[3,3,3,3]
; SSE42-NEXT:    pmovsxbq %xmm7, %xmm7
; SSE42-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE42-NEXT:    pmovsxbq %xmm0, %xmm8
; SSE42-NEXT:    movdqa %xmm1, %xmm0
; SSE42-NEXT:    psrld $16, %xmm0
; SSE42-NEXT:    pmovsxbq %xmm0, %xmm0
; SSE42-NEXT:    psubq %xmm0, %xmm2
; SSE42-NEXT:    pmovsxbq %xmm1, %xmm0
; SSE42-NEXT:    psubq %xmm0, %xmm9
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; SSE42-NEXT:    pmovsxbq %xmm0, %xmm0
; SSE42-NEXT:    psubq %xmm0, %xmm3
; SSE42-NEXT:    movdqa %xmm1, %xmm0
; SSE42-NEXT:    psrlq $48, %xmm0
; SSE42-NEXT:    pmovsxbq %xmm0, %xmm0
; SSE42-NEXT:    psubq %xmm0, %xmm5
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,2,3]
; SSE42-NEXT:    pmovsxbq %xmm0, %xmm0
; SSE42-NEXT:    psubq %xmm0, %xmm4
; SSE42-NEXT:    movdqa %xmm1, %xmm0
; SSE42-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE42-NEXT:    pmovsxbq %xmm0, %xmm0
; SSE42-NEXT:    psubq %xmm0, %xmm6
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[3,3,3,3]
; SSE42-NEXT:    pmovsxbq %xmm0, %xmm0
; SSE42-NEXT:    psubq %xmm0, %xmm7
; SSE42-NEXT:    psrldq {{.*#+}} xmm1 = xmm1[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE42-NEXT:    pmovsxbq %xmm1, %xmm0
; SSE42-NEXT:    psubq %xmm0, %xmm8
; SSE42-NEXT:    pxor %xmm1, %xmm1
; SSE42-NEXT:    pxor %xmm10, %xmm10
; SSE42-NEXT:    psubq %xmm2, %xmm10
; SSE42-NEXT:    movdqa %xmm2, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm10, %xmm2
; SSE42-NEXT:    pxor %xmm10, %xmm10
; SSE42-NEXT:    psubq %xmm9, %xmm10
; SSE42-NEXT:    movdqa %xmm9, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm10, %xmm9
; SSE42-NEXT:    pxor %xmm10, %xmm10
; SSE42-NEXT:    psubq %xmm3, %xmm10
; SSE42-NEXT:    movdqa %xmm3, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm10, %xmm3
; SSE42-NEXT:    pxor %xmm10, %xmm10
; SSE42-NEXT:    psubq %xmm5, %xmm10
; SSE42-NEXT:    movdqa %xmm5, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm10, %xmm5
; SSE42-NEXT:    pxor %xmm10, %xmm10
; SSE42-NEXT:    psubq %xmm4, %xmm10
; SSE42-NEXT:    movdqa %xmm4, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm10, %xmm4
; SSE42-NEXT:    pxor %xmm10, %xmm10
; SSE42-NEXT:    psubq %xmm6, %xmm10
; SSE42-NEXT:    movdqa %xmm6, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm10, %xmm6
; SSE42-NEXT:    pxor %xmm10, %xmm10
; SSE42-NEXT:    psubq %xmm7, %xmm10
; SSE42-NEXT:    movdqa %xmm7, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm10, %xmm7
; SSE42-NEXT:    psubq %xmm8, %xmm1
; SSE42-NEXT:    movdqa %xmm8, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm1, %xmm8
; SSE42-NEXT:    movapd {{.*#+}} xmm0 = [255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0]
; SSE42-NEXT:    andpd %xmm0, %xmm8
; SSE42-NEXT:    andpd %xmm0, %xmm7
; SSE42-NEXT:    packusdw %xmm8, %xmm7
; SSE42-NEXT:    andpd %xmm0, %xmm6
; SSE42-NEXT:    andpd %xmm0, %xmm4
; SSE42-NEXT:    packusdw %xmm6, %xmm4
; SSE42-NEXT:    packusdw %xmm7, %xmm4
; SSE42-NEXT:    andpd %xmm0, %xmm5
; SSE42-NEXT:    andpd %xmm0, %xmm3
; SSE42-NEXT:    packusdw %xmm5, %xmm3
; SSE42-NEXT:    andpd %xmm0, %xmm9
; SSE42-NEXT:    andpd %xmm0, %xmm2
; SSE42-NEXT:    packusdw %xmm2, %xmm9
; SSE42-NEXT:    packusdw %xmm3, %xmm9
; SSE42-NEXT:    packuswb %xmm4, %xmm9
; SSE42-NEXT:    movdqa %xmm9, %xmm0
; SSE42-NEXT:    retq
;
; AVX1-LABEL: abd_ext_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovsxbw %xmm2, %xmm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm4 = xmm3[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm4, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm3[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm5, %xmm5
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[1,1,1,1]
; AVX1-NEXT:    vpmovsxwq %xmm3, %xmm3
; AVX1-NEXT:    vpmovsxbq %xmm2, %xmm2
; AVX1-NEXT:    vpmovsxbw %xmm0, %xmm6
; AVX1-NEXT:    vpshufd {{.*#+}} xmm7 = xmm6[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm7, %xmm7
; AVX1-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm6, %xmm6
; AVX1-NEXT:    vpmovsxbq %xmm0, %xmm8
; AVX1-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq %xmm0, %xmm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm9 = xmm1[2,3,2,3]
; AVX1-NEXT:    vpmovsxbw %xmm9, %xmm10
; AVX1-NEXT:    vpshufd {{.*#+}} xmm11 = xmm10[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm11, %xmm11
; AVX1-NEXT:    vpsubq %xmm11, %xmm4, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm11 = xmm10[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm11, %xmm11
; AVX1-NEXT:    vpsubq %xmm11, %xmm5, %xmm5
; AVX1-NEXT:    vpshufd {{.*#+}} xmm10 = xmm10[1,1,1,1]
; AVX1-NEXT:    vpmovsxwq %xmm10, %xmm10
; AVX1-NEXT:    vpsubq %xmm10, %xmm3, %xmm3
; AVX1-NEXT:    vpmovsxbq %xmm9, %xmm9
; AVX1-NEXT:    vpsubq %xmm9, %xmm2, %xmm2
; AVX1-NEXT:    vpmovsxbw %xmm1, %xmm9
; AVX1-NEXT:    vpshufd {{.*#+}} xmm10 = xmm9[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm10, %xmm10
; AVX1-NEXT:    vpsubq %xmm10, %xmm7, %xmm7
; AVX1-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm9, %xmm9
; AVX1-NEXT:    vpsubq %xmm9, %xmm6, %xmm6
; AVX1-NEXT:    vpmovsxbq %xmm1, %xmm9
; AVX1-NEXT:    vpsubq %xmm9, %xmm8, %xmm8
; AVX1-NEXT:    vpsrld $16, %xmm1, %xmm1
; AVX1-NEXT:    vpmovsxbq %xmm1, %xmm1
; AVX1-NEXT:    vpsubq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm8, %ymm1
; AVX1-NEXT:    vinsertf128 $1, %xmm6, %ymm7, %ymm9
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm10
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm4, %ymm11
; AVX1-NEXT:    vpxor %xmm12, %xmm12, %xmm12
; AVX1-NEXT:    vpsubq %xmm5, %xmm12, %xmm5
; AVX1-NEXT:    vpsubq %xmm4, %xmm12, %xmm4
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm4, %ymm4
; AVX1-NEXT:    vblendvpd %ymm11, %ymm4, %ymm11, %ymm4
; AVX1-NEXT:    vpsubq %xmm2, %xmm12, %xmm2
; AVX1-NEXT:    vpsubq %xmm3, %xmm12, %xmm3
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX1-NEXT:    vblendvpd %ymm10, %ymm2, %ymm10, %ymm2
; AVX1-NEXT:    vpsubq %xmm6, %xmm12, %xmm3
; AVX1-NEXT:    vpsubq %xmm7, %xmm12, %xmm5
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm5, %ymm3
; AVX1-NEXT:    vblendvpd %ymm9, %ymm3, %ymm9, %ymm3
; AVX1-NEXT:    vpsubq %xmm0, %xmm12, %xmm0
; AVX1-NEXT:    vpsubq %xmm8, %xmm12, %xmm5
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm5, %ymm0
; AVX1-NEXT:    vblendvpd %ymm1, %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    vmovapd {{.*#+}} ymm1 = [255,255,255,255]
; AVX1-NEXT:    vandpd %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vandpd %ymm1, %ymm3, %ymm3
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vandpd %ymm1, %ymm2, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vandpd %ymm1, %ymm4, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackusdw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: abd_ext_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovsxbw %xmm0, %ymm2
; AVX2-NEXT:    vpshufd {{.*#+}} xmm3 = xmm2[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm3, %ymm3
; AVX2-NEXT:    vpmovsxbq %xmm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX2-NEXT:    vpshufd {{.*#+}} xmm4 = xmm2[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm4, %ymm4
; AVX2-NEXT:    vpmovsxwq %xmm2, %ymm2
; AVX2-NEXT:    vpmovsxbw %xmm1, %ymm5
; AVX2-NEXT:    vpshufd {{.*#+}} xmm6 = xmm5[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm6, %ymm6
; AVX2-NEXT:    vpsubq %ymm6, %ymm3, %ymm3
; AVX2-NEXT:    vpmovsxbq %xmm1, %ymm1
; AVX2-NEXT:    vpsubq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm5, %xmm1
; AVX2-NEXT:    vpshufd {{.*#+}} xmm5 = xmm1[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm5, %ymm5
; AVX2-NEXT:    vpsubq %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpmovsxwq %xmm1, %ymm1
; AVX2-NEXT:    vpsubq %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpsubq %ymm3, %ymm2, %ymm5
; AVX2-NEXT:    vblendvpd %ymm3, %ymm5, %ymm3, %ymm3
; AVX2-NEXT:    vpsubq %ymm0, %ymm2, %ymm5
; AVX2-NEXT:    vblendvpd %ymm0, %ymm5, %ymm0, %ymm0
; AVX2-NEXT:    vpsubq %ymm4, %ymm2, %ymm5
; AVX2-NEXT:    vblendvpd %ymm4, %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpsubq %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vblendvpd %ymm1, %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm2 = [255,255,255,255]
; AVX2-NEXT:    vandpd %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vandpd %ymm2, %ymm4, %ymm4
; AVX2-NEXT:    vpackusdw %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,1,3]
; AVX2-NEXT:    vandpd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vandpd %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpackusdw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vpackusdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: abd_ext_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbw %xmm0, %ymm0
; AVX512-NEXT:    vpmovsxwq %xmm0, %zmm2
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512-NEXT:    vpmovsxbw %xmm1, %ymm1
; AVX512-NEXT:    vpmovsxwq %xmm1, %zmm3
; AVX512-NEXT:    vpsubq %zmm3, %zmm2, %zmm2
; AVX512-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512-NEXT:    vpmovsxwq %xmm1, %zmm1
; AVX512-NEXT:    vpsubq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpabsq %zmm2, %zmm1
; AVX512-NEXT:    vpabsq %zmm0, %zmm0
; AVX512-NEXT:    vpmovqb %zmm0, %xmm0
; AVX512-NEXT:    vpmovqb %zmm1, %xmm1
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %aext = sext <16 x i8> %a to <16 x i64>
  %bext = sext <16 x i8> %b to <16 x i64>
  %sub = sub <16 x i64> %aext, %bext
  %abs = call <16 x i64> @llvm.abs.v16i64(<16 x i64> %sub, i1 false)
  %trunc = trunc <16 x i64> %abs to <16 x i8>
  ret <16 x i8> %trunc
}

define <16 x i8> @abd_ext_v16i8_undef(<16 x i8> %a, <16 x i8> %b) nounwind {
; SSE2-LABEL: abd_ext_v16i8_undef:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm0[0],xmm4[1],xmm0[1],xmm4[2],xmm0[2],xmm4[3],xmm0[3],xmm4[4],xmm0[4],xmm4[5],xmm0[5],xmm4[6],xmm0[6],xmm4[7],xmm0[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1],xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; SSE2-NEXT:    psrad $24, %xmm3
; SSE2-NEXT:    pxor %xmm9, %xmm9
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm5
; SSE2-NEXT:    movdqa %xmm3, %xmm0
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm5[0],xmm0[1],xmm5[1]
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm3 = xmm3[2],xmm5[2],xmm3[3],xmm5[3]
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4],xmm4[4],xmm5[5],xmm4[5],xmm5[6],xmm4[6],xmm5[7],xmm4[7]
; SSE2-NEXT:    psrad $24, %xmm5
; SSE2-NEXT:    pxor %xmm6, %xmm6
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm6
; SSE2-NEXT:    movdqa %xmm5, %xmm4
; SSE2-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm6[0],xmm4[1],xmm6[1]
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm5 = xmm5[2],xmm6[2],xmm5[3],xmm6[3]
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm7 = xmm7[8],xmm2[8],xmm7[9],xmm2[9],xmm7[10],xmm2[10],xmm7[11],xmm2[11],xmm7[12],xmm2[12],xmm7[13],xmm2[13],xmm7[14],xmm2[14],xmm7[15],xmm2[15]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm6 = xmm6[0],xmm7[0],xmm6[1],xmm7[1],xmm6[2],xmm7[2],xmm6[3],xmm7[3]
; SSE2-NEXT:    psrad $24, %xmm6
; SSE2-NEXT:    pxor %xmm8, %xmm8
; SSE2-NEXT:    pcmpgtd %xmm6, %xmm8
; SSE2-NEXT:    movdqa %xmm6, %xmm2
; SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm8[0],xmm2[1],xmm8[1]
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm6 = xmm6[2],xmm8[2],xmm6[3],xmm8[3]
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm8 = xmm8[4],xmm7[4],xmm8[5],xmm7[5],xmm8[6],xmm7[6],xmm8[7],xmm7[7]
; SSE2-NEXT:    psrad $24, %xmm8
; SSE2-NEXT:    pxor %xmm10, %xmm10
; SSE2-NEXT:    pcmpgtd %xmm8, %xmm10
; SSE2-NEXT:    movdqa %xmm8, %xmm7
; SSE2-NEXT:    punpckldq {{.*#+}} xmm7 = xmm7[0],xmm10[0],xmm7[1],xmm10[1]
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm8 = xmm8[2],xmm10[2],xmm8[3],xmm10[3]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm10 = xmm10[0],xmm1[0],xmm10[1],xmm1[1],xmm10[2],xmm1[2],xmm10[3],xmm1[3],xmm10[4],xmm1[4],xmm10[5],xmm1[5],xmm10[6],xmm1[6],xmm10[7],xmm1[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm11 = xmm11[0],xmm10[0],xmm11[1],xmm10[1],xmm11[2],xmm10[2],xmm11[3],xmm10[3]
; SSE2-NEXT:    psrad $24, %xmm11
; SSE2-NEXT:    pxor %xmm12, %xmm12
; SSE2-NEXT:    pcmpgtd %xmm11, %xmm12
; SSE2-NEXT:    movdqa %xmm11, %xmm13
; SSE2-NEXT:    punpckldq {{.*#+}} xmm13 = xmm13[0],xmm12[0],xmm13[1],xmm12[1]
; SSE2-NEXT:    psubq %xmm13, %xmm0
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm11 = xmm11[2],xmm12[2],xmm11[3],xmm12[3]
; SSE2-NEXT:    psubq %xmm11, %xmm3
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm10 = xmm10[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    psrad $24, %xmm10
; SSE2-NEXT:    pxor %xmm11, %xmm11
; SSE2-NEXT:    pcmpgtd %xmm10, %xmm11
; SSE2-NEXT:    movdqa %xmm10, %xmm12
; SSE2-NEXT:    punpckldq {{.*#+}} xmm12 = xmm12[0],xmm11[0],xmm12[1],xmm11[1]
; SSE2-NEXT:    psubq %xmm12, %xmm4
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm10 = xmm10[2],xmm11[2],xmm10[3],xmm11[3]
; SSE2-NEXT:    psubq %xmm10, %xmm5
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm10 = xmm10[0],xmm1[0],xmm10[1],xmm1[1],xmm10[2],xmm1[2],xmm10[3],xmm1[3]
; SSE2-NEXT:    psrad $24, %xmm10
; SSE2-NEXT:    pxor %xmm11, %xmm11
; SSE2-NEXT:    pcmpgtd %xmm10, %xmm11
; SSE2-NEXT:    movdqa %xmm10, %xmm12
; SSE2-NEXT:    punpckldq {{.*#+}} xmm12 = xmm12[0],xmm11[0],xmm12[1],xmm11[1]
; SSE2-NEXT:    psubq %xmm12, %xmm2
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm10 = xmm10[2],xmm11[2],xmm10[3],xmm11[3]
; SSE2-NEXT:    psubq %xmm10, %xmm6
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    psrad $24, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm9
; SSE2-NEXT:    movdqa %xmm1, %xmm10
; SSE2-NEXT:    punpckldq {{.*#+}} xmm10 = xmm10[0],xmm9[0],xmm10[1],xmm9[1]
; SSE2-NEXT:    psubq %xmm10, %xmm7
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm9[2],xmm1[3],xmm9[3]
; SSE2-NEXT:    psubq %xmm1, %xmm8
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm0
; SSE2-NEXT:    psubq %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm3, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm3
; SSE2-NEXT:    psubq %xmm1, %xmm3
; SSE2-NEXT:    movdqa %xmm4, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm4
; SSE2-NEXT:    psubq %xmm1, %xmm4
; SSE2-NEXT:    movdqa %xmm5, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm5
; SSE2-NEXT:    psubq %xmm1, %xmm5
; SSE2-NEXT:    movdqa %xmm2, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm2
; SSE2-NEXT:    psubq %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm6, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm6
; SSE2-NEXT:    psubq %xmm1, %xmm6
; SSE2-NEXT:    movdqa %xmm7, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm7
; SSE2-NEXT:    psubq %xmm1, %xmm7
; SSE2-NEXT:    movdqa %xmm8, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm8
; SSE2-NEXT:    psubq %xmm1, %xmm8
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0]
; SSE2-NEXT:    pand %xmm1, %xmm8
; SSE2-NEXT:    pand %xmm1, %xmm7
; SSE2-NEXT:    packuswb %xmm8, %xmm7
; SSE2-NEXT:    pand %xmm1, %xmm6
; SSE2-NEXT:    pand %xmm1, %xmm2
; SSE2-NEXT:    packuswb %xmm6, %xmm2
; SSE2-NEXT:    packuswb %xmm7, %xmm2
; SSE2-NEXT:    pand %xmm1, %xmm5
; SSE2-NEXT:    pand %xmm1, %xmm4
; SSE2-NEXT:    packuswb %xmm5, %xmm4
; SSE2-NEXT:    pand %xmm1, %xmm3
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    packuswb %xmm3, %xmm0
; SSE2-NEXT:    packuswb %xmm4, %xmm0
; SSE2-NEXT:    packuswb %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: abd_ext_v16i8_undef:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movdqa %xmm0, %xmm2
; SSE42-NEXT:    psrld $16, %xmm2
; SSE42-NEXT:    pmovsxbq %xmm2, %xmm2
; SSE42-NEXT:    pmovsxbq %xmm0, %xmm9
; SSE42-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[1,1,1,1]
; SSE42-NEXT:    pmovsxbq %xmm3, %xmm3
; SSE42-NEXT:    movdqa %xmm0, %xmm4
; SSE42-NEXT:    psrlq $48, %xmm4
; SSE42-NEXT:    pmovsxbq %xmm4, %xmm5
; SSE42-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[2,3,2,3]
; SSE42-NEXT:    pmovsxbq %xmm4, %xmm4
; SSE42-NEXT:    movdqa %xmm0, %xmm6
; SSE42-NEXT:    psrldq {{.*#+}} xmm6 = xmm6[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE42-NEXT:    pmovsxbq %xmm6, %xmm6
; SSE42-NEXT:    pshufd {{.*#+}} xmm7 = xmm0[3,3,3,3]
; SSE42-NEXT:    pmovsxbq %xmm7, %xmm7
; SSE42-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE42-NEXT:    pmovsxbq %xmm0, %xmm8
; SSE42-NEXT:    movdqa %xmm1, %xmm0
; SSE42-NEXT:    psrld $16, %xmm0
; SSE42-NEXT:    pmovsxbq %xmm0, %xmm0
; SSE42-NEXT:    psubq %xmm0, %xmm2
; SSE42-NEXT:    pmovsxbq %xmm1, %xmm0
; SSE42-NEXT:    psubq %xmm0, %xmm9
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; SSE42-NEXT:    pmovsxbq %xmm0, %xmm0
; SSE42-NEXT:    psubq %xmm0, %xmm3
; SSE42-NEXT:    movdqa %xmm1, %xmm0
; SSE42-NEXT:    psrlq $48, %xmm0
; SSE42-NEXT:    pmovsxbq %xmm0, %xmm0
; SSE42-NEXT:    psubq %xmm0, %xmm5
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,2,3]
; SSE42-NEXT:    pmovsxbq %xmm0, %xmm0
; SSE42-NEXT:    psubq %xmm0, %xmm4
; SSE42-NEXT:    movdqa %xmm1, %xmm0
; SSE42-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE42-NEXT:    pmovsxbq %xmm0, %xmm0
; SSE42-NEXT:    psubq %xmm0, %xmm6
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[3,3,3,3]
; SSE42-NEXT:    pmovsxbq %xmm0, %xmm0
; SSE42-NEXT:    psubq %xmm0, %xmm7
; SSE42-NEXT:    psrldq {{.*#+}} xmm1 = xmm1[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE42-NEXT:    pmovsxbq %xmm1, %xmm0
; SSE42-NEXT:    psubq %xmm0, %xmm8
; SSE42-NEXT:    pxor %xmm1, %xmm1
; SSE42-NEXT:    pxor %xmm10, %xmm10
; SSE42-NEXT:    psubq %xmm2, %xmm10
; SSE42-NEXT:    movdqa %xmm2, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm10, %xmm2
; SSE42-NEXT:    pxor %xmm10, %xmm10
; SSE42-NEXT:    psubq %xmm9, %xmm10
; SSE42-NEXT:    movdqa %xmm9, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm10, %xmm9
; SSE42-NEXT:    pxor %xmm10, %xmm10
; SSE42-NEXT:    psubq %xmm3, %xmm10
; SSE42-NEXT:    movdqa %xmm3, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm10, %xmm3
; SSE42-NEXT:    pxor %xmm10, %xmm10
; SSE42-NEXT:    psubq %xmm5, %xmm10
; SSE42-NEXT:    movdqa %xmm5, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm10, %xmm5
; SSE42-NEXT:    pxor %xmm10, %xmm10
; SSE42-NEXT:    psubq %xmm4, %xmm10
; SSE42-NEXT:    movdqa %xmm4, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm10, %xmm4
; SSE42-NEXT:    pxor %xmm10, %xmm10
; SSE42-NEXT:    psubq %xmm6, %xmm10
; SSE42-NEXT:    movdqa %xmm6, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm10, %xmm6
; SSE42-NEXT:    pxor %xmm10, %xmm10
; SSE42-NEXT:    psubq %xmm7, %xmm10
; SSE42-NEXT:    movdqa %xmm7, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm10, %xmm7
; SSE42-NEXT:    psubq %xmm8, %xmm1
; SSE42-NEXT:    movdqa %xmm8, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm1, %xmm8
; SSE42-NEXT:    movapd {{.*#+}} xmm0 = [255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0]
; SSE42-NEXT:    andpd %xmm0, %xmm8
; SSE42-NEXT:    andpd %xmm0, %xmm7
; SSE42-NEXT:    packusdw %xmm8, %xmm7
; SSE42-NEXT:    andpd %xmm0, %xmm6
; SSE42-NEXT:    andpd %xmm0, %xmm4
; SSE42-NEXT:    packusdw %xmm6, %xmm4
; SSE42-NEXT:    packusdw %xmm7, %xmm4
; SSE42-NEXT:    andpd %xmm0, %xmm5
; SSE42-NEXT:    andpd %xmm0, %xmm3
; SSE42-NEXT:    packusdw %xmm5, %xmm3
; SSE42-NEXT:    andpd %xmm0, %xmm9
; SSE42-NEXT:    andpd %xmm0, %xmm2
; SSE42-NEXT:    packusdw %xmm2, %xmm9
; SSE42-NEXT:    packusdw %xmm3, %xmm9
; SSE42-NEXT:    packuswb %xmm4, %xmm9
; SSE42-NEXT:    movdqa %xmm9, %xmm0
; SSE42-NEXT:    retq
;
; AVX1-LABEL: abd_ext_v16i8_undef:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovsxbw %xmm2, %xmm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm4 = xmm3[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm4, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm3[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm5, %xmm5
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[1,1,1,1]
; AVX1-NEXT:    vpmovsxwq %xmm3, %xmm3
; AVX1-NEXT:    vpmovsxbq %xmm2, %xmm2
; AVX1-NEXT:    vpmovsxbw %xmm0, %xmm6
; AVX1-NEXT:    vpshufd {{.*#+}} xmm7 = xmm6[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm7, %xmm7
; AVX1-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm6, %xmm6
; AVX1-NEXT:    vpmovsxbq %xmm0, %xmm8
; AVX1-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq %xmm0, %xmm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm9 = xmm1[2,3,2,3]
; AVX1-NEXT:    vpmovsxbw %xmm9, %xmm10
; AVX1-NEXT:    vpshufd {{.*#+}} xmm11 = xmm10[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm11, %xmm11
; AVX1-NEXT:    vpsubq %xmm11, %xmm4, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm11 = xmm10[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm11, %xmm11
; AVX1-NEXT:    vpsubq %xmm11, %xmm5, %xmm5
; AVX1-NEXT:    vpshufd {{.*#+}} xmm10 = xmm10[1,1,1,1]
; AVX1-NEXT:    vpmovsxwq %xmm10, %xmm10
; AVX1-NEXT:    vpsubq %xmm10, %xmm3, %xmm3
; AVX1-NEXT:    vpmovsxbq %xmm9, %xmm9
; AVX1-NEXT:    vpsubq %xmm9, %xmm2, %xmm2
; AVX1-NEXT:    vpmovsxbw %xmm1, %xmm9
; AVX1-NEXT:    vpshufd {{.*#+}} xmm10 = xmm9[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm10, %xmm10
; AVX1-NEXT:    vpsubq %xmm10, %xmm7, %xmm7
; AVX1-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm9, %xmm9
; AVX1-NEXT:    vpsubq %xmm9, %xmm6, %xmm6
; AVX1-NEXT:    vpmovsxbq %xmm1, %xmm9
; AVX1-NEXT:    vpsubq %xmm9, %xmm8, %xmm8
; AVX1-NEXT:    vpsrld $16, %xmm1, %xmm1
; AVX1-NEXT:    vpmovsxbq %xmm1, %xmm1
; AVX1-NEXT:    vpsubq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm8, %ymm1
; AVX1-NEXT:    vinsertf128 $1, %xmm6, %ymm7, %ymm9
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm10
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm4, %ymm11
; AVX1-NEXT:    vpxor %xmm12, %xmm12, %xmm12
; AVX1-NEXT:    vpsubq %xmm5, %xmm12, %xmm5
; AVX1-NEXT:    vpsubq %xmm4, %xmm12, %xmm4
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm4, %ymm4
; AVX1-NEXT:    vblendvpd %ymm11, %ymm4, %ymm11, %ymm4
; AVX1-NEXT:    vpsubq %xmm2, %xmm12, %xmm2
; AVX1-NEXT:    vpsubq %xmm3, %xmm12, %xmm3
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX1-NEXT:    vblendvpd %ymm10, %ymm2, %ymm10, %ymm2
; AVX1-NEXT:    vpsubq %xmm6, %xmm12, %xmm3
; AVX1-NEXT:    vpsubq %xmm7, %xmm12, %xmm5
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm5, %ymm3
; AVX1-NEXT:    vblendvpd %ymm9, %ymm3, %ymm9, %ymm3
; AVX1-NEXT:    vpsubq %xmm0, %xmm12, %xmm0
; AVX1-NEXT:    vpsubq %xmm8, %xmm12, %xmm5
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm5, %ymm0
; AVX1-NEXT:    vblendvpd %ymm1, %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    vmovapd {{.*#+}} ymm1 = [255,255,255,255]
; AVX1-NEXT:    vandpd %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vandpd %ymm1, %ymm3, %ymm3
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vandpd %ymm1, %ymm2, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vandpd %ymm1, %ymm4, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackusdw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: abd_ext_v16i8_undef:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovsxbw %xmm0, %ymm2
; AVX2-NEXT:    vpshufd {{.*#+}} xmm3 = xmm2[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm3, %ymm3
; AVX2-NEXT:    vpmovsxbq %xmm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX2-NEXT:    vpshufd {{.*#+}} xmm4 = xmm2[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm4, %ymm4
; AVX2-NEXT:    vpmovsxwq %xmm2, %ymm2
; AVX2-NEXT:    vpmovsxbw %xmm1, %ymm5
; AVX2-NEXT:    vpshufd {{.*#+}} xmm6 = xmm5[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm6, %ymm6
; AVX2-NEXT:    vpsubq %ymm6, %ymm3, %ymm3
; AVX2-NEXT:    vpmovsxbq %xmm1, %ymm1
; AVX2-NEXT:    vpsubq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm5, %xmm1
; AVX2-NEXT:    vpshufd {{.*#+}} xmm5 = xmm1[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm5, %ymm5
; AVX2-NEXT:    vpsubq %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpmovsxwq %xmm1, %ymm1
; AVX2-NEXT:    vpsubq %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpsubq %ymm3, %ymm2, %ymm5
; AVX2-NEXT:    vblendvpd %ymm3, %ymm5, %ymm3, %ymm3
; AVX2-NEXT:    vpsubq %ymm0, %ymm2, %ymm5
; AVX2-NEXT:    vblendvpd %ymm0, %ymm5, %ymm0, %ymm0
; AVX2-NEXT:    vpsubq %ymm4, %ymm2, %ymm5
; AVX2-NEXT:    vblendvpd %ymm4, %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpsubq %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vblendvpd %ymm1, %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm2 = [255,255,255,255]
; AVX2-NEXT:    vandpd %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vandpd %ymm2, %ymm4, %ymm4
; AVX2-NEXT:    vpackusdw %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,1,3]
; AVX2-NEXT:    vandpd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vandpd %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpackusdw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vpackusdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: abd_ext_v16i8_undef:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbw %xmm0, %ymm0
; AVX512-NEXT:    vpmovsxwq %xmm0, %zmm2
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512-NEXT:    vpmovsxbw %xmm1, %ymm1
; AVX512-NEXT:    vpmovsxwq %xmm1, %zmm3
; AVX512-NEXT:    vpsubq %zmm3, %zmm2, %zmm2
; AVX512-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512-NEXT:    vpmovsxwq %xmm1, %zmm1
; AVX512-NEXT:    vpsubq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpabsq %zmm2, %zmm1
; AVX512-NEXT:    vpabsq %zmm0, %zmm0
; AVX512-NEXT:    vpmovqb %zmm0, %xmm0
; AVX512-NEXT:    vpmovqb %zmm1, %xmm1
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %aext = sext <16 x i8> %a to <16 x i64>
  %bext = sext <16 x i8> %b to <16 x i64>
  %sub = sub <16 x i64> %aext, %bext
  %abs = call <16 x i64> @llvm.abs.v16i64(<16 x i64> %sub, i1 true)
  %trunc = trunc <16 x i64> %abs to <16 x i8>
  ret <16 x i8> %trunc
}

define <8 x i16> @abd_ext_v8i16(<8 x i16> %a, <8 x i16> %b) nounwind {
; SSE2-LABEL: abd_ext_v8i16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; SSE2-NEXT:    psrad $16, %xmm2
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm4
; SSE2-NEXT:    movdqa %xmm2, %xmm3
; SSE2-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm2 = xmm2[2],xmm4[2],xmm2[3],xmm4[3]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    psrad $16, %xmm0
; SSE2-NEXT:    pxor %xmm6, %xmm6
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm6
; SSE2-NEXT:    movdqa %xmm0, %xmm4
; SSE2-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm6[0],xmm4[1],xmm6[1]
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm6[2],xmm0[3],xmm6[3]
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm6 = xmm6[4],xmm1[4],xmm6[5],xmm1[5],xmm6[6],xmm1[6],xmm6[7],xmm1[7]
; SSE2-NEXT:    psrad $16, %xmm6
; SSE2-NEXT:    pxor %xmm7, %xmm7
; SSE2-NEXT:    pcmpgtd %xmm6, %xmm7
; SSE2-NEXT:    movdqa %xmm6, %xmm8
; SSE2-NEXT:    punpckldq {{.*#+}} xmm8 = xmm8[0],xmm7[0],xmm8[1],xmm7[1]
; SSE2-NEXT:    psubq %xmm8, %xmm3
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm6 = xmm6[2],xmm7[2],xmm6[3],xmm7[3]
; SSE2-NEXT:    psubq %xmm6, %xmm2
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    psrad $16, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm5
; SSE2-NEXT:    movdqa %xmm1, %xmm6
; SSE2-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm5[0],xmm6[1],xmm5[1]
; SSE2-NEXT:    psubq %xmm6, %xmm4
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm5[2],xmm1[3],xmm5[3]
; SSE2-NEXT:    psubq %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm3, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm3
; SSE2-NEXT:    psubq %xmm1, %xmm3
; SSE2-NEXT:    movdqa %xmm2, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm2
; SSE2-NEXT:    psubq %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm4, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm4
; SSE2-NEXT:    psubq %xmm1, %xmm4
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm0
; SSE2-NEXT:    psubq %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm4[0,2,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,2,3,4,5,6,7]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,2,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm2 = xmm0[0,1,0,2,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,2,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,0,2,4,5,6,7]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE2-NEXT:    movsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: abd_ext_v8i16:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[1,1,1,1]
; SSE42-NEXT:    pmovsxwq %xmm2, %xmm2
; SSE42-NEXT:    pmovsxwq %xmm0, %xmm5
; SSE42-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[2,3,2,3]
; SSE42-NEXT:    pmovsxwq %xmm3, %xmm3
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE42-NEXT:    pmovsxwq %xmm0, %xmm4
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; SSE42-NEXT:    pmovsxwq %xmm0, %xmm0
; SSE42-NEXT:    psubq %xmm0, %xmm2
; SSE42-NEXT:    pmovsxwq %xmm1, %xmm0
; SSE42-NEXT:    psubq %xmm0, %xmm5
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,2,3]
; SSE42-NEXT:    pmovsxwq %xmm0, %xmm0
; SSE42-NEXT:    psubq %xmm0, %xmm3
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[3,3,3,3]
; SSE42-NEXT:    pmovsxwq %xmm0, %xmm0
; SSE42-NEXT:    psubq %xmm0, %xmm4
; SSE42-NEXT:    pxor %xmm1, %xmm1
; SSE42-NEXT:    pxor %xmm6, %xmm6
; SSE42-NEXT:    psubq %xmm2, %xmm6
; SSE42-NEXT:    movdqa %xmm2, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm6, %xmm2
; SSE42-NEXT:    pxor %xmm6, %xmm6
; SSE42-NEXT:    psubq %xmm5, %xmm6
; SSE42-NEXT:    movdqa %xmm5, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm6, %xmm5
; SSE42-NEXT:    pxor %xmm6, %xmm6
; SSE42-NEXT:    psubq %xmm3, %xmm6
; SSE42-NEXT:    movdqa %xmm3, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm6, %xmm3
; SSE42-NEXT:    pxor %xmm6, %xmm6
; SSE42-NEXT:    psubq %xmm4, %xmm6
; SSE42-NEXT:    movdqa %xmm4, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm6, %xmm4
; SSE42-NEXT:    pblendw {{.*#+}} xmm4 = xmm4[0],xmm1[1,2,3],xmm4[4],xmm1[5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm3 = xmm3[0],xmm1[1,2,3],xmm3[4],xmm1[5,6,7]
; SSE42-NEXT:    packusdw %xmm4, %xmm3
; SSE42-NEXT:    pblendw {{.*#+}} xmm5 = xmm5[0],xmm1[1,2,3],xmm5[4],xmm1[5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm2 = xmm2[0],xmm1[1,2,3],xmm2[4],xmm1[5,6,7]
; SSE42-NEXT:    packusdw %xmm2, %xmm5
; SSE42-NEXT:    packusdw %xmm3, %xmm5
; SSE42-NEXT:    movdqa %xmm5, %xmm0
; SSE42-NEXT:    retq
;
; AVX1-LABEL: abd_ext_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm2, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm3, %xmm3
; AVX1-NEXT:    vpmovsxwq %xmm0, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX1-NEXT:    vpmovsxwq %xmm0, %xmm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm1[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm5, %xmm5
; AVX1-NEXT:    vpsubq %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm1[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm5, %xmm5
; AVX1-NEXT:    vpsubq %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vpmovsxwq %xmm1, %xmm5
; AVX1-NEXT:    vpsubq %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; AVX1-NEXT:    vpmovsxwq %xmm1, %xmm1
; AVX1-NEXT:    vpsubq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm4, %ymm1
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm5
; AVX1-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX1-NEXT:    vpsubq %xmm3, %xmm6, %xmm3
; AVX1-NEXT:    vpsubq %xmm2, %xmm6, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX1-NEXT:    vblendvpd %ymm5, %ymm2, %ymm5, %ymm2
; AVX1-NEXT:    vpsubq %xmm0, %xmm6, %xmm0
; AVX1-NEXT:    vpsubq %xmm4, %xmm6, %xmm3
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm0
; AVX1-NEXT:    vblendvpd %ymm1, %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    vmovapd {{.*#+}} ymm1 = [65535,65535,65535,65535]
; AVX1-NEXT:    vandpd %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vandpd %ymm1, %ymm2, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: abd_ext_v8i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm2, %ymm2
; AVX2-NEXT:    vpmovsxwq %xmm0, %ymm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm3 = xmm1[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm3, %ymm3
; AVX2-NEXT:    vpsubq %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpmovsxwq %xmm1, %ymm1
; AVX2-NEXT:    vpsubq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsubq %ymm2, %ymm1, %ymm3
; AVX2-NEXT:    vblendvpd %ymm2, %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpsubq %ymm0, %ymm1, %ymm3
; AVX2-NEXT:    vblendvpd %ymm0, %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7],ymm0[8],ymm1[9,10,11],ymm0[12],ymm1[13,14,15]
; AVX2-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0],ymm1[1,2,3],ymm2[4],ymm1[5,6,7],ymm2[8],ymm1[9,10,11],ymm2[12],ymm1[13,14,15]
; AVX2-NEXT:    vpackusdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: abd_ext_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512-NEXT:    vpmovsxwq %xmm1, %zmm1
; AVX512-NEXT:    vpsubq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpabsq %zmm0, %zmm0
; AVX512-NEXT:    vpmovqw %zmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %aext = sext <8 x i16> %a to <8 x i64>
  %bext = sext <8 x i16> %b to <8 x i64>
  %sub = sub <8 x i64> %aext, %bext
  %abs = call <8 x i64> @llvm.abs.v8i64(<8 x i64> %sub, i1 false)
  %trunc = trunc <8 x i64> %abs to <8 x i16>
  ret <8 x i16> %trunc
}

define <8 x i16> @abd_ext_v8i16_undef(<8 x i16> %a, <8 x i16> %b) nounwind {
; SSE2-LABEL: abd_ext_v8i16_undef:
; SSE2:       # %bb.0:
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; SSE2-NEXT:    psrad $16, %xmm2
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm4
; SSE2-NEXT:    movdqa %xmm2, %xmm3
; SSE2-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm2 = xmm2[2],xmm4[2],xmm2[3],xmm4[3]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    psrad $16, %xmm0
; SSE2-NEXT:    pxor %xmm6, %xmm6
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm6
; SSE2-NEXT:    movdqa %xmm0, %xmm4
; SSE2-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm6[0],xmm4[1],xmm6[1]
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm6[2],xmm0[3],xmm6[3]
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm6 = xmm6[4],xmm1[4],xmm6[5],xmm1[5],xmm6[6],xmm1[6],xmm6[7],xmm1[7]
; SSE2-NEXT:    psrad $16, %xmm6
; SSE2-NEXT:    pxor %xmm7, %xmm7
; SSE2-NEXT:    pcmpgtd %xmm6, %xmm7
; SSE2-NEXT:    movdqa %xmm6, %xmm8
; SSE2-NEXT:    punpckldq {{.*#+}} xmm8 = xmm8[0],xmm7[0],xmm8[1],xmm7[1]
; SSE2-NEXT:    psubq %xmm8, %xmm3
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm6 = xmm6[2],xmm7[2],xmm6[3],xmm7[3]
; SSE2-NEXT:    psubq %xmm6, %xmm2
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    psrad $16, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm5
; SSE2-NEXT:    movdqa %xmm1, %xmm6
; SSE2-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm5[0],xmm6[1],xmm5[1]
; SSE2-NEXT:    psubq %xmm6, %xmm4
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm5[2],xmm1[3],xmm5[3]
; SSE2-NEXT:    psubq %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm3, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm3
; SSE2-NEXT:    psubq %xmm1, %xmm3
; SSE2-NEXT:    movdqa %xmm2, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm2
; SSE2-NEXT:    psubq %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm4, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm4
; SSE2-NEXT:    psubq %xmm1, %xmm4
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm0
; SSE2-NEXT:    psubq %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm4[0,2,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,2,3,4,5,6,7]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,2,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm2 = xmm0[0,1,0,2,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,2,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,0,2,4,5,6,7]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE2-NEXT:    movsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: abd_ext_v8i16_undef:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[1,1,1,1]
; SSE42-NEXT:    pmovsxwq %xmm2, %xmm2
; SSE42-NEXT:    pmovsxwq %xmm0, %xmm5
; SSE42-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[2,3,2,3]
; SSE42-NEXT:    pmovsxwq %xmm3, %xmm3
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE42-NEXT:    pmovsxwq %xmm0, %xmm4
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; SSE42-NEXT:    pmovsxwq %xmm0, %xmm0
; SSE42-NEXT:    psubq %xmm0, %xmm2
; SSE42-NEXT:    pmovsxwq %xmm1, %xmm0
; SSE42-NEXT:    psubq %xmm0, %xmm5
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,2,3]
; SSE42-NEXT:    pmovsxwq %xmm0, %xmm0
; SSE42-NEXT:    psubq %xmm0, %xmm3
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[3,3,3,3]
; SSE42-NEXT:    pmovsxwq %xmm0, %xmm0
; SSE42-NEXT:    psubq %xmm0, %xmm4
; SSE42-NEXT:    pxor %xmm1, %xmm1
; SSE42-NEXT:    pxor %xmm6, %xmm6
; SSE42-NEXT:    psubq %xmm2, %xmm6
; SSE42-NEXT:    movdqa %xmm2, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm6, %xmm2
; SSE42-NEXT:    pxor %xmm6, %xmm6
; SSE42-NEXT:    psubq %xmm5, %xmm6
; SSE42-NEXT:    movdqa %xmm5, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm6, %xmm5
; SSE42-NEXT:    pxor %xmm6, %xmm6
; SSE42-NEXT:    psubq %xmm3, %xmm6
; SSE42-NEXT:    movdqa %xmm3, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm6, %xmm3
; SSE42-NEXT:    pxor %xmm6, %xmm6
; SSE42-NEXT:    psubq %xmm4, %xmm6
; SSE42-NEXT:    movdqa %xmm4, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm6, %xmm4
; SSE42-NEXT:    pblendw {{.*#+}} xmm4 = xmm4[0],xmm1[1,2,3],xmm4[4],xmm1[5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm3 = xmm3[0],xmm1[1,2,3],xmm3[4],xmm1[5,6,7]
; SSE42-NEXT:    packusdw %xmm4, %xmm3
; SSE42-NEXT:    pblendw {{.*#+}} xmm5 = xmm5[0],xmm1[1,2,3],xmm5[4],xmm1[5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm2 = xmm2[0],xmm1[1,2,3],xmm2[4],xmm1[5,6,7]
; SSE42-NEXT:    packusdw %xmm2, %xmm5
; SSE42-NEXT:    packusdw %xmm3, %xmm5
; SSE42-NEXT:    movdqa %xmm5, %xmm0
; SSE42-NEXT:    retq
;
; AVX1-LABEL: abd_ext_v8i16_undef:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm2, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm3, %xmm3
; AVX1-NEXT:    vpmovsxwq %xmm0, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX1-NEXT:    vpmovsxwq %xmm0, %xmm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm1[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm5, %xmm5
; AVX1-NEXT:    vpsubq %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm1[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm5, %xmm5
; AVX1-NEXT:    vpsubq %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vpmovsxwq %xmm1, %xmm5
; AVX1-NEXT:    vpsubq %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; AVX1-NEXT:    vpmovsxwq %xmm1, %xmm1
; AVX1-NEXT:    vpsubq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm4, %ymm1
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm5
; AVX1-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX1-NEXT:    vpsubq %xmm3, %xmm6, %xmm3
; AVX1-NEXT:    vpsubq %xmm2, %xmm6, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX1-NEXT:    vblendvpd %ymm5, %ymm2, %ymm5, %ymm2
; AVX1-NEXT:    vpsubq %xmm0, %xmm6, %xmm0
; AVX1-NEXT:    vpsubq %xmm4, %xmm6, %xmm3
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm0
; AVX1-NEXT:    vblendvpd %ymm1, %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    vmovapd {{.*#+}} ymm1 = [65535,65535,65535,65535]
; AVX1-NEXT:    vandpd %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vandpd %ymm1, %ymm2, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: abd_ext_v8i16_undef:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm2, %ymm2
; AVX2-NEXT:    vpmovsxwq %xmm0, %ymm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm3 = xmm1[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm3, %ymm3
; AVX2-NEXT:    vpsubq %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpmovsxwq %xmm1, %ymm1
; AVX2-NEXT:    vpsubq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsubq %ymm2, %ymm1, %ymm3
; AVX2-NEXT:    vblendvpd %ymm2, %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpsubq %ymm0, %ymm1, %ymm3
; AVX2-NEXT:    vblendvpd %ymm0, %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7],ymm0[8],ymm1[9,10,11],ymm0[12],ymm1[13,14,15]
; AVX2-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0],ymm1[1,2,3],ymm2[4],ymm1[5,6,7],ymm2[8],ymm1[9,10,11],ymm2[12],ymm1[13,14,15]
; AVX2-NEXT:    vpackusdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: abd_ext_v8i16_undef:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512-NEXT:    vpmovsxwq %xmm1, %zmm1
; AVX512-NEXT:    vpsubq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpabsq %zmm0, %zmm0
; AVX512-NEXT:    vpmovqw %zmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %aext = sext <8 x i16> %a to <8 x i64>
  %bext = sext <8 x i16> %b to <8 x i64>
  %sub = sub <8 x i64> %aext, %bext
  %abs = call <8 x i64> @llvm.abs.v8i64(<8 x i64> %sub, i1 true)
  %trunc = trunc <8 x i64> %abs to <8 x i16>
  ret <8 x i16> %trunc
}

define <4 x i32> @abd_ext_v4i32(<4 x i32> %a, <4 x i32> %b) nounwind {
; SSE2-LABEL: abd_ext_v4i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,3,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1]
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm4
; SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm4[0],xmm2[1],xmm4[1]
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm1[2,3,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm4[0],xmm1[1],xmm4[1]
; SSE2-NEXT:    psubq %xmm1, %xmm0
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm3
; SSE2-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; SSE2-NEXT:    psubq %xmm5, %xmm2
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm0
; SSE2-NEXT:    psubq %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm2, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm2
; SSE2-NEXT:    psubq %xmm1, %xmm2
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm2[0,2]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: abd_ext_v4i32:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pmovsxdq %xmm0, %xmm2
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE42-NEXT:    pmovsxdq %xmm0, %xmm3
; SSE42-NEXT:    pmovsxdq %xmm1, %xmm0
; SSE42-NEXT:    psubq %xmm0, %xmm2
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,2,3]
; SSE42-NEXT:    pmovsxdq %xmm0, %xmm0
; SSE42-NEXT:    psubq %xmm0, %xmm3
; SSE42-NEXT:    pxor %xmm1, %xmm1
; SSE42-NEXT:    pxor %xmm4, %xmm4
; SSE42-NEXT:    psubq %xmm2, %xmm4
; SSE42-NEXT:    movdqa %xmm2, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm4, %xmm2
; SSE42-NEXT:    psubq %xmm3, %xmm1
; SSE42-NEXT:    movdqa %xmm3, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm1, %xmm3
; SSE42-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,2],xmm3[0,2]
; SSE42-NEXT:    movaps %xmm2, %xmm0
; SSE42-NEXT:    retq
;
; AVX1-LABEL: abd_ext_v4i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm3
; AVX1-NEXT:    vpsubq %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm1
; AVX1-NEXT:    vpsubq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpsubq %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpsubq %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX1-NEXT:    vblendvpd %ymm1, %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: abd_ext_v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovsxdq %xmm0, %ymm0
; AVX2-NEXT:    vpmovsxdq %xmm1, %ymm1
; AVX2-NEXT:    vpsubq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsubq %ymm0, %ymm1, %ymm1
; AVX2-NEXT:    vblendvpd %ymm0, %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: abd_ext_v4i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxdq %xmm0, %ymm0
; AVX512-NEXT:    vpmovsxdq %xmm1, %ymm1
; AVX512-NEXT:    vpsubq %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpabsq %ymm0, %ymm0
; AVX512-NEXT:    vpmovqd %ymm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %aext = sext <4 x i32> %a to <4 x i64>
  %bext = sext <4 x i32> %b to <4 x i64>
  %sub = sub <4 x i64> %aext, %bext
  %abs = call <4 x i64> @llvm.abs.v4i64(<4 x i64> %sub, i1 false)
  %trunc = trunc <4 x i64> %abs to <4 x i32>
  ret <4 x i32> %trunc
}

define <4 x i32> @abd_ext_v4i32_undef(<4 x i32> %a, <4 x i32> %b) nounwind {
; SSE2-LABEL: abd_ext_v4i32_undef:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,3,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1]
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm4
; SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm4[0],xmm2[1],xmm4[1]
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm1[2,3,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm4[0],xmm1[1],xmm4[1]
; SSE2-NEXT:    psubq %xmm1, %xmm0
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm3
; SSE2-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; SSE2-NEXT:    psubq %xmm5, %xmm2
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm0
; SSE2-NEXT:    psubq %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm2, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm2
; SSE2-NEXT:    psubq %xmm1, %xmm2
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm2[0,2]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: abd_ext_v4i32_undef:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pmovsxdq %xmm0, %xmm2
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE42-NEXT:    pmovsxdq %xmm0, %xmm3
; SSE42-NEXT:    pmovsxdq %xmm1, %xmm0
; SSE42-NEXT:    psubq %xmm0, %xmm2
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,2,3]
; SSE42-NEXT:    pmovsxdq %xmm0, %xmm0
; SSE42-NEXT:    psubq %xmm0, %xmm3
; SSE42-NEXT:    pxor %xmm1, %xmm1
; SSE42-NEXT:    pxor %xmm4, %xmm4
; SSE42-NEXT:    psubq %xmm2, %xmm4
; SSE42-NEXT:    movdqa %xmm2, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm4, %xmm2
; SSE42-NEXT:    psubq %xmm3, %xmm1
; SSE42-NEXT:    movdqa %xmm3, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm1, %xmm3
; SSE42-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,2],xmm3[0,2]
; SSE42-NEXT:    movaps %xmm2, %xmm0
; SSE42-NEXT:    retq
;
; AVX1-LABEL: abd_ext_v4i32_undef:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm3
; AVX1-NEXT:    vpsubq %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm1
; AVX1-NEXT:    vpsubq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpsubq %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpsubq %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX1-NEXT:    vblendvpd %ymm1, %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: abd_ext_v4i32_undef:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovsxdq %xmm0, %ymm0
; AVX2-NEXT:    vpmovsxdq %xmm1, %ymm1
; AVX2-NEXT:    vpsubq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsubq %ymm0, %ymm1, %ymm1
; AVX2-NEXT:    vblendvpd %ymm0, %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: abd_ext_v4i32_undef:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxdq %xmm0, %ymm0
; AVX512-NEXT:    vpmovsxdq %xmm1, %ymm1
; AVX512-NEXT:    vpsubq %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpabsq %ymm0, %ymm0
; AVX512-NEXT:    vpmovqd %ymm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %aext = sext <4 x i32> %a to <4 x i64>
  %bext = sext <4 x i32> %b to <4 x i64>
  %sub = sub <4 x i64> %aext, %bext
  %abs = call <4 x i64> @llvm.abs.v4i64(<4 x i64> %sub, i1 true)
  %trunc = trunc <4 x i64> %abs to <4 x i32>
  ret <4 x i32> %trunc
}

define <2 x i64> @abd_ext_v2i64(<2 x i64> %a, <2 x i64> %b) nounwind {
; SSE2-LABEL: abd_ext_v2i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,3,2,3]
; SSE2-NEXT:    movq %xmm2, %rax
; SSE2-NEXT:    movq %rax, %rcx
; SSE2-NEXT:    sarq $63, %rcx
; SSE2-NEXT:    movq %xmm0, %rdx
; SSE2-NEXT:    movq %rdx, %rsi
; SSE2-NEXT:    sarq $63, %rsi
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,2,3]
; SSE2-NEXT:    movq %xmm0, %rdi
; SSE2-NEXT:    movq %rdi, %r8
; SSE2-NEXT:    sarq $63, %r8
; SSE2-NEXT:    movq %xmm1, %r9
; SSE2-NEXT:    movq %r9, %r10
; SSE2-NEXT:    sarq $63, %r10
; SSE2-NEXT:    subq %r9, %rdx
; SSE2-NEXT:    sbbq %r10, %rsi
; SSE2-NEXT:    subq %rdi, %rax
; SSE2-NEXT:    sbbq %r8, %rcx
; SSE2-NEXT:    sarq $63, %rcx
; SSE2-NEXT:    xorq %rcx, %rax
; SSE2-NEXT:    subq %rcx, %rax
; SSE2-NEXT:    sarq $63, %rsi
; SSE2-NEXT:    xorq %rsi, %rdx
; SSE2-NEXT:    subq %rsi, %rdx
; SSE2-NEXT:    movq %rdx, %xmm0
; SSE2-NEXT:    movq %rax, %xmm1
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: abd_ext_v2i64:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movq %xmm0, %rax
; SSE42-NEXT:    movq %rax, %rcx
; SSE42-NEXT:    sarq $63, %rcx
; SSE42-NEXT:    pextrq $1, %xmm0, %rdx
; SSE42-NEXT:    movq %rdx, %rsi
; SSE42-NEXT:    sarq $63, %rsi
; SSE42-NEXT:    movq %xmm1, %rdi
; SSE42-NEXT:    movq %rdi, %r8
; SSE42-NEXT:    sarq $63, %r8
; SSE42-NEXT:    pextrq $1, %xmm1, %r9
; SSE42-NEXT:    movq %r9, %r10
; SSE42-NEXT:    sarq $63, %r10
; SSE42-NEXT:    subq %r9, %rdx
; SSE42-NEXT:    sbbq %r10, %rsi
; SSE42-NEXT:    subq %rdi, %rax
; SSE42-NEXT:    sbbq %r8, %rcx
; SSE42-NEXT:    sarq $63, %rcx
; SSE42-NEXT:    xorq %rcx, %rax
; SSE42-NEXT:    subq %rcx, %rax
; SSE42-NEXT:    sarq $63, %rsi
; SSE42-NEXT:    xorq %rsi, %rdx
; SSE42-NEXT:    subq %rsi, %rdx
; SSE42-NEXT:    movq %rdx, %xmm1
; SSE42-NEXT:    movq %rax, %xmm0
; SSE42-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE42-NEXT:    retq
;
; AVX-LABEL: abd_ext_v2i64:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovq %xmm0, %rax
; AVX-NEXT:    movq %rax, %rcx
; AVX-NEXT:    sarq $63, %rcx
; AVX-NEXT:    vpextrq $1, %xmm0, %rdx
; AVX-NEXT:    movq %rdx, %rsi
; AVX-NEXT:    sarq $63, %rsi
; AVX-NEXT:    vmovq %xmm1, %rdi
; AVX-NEXT:    movq %rdi, %r8
; AVX-NEXT:    sarq $63, %r8
; AVX-NEXT:    vpextrq $1, %xmm1, %r9
; AVX-NEXT:    movq %r9, %r10
; AVX-NEXT:    sarq $63, %r10
; AVX-NEXT:    subq %r9, %rdx
; AVX-NEXT:    sbbq %r10, %rsi
; AVX-NEXT:    subq %rdi, %rax
; AVX-NEXT:    sbbq %r8, %rcx
; AVX-NEXT:    sarq $63, %rcx
; AVX-NEXT:    xorq %rcx, %rax
; AVX-NEXT:    subq %rcx, %rax
; AVX-NEXT:    sarq $63, %rsi
; AVX-NEXT:    xorq %rsi, %rdx
; AVX-NEXT:    subq %rsi, %rdx
; AVX-NEXT:    vmovq %rdx, %xmm0
; AVX-NEXT:    vmovq %rax, %xmm1
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX-NEXT:    retq
  %aext = sext <2 x i64> %a to <2 x i128>
  %bext = sext <2 x i64> %b to <2 x i128>
  %sub = sub <2 x i128> %aext, %bext
  %abs = call <2 x i128> @llvm.abs.v2i128(<2 x i128> %sub, i1 false)
  %trunc = trunc <2 x i128> %abs to <2 x i64>
  ret <2 x i64> %trunc
}

define <2 x i64> @abd_ext_v2i64_undef(<2 x i64> %a, <2 x i64> %b) nounwind {
; SSE2-LABEL: abd_ext_v2i64_undef:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,3,2,3]
; SSE2-NEXT:    movq %xmm2, %rax
; SSE2-NEXT:    movq %rax, %rcx
; SSE2-NEXT:    sarq $63, %rcx
; SSE2-NEXT:    movq %xmm0, %rdx
; SSE2-NEXT:    movq %rdx, %rsi
; SSE2-NEXT:    sarq $63, %rsi
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,2,3]
; SSE2-NEXT:    movq %xmm0, %rdi
; SSE2-NEXT:    movq %rdi, %r8
; SSE2-NEXT:    sarq $63, %r8
; SSE2-NEXT:    movq %xmm1, %r9
; SSE2-NEXT:    movq %r9, %r10
; SSE2-NEXT:    sarq $63, %r10
; SSE2-NEXT:    subq %r9, %rdx
; SSE2-NEXT:    sbbq %r10, %rsi
; SSE2-NEXT:    subq %rdi, %rax
; SSE2-NEXT:    sbbq %r8, %rcx
; SSE2-NEXT:    sarq $63, %rcx
; SSE2-NEXT:    xorq %rcx, %rax
; SSE2-NEXT:    subq %rcx, %rax
; SSE2-NEXT:    sarq $63, %rsi
; SSE2-NEXT:    xorq %rsi, %rdx
; SSE2-NEXT:    subq %rsi, %rdx
; SSE2-NEXT:    movq %rdx, %xmm0
; SSE2-NEXT:    movq %rax, %xmm1
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: abd_ext_v2i64_undef:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movq %xmm0, %rax
; SSE42-NEXT:    movq %rax, %rcx
; SSE42-NEXT:    sarq $63, %rcx
; SSE42-NEXT:    pextrq $1, %xmm0, %rdx
; SSE42-NEXT:    movq %rdx, %rsi
; SSE42-NEXT:    sarq $63, %rsi
; SSE42-NEXT:    movq %xmm1, %rdi
; SSE42-NEXT:    movq %rdi, %r8
; SSE42-NEXT:    sarq $63, %r8
; SSE42-NEXT:    pextrq $1, %xmm1, %r9
; SSE42-NEXT:    movq %r9, %r10
; SSE42-NEXT:    sarq $63, %r10
; SSE42-NEXT:    subq %r9, %rdx
; SSE42-NEXT:    sbbq %r10, %rsi
; SSE42-NEXT:    subq %rdi, %rax
; SSE42-NEXT:    sbbq %r8, %rcx
; SSE42-NEXT:    sarq $63, %rcx
; SSE42-NEXT:    xorq %rcx, %rax
; SSE42-NEXT:    subq %rcx, %rax
; SSE42-NEXT:    sarq $63, %rsi
; SSE42-NEXT:    xorq %rsi, %rdx
; SSE42-NEXT:    subq %rsi, %rdx
; SSE42-NEXT:    movq %rdx, %xmm1
; SSE42-NEXT:    movq %rax, %xmm0
; SSE42-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE42-NEXT:    retq
;
; AVX-LABEL: abd_ext_v2i64_undef:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovq %xmm0, %rax
; AVX-NEXT:    movq %rax, %rcx
; AVX-NEXT:    sarq $63, %rcx
; AVX-NEXT:    vpextrq $1, %xmm0, %rdx
; AVX-NEXT:    movq %rdx, %rsi
; AVX-NEXT:    sarq $63, %rsi
; AVX-NEXT:    vmovq %xmm1, %rdi
; AVX-NEXT:    movq %rdi, %r8
; AVX-NEXT:    sarq $63, %r8
; AVX-NEXT:    vpextrq $1, %xmm1, %r9
; AVX-NEXT:    movq %r9, %r10
; AVX-NEXT:    sarq $63, %r10
; AVX-NEXT:    subq %r9, %rdx
; AVX-NEXT:    sbbq %r10, %rsi
; AVX-NEXT:    subq %rdi, %rax
; AVX-NEXT:    sbbq %r8, %rcx
; AVX-NEXT:    sarq $63, %rcx
; AVX-NEXT:    xorq %rcx, %rax
; AVX-NEXT:    subq %rcx, %rax
; AVX-NEXT:    sarq $63, %rsi
; AVX-NEXT:    xorq %rsi, %rdx
; AVX-NEXT:    subq %rsi, %rdx
; AVX-NEXT:    vmovq %rdx, %xmm0
; AVX-NEXT:    vmovq %rax, %xmm1
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX-NEXT:    retq
  %aext = sext <2 x i64> %a to <2 x i128>
  %bext = sext <2 x i64> %b to <2 x i128>
  %sub = sub <2 x i128> %aext, %bext
  %abs = call <2 x i128> @llvm.abs.v2i128(<2 x i128> %sub, i1 true)
  %trunc = trunc <2 x i128> %abs to <2 x i64>
  ret <2 x i64> %trunc
}

;
; sub(smax(a,b),smin(a,b)) -> abds(a,b)
;

define <16 x i8> @abd_minmax_v16i8(<16 x i8> %a, <16 x i8> %b) nounwind {
; SSE2-LABEL: abd_minmax_v16i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    pcmpgtb %xmm0, %xmm2
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    pand %xmm2, %xmm3
; SSE2-NEXT:    pandn %xmm1, %xmm2
; SSE2-NEXT:    por %xmm3, %xmm2
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    pcmpgtb %xmm1, %xmm3
; SSE2-NEXT:    pand %xmm3, %xmm0
; SSE2-NEXT:    pandn %xmm1, %xmm3
; SSE2-NEXT:    por %xmm3, %xmm0
; SSE2-NEXT:    psubb %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: abd_minmax_v16i8:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movdqa %xmm0, %xmm2
; SSE42-NEXT:    pminsb %xmm1, %xmm2
; SSE42-NEXT:    pmaxsb %xmm1, %xmm0
; SSE42-NEXT:    psubb %xmm2, %xmm0
; SSE42-NEXT:    retq
;
; AVX-LABEL: abd_minmax_v16i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpminsb %xmm1, %xmm0, %xmm2
; AVX-NEXT:    vpmaxsb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpsubb %xmm2, %xmm0, %xmm0
; AVX-NEXT:    retq
  %min = call <16 x i8> @llvm.smin.v16i8(<16 x i8> %a, <16 x i8> %b)
  %max = call <16 x i8> @llvm.smax.v16i8(<16 x i8> %a, <16 x i8> %b)
  %sub = sub <16 x i8> %max, %min
  ret <16 x i8> %sub
}

define <8 x i16> @abd_minmax_v8i16(<8 x i16> %a, <8 x i16> %b) nounwind {
; SSE-LABEL: abd_minmax_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pminsw %xmm1, %xmm2
; SSE-NEXT:    pmaxsw %xmm1, %xmm0
; SSE-NEXT:    psubw %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: abd_minmax_v8i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpminsw %xmm1, %xmm0, %xmm2
; AVX-NEXT:    vpmaxsw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpsubw %xmm2, %xmm0, %xmm0
; AVX-NEXT:    retq
  %min = call <8 x i16> @llvm.smin.v8i16(<8 x i16> %a, <8 x i16> %b)
  %max = call <8 x i16> @llvm.smax.v8i16(<8 x i16> %a, <8 x i16> %b)
  %sub = sub <8 x i16> %max, %min
  ret <8 x i16> %sub
}

define <4 x i32> @abd_minmax_v4i32(<4 x i32> %a, <4 x i32> %b) nounwind {
; SSE2-LABEL: abd_minmax_v4i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm2
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    pand %xmm2, %xmm3
; SSE2-NEXT:    pandn %xmm1, %xmm2
; SSE2-NEXT:    por %xmm3, %xmm2
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm3
; SSE2-NEXT:    pand %xmm3, %xmm0
; SSE2-NEXT:    pandn %xmm1, %xmm3
; SSE2-NEXT:    por %xmm3, %xmm0
; SSE2-NEXT:    psubd %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: abd_minmax_v4i32:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movdqa %xmm0, %xmm2
; SSE42-NEXT:    pminsd %xmm1, %xmm2
; SSE42-NEXT:    pmaxsd %xmm1, %xmm0
; SSE42-NEXT:    psubd %xmm2, %xmm0
; SSE42-NEXT:    retq
;
; AVX-LABEL: abd_minmax_v4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpminsd %xmm1, %xmm0, %xmm2
; AVX-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpsubd %xmm2, %xmm0, %xmm0
; AVX-NEXT:    retq
  %min = call <4 x i32> @llvm.smin.v4i32(<4 x i32> %a, <4 x i32> %b)
  %max = call <4 x i32> @llvm.smax.v4i32(<4 x i32> %a, <4 x i32> %b)
  %sub = sub <4 x i32> %max, %min
  ret <4 x i32> %sub
}

define <2 x i64> @abd_minmax_v2i64(<2 x i64> %a, <2 x i64> %b) nounwind {
; SSE2-LABEL: abd_minmax_v2i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648]
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    pxor %xmm2, %xmm3
; SSE2-NEXT:    pxor %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,2,2]
; SSE2-NEXT:    movdqa %xmm3, %xmm6
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE2-NEXT:    pand %xmm6, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-NEXT:    por %xmm5, %xmm4
; SSE2-NEXT:    movdqa %xmm0, %xmm5
; SSE2-NEXT:    pand %xmm4, %xmm5
; SSE2-NEXT:    pandn %xmm1, %xmm4
; SSE2-NEXT:    por %xmm5, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,0,2,2]
; SSE2-NEXT:    pand %xmm6, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-NEXT:    por %xmm2, %xmm3
; SSE2-NEXT:    pand %xmm3, %xmm0
; SSE2-NEXT:    pandn %xmm1, %xmm3
; SSE2-NEXT:    por %xmm3, %xmm0
; SSE2-NEXT:    psubq %xmm4, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: abd_minmax_v2i64:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movdqa %xmm0, %xmm2
; SSE42-NEXT:    pcmpgtq %xmm1, %xmm0
; SSE42-NEXT:    movdqa %xmm2, %xmm3
; SSE42-NEXT:    blendvpd %xmm0, %xmm1, %xmm3
; SSE42-NEXT:    blendvpd %xmm0, %xmm2, %xmm1
; SSE42-NEXT:    psubq %xmm3, %xmm1
; SSE42-NEXT:    movdqa %xmm1, %xmm0
; SSE42-NEXT:    retq
;
; AVX1-LABEL: abd_minmax_v2i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm3
; AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsubq %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: abd_minmax_v2i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm2
; AVX2-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm3
; AVX2-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vpsubq %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: abd_minmax_v2i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpminsq %xmm1, %xmm0, %xmm2
; AVX512-NEXT:    vpmaxsq %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpsubq %xmm2, %xmm0, %xmm0
; AVX512-NEXT:    retq
  %min = call <2 x i64> @llvm.smin.v2i64(<2 x i64> %a, <2 x i64> %b)
  %max = call <2 x i64> @llvm.smax.v2i64(<2 x i64> %a, <2 x i64> %b)
  %sub = sub <2 x i64> %max, %min
  ret <2 x i64> %sub
}

;
; abs(sub_nsw(x, y)) -> abds(a,b)
;

define <16 x i8> @abd_subnsw_v16i8(<16 x i8> %a, <16 x i8> %b) nounwind {
; SSE2-LABEL: abd_subnsw_v16i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    psubb %xmm1, %xmm0
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    psubb %xmm0, %xmm1
; SSE2-NEXT:    pminub %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: abd_subnsw_v16i8:
; SSE42:       # %bb.0:
; SSE42-NEXT:    psubb %xmm1, %xmm0
; SSE42-NEXT:    pabsb %xmm0, %xmm0
; SSE42-NEXT:    retq
;
; AVX-LABEL: abd_subnsw_v16i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsubb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpabsb %xmm0, %xmm0
; AVX-NEXT:    retq
  %sub = sub nsw <16 x i8> %a, %b
  %abs = call <16 x i8> @llvm.abs.v16i8(<16 x i8> %sub, i1 false)
  ret <16 x i8> %abs
}

define <8 x i16> @abd_subnsw_v8i16(<8 x i16> %a, <8 x i16> %b) nounwind {
; SSE2-LABEL: abd_subnsw_v8i16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    psubw %xmm1, %xmm0
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    psubw %xmm0, %xmm1
; SSE2-NEXT:    pmaxsw %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: abd_subnsw_v8i16:
; SSE42:       # %bb.0:
; SSE42-NEXT:    psubw %xmm1, %xmm0
; SSE42-NEXT:    pabsw %xmm0, %xmm0
; SSE42-NEXT:    retq
;
; AVX-LABEL: abd_subnsw_v8i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsubw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpabsw %xmm0, %xmm0
; AVX-NEXT:    retq
  %sub = sub nsw <8 x i16> %a, %b
  %abs = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %sub, i1 false)
  ret <8 x i16> %abs
}

define <4 x i32> @abd_subnsw_v4i32(<4 x i32> %a, <4 x i32> %b) nounwind {
; SSE2-LABEL: abd_subnsw_v4i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    psubd %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pxor %xmm1, %xmm0
; SSE2-NEXT:    psubd %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: abd_subnsw_v4i32:
; SSE42:       # %bb.0:
; SSE42-NEXT:    psubd %xmm1, %xmm0
; SSE42-NEXT:    pabsd %xmm0, %xmm0
; SSE42-NEXT:    retq
;
; AVX-LABEL: abd_subnsw_v4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsubd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpabsd %xmm0, %xmm0
; AVX-NEXT:    retq
  %sub = sub nsw <4 x i32> %a, %b
  %abs = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %sub, i1 false)
  ret <4 x i32> %abs
}

define <2 x i64> @abd_subnsw_v2i64(<2 x i64> %a, <2 x i64> %b) nounwind {
; SSE2-LABEL: abd_subnsw_v2i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    psubq %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm0
; SSE2-NEXT:    psubq %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: abd_subnsw_v2i64:
; SSE42:       # %bb.0:
; SSE42-NEXT:    psubq %xmm1, %xmm0
; SSE42-NEXT:    pxor %xmm1, %xmm1
; SSE42-NEXT:    psubq %xmm0, %xmm1
; SSE42-NEXT:    blendvpd %xmm0, %xmm1, %xmm0
; SSE42-NEXT:    retq
;
; AVX1-LABEL: abd_subnsw_v2i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsubq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpsubq %xmm0, %xmm1, %xmm1
; AVX1-NEXT:    vblendvpd %xmm0, %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: abd_subnsw_v2i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsubq %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsubq %xmm0, %xmm1, %xmm1
; AVX2-NEXT:    vblendvpd %xmm0, %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: abd_subnsw_v2i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsubq %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpabsq %xmm0, %xmm0
; AVX512-NEXT:    retq
  %sub = sub nsw <2 x i64> %a, %b
  %abs = call <2 x i64> @llvm.abs.v2i64(<2 x i64> %sub, i1 false)
  ret <2 x i64> %abs
}

declare <16 x i8> @llvm.abs.v16i8(<16 x i8>, i1)
declare <8 x i16> @llvm.abs.v8i16(<8 x i16>, i1)
declare <4 x i32> @llvm.abs.v4i32(<4 x i32>, i1)
declare <2 x i64> @llvm.abs.v2i64(<2 x i64>, i1)
declare <4 x i64> @llvm.abs.v4i64(<4 x i64>, i1)
declare <8 x i64> @llvm.abs.v8i64(<8 x i64>, i1)
declare <16 x i64> @llvm.abs.v16i64(<16 x i64>, i1)
declare <2 x i128> @llvm.abs.v2i128(<2 x i128>, i1)

declare <16 x i8> @llvm.smax.v16i8(<16 x i8>, <16 x i8>)
declare <8 x i16> @llvm.smax.v8i16(<8 x i16>, <8 x i16>)
declare <4 x i32> @llvm.smax.v4i32(<4 x i32>, <4 x i32>)
declare <2 x i64> @llvm.smax.v2i64(<2 x i64>, <2 x i64>)

declare <16 x i8> @llvm.smin.v16i8(<16 x i8>, <16 x i8>)
declare <8 x i16> @llvm.smin.v8i16(<8 x i16>, <8 x i16>)
declare <4 x i32> @llvm.smin.v4i32(<4 x i32>, <4 x i32>)
declare <2 x i64> @llvm.smin.v2i64(<2 x i64>, <2 x i64>)
