/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.constraint;

import com.netscape.certsrv.profile.ERejectException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.common.EnrollProfile;
import com.netscape.cms.profile.constraint.EnrollConstraint;
import com.netscape.cms.profile.def.CMCUserSignedSubjectNameDefault;
import com.netscape.cms.profile.def.PolicyDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.util.Locale;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMCUserSignedSubjectNameConstraint
extends EnrollConstraint {
    public static Logger logger = LoggerFactory.getLogger(CMCUserSignedSubjectNameConstraint.class);

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        return null;
    }

    public String getDefaultConfig(String name) {
        return null;
    }

    @Override
    public void validate(Request request, X509CertInfo info) throws ERejectException {
        String method = "CMCUserSignedSubjectNameConstraint: ";
        Object msg = "";
        logger.debug(method + "validate start");
        CertificateSubjectName infoCertSN = null;
        CertificateSubjectName authTokenCertSN = null;
        try {
            infoCertSN = (CertificateSubjectName)info.get("subject");
            if (infoCertSN == null) {
                msg = method + "infoCertSN null";
                logger.error((String)msg);
                throw new Exception((String)msg);
            }
            logger.debug(method + "validate user subject=" + infoCertSN);
            String certSerial = request.getExtDataInString("cmcSigningCert");
            if (certSerial == null) {
                msg = method + "certSerial null";
                logger.error((String)msg);
                throw new Exception((String)msg);
            }
            authTokenCertSN = EnrollProfile.getCMCSigningCertSNfromCertSerial(certSerial);
            if (authTokenCertSN == null) {
                msg = method + "authTokenCertSN null";
                logger.error((String)msg);
                throw new Exception((String)msg);
            }
            X500Name infoCertName = (X500Name)infoCertSN.get("dname");
            if (infoCertName == null) {
                msg = method + "infoCertName null";
                logger.error((String)msg);
                throw new Exception((String)msg);
            }
            X500Name authTokenCertName = (X500Name)authTokenCertSN.get("dname");
            if (authTokenCertName == null) {
                msg = method + "authTokenCertName null";
                logger.error((String)msg);
                throw new Exception((String)msg);
            }
            if (!infoCertName.equals((Object)authTokenCertName)) {
                msg = method + "names do not match";
                logger.error((String)msg);
                throw new Exception((String)msg);
            }
            logger.debug(method + "names match");
        }
        catch (Exception e) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_SUBJECT_NAME_NOT_MATCHED", (String[])new String[0]) + e);
        }
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CONSTRAINT_CMC_USER_SIGNED_SUBJECT_NAME_TEXT", (String[])new String[0]);
    }

    @Override
    public boolean isApplicable(PolicyDefault def) {
        String method = "CMCUserSignedSubjectNameConstraint: isApplicable: ";
        if (def instanceof CMCUserSignedSubjectNameDefault) {
            logger.debug(method + "true");
            return true;
        }
        logger.debug(method + "false");
        return false;
    }
}

