/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.constraint;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.profile.ERejectException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.constraint.EnrollConstraint;
import com.netscape.cms.profile.def.NoDefault;
import com.netscape.cms.profile.def.PolicyDefault;
import com.netscape.cms.profile.def.SubjectNameDefault;
import com.netscape.cms.profile.def.UserSubjectNameDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.dbs.RevocationInfo;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Locale;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.CRLExtensions;
import org.mozilla.jss.netscape.security.x509.CRLReasonExtension;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.KeyUsageExtension;
import org.mozilla.jss.netscape.security.x509.RevocationReason;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueSubjectNameConstraint
extends EnrollConstraint {
    public static Logger logger = LoggerFactory.getLogger(UniqueSubjectNameConstraint.class);
    public static final String CONFIG_KEY_USAGE_EXTENSION_CHECKING = "enableKeyUsageExtensionChecking";
    private boolean mKeyUsageExtensionChecking = true;

    public UniqueSubjectNameConstraint() {
        this.addConfigName(CONFIG_KEY_USAGE_EXTENSION_CHECKING);
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals(CONFIG_KEY_USAGE_EXTENSION_CHECKING)) {
            return new Descriptor("boolean", null, "true", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CONFIG_KEY_USAGE_EXTENSION_CHECKING", (String[])new String[0]));
        }
        return null;
    }

    public String getDefaultConfig(String name) {
        return null;
    }

    private boolean sameKeyUsageExtension(CertRecord rec, X509CertInfo certInfo) {
        X509CertImpl impl = rec.getCertificate();
        boolean[] bits = impl.getKeyUsage();
        CertificateExtensions extensions = null;
        try {
            extensions = (CertificateExtensions)certInfo.get("extensions");
        }
        catch (IOException iOException) {
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        KeyUsageExtension ext = null;
        if (extensions == null) {
            if (bits != null) {
                return false;
            }
        } else {
            try {
                ext = (KeyUsageExtension)extensions.get("KeyUsage");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (ext == null) {
                if (bits != null) {
                    return false;
                }
            } else {
                boolean[] InfoBits = ext.getBits();
                if (InfoBits == null) {
                    if (bits != null) {
                        return false;
                    }
                } else {
                    if (bits == null) {
                        return false;
                    }
                    if (InfoBits.length != bits.length) {
                        return false;
                    }
                    for (int i = 0; i < InfoBits.length; ++i) {
                        if (InfoBits[i] == bits[i]) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public void validate(Request request, X509CertInfo info) throws ERejectException {
        logger.debug("UniqueSubjectNameConstraint: validate start");
        CertificateSubjectName sn = null;
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository certdb = engine.getCertificateRepository();
        this.mKeyUsageExtensionChecking = this.getConfigBoolean(CONFIG_KEY_USAGE_EXTENSION_CHECKING);
        try {
            sn = (CertificateSubjectName)info.get("subject");
        }
        catch (Exception e) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_SUBJECT_NAME_NOT_FOUND", (String[])new String[0]));
        }
        String certsubjectname = null;
        if (sn == null) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_SUBJECT_NAME_NOT_FOUND", (String[])new String[0]));
        }
        certsubjectname = sn.toString();
        String filter = "x509Cert.subject=" + certsubjectname;
        Enumeration<CertRecord> sameSubjRecords = null;
        try {
            sameSubjRecords = certdb.findCertRecords(filter);
        }
        catch (EBaseException e) {
            logger.warn("UniqueSubjectNameConstraint exception: " + e.getMessage(), (Throwable)e);
        }
        while (sameSubjRecords != null && sameSubjRecords.hasMoreElements()) {
            CRLExtensions crlExts;
            CertRecord rec = sameSubjRecords.nextElement();
            String status = rec.getStatus();
            RevocationInfo revocationInfo = rec.getRevocationInfo();
            RevocationReason reason = null;
            if (revocationInfo != null && (crlExts = revocationInfo.getCRLEntryExtensions()) != null) {
                Enumeration enumx = crlExts.getElements();
                while (enumx.hasMoreElements()) {
                    Extension ext = (Extension)enumx.nextElement();
                    if (!(ext instanceof CRLReasonExtension)) continue;
                    reason = ((CRLReasonExtension)ext).getReason();
                }
            }
            if (status.equals("EXPIRED") || status.equals("REVOKED_EXPIRED") || status.equals("REVOKED") && reason != null && !reason.equals((Object)RevocationReason.CERTIFICATE_HOLD) || this.mKeyUsageExtensionChecking && !this.sameKeyUsageExtension(rec, info)) continue;
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_SUBJECT_NAME_NOT_UNIQUE", (String[])new String[]{certsubjectname}));
        }
        logger.debug("UniqueSubjectNameConstraint: validate end");
    }

    @Override
    public String getText(Locale locale) {
        String[] params = new String[]{this.getConfig(CONFIG_KEY_USAGE_EXTENSION_CHECKING)};
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CONSTRAINT_UNIQUE_SUBJECT_NAME_TEXT", (String[])params);
    }

    @Override
    public boolean isApplicable(PolicyDefault def) {
        if (def instanceof NoDefault) {
            return true;
        }
        if (def instanceof SubjectNameDefault) {
            return true;
        }
        return def instanceof UserSubjectNameDefault;
    }
}

