/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.input;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.profile.input.EnrollInput;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.BufferedInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSigningInput
extends EnrollInput {
    public static Logger logger = LoggerFactory.getLogger(FileSigningInput.class);
    public static final String URL = "file_signing_url";
    public static final String TEXT = "file_signing_text";
    public static final String SIZE = "file_signing_size";
    public static final String DIGEST = "file_signing_digest";
    public static final String DIGEST_TYPE = "file_signing_digest_type";

    public FileSigningInput() {
        this.addValueName(URL);
        this.addValueName(TEXT);
    }

    @Override
    public void init(Profile profile, ConfigStore config) throws EProfileException {
        super.init(profile, config);
    }

    @Override
    public String getName(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INPUT_FILE_SIGNING_NAME", (String[])new String[0]);
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INPUT_FILE_SIGNING_TEXT", (String[])new String[0]);
    }

    public String toHexString(byte[] data) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int v = data[i] & 0xFF;
            if (v < 16) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(v));
        }
        return sb.toString();
    }

    @Override
    public void populate(Map<String, String> ctx, Request request) throws Exception {
        request.setExtData(TEXT, ctx.get(TEXT));
        request.setExtData(URL, ctx.get(URL));
        request.setExtData(DIGEST_TYPE, "SHA256");
        try {
            URL url = new URL(ctx.get(URL));
            URLConnection c = url.openConnection();
            c.setAllowUserInteraction(false);
            c.setDoInput(true);
            c.setDoOutput(false);
            c.setUseCaches(false);
            c.connect();
            int len = c.getContentLength();
            request.setExtData(SIZE, Integer.toString(len));
            BufferedInputStream is = new BufferedInputStream(c.getInputStream());
            byte[] data = new byte[len];
            is.read(data, 0, len);
            is.close();
            MessageDigest digester = MessageDigest.getInstance("SHA256");
            byte[] digest = digester.digest(data);
            request.setExtData(DIGEST, this.toHexString(digest));
        }
        catch (Exception e) {
            logger.error("FileSigningInput populate failure " + e.getMessage(), (Throwable)e);
            throw new EProfileException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_FILE_NOT_FOUND", (String[])new String[0]));
        }
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals(URL)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INPUT_FILE_SIGNING_URL", (String[])new String[0]));
        }
        if (name.equals(TEXT)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INPUT_FILE_SIGNING_TEXT", (String[])new String[0]));
        }
        return null;
    }
}

