/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertRecordList;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.dbs.RevocationInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.provider.RSAPublicKey;
import org.mozilla.jss.netscape.security.x509.CRLExtensions;
import org.mozilla.jss.netscape.security.x509.CRLReasonExtension;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caListCerts", urlPatterns={"/ee/ca/listCerts"}, initParams={@WebInitParam(name="GetClientCert", value="false"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="ca"), @WebInitParam(name="templatePath", value="/ee/ca/queryCert.template"), @WebInitParam(name="ID", value="caListCerts"), @WebInitParam(name="resourceID", value="certServer.ee.certificates"), @WebInitParam(name="interface", value="ee"), @WebInitParam(name="maxResults", value="1000")})
public class ListCerts
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(ListCerts.class);
    private static final long serialVersionUID = -3568155814023099576L;
    private static final String TPL_FILE = "queryCert.template";
    private static final BigInteger MINUS_ONE = new BigInteger("-1");
    private static final String USE_CLIENT_FILTER = "useClientFilter";
    private static final String ALLOWED_CLIENT_FILTERS = "allowedClientFilters";
    private CertificateRepository mCertDB;
    private X500Name mAuthName = null;
    private String mFormPath = null;
    private boolean mUseClientFilter = false;
    private Vector<String> mAllowedClientFilters = new Vector();
    private int mMaxReturns = 2000;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        CAEngine engine = CAEngine.getInstance();
        this.mTemplates.remove(CMSRequest.SUCCESS);
        CertificateAuthority ca = engine.getCA();
        this.mCertDB = engine.getCertificateRepository();
        this.mAuthName = ca.getX500Name();
        this.mFormPath = "/ca/queryCert.template";
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
        try {
            this.mMaxReturns = Integer.parseInt(sc.getInitParameter("maxResults"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sc.getInitParameter(USE_CLIENT_FILTER) != null && sc.getInitParameter(USE_CLIENT_FILTER).equalsIgnoreCase("true")) {
            this.mUseClientFilter = true;
        }
        if (sc.getInitParameter(ALLOWED_CLIENT_FILTERS) == null || sc.getInitParameter(ALLOWED_CLIENT_FILTERS).equals("")) {
            this.mAllowedClientFilters.addElement("(certStatus=*)");
            this.mAllowedClientFilters.addElement("(certStatus=VALID)");
            this.mAllowedClientFilters.addElement("(|(certStatus=VALID)(certStatus=INVALID)(certStatus=EXPIRED))");
            this.mAllowedClientFilters.addElement("(|(certStatus=VALID)(certStatus=REVOKED))");
        } else {
            StringTokenizer st = new StringTokenizer(sc.getInitParameter(ALLOWED_CLIENT_FILTERS), ",");
            while (st.hasMoreTokens()) {
                this.mAllowedClientFilters.addElement(st.nextToken());
            }
        }
    }

    public String buildFilter(HttpServletRequest req) {
        String queryCertFilter = req.getParameter("queryCertFilter");
        logger.debug("ListCerts: queryCertFilter: " + queryCertFilter);
        logger.debug("ListCerts: useClientFilter: " + this.mUseClientFilter);
        if (this.mUseClientFilter) {
            Enumeration<String> filters = this.mAllowedClientFilters.elements();
            while (filters.hasMoreElements()) {
                String filter = filters.nextElement();
                logger.debug("ListCerts: Comparing with filter " + filter);
                if (!filter.equals(queryCertFilter)) continue;
                return queryCertFilter;
            }
            logger.debug("ListCerts: Requested filter '" + queryCertFilter + "' is not allowed. Please check the allowedClientFiltersparameter");
            return null;
        }
        boolean skipRevoked = false;
        boolean skipNonValid = false;
        if (req.getParameter("skipRevoked") != null && req.getParameter("skipRevoked").equals("on")) {
            skipRevoked = true;
        }
        if (req.getParameter("skipNonValid") != null && req.getParameter("skipNonValid").equals("on")) {
            skipNonValid = true;
        }
        if (!skipRevoked && !skipNonValid) {
            queryCertFilter = "(certStatus=*)";
        } else if (skipRevoked && skipNonValid) {
            queryCertFilter = "(certStatus=VALID)";
        } else if (skipRevoked) {
            queryCertFilter = "(|(certStatus=VALID)(certStatus=INVALID)(certStatus=EXPIRED))";
        } else if (skipNonValid) {
            queryCertFilter = "(|(certStatus=VALID)(certStatus=REVOKED))";
        }
        return queryCertFilter;
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "list");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        String revokeAll = null;
        EBaseException error = null;
        int maxCount = -1;
        BigInteger sentinel = new BigInteger("0");
        ArgBlock header = new ArgBlock();
        ArgBlock ctx = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, ctx);
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{this.mFormPath, e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        String direction = null;
        boolean reverse = false;
        boolean hardJumpTo = false;
        try {
            if (req.getParameter("direction") != null) {
                direction = req.getParameter("direction").trim();
                reverse = direction.equals("up");
                logger.debug("ListCerts: reverse: " + reverse);
            }
            if (req.getParameter("maxCount") != null) {
                maxCount = Integer.parseInt(req.getParameter("maxCount"));
            }
            if (maxCount == -1 || maxCount > this.mMaxReturns) {
                logger.debug("ListCerts: Resetting page size from " + maxCount + " to " + this.mMaxReturns);
                maxCount = this.mMaxReturns;
            }
            String sentinelStr = "";
            if (reverse) {
                sentinelStr = req.getParameter("querySentinelUp");
            } else if (direction.equals("end")) {
                sentinelStr = "0";
                reverse = true;
                hardJumpTo = true;
            } else {
                sentinelStr = direction.equals("down") ? req.getParameter("querySentinelDown") : "0";
            }
            if (sentinelStr != null) {
                sentinel = sentinelStr.trim().startsWith("0x") ? new BigInteger(sentinelStr.trim().substring(2), 16) : new BigInteger(sentinelStr, 10);
            }
            revokeAll = req.getParameter("revokeAll");
            CAEngine engine = CAEngine.getInstance();
            CertificateAuthority ca = engine.getCA();
            X509CertImpl caCert = ca.getSigningUnit().getCertImpl();
            header.addStringValue("caSerialNumber", caCert.getSerialNumber().toString(16));
            String queryCertFilter = this.buildFilter(req);
            if (queryCertFilter == null) {
                cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
                return;
            }
            logger.debug("ListCerts: queryCertFilter: " + queryCertFilter);
            int totalRecordCount = -1;
            try {
                totalRecordCount = Integer.parseInt(req.getParameter("totalRecordCount"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.processCertFilter(argSet, header, maxCount, sentinel, totalRecordCount, req.getParameter("serialTo"), queryCertFilter, reverse, hardJumpTo, req, resp, revokeAll, locale[0]);
        }
        catch (NumberFormatException e) {
            logger.error(CMS.getLogMessage((String)"BASE_INVALID_NUMBER_FORMAT", (Object[])new Object[0]), (Throwable)e);
            error = new EBaseException(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_BASE_INVALID_NUMBER_FORMAT", (String[])new String[0]), (Throwable)e);
        }
        catch (EBaseException e) {
            error = e;
        }
        ctx.addIntegerValue("maxCount", maxCount);
        try {
            ServletOutputStream out = resp.getOutputStream();
            if (error == null) {
                String xmlOutput = req.getParameter("xml");
                if (xmlOutput != null && xmlOutput.equals("true")) {
                    this.outputXML(resp, argSet);
                } else {
                    cmsReq.setStatus(CMSRequest.SUCCESS);
                    resp.setContentType("text/html");
                    form.renderOutput((OutputStream)out, argSet);
                }
            } else {
                cmsReq.setStatus(CMSRequest.ERROR);
                cmsReq.setError(error);
            }
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_OUT_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
    }

    private void processCertFilter(CMSTemplateParams argSet, ArgBlock header, int maxCount, BigInteger sentinel, int totalRecordCount, String serialTo, String filter, boolean reverse, boolean hardJumpTo, HttpServletRequest req, HttpServletResponse resp, String revokeAll, Locale locale) throws EBaseException {
        logger.debug("ListCerts.processCertFilter()");
        logger.debug("ListCerts: max count: " + maxCount);
        logger.debug("ListCerts: sentinel: " + sentinel);
        logger.debug("ListCerts: total record count: " + totalRecordCount);
        logger.debug("ListCerts: serialTo: " + serialTo);
        logger.debug("ListCerts: filter: " + filter);
        BigInteger serialToVal = MINUS_ONE;
        try {
            if (serialTo != null) {
                if ((serialTo = serialTo.trim()).startsWith("0x")) {
                    serialToVal = new BigInteger(serialTo.substring(2), 16);
                    serialTo = serialToVal.toString();
                } else {
                    serialToVal = new BigInteger(serialTo);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.debug("ListCerts: serialToVal: " + serialToVal);
        logger.debug("ListCerts: reverse: " + reverse);
        logger.debug("ListCerts: hardJumpTo: " + hardJumpTo);
        String jumpTo = sentinel.toString();
        int pSize = 0;
        pSize = reverse ? (!hardJumpTo ? -1 * maxCount - 1 : -1 * maxCount) : maxCount;
        logger.debug("ListCerts: pSize: " + pSize);
        logger.debug("ListCerts: calling findCertRecordsInList() with jumpTo");
        CertRecordList list = this.mCertDB.findCertRecordsInList(filter, null, jumpTo, hardJumpTo, "serialno", pSize);
        logger.debug("ListCerts: list size: " + list.getSize());
        Enumeration e = list.getCertRecords(0, maxCount);
        CertRecordList tolist = null;
        int toCurIndex = 0;
        if (!serialToVal.equals(MINUS_ONE)) {
            logger.debug("ListCerts: calling findCertRecordsInList() with serialTo");
            tolist = this.mCertDB.findCertRecordsInList(filter, null, serialTo, "serialno", maxCount);
            logger.debug("ListCerts: tolist size: " + tolist.getSize());
            Enumeration en = tolist.getCertRecords(0, 0);
            if (en == null || !en.hasMoreElements()) {
                logger.debug("ListCerts: no results");
                toCurIndex = list.getSize() - 1;
            } else {
                toCurIndex = tolist.getCurrentIndex();
                CertRecord rx = (CertRecord)en.nextElement();
                BigInteger curToSerial = rx.getSerialNumber();
                logger.debug("ListCerts: curToSerial: " + curToSerial);
                if (curToSerial.compareTo(serialToVal) == -1) {
                    toCurIndex = list.getSize() - 1;
                } else if (!rx.getSerialNumber().toString().equals(serialTo.trim())) {
                    --toCurIndex;
                }
            }
            logger.debug("ListCerts: toCurIndex: " + toCurIndex);
        }
        int curIndex = list.getCurrentIndex();
        logger.debug("ListCerts: curIndex: " + curIndex);
        BigInteger firstSerial = new BigInteger("0");
        BigInteger curSerial = new BigInteger("0");
        CertRecord[] recs = new CertRecord[maxCount];
        int rcount = 0;
        if (e != null) {
            CertRecord rec;
            logger.debug("ListCerts: records:");
            int count = 0;
            while (count < (reverse && !hardJumpTo ? maxCount + 1 : maxCount) && e.hasMoreElements() && (rec = (CertRecord)e.nextElement()) != null) {
                curSerial = rec.getSerialNumber();
                if (count == 0) {
                    firstSerial = curSerial;
                    if (reverse && !hardJumpTo) {
                        logger.debug("ListCerts:   skipping record");
                        ++count;
                        continue;
                    }
                }
                if (!serialToVal.equals(MINUS_ONE) && curSerial.compareTo(serialToVal) == 1) {
                    logger.debug("ListCerts: curSerial compare serialToVal 1 breaking...");
                    break;
                }
                if (reverse) {
                    recs[rcount++] = rec;
                } else {
                    ArgBlock rarg = new ArgBlock();
                    this.fillRecordIntoArg(rec, rarg);
                    argSet.addRepeatRecord(rarg);
                }
                ++count;
            }
        } else {
            logger.debug("ListCerts: no records found");
            return;
        }
        if (reverse) {
            logger.debug("ListCerts: fill records into arg block and argSet");
            for (int ii = rcount - 1; ii >= 0; --ii) {
                if (recs[ii] == null) continue;
                ArgBlock rarg = new ArgBlock();
                this.fillRecordIntoArg(recs[ii], rarg);
                argSet.addRepeatRecord(rarg);
            }
        }
        CertRecord nextRec = null;
        if (e.hasMoreElements()) {
            nextRec = (CertRecord)e.nextElement();
            logger.debug("ListCerts: next record: " + nextRec.getSerialNumber());
        } else {
            logger.debug("ListCerts: no next record");
        }
        header.addStringValue("op", CMSTemplate.escapeJavaScriptString((String)req.getParameter("op")));
        if (revokeAll != null) {
            header.addStringValue("revokeAll", CMSTemplate.escapeJavaScriptString((String)revokeAll));
        }
        if (this.mAuthName != null) {
            header.addStringValue("issuerName", this.mAuthName.toString());
        }
        if (!serialToVal.equals(MINUS_ONE)) {
            header.addStringValue("serialTo", serialToVal.toString());
        }
        header.addStringValue("serviceURL", req.getRequestURI());
        header.addStringValue("queryCertFilter", filter);
        String skipRevoked = req.getParameter("skipRevoked");
        header.addStringValue("skipRevoked", skipRevoked == null ? "" : (skipRevoked.equals("on") ? "on" : "off"));
        String skipNonValid = req.getParameter("skipNonValid");
        header.addStringValue("skipNonValid", skipNonValid == null ? "" : (skipNonValid.equals("on") ? "on" : "off"));
        header.addStringValue("templateName", "queryCert");
        header.addStringValue("queryFilter", filter);
        header.addIntegerValue("maxCount", maxCount);
        if (totalRecordCount == -1) {
            if (!serialToVal.equals(MINUS_ONE)) {
                totalRecordCount = toCurIndex - curIndex + 1;
                logger.debug("ListCerts: totalRecordCount: " + totalRecordCount);
            } else {
                totalRecordCount = list.getSize() - list.getCurrentIndex();
                logger.debug("ListCerts: totalRecordCount: " + totalRecordCount);
            }
        }
        int currentRecordCount = list.getSize() - list.getCurrentIndex();
        logger.debug("ListCerts: totalRecordCount: " + totalRecordCount);
        logger.debug("ListCerts: currentRecordCount: " + currentRecordCount);
        header.addIntegerValue("totalRecordCount", totalRecordCount);
        header.addIntegerValue("currentRecordCount", currentRecordCount);
        String qs = "";
        qs = reverse ? "querySentinelUp" : "querySentinelDown";
        logger.debug("ListCerts: qs: " + qs);
        if (hardJumpTo) {
            logger.debug("ListCerts: curSerial added to querySentinelUp: " + curSerial);
            header.addStringValue("querySentinelUp", curSerial.toString());
        } else if (nextRec == null) {
            header.addStringValue(qs, null);
            logger.debug("ListCerts: nextRec is null");
            if (reverse) {
                logger.debug("ListCerts: curSerial added to querySentinelUp: " + curSerial);
                header.addStringValue("querySentinelUp", curSerial.toString());
            }
        } else {
            BigInteger nextRecNo = nextRec.getSerialNumber();
            logger.debug("ListCerts: nextRecNo: " + nextRecNo);
            if (serialToVal.equals(MINUS_ONE)) {
                header.addStringValue(qs, nextRecNo.toString());
            } else if (nextRecNo.compareTo(serialToVal) <= 0) {
                header.addStringValue(qs, nextRecNo.toString());
            } else {
                header.addStringValue(qs, null);
            }
            logger.debug("ListCerts: querySentinel " + qs + ": " + nextRecNo);
        }
        header.addStringValue(!reverse ? "querySentinelUp" : "querySentinelDown", firstSerial.toString());
    }

    private void fillRecordIntoArg(CertRecord rec, ArgBlock rarg) throws EBaseException {
        X509CertImpl xcert = rec.getCertificate();
        if (xcert != null) {
            this.fillX509RecordIntoArg(rec, rarg);
        }
    }

    private void fillX509RecordIntoArg(CertRecord rec, ArgBlock rarg) throws EBaseException {
        X509CertImpl cert = rec.getCertificate();
        rarg.addIntegerValue("version", cert.getVersion());
        rarg.addStringValue("serialNumber", cert.getSerialNumber().toString(16));
        rarg.addStringValue("serialNumberDecimal", cert.getSerialNumber().toString());
        if (cert.getSubjectName().toString().equals("")) {
            rarg.addStringValue("subject", " ");
        } else {
            rarg.addStringValue("subject", CMSTemplate.escapeJavaScriptString((String)cert.getSubjectName().toString()));
        }
        rarg.addStringValue("type", "X.509");
        try {
            PublicKey pKey = cert.getPublicKey();
            X509Key key = null;
            if (pKey instanceof CertificateX509Key) {
                CertificateX509Key certKey = (CertificateX509Key)pKey;
                key = (X509Key)certKey.get("value");
            }
            if (pKey instanceof X509Key) {
                key = (X509Key)pKey;
            }
            rarg.addStringValue("subjectPublicKeyAlgorithm", key.getAlgorithmId().getOID().toString());
            if (key.getAlgorithmId().toString().equalsIgnoreCase("RSA")) {
                RSAPublicKey rsaKey = new RSAPublicKey(key.getEncoded());
                rarg.addIntegerValue("subjectPublicKeyLength", rsaKey.getKeySize());
            }
        }
        catch (Exception e) {
            rarg.addStringValue("subjectPublicKeyAlgorithm", null);
            rarg.addIntegerValue("subjectPublicKeyLength", 0);
        }
        rarg.addLongValue("validNotBefore", cert.getNotBefore().getTime() / 1000L);
        rarg.addLongValue("validNotAfter", cert.getNotAfter().getTime() / 1000L);
        rarg.addStringValue("signatureAlgorithm", cert.getSigAlgOID());
        String issuedBy = rec.getIssuedBy();
        if (issuedBy == null) {
            issuedBy = "";
        }
        rarg.addStringValue("issuedBy", CMSTemplate.escapeJavaScriptString((String)issuedBy));
        rarg.addLongValue("issuedOn", rec.getCreateTime().getTime() / 1000L);
        rarg.addStringValue("revokedBy", rec.getRevokedBy() == null ? "" : CMSTemplate.escapeJavaScriptString((String)rec.getRevokedBy()));
        if (rec.getRevokedOn() == null) {
            rarg.addStringValue("revokedOn", null);
        } else {
            CRLExtensions crlExts;
            rarg.addLongValue("revokedOn", rec.getRevokedOn().getTime() / 1000L);
            RevocationInfo revocationInfo = rec.getRevocationInfo();
            if (revocationInfo != null && (crlExts = revocationInfo.getCRLEntryExtensions()) != null) {
                Enumeration enum1 = crlExts.getElements();
                int reason = 0;
                while (enum1.hasMoreElements()) {
                    Extension ext = (Extension)enum1.nextElement();
                    if (!(ext instanceof CRLReasonExtension)) continue;
                    reason = ((CRLReasonExtension)ext).getReason().getCode();
                    break;
                }
                rarg.addIntegerValue("revocationReason", reason);
            }
        }
    }
}

