/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.csadmin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.base.UserInfo;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmsutil.json.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.CertificateChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caGetCertChain", urlPatterns={"/ee/ca/getCertChain"}, initParams={@WebInitParam(name="GetClientCert", value="false"), @WebInitParam(name="authority", value="ca"), @WebInitParam(name="ID", value="caGetCertChain")})
public class GetCertChain
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(GetCertChain.class);
    private static final long serialVersionUID = -356806997334418285L;
    private static final String SUCCESS = "0";

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
    }

    protected void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletResponse httpResp = cmsReq.getHttpResp();
        CAEngine engine = CAEngine.getInstance();
        CertificateAuthority ca = engine.getCA();
        CertificateChain certChain = ca.getCACertChain();
        if (certChain == null) {
            logger.warn("GetCertChain: cannot get the certificate chain.");
            this.outputError(httpResp, "Error: Failed to get certificate chain.");
            return;
        }
        X509Certificate[] certs = certChain.getChain();
        if (certs == null) {
            logger.warn("GetCertChain: no certificate chain");
        } else {
            logger.debug("GetCertChain: certificate chain:");
            for (X509Certificate cert : certs) {
                logger.debug("GetCertChain: - " + cert.getSubjectDN());
            }
        }
        byte[] bytes = null;
        try {
            ByteArrayOutputStream encoded = new ByteArrayOutputStream();
            certChain.encode((OutputStream)encoded);
            bytes = encoded.toByteArray();
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage((String)"CMSGW_ERROR_ENCODING_CA_CHAIN_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
            this.outputError(httpResp, "Error: Failed to encode the certificate chain");
        }
        String chainBase64 = Utils.base64encode((byte[])bytes, (boolean)true);
        chainBase64 = this.normalizeCertStr(chainBase64);
        try {
            JSONObject jsonObj = new JSONObject();
            ObjectNode responseNode = jsonObj.getMapper().createObjectNode();
            responseNode.put("Status", SUCCESS);
            responseNode.put("ChainBase64", chainBase64);
            jsonObj.getRootNode().set("Response", (JsonNode)responseNode);
            this.outputResult(httpResp, "application/json", jsonObj.toByteArray());
        }
        catch (Exception e) {
            logger.warn("Failed to send the output: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void renderResult(CMSRequest cmsReq) throws IOException {
    }

    protected Locale getLocale(HttpServletRequest req) {
        Locale locale = null;
        String lang = req.getHeader("accept-language");
        locale = lang == null ? Locale.getDefault() : new Locale(UserInfo.getUserLanguage((String)lang), UserInfo.getUserCountry((String)lang));
        return locale;
    }

    private String normalizeCertStr(String s) {
        StringBuffer val = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\n' || s.charAt(i) == '\r' || s.charAt(i) == '\"' || s.charAt(i) == ' ') continue;
            val.append(s.charAt(i));
        }
        return val.toString();
    }
}

