/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.request.RequestRepository;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialNumberUpdateTask
implements Runnable {
    public static Logger logger = LoggerFactory.getLogger(SerialNumberUpdateTask.class);
    CertificateRepository certRepository;
    RequestRepository requestRepository;
    int interval;
    ScheduledExecutorService executorService;

    public SerialNumberUpdateTask(CertificateRepository certRepository, RequestRepository requestRepository, int interval) {
        this.certRepository = certRepository;
        this.requestRepository = requestRepository;
        this.interval = interval;
    }

    public void start() {
        this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "SerialNumberUpdateTask");
            }
        });
        this.executorService.scheduleWithFixedDelay(this, 0L, this.interval, TimeUnit.SECONDS);
    }

    public synchronized void updateSerialNumbers() throws Exception {
        logger.info("SerialNumberUpdateTask: Updating serial number counter");
        this.certRepository.updateCounter();
        logger.info("SerialNumberUpdateTask: Checking serial number ranges");
        this.certRepository.checkRanges();
        logger.info("SerialNumberUpdateTask: Checking request ID ranges");
        this.requestRepository.checkRanges();
    }

    @Override
    public void run() {
        try {
            this.updateSerialNumbers();
        }
        catch (Exception e) {
            logger.warn("SerialNumberUpdateTask: " + e.getMessage(), (Throwable)e);
        }
    }

    public void stop() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }
}

