/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.key;

import com.netscape.certsrv.base.RESTMessage;
import com.netscape.certsrv.client.Client;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.key.KeyRequestInfo;
import com.netscape.certsrv.key.KeyRequestInfoCollection;
import com.netscape.certsrv.key.KeyRequestResponse;
import com.netscape.certsrv.request.RequestId;
import java.util.HashMap;
import javax.ws.rs.client.Entity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyRequestClient
extends Client {
    public static Logger logger = LoggerFactory.getLogger(KeyRequestClient.class);

    public KeyRequestClient(PKIClient client) throws Exception {
        super(client, "kra", "agent/keyrequests");
    }

    public KeyRequestInfoCollection listRequests(String requestState, String requestType, String realm) throws Exception {
        return this.listRequests(requestState, requestType, null, new RequestId(0), 100, 100, 10, realm);
    }

    public KeyRequestInfoCollection listRequests(String requestState, String requestType) throws Exception {
        return this.listRequests(requestState, requestType, null, new RequestId(0), 100, 100, 10, null);
    }

    public KeyRequestInfoCollection listRequests(String requestState, String requestType, String clientKeyID, RequestId start, Integer pageSize, Integer maxResults, Integer maxTime, String realm) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (requestState != null) {
            params.put("requestState", requestState);
        }
        if (requestType != null) {
            params.put("requestType", requestType);
        }
        if (clientKeyID != null) {
            params.put("clientKeyID", clientKeyID);
        }
        if (start != null) {
            params.put("start", start.toHexString());
        }
        if (pageSize != null) {
            params.put("pageSize", pageSize);
        }
        if (maxResults != null) {
            params.put("maxResults", maxResults);
        }
        if (maxTime != null) {
            params.put("maxTime", maxTime);
        }
        if (realm != null) {
            params.put("realm", realm);
        }
        return this.get(null, params, KeyRequestInfoCollection.class);
    }

    public KeyRequestInfo getRequestInfo(RequestId id) throws Exception {
        if (id == null) {
            throw new IllegalArgumentException("Request Id must be specified.");
        }
        return this.get(id.toHexString(), KeyRequestInfo.class);
    }

    public void approveRequest(RequestId id) throws Exception {
        if (id == null) {
            throw new IllegalArgumentException("Request Id must be specified.");
        }
        this.post(id.toHexString() + "/approve", Void.class);
    }

    public void rejectRequest(RequestId id) throws Exception {
        if (id == null) {
            throw new IllegalArgumentException("Request Id must be specified.");
        }
        this.post(id.toHexString() + "/reject", Void.class);
    }

    public void cancelRequest(RequestId id) throws Exception {
        if (id == null) {
            throw new IllegalArgumentException("Request Id must be specified.");
        }
        this.post(id.toHexString() + "/cancel", Void.class);
    }

    KeyRequestResponse submitRequest(RESTMessage request) throws Exception {
        if (request == null) {
            throw new IllegalArgumentException("A Request object must be specified.");
        }
        logger.info("Submitting " + request.getClassName() + " to KRA");
        Entity<RESTMessage> entity = this.client.entity(request);
        return this.post(null, null, entity, KeyRequestResponse.class);
    }
}

