/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.profile;

import com.netscape.certsrv.client.Client;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.profile.ProfileData;
import com.netscape.certsrv.profile.ProfileDataInfos;
import java.util.HashMap;
import javax.ws.rs.client.Entity;

public class ProfileClient
extends Client {
    public ProfileClient(PKIClient client, String subsystem) throws Exception {
        super(client, subsystem, "profiles");
    }

    public ProfileData retrieveProfile(String id) throws Exception {
        return this.get(id, ProfileData.class);
    }

    public byte[] retrieveProfileRaw(String id) throws Exception {
        return this.get(id + "/raw", byte[].class);
    }

    public ProfileDataInfos listProfiles(Integer start, Integer size) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (start != null) {
            params.put("start", start);
        }
        if (size != null) {
            params.put("size", size);
        }
        return this.get(null, params, ProfileDataInfos.class);
    }

    public void enableProfile(String id) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("action", "enable");
        this.post(id, params, null, Void.class);
    }

    public void disableProfile(String id) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("action", "disable");
        this.post(id, params, null, Void.class);
    }

    public ProfileData createProfile(ProfileData data) throws Exception {
        String createProfileRequest = (String)this.client.marshall(data);
        Entity<String> entity = this.client.entity(createProfileRequest);
        return this.post(null, null, entity, ProfileData.class);
    }

    public byte[] createProfileRaw(byte[] properties) throws Exception {
        Entity<byte[]> entity = this.client.entity(properties);
        return this.post("raw", null, entity, byte[].class);
    }

    public ProfileData modifyProfile(ProfileData data) throws Exception {
        String modifyProfileRequest = (String)this.client.marshall(data);
        Entity<String> entity = this.client.entity(modifyProfileRequest);
        return this.put(data.getId(), null, entity, ProfileData.class);
    }

    public byte[] modifyProfileRaw(String profileId, byte[] properties) throws Exception {
        Entity<byte[]> entity = this.client.entity(properties);
        return this.put(profileId + "/raw", null, entity, byte[].class);
    }

    public void deleteProfile(String id) throws Exception {
        this.delete(id, Void.class);
    }
}

