/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.request;

import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.base.ResourceNotFoundException;
import com.netscape.certsrv.request.RequestId;

public class RequestNotFoundException
extends ResourceNotFoundException {
    private static final long serialVersionUID = -4784839378360933483L;
    public RequestId requestId;

    public RequestNotFoundException(RequestId requestId) {
        this(requestId, "Request ID " + requestId.toHexString() + " not found");
    }

    public RequestNotFoundException(RequestId requestId, String message) {
        super(message);
        this.requestId = requestId;
    }

    public RequestNotFoundException(RequestId requestId, String message, Throwable cause) {
        super(message, cause);
        this.requestId = requestId;
    }

    public RequestNotFoundException(PKIException.Data data) {
        super(data);
        this.requestId = new RequestId(data.getAttribute("requestId"));
    }

    @Override
    public PKIException.Data getData() {
        PKIException.Data data = super.getData();
        data.setAttribute("requestId", this.requestId.toString());
        return data;
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public void setRequestId(RequestId requestId) {
        this.requestId = requestId;
    }
}

