/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.tps.apdu;

import org.dogtagpki.tps.apdu.APDU;
import org.dogtagpki.tps.main.TPSBuffer;

public class ExternalAuthenticateAPDU
extends APDU {
    public ExternalAuthenticateAPDU(TPSBuffer theData, SecurityLevel securityLevel) {
        this.setCLA((byte)-124);
        this.setINS((byte)-126);
        this.setP1(ExternalAuthenticateAPDU.securityLevelToByte(securityLevel));
        this.setP2((byte)0);
        this.setData(theData);
    }

    public TPSBuffer getHostCryptogram() {
        return this.getData();
    }

    @Override
    public APDU.Type getType() {
        return APDU.Type.APDU_EXTERNAL_AUTHENTICATE;
    }

    public static byte securityLevelToByte(SecurityLevel level) {
        return switch (level) {
            case SecurityLevel.SECURE_MSG_ANY -> 0;
            case SecurityLevel.SECURE_MSG_MAC -> 1;
            case SecurityLevel.SECURE_MSG_NONE -> 2;
            case SecurityLevel.SECURE_MSG_MAC_ENC -> 3;
            default -> 0;
        };
    }

    public static SecurityLevel byteToSecurityLevel(byte level) {
        return switch (level) {
            case 0 -> SecurityLevel.SECURE_MSG_ANY;
            case 1 -> SecurityLevel.SECURE_MSG_MAC;
            case 2 -> SecurityLevel.SECURE_MSG_NONE;
            case 3 -> SecurityLevel.SECURE_MSG_MAC_ENC;
            default -> SecurityLevel.SECURE_MSG_ANY;
        };
    }

    public static enum SecurityLevel {
        SECURE_MSG_ANY,
        SECURE_MSG_MAC,
        SECURE_MSG_NONE,
        SECURE_MSG_MAC_ENC;

    }
}

