/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.tps.msg;

import org.dogtagpki.tps.apdu.APDUResponse;
import org.dogtagpki.tps.main.TPSBuffer;
import org.dogtagpki.tps.main.Util;
import org.dogtagpki.tps.msg.TPSMessage;

public class TokenPDUResponseMsg
extends TPSMessage {
    private APDUResponse response = null;

    public TokenPDUResponseMsg(String message) {
        super(message);
        String size = this.get("pdu_size");
        String apduData = this.get("pdu_data");
        int sizeI = Integer.parseInt(size);
        byte[] decoded_pdu_data = Util.uriDecodeFromHex(apduData);
        if (decoded_pdu_data.length == sizeI) {
            TPSBuffer responseBuffer = new TPSBuffer(decoded_pdu_data);
            this.response = new APDUResponse(responseBuffer);
        }
    }

    public APDUResponse getResponseAPDU() {
        return this.response;
    }

    public static void main(String[] args) {
        String pdu_data = "s=46&msg_type=10&pdu_size=6&pdu_data=R%B3F%85%90%00";
        TokenPDUResponseMsg msg = new TokenPDUResponseMsg(pdu_data);
        System.out.println(msg.encode());
        String pdu_data1 = "s=38&msg_type=10&pdu_size=2&pdu_data=%90%00";
        TokenPDUResponseMsg msg1 = new TokenPDUResponseMsg(pdu_data1);
        System.out.println(msg1.encode());
    }
}

