/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tps.config;

import com.netscape.certsrv.util.JSONSerializer;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.config.ConfigCLI;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.dogtagpki.common.ConfigClient;
import org.dogtagpki.common.ConfigData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigModifyCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(ConfigModifyCLI.class);
    public ConfigCLI configCLI;

    public ConfigModifyCLI(ConfigCLI configCLI) {
        super("mod", "Modify general properties", (CLI)configCLI);
        this.configCLI = configCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " --input <file> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "input", true, "Input file containing general properties.");
        option.setArgName("file");
        this.options.addOption(option);
        option = new Option(null, "output", true, "Output file to store general properties.");
        option.setArgName("file");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        ConfigData configData;
        PrintWriter out;
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 0) {
            throw new Exception("Too many arguments specified.");
        }
        String input = cmd.getOptionValue("input");
        String output = cmd.getOptionValue("output");
        if (input == null) {
            throw new Exception("Missing input file");
        }
        try (BufferedReader in = new BufferedReader(new FileReader(input));
             StringWriter sw = new StringWriter();){
            out = new PrintWriter((Writer)sw, true);
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    out.println(line);
                }
                configData = (ConfigData)JSONSerializer.fromJSON((String)sw.toString(), ConfigData.class);
            }
            finally {
                out.close();
            }
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        ConfigClient configClient = this.configCLI.getConfigClient();
        configData = configClient.updateConfig(configData);
        MainCLI.printMessage("Updated configuration");
        if (output == null) {
            ConfigCLI.printConfigData(configData);
        } else {
            out = new PrintWriter(new FileWriter(output));
            try {
                out.println(configData.toJSON());
            }
            finally {
                out.close();
            }
        }
    }
}

