/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tps.config;

import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.config.ConfigCLI;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.dogtagpki.common.ConfigClient;
import org.dogtagpki.common.ConfigData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigShowCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(ConfigShowCLI.class);
    public ConfigCLI configCLI;

    public ConfigShowCLI(ConfigCLI configCLI) {
        super("show", "Show general properties", (CLI)configCLI);
        this.configCLI = configCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + "[OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "output", true, "Output file to store general properties.");
        option.setArgName("file");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 0) {
            throw new Exception("Too many arguments specified.");
        }
        String output = cmd.getOptionValue("output");
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        ConfigClient configClient = this.configCLI.getConfigClient();
        ConfigData configData = configClient.getConfig();
        if (output == null) {
            MainCLI.printMessage("Configuration");
            ConfigCLI.printConfigData(configData);
        } else {
            try (PrintWriter out = new PrintWriter(new FileWriter(output));){
                out.println(configData.toJSON());
            }
            MainCLI.printMessage("Stored configuration into " + output);
        }
    }
}

