/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.evaluators;

import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.evaluators.AccessEvaluator;
import com.netscape.cmscore.apps.CMS;
import org.dogtagpki.server.authentication.AuthToken;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPAddressAccessEvaluator
extends AccessEvaluator {
    public static Logger logger = LoggerFactory.getLogger(IPAddressAccessEvaluator.class);

    public IPAddressAccessEvaluator() {
        this.type = "ipaddress";
        this.description = "IP Address evaluator";
    }

    @Override
    public void init() {
    }

    @Override
    public String[] getSupportedOperators() {
        String[] s = new String[]{"=", "!="};
        return s;
    }

    @Override
    public boolean evaluate(AuthToken authToken, String type, String op, String value) {
        return this.evaluate(type, op, value);
    }

    @Override
    public boolean evaluate(String type, String op, String value) {
        SessionContext mSC = SessionContext.getContext();
        value = Utils.stripQuotes((String)value);
        String ipaddress = (String)mSC.get((Object)"ipAddress");
        if (type.equals(this.type)) {
            if (ipaddress == null) {
                logger.warn("IPAddressAccessEvaluator: " + CMS.getLogMessage("EVALUATOR_IPADDRESS_NULL", new Object[0]));
                return false;
            }
            boolean ipMatches = ipaddress.matches(value);
            return op.equals("=") ? ipMatches : !ipMatches;
        }
        return false;
    }
}

