/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.rest;

import com.netscape.certsrv.authentication.AuthMethodMapping;
import com.netscape.certsrv.authentication.ExternalAuthToken;
import com.netscape.certsrv.base.ForbiddenException;
import com.netscape.cms.realm.PKIPrincipal;
import com.netscape.cmscore.apps.CMS;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.HashSet;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;
import org.apache.catalina.realm.GenericPrincipal;
import org.dogtagpki.server.authentication.AuthToken;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.spi.Failure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class AuthMethodInterceptor
implements ContainerRequestFilter {
    public static Logger logger = LoggerFactory.getLogger(AuthMethodInterceptor.class);
    Properties properties;
    @Context
    ServletContext servletContext;
    @Context
    SecurityContext securityContext;

    public synchronized void loadProperties() throws IOException {
        if (this.properties != null) {
            return;
        }
        this.properties = new Properties();
        String context = this.servletContext.getContextPath();
        String subsystem = context.startsWith("/") ? context.substring(1) : context;
        String defaultMapping = "/usr/share/pki/" + subsystem + "/conf/auth-method.properties";
        logger.debug("AuthMethodInterceptor: loading " + defaultMapping);
        try (FileReader in = new FileReader(defaultMapping);){
            this.properties.load(in);
        }
        File customMapping = new File(CMS.getInstanceDir() + "/" + subsystem + "/conf/auth-method.properties");
        logger.debug("AuthMethodInterceptor: checking " + customMapping);
        if (customMapping.exists()) {
            logger.debug("AuthMethodInterceptor: loading " + customMapping);
            try (FileReader in = new FileReader(customMapping);){
                this.properties.load(in);
            }
        }
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        ResourceMethodInvoker methodInvoker = (ResourceMethodInvoker)requestContext.getProperty("org.jboss.resteasy.core.ResourceMethodInvoker");
        Method method = methodInvoker.getMethod();
        Class clazz = methodInvoker.getResourceClass();
        logger.debug("AuthMethodInterceptor: " + clazz.getSimpleName() + "." + method.getName() + "()");
        AuthMethodMapping authMapping = method.getAnnotation(AuthMethodMapping.class);
        if (authMapping == null) {
            authMapping = clazz.getAnnotation(AuthMethodMapping.class);
        }
        String name = authMapping == null ? "default" : authMapping.value();
        logger.debug("AuthMethodInterceptor: mapping: " + name);
        try {
            this.loadProperties();
            String value = this.properties.getProperty(name);
            HashSet<String> authMethods = new HashSet<String>();
            if (value != null) {
                for (String v : value.split(",")) {
                    authMethods.add(v.trim());
                }
            }
            logger.debug("AuthMethodInterceptor: required auth methods: " + authMethods);
            Principal principal = this.securityContext.getUserPrincipal();
            if (principal == null) {
                if (authMethods.isEmpty() || authMethods.contains("anonymous") || authMethods.contains("*")) {
                    logger.debug("AuthMethodInterceptor: anonymous access allowed");
                    return;
                }
                logger.error("AuthMethodInterceptor: anonymous access not allowed");
                throw new ForbiddenException("Anonymous access not allowed.");
            }
            AuthToken authToken = null;
            if (principal instanceof PKIPrincipal) {
                authToken = ((PKIPrincipal)((Object)principal)).getAuthToken();
            } else if (principal instanceof GenericPrincipal) {
                authToken = new ExternalAuthToken((GenericPrincipal)principal);
            }
            if (authToken == null) {
                logger.error("AuthMethodInterceptor: missing authentication token");
                throw new ForbiddenException("Missing authentication token.");
            }
            String authManager = authToken.getInString("authMgrInstName");
            logger.debug("AuthMethodInterceptor: authentication manager: " + authManager);
            if (authManager == null) {
                logger.error("AuthMethodInterceptor: missing authentication manager");
                throw new ForbiddenException("Missing authentication manager.");
            }
            if (authMethods.isEmpty() || authManager.equals("external") || authMethods.contains(authManager) || authMethods.contains("*")) {
                logger.debug("AuthMethodInterceptor: access granted");
                return;
            }
            throw new ForbiddenException("Authentication method not allowed.");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Failure((Throwable)e);
        }
    }
}

