/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.tps.TPSSession;
import org.dogtagpki.tps.TPSConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPSServlet
extends HttpServlet {
    public static Logger logger = LoggerFactory.getLogger(TPSServlet.class);
    private static final long serialVersionUID = -1092227495262381074L;

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String encoding = request.getHeader("Transfer-Encoding");
        String method = request.getMethod();
        logger.debug("Encoding: " + encoding);
        logger.debug("Method: " + method);
        if (!"POST".equals(method)) {
            response.setStatus(405);
            logger.warn("Returning 405 Method Not Allowed - the HTTP method must be POST");
            return;
        }
        if (!"chunked".equals(encoding)) {
            response.setStatus(400);
            logger.warn("Returning 400 Bad Request - Transfer-Encoding is not chunked");
            return;
        }
        response.setHeader("Transfer-Encoding", "chunked");
        response.flushBuffer();
        TPSConnection con = new TPSConnection((InputStream)request.getInputStream(), (OutputStream)response.getOutputStream(), true);
        logger.debug("TPSConnection created: " + con);
        String ipAddress = request.getRemoteAddr();
        TPSSession session = new TPSSession(con, ipAddress);
        logger.debug("TPSSession created: " + session);
        session.process();
        logger.debug("After session.process() exiting ...");
    }
}

