/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.processor;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotFound;
import com.netscape.certsrv.tps.token.TokenStatus;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.security.JssSubsystem;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.zip.DataFormatException;
import org.dogtagpki.server.tps.TPSEngine;
import org.dogtagpki.server.tps.TPSEngineConfig;
import org.dogtagpki.server.tps.TPSSession;
import org.dogtagpki.server.tps.TPSSubsystem;
import org.dogtagpki.server.tps.TPSTokenPolicy;
import org.dogtagpki.server.tps.TokenDBConfig;
import org.dogtagpki.server.tps.channel.SecureChannel;
import org.dogtagpki.server.tps.cms.CARemoteRequestHandler;
import org.dogtagpki.server.tps.cms.CARenewCertResponse;
import org.dogtagpki.server.tps.cms.CARetrieveCertResponse;
import org.dogtagpki.server.tps.cms.CARevokeCertResponse;
import org.dogtagpki.server.tps.cms.KRARecoverKeyResponse;
import org.dogtagpki.server.tps.cms.KRAServerSideKeyGenResponse;
import org.dogtagpki.server.tps.dbs.TPSCertRecord;
import org.dogtagpki.server.tps.dbs.TokenCertStatus;
import org.dogtagpki.server.tps.dbs.TokenRecord;
import org.dogtagpki.server.tps.main.AttributeSpec;
import org.dogtagpki.server.tps.main.ExternalRegAttrs;
import org.dogtagpki.server.tps.main.ExternalRegCertToRecover;
import org.dogtagpki.server.tps.main.ObjectSpec;
import org.dogtagpki.server.tps.main.PKCS11Obj;
import org.dogtagpki.server.tps.processor.AppletInfo;
import org.dogtagpki.server.tps.processor.CertEnrollInfo;
import org.dogtagpki.server.tps.processor.EnrolledCertsInfo;
import org.dogtagpki.server.tps.processor.TPSProcessor;
import org.dogtagpki.tps.main.TPSBuffer;
import org.dogtagpki.tps.main.TPSException;
import org.dogtagpki.tps.main.Util;
import org.dogtagpki.tps.msg.BeginOpMsg;
import org.dogtagpki.tps.msg.EndOpMsg;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.crypto.InvalidKeyFormatException;
import org.mozilla.jss.netscape.security.provider.RSAPublicKey;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.RevocationReason;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.pkcs11.PK11RSAPublicKey;
import org.mozilla.jss.pkix.primitive.SubjectPublicKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPSEnrollProcessor
extends TPSProcessor {
    public static Logger logger = LoggerFactory.getLogger(TPSEnrollProcessor.class);

    public TPSEnrollProcessor(TPSSession session) {
        super(session);
    }

    @Override
    public void process(BeginOpMsg beginMsg) throws TPSException, IOException {
        if (beginMsg == null) {
            throw new TPSException("TPSEnrollrocessor.process: invalid input data, not beginMsg provided.", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        this.setBeginMessage(beginMsg);
        this.setCurrentTokenOperation("enroll");
        this.checkIsExternalReg();
        this.enroll();
    }

    /*
     * Unable to fully structure code
     */
    private void enroll() throws TPSException, IOException {
        block61: {
            method = "TPSEnrollProcessor.enroll:";
            TPSEnrollProcessor.logger.debug(method + " entering...");
            logMsg = null;
            auditInfo = null;
            engine = TPSEngine.getInstance();
            jssSubsystem = engine.getJSSSubsystem();
            tps = (TPSSubsystem)engine.getSubsystem("tps");
            tokenPolicy = null;
            configStore = engine.getConfig();
            appletInfo = null;
            tokenRecord = null;
            lifecycleState = -16;
            appletUpgraded = 0;
            lifecycleState = this.getLifecycleState();
            try {
                appletInfo = this.getAppletInfo();
                this.auditOpRequest("enroll", appletInfo, "success", null);
            }
            catch (TPSException e) {
                auditInfo = e.toString();
                this.auditOpRequest("enroll", appletInfo, "failure", auditInfo);
                tps.tdb.tdbActivity("enrollment", tokenRecord, this.session.getIpAddress(), auditInfo, "failure");
                throw e;
            }
            appletInfo.setAid(this.getCardManagerAID());
            TPSEnrollProcessor.logger.debug(method + " token cuid: " + appletInfo.getCUIDhexStringPlain());
            isTokenPresent = false;
            tokenRecord = this.isTokenRecordPresent(appletInfo);
            if (tokenRecord != null) {
                TPSEnrollProcessor.logger.debug("{} found token... policy: {}", (Object)method, (Object)tokenRecord.getPolicy());
                isTokenPresent = true;
            } else {
                TPSEnrollProcessor.logger.debug(method + " token does not exist in tokendb... create one in memory");
                tokenRecord = new TokenRecord();
                tokenRecord.setId(appletInfo.getCUIDhexStringPlain());
                this.fillTokenRecordDefaultPolicy(tokenRecord);
            }
            this.fillTokenRecord(tokenRecord, appletInfo);
            cuid = appletInfo.getCUIDhexStringPlain();
            this.session.setTokenRecord(tokenRecord);
            tokenType = null;
            erAttrs = null;
            if (!this.isExternalReg) break block61;
            TPSEnrollProcessor.logger.debug(method + " isExternalReg: ON");
            configName = "externalReg.authId";
            try {
                authId = configStore.getString(configName);
            }
            catch (EBaseException e) {
                TPSEnrollProcessor.logger.error(method + " Internal Error obtaining mandatory config values: " + e.getMessage(), (Throwable)e);
                logMsg = "TPS error getting config values from config store." + e.toString();
                tps.tdb.tdbActivity("enrollment", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
                throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
            }
            userAuth = null;
            try {
                TPSEnrollProcessor.logger.debug(method + " isExternalReg: calling requestUserId");
                userAuth = this.getAuthentication(authId);
                this.processAuthentication("enroll", userAuth, cuid, tokenRecord);
                this.auditAuthSuccess(this.userid, this.currentTokenOperation, appletInfo, authId);
            }
            catch (Exception e) {
                this.auditAuthFailure(this.userid, this.currentTokenOperation, appletInfo, userAuth != null ? userAuth.getID() : null);
                TPSEnrollProcessor.logger.error(method + ": authentication exception thrown: " + e.getMessage(), (Throwable)e);
                logMsg = "ExternalReg authentication failed, status = STATUS_ERROR_LOGIN";
                tps.tdb.tdbActivity("enrollment", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
                throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_LOGIN);
            }
            try {
                erAttrs = this.processExternalRegAttrs(authId);
            }
            catch (Exception ee) {
                logMsg = "after processExternalRegAttrs: " + ee.toString();
                tps.tdb.tdbActivity("enrollment", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
                throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
            }
            TPSEnrollProcessor.logger.debug(method + " checking if record registrationtype matches currentTokenOperation.");
            if (erAttrs.getRegistrationType() == null || erAttrs.getRegistrationType().length() <= 0) ** GOTO lbl81
            if (erAttrs.getRegistrationType().equalsIgnoreCase(this.currentTokenOperation)) {
                TPSEnrollProcessor.logger.debug(method + ": --> registrationtype matches currentTokenOperation");
            } else {
                TPSEnrollProcessor.logger.debug(method + " Error: registrationType " + erAttrs.getRegistrationType() + " does not match currentTokenOperation " + this.currentTokenOperation);
                logMsg = "Improper Use of CRI, PIN Reset CRI used for Enrollment";
                tps.tdb.tdbActivity("enrollment", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
                throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_LOGIN);
lbl81:
                // 1 sources

                TPSEnrollProcessor.logger.debug(method + ": --> registrationtype attribute disabled or not found, continuing.");
            }
            if (erAttrs.getTokenCUID() == null) ** GOTO lbl94
            TPSEnrollProcessor.logger.debug(method + " checking if token cuid matches record cuid");
            TPSEnrollProcessor.logger.debug(method + " erAttrs.getTokenCUID()=" + erAttrs.getTokenCUID());
            TPSEnrollProcessor.logger.debug(method + " tokenRecord.getId()=" + tokenRecord.getId());
            if (tokenRecord.getId().equalsIgnoreCase(erAttrs.getTokenCUID())) {
                logMsg = "isExternalReg: token CUID matches record";
                TPSEnrollProcessor.logger.debug(method + (String)logMsg);
            } else {
                logMsg = "isExternalReg: token CUID not matching record:" + tokenRecord.getId() + " : " + erAttrs.getTokenCUID();
                TPSEnrollProcessor.logger.error(method + (String)logMsg);
                tps.tdb.tdbActivity("enrollment", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
                throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_NOT_TOKEN_OWNER);
lbl94:
                // 1 sources

                TPSEnrollProcessor.logger.debug(method + " no need to check if token cuid matches record");
            }
            this.session.setExternalRegAttrs(erAttrs);
            this.setExternalRegSelectedTokenType(erAttrs);
            TPSEnrollProcessor.logger.debug(method + " isExternalReg: about to process keySet resolver");
            try {
                resolverInstName = this.getKeySetResolverInstanceName();
                if (resolverInstName.equals("none") || this.selectedKeySet != null) ** GOTO lbl128
                mappingParams = this.createFilterMappingParams(resolverInstName, appletInfo.getCUIDhexStringPlain(), appletInfo.getMSNString(), appletInfo.getMajorVersion(), appletInfo.getMinorVersion());
                subsystem = (TPSSubsystem)engine.getSubsystem("tps");
                resolverInst = subsystem.getMappingResolverManager().getResolverInstance(resolverInstName);
                keySet = resolverInst.getResolvedMapping(mappingParams, "keySet");
                this.setSelectedKeySet(keySet);
                TPSEnrollProcessor.logger.debug(method + " resolved keySet: " + keySet);
            }
            catch (TPSException e) {
                logMsg = e.toString();
                tps.tdb.tdbActivity("format", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
                throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
            }
        }
        TPSEnrollProcessor.logger.debug(method + " isExternalReg: OFF");
        try {
            resolverInstName = this.getResolverInstanceName();
            if (!resolverInstName.equals("none") && this.selectedTokenType == null) {
                mappingParams = this.createFilterMappingParams(resolverInstName, appletInfo.getCUIDhexStringPlain(), appletInfo.getMSNString(), appletInfo.getMajorVersion(), appletInfo.getMinorVersion());
                subsystem = (TPSSubsystem)engine.getSubsystem("tps");
                resolverInst = subsystem.getMappingResolverManager().getResolverInstance(resolverInstName);
                tokenType = resolverInst.getResolvedMapping(mappingParams);
                this.setSelectedTokenType(tokenType);
                TPSEnrollProcessor.logger.debug(method + " resolved tokenType: " + tokenType);
            }
        }
        catch (TPSException e) {
            logMsg = e.toString();
            tps.tdb.tdbActivity("enrollment", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
            throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
lbl128:
        // 3 sources

        this.checkProfileStateOK();
        doForceFormat = false;
        if (!isTokenPresent) ** GOTO lbl152
        TPSEnrollProcessor.logger.debug(method + " token exists in tokendb");
        newState = TokenStatus.ACTIVE;
        this.checkInvalidTokenStatus(tokenRecord, "enrollment");
        if (!tps.isOperationTransitionAllowed(tokenRecord, newState)) {
            TPSEnrollProcessor.logger.error(method + " token transition disallowed " + tokenRecord.getTokenStatus() + " to " + newState);
            logMsg = "Operation for CUID " + cuid + " Disabled, illegal transition attempted " + tokenRecord.getTokenStatus() + " to " + newState;
            tps.tdb.tdbActivity("enrollment", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
            throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_DISABLED_TOKEN);
        }
        TPSEnrollProcessor.logger.debug(method + " token transition allowed " + tokenRecord.getTokenStatus() + " to " + newState);
        tokenPolicy = new TPSTokenPolicy(tps, cuid);
        doForceFormat = tokenPolicy.isForceTokenFormat();
        if (doForceFormat) {
            TPSEnrollProcessor.logger.debug(method + " Will force format first due to policy.");
        }
        if (this.isExternalReg || tokenPolicy.isAllowdTokenReenroll() || tokenPolicy.isAllowdTokenRenew()) {
            logMsg = "isExternalReg: skip token policy (reenroll, renewal) check";
            TPSEnrollProcessor.logger.debug(method + (String)logMsg);
        } else {
            TPSEnrollProcessor.logger.error(method + " token renewal or reEnroll disallowed");
            logMsg = "Operation renewal or reEnroll for CUID " + cuid + " Disabled";
            tps.tdb.tdbActivity("enrollment", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
            throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_DISABLED_TOKEN);
lbl152:
            // 1 sources

            TPSEnrollProcessor.logger.debug(method + " token does not exist");
            this.checkAllowUnknownToken("enroll");
            TPSEnrollProcessor.logger.debug(method + "force a format");
            doForceFormat = true;
        }
        if (!this.isExternalReg) {
            this.checkAndAuthenticateUser(appletInfo, this.getSelectedTokenType());
        }
        if (!(allowMultiTokens = this.checkAllowMultiActiveTokensUser(this.isExternalReg)) && (alreadyHasActiveToken = this.checkUserAlreadyHasOtherActiveToken(this.userid, cuid))) {
            throw new TPSException(method + " User already has an active token when trying to enroll this new token!", EndOpMsg.TPSStatus.STATUS_ERROR_HAS_AT_LEAST_ONE_ACTIVE_TOKEN);
        }
        if (doForceFormat) {
            this.format(true);
        } else {
            appletUpgraded = this.checkAndUpgradeApplet(appletInfo);
            appletInfo = this.getAppletInfo();
        }
        TPSEnrollProcessor.logger.debug(method + " Finished updating applet if needed.");
        channel = this.checkAndUpgradeSymKeys(appletInfo, tokenRecord);
        channel.externalAuthenticate();
        this.checkAndHandlePinReset(channel);
        tokenRecord.setKeyInfo(channel.getKeyInfoData().toHexStringPlain());
        tksConnId = this.getTKSConnectorID();
        plaintextChallenge = this.computeRandomData(16, tksConnId);
        wrappedChallenge = this.encryptData(appletInfo, channel.getKeyInfoData(), plaintextChallenge, tksConnId, this.getProtocol());
        pkcs11objx = null;
        try {
            pkcs11objx = this.getCurrentObjectsOnToken(channel);
        }
        catch (DataFormatException e) {
            logMsg = method + " Failed to parse original token data: " + e.toString();
            tps.tdb.tdbActivity("enrollment", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
            throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_CANNOT_PERFORM_OPERATION);
        }
        pkcs11objx.setCUID(appletInfo.getCUID());
        this.statusUpdate(10, "PROGRESS_PROCESS_PROFILE");
        certsInfo = new EnrolledCertsInfo();
        certsInfo.setWrappedChallenge(wrappedChallenge);
        certsInfo.setPlaintextChallenge(plaintextChallenge);
        certsInfo.setPKCS11Obj(pkcs11objx);
        certsInfo.setStartProgress(15);
        certsInfo.setEndProgress(90);
        renewed = false;
        recovered = false;
        status = EndOpMsg.TPSStatus.STATUS_NO_ERROR;
        if (!this.isExternalReg) {
            status = this.generateCertsAfterRenewalRecoveryPolicy(certsInfo, channel, appletInfo);
        }
        logMsg = " generateCertsAfterRenewalRecoveryPolicy returned status=" + status;
        statusString = "Unknown";
        if (status == EndOpMsg.TPSStatus.STATUS_NO_ERROR) {
            statusString = "Enrollment to follow";
        } else if (status == EndOpMsg.TPSStatus.STATUS_RECOVERY_IS_PROCESSED) {
            statusString = "Recovery processed";
            recovered = true;
            tps.tdb.tdbActivity("recovery", tokenRecord, this.session.getIpAddress(), (String)logMsg, "success");
        } else if (status == EndOpMsg.TPSStatus.STATUS_RENEWAL_IS_PROCESSED) {
            statusString = "Renewal processed";
            renewed = true;
            tps.tdb.tdbActivity("renewal", tokenRecord, this.session.getIpAddress(), (String)logMsg, "success");
        } else {
            TPSEnrollProcessor.logger.error(method + (String)logMsg);
            tps.tdb.tdbActivity("enrollment", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
            throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        if (!this.isExternalReg) {
            logMsg = "generateCertsAfterRenewalRecoveryPolicy returns status:" + status.code + " : " + statusString;
            TPSEnrollProcessor.logger.debug(method + (String)logMsg);
        }
        if (status == EndOpMsg.TPSStatus.STATUS_NO_ERROR) {
            if (this.generateCertificates(certsInfo, channel, appletInfo)) {
                TPSEnrollProcessor.logger.debug(method + "generateCertificates returned true means cert enrollment successful");
                if (this.isExternalReg) {
                    try {
                        recoverStatus = this.externalRegRecover(cuid, this.userid, channel, certsInfo, appletInfo, tokenRecord);
                        TPSEnrollProcessor.logger.debug(method + " after externalRegRecover status is:" + recoverStatus);
                        if (recoverStatus != EndOpMsg.TPSStatus.STATUS_RECOVERY_IS_PROCESSED) {
                            logMsg = method + " externalRegRecover returned: recoverStatus=" + recoverStatus;
                            TPSEnrollProcessor.logger.error((String)logMsg);
                            tps.tdb.tdbActivity("recovery", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
                            throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_RECOVERY_FAILED);
                        }
                        recovered = true;
                        logMsg = method + " externalRegRecover returned: recoverStatus=" + recoverStatus;
                        tps.tdb.tdbActivity("recovery", tokenRecord, this.session.getIpAddress(), (String)logMsg, "success");
                    }
                    catch (EBaseException e) {
                        logMsg = method + " externalRegRecover: " + e.getMessage();
                        TPSEnrollProcessor.logger.error((String)logMsg, (Throwable)e);
                        tps.tdb.tdbActivity("recovery", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
                        throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_RECOVERY_FAILED);
                    }
                }
            } else {
                TPSEnrollProcessor.logger.error(method + "generateCertificates returned false means cert enrollment unsuccessful");
                if (!this.isExternalReg) {
                    TPSEnrollProcessor.logger.warn(method + "generateCertificates returned false means some certs failed enrollment;  clean up (format) the token");
                    this.format(true);
                }
                tps.tdb.tdbActivity("enrollment", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
                throw new TPSException("generateCertificates failed", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
            }
        }
        if (!this.isExternalReg && status == EndOpMsg.TPSStatus.STATUS_RENEWAL_IS_PROCESSED && tokenPolicy.isAllowdTokenRenew()) {
            renewed = true;
            TPSEnrollProcessor.logger.debug(method + " renewal happened.. ");
        }
        tokenLabel = this.buildTokenLabel(certsInfo, appletInfo);
        pkcs11objx.setTokenName(new TPSBuffer(tokenLabel.getBytes()));
        lastObjVer = pkcs11objx.getOldObjectVersion();
        TPSEnrollProcessor.logger.debug(method + " getOldObjectVersion: returning: " + lastObjVer);
        if (lastObjVer != 0) {
            while (lastObjVer == 255) {
                randomGenerator = jssSubsystem.getRandomNumberGenerator();
                lastObjVer = randomGenerator.nextInt(1000);
            }
            TPSEnrollProcessor.logger.debug(method + " Setting objectVersion to: " + ++lastObjVer);
            pkcs11objx.setObjectVersion(lastObjVer);
        }
        pkcs11objx.setFormatVersion(pkcs11objx.getOldFormatVersion());
        channel = this.setupSecureChannel(appletInfo);
        this.statusUpdate(92, "PROGRESS_WRITE_OBJECTS");
        if (this.isExternalReg && (status = this.cleanObjectListBeforeExternalRecovery(certsInfo)) != EndOpMsg.TPSStatus.STATUS_NO_ERROR) {
            throw new TPSException("cleanObjectListBeforeExternalRecovery returns error: " + status, EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        this.writeFinalPKCS11ObjectToToken(pkcs11objx, appletInfo, channel);
        this.statusUpdate(98, "PROGRESS_ISSUER_INFO");
        this.writeIssuerInfoToToken(channel, appletInfo);
        this.statusUpdate(99, "PROGRESS_SET_LIFECYCLE");
        if (lifecycleState != 15 || appletUpgraded == 1) {
            TPSEnrollProcessor.logger.debug(method + " Need to reset the lifecycle state. current state: " + lifecycleState + " Was applet upgraded: " + appletUpgraded);
            channel.setLifecycleState((byte)15);
            TPSEnrollProcessor.logger.debug(method + " after channel.setLifecycleState");
        } else {
            TPSEnrollProcessor.logger.debug(method + " No need to reset lifecycle state, it is already at the proper value.");
        }
        erCertsToRecover = null;
        erAttrs = this.session.getExternalRegAttrs();
        if (this.isExternalReg && erAttrs != null) {
            erCertsToRecover = erAttrs.getCertsToRecover();
        }
        TPSEnrollProcessor.logger.debug(method + " updating tokendb with certs.");
        try {
            tps.tdb.tdbRemoveCertificatesByCUID(tokenRecord.getId(), erCertsToRecover);
        }
        catch (Exception e) {
            logMsg = "Attempt to clean up record with tdbRemoveCertificatesByCUID failed; token probably clean; continue anyway: " + e.getMessage();
            TPSEnrollProcessor.logger.warn(method + (String)logMsg, (Throwable)e);
        }
        certRecords = certsInfo.toTPSCertRecords(tokenRecord.getId(), tokenRecord.getUserID());
        TPSEnrollProcessor.logger.debug(method + " adding certs to token with tdbAddCertificatesForCUID...");
        try {
            tps.tdb.tdbAddCertificatesForCUID(tokenRecord.getId(), certRecords);
            TPSEnrollProcessor.logger.debug(method + " tokendb updated with certs to the cuid so that it reflects what's on the token");
        }
        catch (TPSException e) {
            TPSEnrollProcessor.logger.debug(method + " Exception occurred in tdbAddCertificatesForCUID: " + e.getMessage());
            try {
                this.auditEnrollment(this.userid, "enrollment", appletInfo, "failure", channel.getKeyInfoData().toHexStringPlain(), null, null, e.getMessage());
                tps.tdb.tdbActivity("enrollment", tokenRecord, this.session.getIpAddress(), e.getMessage(), "failure");
            }
            catch (Exception f) {
                TPSEnrollProcessor.logger.debug(method + " Failed to log previous exception: " + f);
            }
        }
        finalAppletVersion = appletInfo.getFinalAppletVersion();
        if (finalAppletVersion == null) {
            finalAppletVersion = "(null)";
        }
        logMsg = "appletVersion=" + finalAppletVersion + "; tokenType=" + this.selectedTokenType + "; userid=" + this.userid;
        TPSEnrollProcessor.logger.debug(method + (String)logMsg);
        try {
            tokenRecord.setTokenStatus(TokenStatus.ACTIVE);
            tps.tdb.tdbUpdateTokenEntry(tokenRecord);
            tps.tdb.tdbActivity("enrollment", tokenRecord, this.session.getIpAddress(), (String)logMsg, "success");
        }
        catch (Exception e) {
            logMsg = (String)logMsg + ":" + e.toString();
            tps.tdb.tdbActivity("enrollment", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
            throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_UPDATE_TOKENDB_FAILED);
        }
        keyList = pkcs11objx.getKeyIndexList();
        channel.clearAppletKeySlotData(keyList);
        TPSEnrollProcessor.logger.debug(method + " leaving ...");
        this.statusUpdate(100, "PROGRESS_DONE_ENROLLMENT");
    }

    private EndOpMsg.TPSStatus cleanObjectListBeforeExternalRecovery(EnrolledCertsInfo certsInfo) {
        EndOpMsg.TPSStatus status = EndOpMsg.TPSStatus.STATUS_NO_ERROR;
        String method = "TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery :";
        int MAX_CERTS = 30;
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        int[] certsToDelete = new int[30];
        int[] certsToSave = new int[30];
        int numCertsToDelete = 0;
        int numCertsToSave = 0;
        logger.debug("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery :: begins");
        if (certsInfo == null) {
            logger.warn("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery :certsInfo cannot be null");
            return EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION;
        }
        PKCS11Obj pkcs11obj = certsInfo.getPKCS11Obj();
        if (pkcs11obj == null) {
            logger.warn("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery :no pkcs11obj to work with");
            return EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION;
        }
        ExternalRegAttrs erAttrs = this.session.getExternalRegAttrs();
        if (this.session == null || erAttrs == null || erAttrs.getCertsToRecover() == null) {
            logger.warn("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery :no externalReg attrs to work with");
            return EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION;
        }
        int count = erAttrs.getCertsToRecoverCount();
        logger.debug("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery :number of certs to recover=" + count);
        if (count == 0) {
            logger.warn("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery : nothing to process. Returning status: " + status);
            return status;
        }
        String tokenType = erAttrs.getTokenType();
        if (tokenType == null) {
            logger.warn("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery : erAttrs tokenType null. Returning status: " + status);
            return EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION;
        }
        String configName = "op.enroll." + tokenType + ".keyGen.keyType.num";
        int keyTypeNum = 0;
        try {
            logger.debug("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery : getting config : " + configName);
            Integer keyTypeNumI = configStore.getInteger(configName);
            keyTypeNum = keyTypeNumI;
        }
        catch (Exception e) {
            keyTypeNum = 0;
        }
        logger.debug("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery : config keyTypeNum: " + keyTypeNum);
        int index = -1;
        for (int i = 0; i < keyTypeNum; ++i) {
            String certId;
            String keyTypeValue;
            configName = "op.enroll." + tokenType + ".keyGen.keyType.value." + i;
            try {
                logger.debug("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery : getting config : " + configName);
                keyTypeValue = configStore.getString(configName);
            }
            catch (EPropertyNotFound e) {
                logger.warn("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery :" + e.getMessage(), (Throwable)e);
                return EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION;
            }
            catch (EBaseException e) {
                logger.warn("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery :" + e.getMessage(), (Throwable)e);
                return EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION;
            }
            logger.debug("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery : config keyTypeValue: " + keyTypeValue);
            String keyTypePrefix = "op.enroll." + tokenType + ".keyGen." + keyTypeValue;
            logger.debug("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery : keyTypePrefix is: " + keyTypePrefix);
            configName = keyTypePrefix + ".certId";
            try {
                logger.debug("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery : getting config : " + configName);
                certId = configStore.getString(configName);
            }
            catch (EPropertyNotFound e) {
                logger.warn("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery :" + e.getMessage(), (Throwable)e);
                return EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION;
            }
            catch (EBaseException e) {
                logger.warn("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery :" + e.getMessage(), (Throwable)e);
                return EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION;
            }
            if (certId != null && certId.length() > 1) {
                index = ObjectSpec.getObjectIndex(certId);
            }
            if (index < 0 || numCertsToSave >= 30) continue;
            logger.debug("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery : saving object index to certsToSave: " + index);
            certsToSave[numCertsToSave++] = index;
        }
        int num_objs = pkcs11obj.getObjectSpecCount();
        logger.debug("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery : pkcs11obj num_objs =" + num_objs);
        block11: for (int i = 0; i < num_objs; ++i) {
            ObjectSpec os = pkcs11obj.getObjectSpec(i);
            char type = os.getObjectType();
            int objIndex = os.getObjectIndex();
            logger.debug("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery :i=" + i + " objIndex =" + objIndex);
            if (type == 'C') {
                logger.debug("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery :obj type is cert... processing");
                for (int j = 0; j < os.getAttributeSpecCount(); ++j) {
                    AttributeSpec as = os.getAttributeSpec(j);
                    if (as.getAttributeID() != 17L) continue;
                    if (as.getType() != 0) continue block11;
                    TPSBuffer certBuff = as.getValue();
                    X509CertImpl xCert = null;
                    try {
                        xCert = new X509CertImpl(certBuff.toBytesArray());
                    }
                    catch (CertificateException e) {
                        logger.error("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery :" + e.getMessage(), (Throwable)e);
                        return EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU;
                    }
                    ExternalRegCertToRecover certToRecover = this.isInCertsToRecoverList(xCert);
                    int certId = objIndex;
                    if (certToRecover == null) {
                        logger.debug("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery : cert not found in recovery list, possible deletion... id:" + certId);
                        boolean protect = false;
                        for (int p = 0; p < numCertsToSave; ++p) {
                            if (certsToSave[p] != certId) continue;
                            protect = true;
                            break;
                        }
                        logger.debug("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery : protect cert " + certId + ": " + protect);
                        if (numCertsToDelete >= 30 || protect) continue block11;
                        certsToDelete[numCertsToDelete++] = certId;
                        continue block11;
                    }
                    logger.debug("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery : cert found in recovery list, to be retained. id:" + certId);
                    if (!certToRecover.getIsRetainable()) continue block11;
                    logger.debug("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery :cert is retainable; add to certsInfo");
                    certsInfo.addCertificate(xCert);
                    continue block11;
                }
                continue;
            }
            logger.debug("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery :obj type is not cert... next");
        }
        logger.debug("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery :numCertsToDelete: " + numCertsToDelete);
        for (int k = 0; k < numCertsToDelete; ++k) {
            logger.debug("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery :cert to delete: " + certsToDelete[k]);
            this.removeCertFromObjectList(certsToDelete[k], pkcs11obj);
        }
        num_objs = pkcs11obj.getObjectSpecCount();
        logger.debug("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery :after removeCertFromObjectList(); final obj count: " + num_objs);
        logger.debug("TPSEnrollProcessor.cleanObjectListBeforeExternalRecovery : ends. Returning status: " + status);
        return status;
    }

    void removeCertFromObjectList(int cIndex, PKCS11Obj pkcs11obj) {
        String method = "TPSEnrollProcessor.removeCertFromObjectList: ";
        if (pkcs11obj == null) {
            logger.debug(method + " pkcs11obj null");
            return;
        }
        logger.debug(method + " index of cert to delete is: " + cIndex);
        int C = cIndex;
        int c = cIndex;
        int k1 = 2 * cIndex;
        int k2 = 2 * cIndex + 1;
        int index = 0;
        for (int i = 0; i < pkcs11obj.getObjectSpecCount(); ++i) {
            ObjectSpec spec = pkcs11obj.getObjectSpec(i);
            char c1 = spec.getObjectType();
            index = spec.getObjectIndex();
            if (!(c1 != 'c' && c1 != 'C' || index != C && index != c)) {
                logger.debug(method + " found index:" + index + "; Removing cert Object");
                pkcs11obj.removeObjectSpec(i);
                --i;
            }
            if (c1 != 'k' || index != k1 && index != k2) continue;
            logger.debug(method + " found index:" + index + "; Removing key Object");
            pkcs11obj.removeObjectSpec(i);
            --i;
        }
    }

    private void writeFinalPKCS11ObjectToToken(PKCS11Obj pkcs11objx, AppletInfo ainfo, SecureChannel channel) throws TPSException, IOException {
        String method = "TPSEnrollProcessor.writeFinalPKCS11ObjectToToken";
        if (pkcs11objx == null || ainfo == null || channel == null) {
            throw new TPSException("TPSErollProcessor.writeFinalPKCS11ObjectToToken: invalid input data!", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        logger.debug("TPSEnrollProcessor.writeFinalPKCS11ObjectToToken:  entering...");
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String compressConfig = "op." + this.currentTokenOperation + "." + this.selectedTokenType + ".pkcs11obj.compress.enable";
        logger.debug("TPSEnrollProcessor.writeFinalPKCS11ObjectToToken:  config to check: " + compressConfig);
        boolean doCompress = false;
        try {
            doCompress = configStore.getBoolean(compressConfig, true);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSEnrollProcessor.writeFinalPKCS11ObjectToToken: internal error obtaining config value " + e);
        }
        logger.debug("TPSEnrollProcessor.writeFinalPKCS11ObjectToToken:  doCompress: " + doCompress);
        TPSBuffer tokenData = null;
        tokenData = doCompress ? pkcs11objx.getCompressedData() : pkcs11objx.getData();
        if (tokenData.size() > ainfo.getTotalMem()) {
            throw new TPSException("TPSEnrollProcessor.writeFinalPKCS11ObjectToToken:  NOt enough memory to write certificates!", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        byte[] zobjectid = new byte[]{122, 48, 0, 0};
        byte[] perms = new byte[]{-1, -1, 64, 0, 64, 0};
        TPSBuffer zobjidBuf = new TPSBuffer(zobjectid);
        channel.createObject(zobjidBuf, new TPSBuffer(perms), tokenData.size());
        channel.writeObject(zobjidBuf, tokenData);
        logger.debug("TPSEnrollProcessor.writeFinalPKCS11ObjectToToken:  leaving successfully ...");
    }

    private PKCS11Obj getCurrentObjectsOnToken(SecureChannel channel) throws TPSException, IOException, DataFormatException {
        String method = "TPSEnrollProcessor.getCurrentObjectsOnToken";
        byte seq = 0;
        TPSBuffer objects = null;
        int lastFormatVersion = 256;
        TPSEngine engine = TPSEngine.getInstance();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        SecureRandom randomGenerator = jssSubsystem.getRandomNumberGenerator();
        int lastObjectVersion = randomGenerator.nextInt(1000);
        logger.debug("TPSEnrollProcessor.getCurrentObjectsOnToken: Random lastObjectVersion: " + lastObjectVersion);
        PKCS11Obj pkcs11objx = new PKCS11Obj();
        pkcs11objx.setOldFormatVersion(lastFormatVersion);
        pkcs11objx.setOldObjectVersion(lastObjectVersion);
        do {
            if ((objects = this.listObjects(seq)) != null) {
                logger.debug("TPSEnrollProcessor.getCurrentObjectsOnToken: objects exist ");
            }
            if (objects == null) {
                pkcs11objx.setOldObjectVersion(lastObjectVersion);
                seq = 0;
                continue;
            }
            seq = 1;
            TPSBuffer objectID = objects.substr(0, 4);
            TPSBuffer objectLen = objects.substr(4, 4);
            long objectIDVal = objectID.getLongFrom4Bytes(0);
            long objectLenVal = objectLen.getLongFrom4Bytes(0);
            TPSBuffer obj = channel.readObject(objectID, 0, (int)objectLenVal);
            if (obj != null) {
                logger.debug("TPSEnrollProcessor.getCurrentObjectsOnToken: obj exists");
            }
            if ((char)objectID.at(0) == 'z' && objectID.at(1) == 48) {
                lastFormatVersion = obj.getIntFrom2Bytes(0);
                lastObjectVersion = obj.getIntFrom2Bytes(2);
                logger.debug("TPSEnrollProcessor.getCurrentObjectsOnToken: Versions read from token:  lastFormatVersion : " + lastFormatVersion + " lastObjectVersion: " + lastObjectVersion);
                pkcs11objx = PKCS11Obj.parse(obj, 0);
                pkcs11objx.setOldFormatVersion(lastFormatVersion);
                pkcs11objx.setOldObjectVersion(lastObjectVersion);
                seq = 0;
            } else {
                ObjectSpec objSpec = ObjectSpec.parseFromTokenData(objectIDVal, obj);
                pkcs11objx.addObjectSpec(objSpec);
            }
            logger.debug("TPSEnrollProcessor.getCurrentObjectsOnToken: just read object from token");
        } while (seq != 0);
        return pkcs11objx;
    }

    private ExternalRegCertToRecover isInCertsToRecoverList(X509CertImpl xCert) {
        String method = "TPSEnrollProcessor.isInCertsToRecoverList :";
        ExternalRegCertToRecover foundObj = null;
        if (xCert == null) {
            logger.warn("TPSEnrollProcessor.isInCertsToRecoverList :xCert is null. return false");
            return null;
        }
        ExternalRegAttrs erAttrs = this.session.getExternalRegAttrs();
        ArrayList<ExternalRegCertToRecover> erCertsToRecover = erAttrs.getCertsToRecover();
        logger.debug("TPSEnrollProcessor.isInCertsToRecoverList : begins checking for cert, serial:" + xCert.getSerialNumber());
        int count = erAttrs.getCertsToRecoverCount();
        if (count <= 0) {
            logger.warn("TPSEnrollProcessor.isInCertsToRecoverList :ends. recover list empty. returning: null");
            return null;
        }
        for (ExternalRegCertToRecover certToRecover : erCertsToRecover) {
            if (certToRecover == null || xCert.getSerialNumber().compareTo(certToRecover.getSerial()) != 0) continue;
            foundObj = certToRecover;
            break;
        }
        logger.debug("TPSEnrollProcessor.isInCertsToRecoverList : ends. returning certToRecover");
        return foundObj;
    }

    private EndOpMsg.TPSStatus generateCertsAfterRenewalRecoveryPolicy(EnrolledCertsInfo certsInfo, SecureChannel channel, AppletInfo aInfo) throws TPSException, IOException {
        Object logMsg;
        EndOpMsg.TPSStatus status = EndOpMsg.TPSStatus.STATUS_NO_ERROR;
        String method = "TPSEnrollProcessor.generateCertsAfterRenewalRecoveryPolicy";
        logger.debug("TPSEnrollProcessor.generateCertsAfterRenewalRecoveryPolicy: begins");
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        TPSSubsystem tps = (TPSSubsystem)engine.getSubsystem("tps");
        TPSTokenPolicy tokenPolicy = null;
        ArrayList<TokenRecord> tokenRecords = null;
        try {
            tokenRecords = tps.tdb.tdbFindTokenRecordsByUID(this.userid);
        }
        catch (Exception e) {
            String logMsg2 = "no token associated with user: " + this.userid + ": " + e.getMessage();
            logger.error("TPSEnrollProcessor.generateCertsAfterRenewalRecoveryPolicy" + logMsg2, (Throwable)e);
            throw new TPSException(logMsg2, EndOpMsg.TPSStatus.STATUS_ERROR_INACTIVE_TOKEN_NOT_FOUND);
        }
        logger.debug("TPSEnrollProcessor.generateCertsAfterRenewalRecoveryPolicy found " + tokenRecords.size() + " tokens for user:" + this.userid);
        boolean isRecover = false;
        TokenRecord lostToken = null;
        for (TokenRecord tokenRecord : tokenRecords) {
            logger.debug("TPSEnrollProcessor.generateCertsAfterRenewalRecoveryPolicy token id:" + tokenRecord.getId() + "; status=" + tokenRecord.getTokenStatus());
            if (tokenRecord.getId().equals(aInfo.getCUIDhexStringPlain())) {
                logMsg = "found current token entry";
                logger.debug("TPSEnrollProcessor.generateCertsAfterRenewalRecoveryPolicy:" + (String)logMsg);
                if (tokenRecord.getTokenStatus() == TokenStatus.FORMATTED) {
                    if (tokenRecords.size() == 1) {
                        logger.debug("TPSEnrollProcessor.generateCertsAfterRenewalRecoveryPolicy: need to do enrollment");
                        break;
                    }
                    logger.debug("TPSEnrollProcessor.generateCertsAfterRenewalRecoveryPolicy: There are multiple token entries for user " + this.userid);
                    if (this.checkUserAlreadyHasActiveToken(this.userid)) continue;
                    isRecover = true;
                    continue;
                }
                if (tokenRecord.getTokenStatus() == TokenStatus.ACTIVE) {
                    tokenPolicy = new TPSTokenPolicy(tps, aInfo.getCUIDhexStringPlain());
                    if (tokenPolicy.isAllowdTokenRenew()) {
                        return this.processRenewal(certsInfo, channel, aInfo, tokenRecord);
                    }
                    logMsg = "token is already active; can't renew because renewal is not allowed; will re-enroll if allowed";
                    logger.debug("TPSEnrollProcessor.generateCertsAfterRenewalRecoveryPolicy:" + (String)logMsg);
                    break;
                }
                if (tokenRecord.getTokenStatus() == TokenStatus.TERMINATED) {
                    logMsg = "terminated token cuid=" + aInfo.getCUIDhexStringPlain() + " cannot be reused";
                    logger.error("TPSEnrollProcessor.generateCertsAfterRenewalRecoveryPolicy:" + (String)logMsg);
                    throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_TOKEN_TERMINATED);
                }
                if (tokenRecord.getTokenStatus() == TokenStatus.PERM_LOST) {
                    logMsg = "This token cannot be reused because it has been reported lost";
                    logger.error("TPSEnrollProcessor.generateCertsAfterRenewalRecoveryPolicy: " + (String)logMsg);
                    throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_UNUSABLE_TOKEN_KEYCOMPROMISE);
                }
                if (tokenRecord.getTokenStatus() == TokenStatus.SUSPENDED) {
                    logMsg = "User needs to contact administrator to report lost token (it should be put on Hold).";
                    logger.debug("TPSEnrollProcessor.generateCertsAfterRenewalRecoveryPolicy: " + (String)logMsg);
                    break;
                }
                if (tokenRecord.getTokenStatus() == TokenStatus.DAMAGED) {
                    logMsg = "This destroyed lost case should not be executed because the token is so damaged. It should not get here";
                    logger.error("TPSEnrollProcessor.generateCertsAfterRenewalRecoveryPolicy: " + (String)logMsg);
                    throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_DISABLED_TOKEN);
                }
                logMsg = "No such token status for this cuid=" + aInfo.getCUIDhexStringPlain();
                logger.error("TPSEnrollProcessor.generateCertsAfterRenewalRecoveryPolicy:" + (String)logMsg);
                throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_NO_SUCH_TOKEN_STATE);
            }
            logMsg = "found token entry different from current token";
            logger.debug("TPSEnrollProcessor.generateCertsAfterRenewalRecoveryPolicy:" + (String)logMsg);
            TokenStatus st = tokenRecord.getTokenStatus();
            if (st != TokenStatus.PERM_LOST && st != TokenStatus.SUSPENDED && st != TokenStatus.DAMAGED) continue;
            lostToken = tokenRecord;
            logMsg = "found a lost token: cuid = " + tokenRecord.getId();
            logger.debug("TPSEnrollProcessor.generateCertsAfterRenewalRecoveryPolicy:" + (String)logMsg);
        }
        if (isRecover) {
            if (lostToken == null) {
                logMsg = "No lost token to be recovered; do enrollment";
                logger.debug("TPSEnrollProcessor.generateCertsAfterRenewalRecoveryPolicy:" + (String)logMsg);
            } else {
                String reasonStr = lostToken.getReason();
                logMsg = "isRecover true; reasonStr =" + reasonStr;
                logger.debug("TPSEnrollProcessor.generateCertsAfterRenewalRecoveryPolicy:" + (String)logMsg);
                if (reasonStr.equals("keyCompromise")) {
                    return this.processRecovery(lostToken, certsInfo, channel, aInfo);
                }
                if (reasonStr.equals("onHold")) {
                    configStore = engine.getConfig();
                    String configName = "op.enroll." + this.getSelectedTokenType() + ".temporaryToken.tokenType";
                    try {
                        String tmpTokenType = configStore.getString(configName);
                        this.setSelectedTokenType(tmpTokenType);
                    }
                    catch (EPropertyNotFound e) {
                        logMsg = " configuration " + configName + " not found: " + e.getMessage();
                        logger.error("TPSEnrollProcessor.generateCertsAfterRenewalRecoveryPolicy:" + (String)logMsg, (Throwable)e);
                        throw new TPSException("TPSEnrollProcessor.generateCertsAfterRenewalRecoveryPolicy:" + (String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
                    }
                    catch (EBaseException e) {
                        logMsg = " configuration " + configName + " not found: " + e.getMessage();
                        logger.error("TPSEnrollProcessor.generateCertsAfterRenewalRecoveryPolicy:" + (String)logMsg, (Throwable)e);
                        throw new TPSException("TPSEnrollProcessor.generateCertsAfterRenewalRecoveryPolicy:" + (String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
                    }
                    return this.processRecovery(lostToken, certsInfo, channel, aInfo);
                }
                if (reasonStr.equals("destroyed")) {
                    return this.processRecovery(lostToken, certsInfo, channel, aInfo);
                }
                logMsg = "No such lost reason: " + reasonStr + " for this cuid: " + aInfo.getCUIDhexStringPlain();
                logger.error("TPSEnrollProcessor.generateCertsAfterRenewalRecoveryPolicy:" + (String)logMsg);
                throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_NO_SUCH_LOST_REASON);
            }
        }
        logger.debug("TPSEnrollProcessor.generateCertsAfterRenewalRecoveryPolicy: ends");
        return status;
    }

    private EndOpMsg.TPSStatus externalRegRecover(String cuid, String userid, SecureChannel channel, EnrolledCertsInfo certsInfo, AppletInfo appletInfo, TokenRecord tokenRecord) throws EBaseException, IOException {
        String method = "TPSEnrollProcessor.externalRegRecover:";
        logger.debug(method + "begins");
        EndOpMsg.TPSStatus status = EndOpMsg.TPSStatus.STATUS_RECOVERY_IS_PROCESSED;
        if (this.session == null || this.session.getExternalRegAttrs() == null || this.session.getExternalRegAttrs().getCertsToRecover() == null) {
            logger.debug(method + "nothing to recover...");
            return status;
        }
        if (certsInfo == null) {
            logger.warn(method + "method param certsInfo cannot be null");
            return status;
        }
        logger.debug(method + "currentCertIndex = " + certsInfo.getCurrentCertIndex());
        TPSEngine engine = TPSEngine.getInstance();
        TPSSubsystem tps = (TPSSubsystem)engine.getSubsystem("tps");
        ArrayList<CertEnrollInfo> preRecoveredCerts = certsInfo.getExternalRegRecoveryEnrollList();
        logger.debug(method + "number of certs to recover=" + this.session.getExternalRegAttrs().getCertsToRecoverCount());
        ArrayList<ExternalRegCertToRecover> erCertsToRecover = this.session.getExternalRegAttrs().getCertsToRecover();
        for (ExternalRegCertToRecover erCert : erCertsToRecover) {
            BigInteger keyid = erCert.getKeyid();
            BigInteger serial = erCert.getSerial();
            String caConn = erCert.getCaConn();
            String kraConn = erCert.getKraConn();
            if (serial == null || caConn == null) {
                logger.warn(method + "invalid exterenalReg cert");
                status = EndOpMsg.TPSStatus.STATUS_ERROR_RECOVERY_FAILED;
                return status;
            }
            Object logMsg = "ExternalReg cert record: serial=" + serial.toString();
            logger.debug(method + (String)logMsg);
            CARemoteRequestHandler caRH = new CARemoteRequestHandler(caConn);
            CARetrieveCertResponse certResp = caRH.retrieveCertificate(serial);
            if (certResp == null) {
                logMsg = "In recovery mode, CARetieveCertResponse object not found!";
                logger.warn(method + (String)logMsg);
                return EndOpMsg.TPSStatus.STATUS_ERROR_RECOVERY_FAILED;
            }
            String retCertB64 = certResp.getCertB64();
            if (retCertB64 == null) {
                logMsg = "recovering cert b64 not found";
                logger.warn(method + (String)logMsg);
                return EndOpMsg.TPSStatus.STATUS_ERROR_RECOVERY_FAILED;
            }
            logger.debug(method + "recovered retCertB64");
            TokenCertStatus recoveredCertStatus = this.getRetrievedCertStatus(certResp);
            if (recoveredCertStatus != TokenCertStatus.ACTIVE && !this.allowRecoverInvalidCert()) {
                logMsg = "invalid cert not allowed on token per policy; serial=" + serial.toString() + "; cert status=" + recoveredCertStatus.toString();
                logger.warn(method + (String)logMsg);
                return EndOpMsg.TPSStatus.STATUS_ERROR_RECOVERY_FAILED;
            }
            certsInfo.addCertStatus(recoveredCertStatus);
            String b64cert = null;
            if (!this.getExternalRegRecoverByKeyID()) {
                b64cert = certResp.getCertB64();
            }
            if (keyid == null) {
                logMsg = " no keyid; retention; skip key recovery; continue";
                logger.debug(method + (String)logMsg);
                continue;
            }
            logMsg = " keyid in user record: " + keyid.toString();
            logger.debug(method + (String)logMsg);
            if (!this.getExternalRegRecoverByKeyID() && keyid.compareTo(BigInteger.valueOf(0L)) != 0) {
                logMsg = " Recovering by cert; keyid is irrelevant from user record";
                logger.debug(method + (String)logMsg);
            }
            KRARecoverKeyResponse keyResp = null;
            if (kraConn != null) {
                logMsg = "kraConn not null:" + kraConn;
                logger.debug(method + (String)logMsg);
                if (channel.getDRMWrappedDesKey() == null) {
                    logMsg = "channel.getDRMWrappedDesKey() null";
                    logger.warn(method + (String)logMsg);
                    return EndOpMsg.TPSStatus.STATUS_ERROR_RECOVERY_FAILED;
                }
                logMsg = "channel.getDRMWrappedDesKey() not null";
                logger.debug(method + (String)logMsg);
                keyResp = TPSEngine.getInstance().recoverKey(cuid, userid, channel.getDRMWrappedDesKey(), this.getExternalRegRecoverByKeyID() ? null : b64cert, kraConn, keyid);
                if (keyResp == null) {
                    String auditInfo = "recovering key not found";
                    this.auditRecovery(userid, appletInfo, "failure", channel.getKeyInfoData().toHexStringPlain(), serial, caConn, kraConn, auditInfo);
                    logger.warn(method + auditInfo);
                    return EndOpMsg.TPSStatus.STATUS_ERROR_RECOVERY_FAILED;
                }
                this.auditRecovery(userid, appletInfo, "success", channel.getKeyInfoData().toHexStringPlain(), serial, caConn, kraConn, null);
            }
            CertEnrollInfo cEnrollInfo = new CertEnrollInfo();
            cEnrollInfo.setTokenToBeRecovered(tokenRecord);
            cEnrollInfo.setRecoveredCertData(certResp);
            cEnrollInfo.setRecoveredKeyData(keyResp);
            preRecoveredCerts.add(cEnrollInfo);
        }
        if (preRecoveredCerts != null && preRecoveredCerts.size() != 0) {
            PKCS11Obj pkcs11obj = certsInfo.getPKCS11Obj();
            int numCerts = preRecoveredCerts.size();
            certsInfo.setNumCertsToEnroll(numCerts);
            for (int i = 0; i < preRecoveredCerts.size(); ++i) {
                CertEnrollInfo certRecoveredInfo = preRecoveredCerts.get(i);
                if (certRecoveredInfo == null) continue;
                int newCertId = pkcs11obj.getNextFreeCertIdNumber();
                certsInfo.setCurrentCertIndex(i);
                logger.debug(method + "before calling generateCertificate, certsInfo.getCurrentCertIndex() =" + certsInfo.getCurrentCertIndex());
                this.generateCertificate(certsInfo, channel, appletInfo, "encryption", TPSEngine.ENROLL_MODES.MODE_RECOVERY, newCertId, certRecoveredInfo);
                logger.debug(method + "after generateCertificate() with MODE_RECOVERY");
            }
        }
        logger.debug(method + "ends");
        return status;
    }

    private EndOpMsg.TPSStatus processRenewal(EnrolledCertsInfo certsInfo, SecureChannel channel, AppletInfo aInfo, TokenRecord tokenRecord) throws TPSException, IOException {
        EndOpMsg.TPSStatus status = EndOpMsg.TPSStatus.STATUS_ERROR_RENEWAL_FAILED;
        String method = "TPSEnrollProcess.processRenewal";
        logger.debug(method + ": begins");
        boolean noFailedCerts = true;
        if (certsInfo == null || aInfo == null || channel == null) {
            throw new TPSException(method + ": Bad Input data!", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        TPSEngine engine = TPSEngine.getInstance();
        TPSSubsystem tps = (TPSSubsystem)engine.getSubsystem("tps");
        int keyTypeNum = this.getNumberCertsToRenew();
        Collection<TPSCertRecord> allCerts = tps.tdb.tdbGetCertRecordsByCUID(tokenRecord.getId());
        ArrayList<TPSCertRecord> oldEncCertsToRecover = new ArrayList<TPSCertRecord>();
        certsInfo.setNumCertsToEnroll(keyTypeNum);
        logger.debug(method + ": Number of certs to renew: " + keyTypeNum);
        int numActuallyRenewed = 0;
        block8: for (int i = 0; i < keyTypeNum; ++i) {
            String keyType = this.getRenewConfigKeyType(i);
            boolean renewEnabled = this.getRenewEnabled(keyType);
            logger.debug(method + ": key type " + keyType);
            if (!renewEnabled) {
                logger.debug(method + ": renew not enabled");
                continue;
            }
            logger.debug(method + ": renew enabled");
            certsInfo.setCurrentCertIndex(i);
            CertEnrollInfo cEnrollInfo = new CertEnrollInfo();
            TPSEngineConfig configStore = engine.getConfig();
            String configName = null;
            boolean graceEnabled = false;
            String graceBeforeS = null;
            String graceAfterS = null;
            try {
                String keyTypePrefix = "op.enroll." + this.selectedTokenType + ".renewal." + keyType;
                configName = keyTypePrefix + ".ca.profileId";
                String profileId = configStore.getString(configName);
                logger.debug(method + ": profileId: " + profileId);
                configName = keyTypePrefix + ".gracePeriod.enable";
                graceEnabled = configStore.getBoolean(configName, false);
                if (graceEnabled) {
                    logger.debug(method + ": grace period check is enabled");
                    configName = keyTypePrefix + ".gracePeriod.before";
                    graceBeforeS = configStore.getString(configName, "");
                    configName = keyTypePrefix + ".gracePeriod.after";
                    graceAfterS = configStore.getString(configName, "");
                } else {
                    logger.debug(method + ": grace period check is not enabled");
                }
                configName = keyTypePrefix + ".certId";
                String certId = configStore.getString(configName, "C0");
                logger.debug(method + ": certId: " + certId);
                configName = keyTypePrefix + ".certAttrId";
                String certAttrId = configStore.getString(configName, "c0");
                logger.debug(method + ": certAttrId: " + certAttrId);
                configName = keyTypePrefix + ".privateKeyAttrId";
                String priKeyAttrId = configStore.getString(configName, "k0");
                logger.debug(method + ": privateKeyAttrId: " + priKeyAttrId);
                configName = keyTypePrefix + ".publicKeyAttrId";
                String publicKeyAttrId = configStore.getString(configName, "k1");
                logger.debug(method + ": publicKeyAttrId: " + publicKeyAttrId);
            }
            catch (EBaseException e) {
                throw new TPSException(method + ": Internal error finding config value: " + configName + ":" + e, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
            }
            for (TPSCertRecord cert : allCerts) {
                if (!keyType.equals(cert.getKeyType())) continue;
                try {
                    logger.debug(method + ": cert " + cert.getId() + " with status:" + cert.getStatus());
                    if (cert.getStatus().equals("revoked") || cert.getStatus().equals("renewed")) {
                        logger.debug(method + ": cert status is not to be renewed");
                        continue;
                    }
                    if (graceEnabled) {
                        try {
                            if (!this.isCertWithinRenewalGracePeriod(cert, graceBeforeS, graceAfterS)) {
                                continue;
                            }
                        }
                        catch (TPSException ge) {
                            logger.warn(method + ":" + ge.getMessage() + "; continue to try renewal", (Throwable)ge);
                        }
                    }
                    CARenewCertResponse certResponse = TPSEngine.getInstance().renewCertificate(cert, cert.getSerialNumber(), this.selectedTokenType, keyType, this.getCAConnectorID("renewal", keyType));
                    cEnrollInfo.setRenewedCertData(certResponse);
                    this.generateCertificate(certsInfo, channel, aInfo, keyType, TPSEngine.ENROLL_MODES.MODE_RENEWAL, -1, cEnrollInfo);
                    ++numActuallyRenewed;
                    if (keyType.equals("encryption")) {
                        logger.debug(method + ": found old encryption cert (just renewed) to attempt to recover back to token, in order to read old emails.");
                        logger.debug(method + " adding cert: " + cert);
                        oldEncCertsToRecover.add(cert);
                    }
                    if (numActuallyRenewed == keyTypeNum) {
                        logger.debug(method + " We have already renewed the proper number of certs, bailing from loop.");
                        status = EndOpMsg.TPSStatus.STATUS_RENEWAL_IS_PROCESSED;
                        continue block8;
                    }
                    status = EndOpMsg.TPSStatus.STATUS_RENEWAL_IS_PROCESSED;
                }
                catch (TPSException e) {
                    logger.warn(method + "renewCertificate: exception:" + e.getMessage(), (Throwable)e);
                    noFailedCerts = false;
                    continue block8;
                }
            }
        }
        if (!noFailedCerts) {
            String logMsg = "There has been failed cert renewal";
            logger.error(method + ":" + logMsg);
            throw new TPSException(logMsg + EndOpMsg.TPSStatus.STATUS_ERROR_RENEWAL_FAILED);
        }
        TPSTokenPolicy tokenPolicy = new TPSTokenPolicy(tps, tokenRecord.getId());
        boolean recoverOldEncCerts = tokenPolicy.isAllowdRenewSaveOldEncCerts();
        logger.debug(method + " Recover Old Encryption Certs for Renewed Certs: " + recoverOldEncCerts);
        if (oldEncCertsToRecover.size() > 0 && recoverOldEncCerts) {
            logger.debug("About to attempt to recover old encryption certs just renewed.");
            for (TPSCertRecord toBeRecovered : oldEncCertsToRecover) {
                String serialToRecover = toBeRecovered.getSerialNumber();
                try {
                    CARetrieveCertResponse certResponse = TPSEngine.getInstance().recoverCertificate(toBeRecovered, serialToRecover, "encryption", this.getCAConnectorID());
                    String b64cert = certResponse.getCertB64();
                    logger.debug(method + ": cert blob recovered");
                    KRARecoverKeyResponse keyResponse = TPSEngine.getInstance().recoverKey(toBeRecovered.getId(), toBeRecovered.getUserID(), channel.getDRMWrappedDesKey(), b64cert, this.getDRMConnectorID(toBeRecovered.getKeyType()));
                    CertEnrollInfo cEnrollInfo = new CertEnrollInfo();
                    cEnrollInfo.setTokenToBeRecovered(tokenRecord);
                    cEnrollInfo.setRecoveredCertData(certResponse);
                    cEnrollInfo.setRecoveredKeyData(keyResponse);
                    PKCS11Obj pkcs11obj = certsInfo.getPKCS11Obj();
                    int newCertId = pkcs11obj.getNextFreeCertIdNumber();
                    logger.debug(method + " newCertId = " + newCertId);
                    logger.debug(method + "before calling generateCertificate, certsInfo.getCurrentCertIndex() =" + newCertId);
                    this.generateCertificate(certsInfo, channel, aInfo, "encryption", TPSEngine.ENROLL_MODES.MODE_RECOVERY, newCertId, cEnrollInfo);
                    logger.debug(method + " About to remove old encryption cert recovered from official token db list: ");
                    certsInfo.removeCertificate(certResponse.getCert());
                }
                catch (TPSException e) {
                    logger.warn(method + "Failure to recoverd old encryption certs during renewal operation: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return status;
    }

    private boolean isCertWithinRenewalGracePeriod(TPSCertRecord cert, String renewGraceBeforeS, String renewGraceAfterS) throws TPSException {
        String method = "TPSEnrollProcessor.isCertWithinRenewalGracePeriod";
        int renewGraceBefore = 0;
        int renewGraceAfter = 0;
        if (cert == null || renewGraceBeforeS == null || renewGraceAfterS == null) {
            logger.error(method + ": missing some input");
            throw new TPSException(method + ": Bad Input data!", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        BigInteger renewGraceBeforeBI = new BigInteger(renewGraceBeforeS);
        BigInteger renewGraceAfterBI = new BigInteger(renewGraceAfterS);
        renewGraceBefore = renewGraceBeforeS == "" ? -1 : Integer.parseInt(renewGraceBeforeS);
        renewGraceAfter = renewGraceAfterS == "" ? -1 : Integer.parseInt(renewGraceAfterS);
        if (renewGraceBefore > 0) {
            renewGraceBeforeBI = renewGraceBeforeBI.multiply(BigInteger.valueOf(86400000L));
        }
        if (renewGraceAfter > 0) {
            renewGraceAfterBI = renewGraceAfterBI.multiply(BigInteger.valueOf(86400000L));
        }
        Date origExpDate = cert.getValidNotAfter();
        Date current = new Date();
        long millisDiff = origExpDate.getTime() - current.getTime();
        logger.debug(method + ": millisDiff=" + millisDiff + " origExpDate=" + origExpDate.getTime() + " current=" + current.getTime());
        if (millisDiff >= 0L) {
            if (renewGraceBefore > 0 && millisDiff > renewGraceBeforeBI.longValue()) {
                logger.warn(method + ": renewal attempted outside of grace period;" + renewGraceBefore + " days before and " + renewGraceAfter + " days after original cert expiration date");
                return false;
            }
        } else if (renewGraceAfter > 0 && 0L - millisDiff > renewGraceAfterBI.longValue()) {
            logger.warn(method + ": renewal attempted outside of grace period;" + renewGraceBefore + " days before and " + renewGraceAfter + " days after original cert expiration date");
            return false;
        }
        return true;
    }

    private boolean getRenewEnabled(String keyType) {
        String method = "TPSEnrollProcessor.getRenewEnabled";
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        boolean enabled = false;
        try {
            String configValue = "op.enroll." + this.selectedTokenType + ".renewal." + keyType + ".enable";
            enabled = configStore.getBoolean(configValue, false);
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        logger.debug(method + ": returning " + enabled);
        return enabled;
    }

    private boolean getExternalRegRecoverByKeyID() {
        String method = "TPSEnrollProcessor.getExternalRegRecoverByKeyID";
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        boolean recoverByKeyID = false;
        try {
            String configValue = "externalReg.recover.byKeyID";
            recoverByKeyID = configStore.getBoolean(configValue, false);
        }
        catch (EBaseException e) {
            logger.warn(method + " exception, take default: " + e.getMessage(), (Throwable)e);
        }
        logger.debug(method + ": returning " + recoverByKeyID);
        return recoverByKeyID;
    }

    private String getRenewConfigKeyType(int keyTypeIndex) throws TPSException {
        String method = "TPSEnrollProcessor.getRenewConfigKeyType";
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String keyType = null;
        try {
            String configValue = "op.enroll." + this.selectedTokenType + ".renewal.keyType.value." + keyTypeIndex;
            keyType = configStore.getString(configValue, null);
        }
        catch (EBaseException e) {
            throw new TPSException(method + ": Internal error finding config value: " + e, EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        if (keyType == null) {
            throw new TPSException(method + ": Internal error finding config value: ", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        logger.debug(method + ": returning: " + keyType);
        return keyType;
    }

    private int getNumberCertsToRenew() throws TPSException {
        String method = "TPSEnrollProcessor.getNumberCertsToRenew";
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        int keyTypeNum = 0;
        try {
            String configValue = "op.enroll." + this.selectedTokenType + ".renewal.keyType.num";
            keyTypeNum = configStore.getInteger(configValue, 0);
        }
        catch (EBaseException e) {
            throw new TPSException(method + ": Internal error finding config value: " + e, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        if (keyTypeNum == 0) {
            throw new TPSException(method + ": invalid number of certificates to renew configured!", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        logger.debug(method + ": returning: " + keyTypeNum);
        return keyTypeNum;
    }

    private EndOpMsg.TPSStatus processRecovery(TokenRecord toBeRecovered, EnrolledCertsInfo certsInfo, SecureChannel channel, AppletInfo aInfo) throws TPSException, IOException {
        String method = "TPSEnrollProcessor.processRecover";
        EndOpMsg.TPSStatus status = EndOpMsg.TPSStatus.STATUS_RECOVERY_IS_PROCESSED;
        TPSEngine engine = TPSEngine.getInstance();
        TPSSubsystem tps = (TPSSubsystem)engine.getSubsystem("tps");
        TPSEngineConfig configStore = engine.getConfig();
        logger.debug(method + ": entering:");
        if (toBeRecovered == null || certsInfo == null || channel == null || aInfo == null) {
            throw new TPSException(method + ": Invalid reason!", EndOpMsg.TPSStatus.STATUS_ERROR_RECOVERY_FAILED);
        }
        String reason = toBeRecovered.getReason();
        int num = this.getNumberCertsForRecovery(reason);
        int totalNumCerts = 0;
        String keyTypeValue = null;
        String scheme = null;
        logger.debug(method + ": About to find if we have any GenerateNewAndRecoverLast schemes.");
        for (int i = 0; i < num; ++i) {
            keyTypeValue = this.getRecoveryKeyTypeValue(reason, i);
            scheme = this.getRecoveryScheme(reason, keyTypeValue);
            if (scheme.equals("GenerateNewKeyAndRecoverLast")) {
                if (keyTypeValue.equals("signing")) {
                    throw new TPSException(method + ": Can't have GenerateNewAndRecoverLast scheme with a signing key!", EndOpMsg.TPSStatus.STATUS_ERROR_RECOVERY_FAILED);
                }
                ++totalNumCerts;
            }
            ++totalNumCerts;
        }
        logger.debug(method + ": About to perform actual recoveries: totalNumCerts: " + totalNumCerts);
        if (totalNumCerts <= num) {
            totalNumCerts = num;
        }
        boolean isGenerateAndRecover = false;
        int actualCertIndex = 0;
        boolean legalScheme = false;
        certsInfo.setNumCertsToEnroll(totalNumCerts);
        for (int i = 0; i < num; ++i) {
            keyTypeValue = this.getRecoveryKeyTypeValue(reason, i);
            scheme = this.getRecoveryScheme(reason, keyTypeValue);
            if (scheme.equals("GenerateNewKeyAndRecoverLast")) {
                logger.debug(method + ": scheme GenerateNewKeyAndRecoverLast found.");
                isGenerateAndRecover = true;
            } else {
                isGenerateAndRecover = false;
            }
            if (scheme.equals(TPSEngine.RECOVERY_GENERATE_NEW_KEY) || isGenerateAndRecover) {
                legalScheme = true;
                CertEnrollInfo cEnrollInfo = new CertEnrollInfo();
                this.generateCertificate(certsInfo, channel, aInfo, keyTypeValue, TPSEngine.ENROLL_MODES.MODE_ENROLL, actualCertIndex, cEnrollInfo);
                actualCertIndex = cEnrollInfo.getCertIdIndex();
                logger.debug(method + ": scheme GenerateNewKey found, or isGenerateAndRecove is true: actualCertIndex, after enrollment: " + actualCertIndex);
            }
            if (scheme.equals(TPSEngine.RECOVERY_RECOVER_LAST) || isGenerateAndRecover) {
                legalScheme = true;
                logger.debug(method + ": scheme RecoverLast found, or isGenerateAndRecove is true");
                if (isGenerateAndRecover) {
                    logger.debug(method + ": isGenerateAndRecover is true.");
                    ++actualCertIndex;
                }
                Collection<TPSCertRecord> certs = tps.tdb.tdbGetCertRecordsByCUID(toBeRecovered.getId());
                String serialToRecover = null;
                TPSCertRecord certToRecover = null;
                for (TPSCertRecord rec : certs) {
                    logger.debug(method + ": Looking for keyType record: " + keyTypeValue + " curSererial: " + rec.getSerialNumber());
                    if (!rec.getKeyType().equals(keyTypeValue)) continue;
                    serialToRecover = rec.getSerialNumber();
                    certToRecover = rec;
                    logger.debug("TPSCertRecord: serial number: " + serialToRecover);
                }
                String b64cert = null;
                if (serialToRecover != null) {
                    Object logMsg;
                    String caConnId;
                    String config = "op.enroll." + certToRecover.getType() + ".keyGen." + certToRecover.getKeyType() + ".ca.conn";
                    try {
                        caConnId = configStore.getString(config);
                    }
                    catch (Exception e) {
                        logMsg = "cannot find config:" + config + ": " + e.getMessage();
                        logger.error(method + ":" + (String)logMsg, (Throwable)e);
                        throw new TPSException(method + ":" + (String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
                    }
                    logger.debug(method + ": Selecting cert to recover: " + serialToRecover);
                    CARetrieveCertResponse certResponse = TPSEngine.getInstance().recoverCertificate(certToRecover, serialToRecover, keyTypeValue, caConnId);
                    b64cert = certResponse.getCertB64();
                    logger.debug(method + ": cert blob recovered");
                    KRARecoverKeyResponse keyResponse = TPSEngine.getInstance().recoverKey(toBeRecovered.getId(), toBeRecovered.getUserID(), channel.getDRMWrappedDesKey(), b64cert, this.getDRMConnectorID(certToRecover.getKeyType()));
                    CertEnrollInfo cEnrollInfo = new CertEnrollInfo();
                    cEnrollInfo.setTokenToBeRecovered(toBeRecovered);
                    cEnrollInfo.setRecoveredCertData(certResponse);
                    cEnrollInfo.setRecoveredKeyData(keyResponse);
                    this.generateCertificate(certsInfo, channel, aInfo, keyTypeValue, TPSEngine.ENROLL_MODES.MODE_RECOVERY, actualCertIndex, cEnrollInfo);
                    if (certToRecover.getStatus().equalsIgnoreCase(TokenCertStatus.ONHOLD.toString())) {
                        logMsg = "unrevoking cert...";
                        logger.debug(method + ":" + (String)logMsg);
                        CARemoteRequestHandler caRH = null;
                        try {
                            caRH = new CARemoteRequestHandler(caConnId);
                            CARevokeCertResponse response = caRH.revokeCertificate(false, serialToRecover, certToRecover.getCertificate(), null);
                            logger.debug(method + ": response status =" + response.getStatus());
                            this.auditRevoke(certToRecover.getTokenID(), false, -1, String.valueOf(response.getStatus()), serialToRecover, caConnId, null);
                            logger.debug(method + ": unrevoke successful. Setting cert status to active for actualCertIndex:" + actualCertIndex);
                            certsInfo.setCertStatus(actualCertIndex, TokenCertStatus.ACTIVE);
                        }
                        catch (EBaseException e) {
                            logMsg = "failed getting CARemoteRequestHandler: " + e.getMessage();
                            logger.error(method + ":" + (String)logMsg, (Throwable)e);
                            this.auditRevoke(certToRecover.getTokenID(), false, -1, "failure", serialToRecover, caConnId, (String)logMsg);
                            throw new TPSException(method + ":" + (String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_RECOVERY_FAILED);
                        }
                    }
                }
            }
            if (!legalScheme) {
                throw new TPSException(method + ": Invalid recovery configuration!", EndOpMsg.TPSStatus.STATUS_ERROR_RECOVERY_FAILED);
            }
            ++actualCertIndex;
        }
        return status;
    }

    private boolean generateCertificates(EnrolledCertsInfo certsInfo, SecureChannel channel, AppletInfo aInfo) throws TPSException, IOException {
        logger.debug("TPSEnrollProcess.generateCertificates: begins ");
        boolean noFailedCerts = true;
        if (certsInfo == null || aInfo == null || channel == null) {
            throw new TPSException("TPSEnrollProcess.generateCertificates: Bad Input data!", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        int keyTypeNum = this.getNumberCertsToEnroll();
        if (this.isExternalReg && keyTypeNum == 0) {
            logger.warn("TPSEnrollProcess.generateCertificates: isExternalReg with tokenType:" + this.selectedTokenType + "; no certs to enroll per configuration");
            return noFailedCerts;
        }
        certsInfo.setNumCertsToEnroll(keyTypeNum);
        logger.debug("TPSEnrollProcess.generateCertificates: Number of certs to enroll: " + keyTypeNum);
        for (int i = 0; i < keyTypeNum; ++i) {
            String keyType = this.getConfiguredKeyType(i);
            certsInfo.setCurrentCertIndex(i);
            try {
                this.generateCertificate(certsInfo, channel, aInfo, keyType, TPSEngine.ENROLL_MODES.MODE_ENROLL, -1, null);
                continue;
            }
            catch (TPSException e) {
                logger.warn("TPSEnrollProcess.generateCertificates: exception:" + e.getMessage(), (Throwable)e);
                noFailedCerts = false;
                break;
            }
        }
        logger.debug("TPSEnrollProcess.generateCertificates: ends ");
        return noFailedCerts;
    }

    private String buildTokenLabel(EnrolledCertsInfo certsInfo, AppletInfo ainfo) throws TPSException {
        String label = null;
        if (certsInfo == null || ainfo == null) {
            throw new TPSException("TPSEnrollProcessor.buildTokenLabel: invalide input data!", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        logger.debug("TPSEnrollProcessor.buildTokenLabel: entering...");
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String configName = "op.enroll." + this.getSelectedTokenType() + ".keyGen.tokenName";
        String pattern = null;
        try {
            pattern = configStore.getString(configName, "$cuid$");
        }
        catch (EBaseException e) {
            throw new TPSException("TPSEnrollProcessor.buildTokenLabel: Internal error finding config value: " + e, EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        logger.debug("TPSEnrollProcessor.buildTokenLabel: pattern: " + pattern);
        LinkedHashMap<String, String> nv = new LinkedHashMap<String, String>();
        nv.put("cuid", ainfo.getCUIDhexString());
        nv.put("msn", ainfo.getMSNString());
        nv.put("userid", this.userid);
        nv.put("auth.cn", this.userid);
        nv.put("profileId", this.getSelectedTokenType());
        label = this.mapPattern(nv, pattern);
        logger.debug("TPSEnrollProcessor.buildTokenLabel: returning: " + label);
        return label;
    }

    private void generateCertificate(EnrolledCertsInfo certsInfo, SecureChannel channel, AppletInfo aInfo, String keyType, TPSEngine.ENROLL_MODES mode, int certIdNumOverride, CertEnrollInfo cEnrollInfo) throws TPSException, IOException {
        String method = "TPSEnrollProcessor.generateCertificate";
        logger.debug("TPSEnrollProcessor.generateCertificate: entering ... certIdNumOverride: " + certIdNumOverride + " mode: " + mode);
        if (certsInfo == null || aInfo == null || channel == null) {
            throw new TPSException("TPSEnrollProcessor.generateCertificate: Bad Input data!", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        boolean isRenewal = false;
        String operationModifier = "keyGen";
        if (mode == TPSEngine.ENROLL_MODES.MODE_RENEWAL) {
            isRenewal = true;
            operationModifier = "renewal";
        }
        if (cEnrollInfo == null) {
            cEnrollInfo = new CertEnrollInfo();
        }
        try {
            SecureChannel.TokenKeyType keyTypeEnum;
            String keyTypePrefix = "op.enroll." + this.getSelectedTokenType() + "." + operationModifier + "." + keyType;
            logger.debug("TPSEnrollProcessor.generateCertificate: keyTypePrefix: " + keyTypePrefix);
            String configName = keyTypePrefix + ".ca.profileId";
            String profileId = null;
            if (this.isExternalReg) {
                profileId = configStore.getString(configName, "NA");
            } else {
                profileId = configStore.getString(configName);
                logger.debug("TPSEnrollProcessor.generateCertificate: profileId: " + profileId);
            }
            configName = keyTypePrefix + ".certId";
            Object certId = configStore.getString(configName, "C0");
            logger.debug("TPSEnrollProcessor.generateCertificate: certId: " + (String)certId);
            configName = keyTypePrefix + ".certAttrId";
            Object certAttrId = configStore.getString(configName, "c0");
            logger.debug("TPSEnrollProcessor.generateCertificate: certAttrId: " + (String)certAttrId);
            configName = keyTypePrefix + ".privateKeyAttrId";
            Object priKeyAttrId = configStore.getString(configName, "k0");
            logger.debug("TPSEnrollProcessor.generateCertificate: priKeyAttrId: " + (String)priKeyAttrId);
            configName = keyTypePrefix + ".publicKeyAttrId";
            Object publicKeyAttrId = configStore.getString(configName, "k1");
            logger.debug("TPSEnrollProcessor.generateCertificate: publicKeyAttrId: " + (String)publicKeyAttrId);
            configName = keyTypePrefix + ".keySize";
            int keySize = configStore.getInteger(configName, 1024);
            logger.debug("TPSEnrollProcessor.generateCertificate: keySize: " + keySize);
            configName = keyTypePrefix + ".alg";
            int algorithm = configStore.getInteger(configName, 2);
            logger.debug("TPSEnrollProcessor.generateCertificate: algorithm: " + algorithm);
            configName = keyTypePrefix + ".publisherId";
            String publisherId = configStore.getString(configName, "");
            logger.debug("TPSEnrollProcessor.generateCertificate: publisherId: " + publisherId);
            configName = keyTypePrefix + ".keyUsage";
            int keyUsage = configStore.getInteger(configName, 0);
            logger.debug("TPSEnrollProcessor.generateCertificate: keyUsage: " + keyUsage);
            configName = keyTypePrefix + ".keyUser";
            int keyUser = configStore.getInteger(configName, 0);
            logger.debug("TPSEnrollProcessor.generateCertificate: keyUser: " + keyUser);
            configName = keyTypePrefix + ".privateKeyNumber";
            int priKeyNumber = configStore.getInteger(configName, 0);
            logger.debug("TPSEnrollProcessor.generateCertificate: privateKeyNumber: " + priKeyNumber);
            configName = keyTypePrefix + ".publicKeyNumber";
            int pubKeyNumber = configStore.getInteger(configName, 0);
            logger.debug("TPSEnrollProcessor.generateCertificate: pubKeyNumber: " + pubKeyNumber);
            configName = keyTypePrefix + ".private.keyCapabilities.sign";
            boolean isSigning = configStore.getBoolean(configName, false);
            logger.debug("TPSEnrollProcessor.generateCertificate: isSigning: " + isSigning);
            configName = keyTypePrefix + ".public.keyCapabilities.encrypt";
            logger.debug("TPSEnrollProcessor.generateCertificate: encrypt config name: " + configName);
            boolean isEncrypt = configStore.getBoolean(configName, true);
            logger.debug("TPSEnrollProcessor.generateCertificate: isEncrypt: " + isEncrypt);
            if (isSigning && isEncrypt) {
                keyTypeEnum = SecureChannel.TokenKeyType.KEY_TYPE_SIGNING_AND_ENCRYPTION;
            } else if (isSigning) {
                keyTypeEnum = SecureChannel.TokenKeyType.KEY_TYPE_SIGNING;
            } else if (isEncrypt) {
                keyTypeEnum = SecureChannel.TokenKeyType.KEY_TYPE_ENCRYPTION;
            } else {
                logger.error("TPSEnrollProcessor.generateCertificate: Illegal toke key type!");
                throw new TPSException("TPSEnrollProcessor.generateCertificate: Illegal toke key type!", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
            }
            logger.debug("TPSEnrollProcessor.generateCertificate: keyTypeEnum value: " + keyTypeEnum);
            if (certIdNumOverride >= 0) {
                logger.debug("TPSEnrollProcessor.generateCertificate: called with overridden cert id number: " + certIdNumOverride);
                pubKeyNumber = 2 * certIdNumOverride + 1;
                priKeyNumber = 2 * certIdNumOverride;
                certId = "C" + certIdNumOverride;
                certAttrId = "c" + certIdNumOverride;
                priKeyAttrId = "k" + priKeyNumber;
                publicKeyAttrId = "k" + pubKeyNumber;
                logger.debug("TPSEnrollProcessor.generateCertificate: called with overridden cert no: certId: " + (String)certId + " certAttrId: " + (String)certAttrId + " priKeyAttrId: " + (String)priKeyAttrId + " publicKeyAttrId: " + (String)publicKeyAttrId);
            }
            cEnrollInfo.setKeyTypeEnum(keyTypeEnum);
            cEnrollInfo.setProfileId(profileId);
            cEnrollInfo.setCertId((String)certId);
            cEnrollInfo.setCertAttrId((String)certAttrId);
            cEnrollInfo.setKeyType(keyType);
            if (!isRenewal) {
                cEnrollInfo.setPrivateKeyAttrId((String)priKeyAttrId);
                cEnrollInfo.setPublicKeyAttrId((String)publicKeyAttrId);
                cEnrollInfo.setKeySize(keySize);
                cEnrollInfo.setAlgorithm(algorithm);
                cEnrollInfo.setPublisherId(publisherId);
                cEnrollInfo.setKeyUsage(keyUsage);
                cEnrollInfo.setKeyUser(keyUser);
                cEnrollInfo.setPrivateKeyNumber(priKeyNumber);
                cEnrollInfo.setPublicKeyNumber(pubKeyNumber);
                cEnrollInfo.setKeyTypePrefix(keyTypePrefix);
            }
            int certsStartProgress = certsInfo.getStartProgressValue();
            int certsEndProgress = certsInfo.getEndProgressValue();
            int currentCertIndex = certsInfo.getCurrentCertIndex();
            int totalNumCerts = certsInfo.getNumCertsToEnroll();
            logger.debug("TPSEnrollProcessor.generateCertificate: Progress values: certsStartProgress: " + certsStartProgress + " certsEndProgress: " + certsEndProgress + " currentCertIndex: " + currentCertIndex + " totalNumCerts: " + totalNumCerts);
            int progressBlock = 0;
            if (totalNumCerts != 0) {
                progressBlock = (certsEndProgress - certsStartProgress) / totalNumCerts;
                logger.debug("TPSEnrollProcessor.generateCertificate: progressBlock: " + progressBlock);
            } else {
                logger.debug("TPSEnrollProcessor.generateCertificate: totalNumCerts =0, progressBlock left at 0");
            }
            int startCertProgValue = certsStartProgress + currentCertIndex * progressBlock;
            int endCertProgValue = startCertProgValue + progressBlock;
            logger.debug("TPSEnrollProcessor.generateCertificate: startCertProgValue: " + startCertProgValue + " endCertProgValue: " + endCertProgValue);
            cEnrollInfo.setStartProgressValue(startCertProgValue);
            cEnrollInfo.setEndProgressValue(endCertProgValue);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSEnrollProcessor.generateCertificate: Internal error finding config value: " + e, EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        this.enrollOneCertificate(certsInfo, cEnrollInfo, aInfo, channel, mode);
    }

    /*
     * Unable to fully structure code
     */
    private void enrollOneCertificate(EnrolledCertsInfo certsInfo, CertEnrollInfo cEnrollInfo, AppletInfo aInfo, SecureChannel channel, TPSEngine.ENROLL_MODES mode) throws TPSException, IOException {
        method = "TPSEnrollProcessor.enrollOneCertificate";
        auditInfo = null;
        TPSEnrollProcessor.logger.debug(method + ": entering ... mode: " + mode);
        if (certsInfo == null || aInfo == null || cEnrollInfo == null || channel == null) {
            throw new TPSException(method + ": Bad Input data!", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        TPSEnrollProcessor.logger.debug(method + ": currentCertIndex = " + certsInfo.getCurrentCertIndex());
        engine = TPSEngine.getInstance();
        tps = (TPSSubsystem)engine.getSubsystem("tps");
        this.statusUpdate(cEnrollInfo.getStartProgressValue(), "PROGRESS_KEY_GENERATION");
        serverSideKeyGen = this.checkForServerSideKeyGen(cEnrollInfo);
        objectOverwrite = this.checkForObjectOverwrite(cEnrollInfo);
        pkcs11obj = certsInfo.getPKCS11Obj();
        keyAlg = cEnrollInfo.getAlgorithm();
        isECC = TPSEngine.getInstance().isAlgorithmECC(keyAlg);
        if (objectOverwrite) {
            TPSEnrollProcessor.logger.debug(method + ": We are configured to overwrite existing cert objects.");
        } else {
            certIdExists = pkcs11obj.doesCertIdExist(cEnrollInfo.getCertId());
            if (certIdExists) {
                auditInfo = "cert id exists on token; Overwrite of certificates not allowed";
                this.auditEnrollment(this.userid, "enrollment", aInfo, "failure", channel.getKeyInfoData().toHexStringPlain(), null, null, (String)auditInfo);
                throw new TPSException(method + ": " + (String)auditInfo, EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
            }
        }
        public_key_blob = null;
        ssKeyGenResponse = null;
        keyResp = null;
        parsedPubKey = null;
        parsedPK11PubKey = null;
        parsedPubKey_ba = null;
        isRecovery = false;
        isRenewal = false;
        if (mode == TPSEngine.ENROLL_MODES.MODE_RECOVERY) {
            isRecovery = true;
            TPSEnrollProcessor.logger.debug(method + ": detecting recovery mode!");
            if (isRecovery && !serverSideKeyGen) {
                auditInfo = "Attempting illegal recovery when archival is not enabled";
                this.auditRecovery(this.userid, aInfo, "failure", channel.getKeyInfoData().toHexStringPlain(), null, null, null, (String)auditInfo);
                throw new TPSException(method + ": " + (String)auditInfo, EndOpMsg.TPSStatus.STATUS_ERROR_RECOVERY_FAILED);
            }
        }
        if (mode == TPSEngine.ENROLL_MODES.MODE_RENEWAL) {
            isRenewal = true;
            TPSEnrollProcessor.logger.debug(method + ": detecting renewal mode!");
        }
        if (serverSideKeyGen || isRecovery) {
            TPSEnrollProcessor.logger.debug(method + ": either generate private key on the server, or preform recovery or perform renewal.");
            archive = this.checkForServerKeyArchival(cEnrollInfo);
            kraConnId = this.getDRMConnectorID(cEnrollInfo.getKeyType());
            publicKeyStr = null;
            if (!isRecovery) {
                ssKeyGenResponse = TPSEngine.getInstance().serverSideKeyGen(cEnrollInfo.getKeySize(), aInfo.getCUIDhexStringPlain(), this.userid, kraConnId, channel.getDRMWrappedDesKey(), archive, isECC);
                publicKeyStr = ssKeyGenResponse.getPublicKey();
                TPSEnrollProcessor.logger.debug(method + ": got public key string from server ");
                public_key_blob = new TPSBuffer(Utils.base64decode((String)publicKeyStr));
            } else {
                TPSEnrollProcessor.logger.debug(method + ": Attempt to get key data in recovery mode!");
                keyResp = cEnrollInfo.getRecoveredKeyData();
                publicKeyStr = keyResp.getPublicKey();
                public_key_blob = new TPSBuffer(Utils.base64decode((String)publicKeyStr));
            }
            try {
                parsedPK11PubKey = PK11RSAPublicKey.fromSPKI((byte[])public_key_blob.toBytesArray());
                parsedPubKey_ba = parsedPK11PubKey.getEncoded();
                if (!isRecovery) ** GOTO lbl93
                rsaKey = new RSAPublicKey(parsedPubKey_ba);
                cEnrollInfo.setKeySize(rsaKey.getKeySize());
                TPSEnrollProcessor.logger.debug(method + ": recovery reset keysize to:" + rsaKey.getKeySize());
            }
            catch (InvalidKeyFormatException e) {
                auditInfo = method + ", can't create public key object from server side key generated public key blob! " + e.getMessage();
                if (!isRecovery) {
                    this.auditEnrollment(this.userid, "enrollment", aInfo, "failure", channel.getKeyInfoData().toHexStringPlain(), BigInteger.ZERO, null, (String)auditInfo);
                } else {
                    this.auditRecovery(this.userid, aInfo, "failure", channel.getKeyInfoData().toHexStringPlain(), null, null, kraConnId, (String)auditInfo);
                }
                TPSEnrollProcessor.logger.error((String)auditInfo, (Throwable)e);
                throw new TPSException((String)auditInfo, EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
            }
            catch (InvalidKeyException e) {
                msg = method + ", can't create public key object from server side key generated public key blob! " + e.getMessage();
                TPSEnrollProcessor.logger.error(msg, (Throwable)e);
                throw new TPSException(msg, EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
            }
        } else if (isRenewal) {
            TPSEnrollProcessor.logger.debug(method + ": We are in renewal mode, no work to do with the keys, in renewal the keys remain on the token.");
        } else {
            TPSEnrollProcessor.logger.debug(method + ": about to generate the private key on the token.");
            algorithm = 128;
            if (certsInfo.getKeyCheck() != null) {
                algorithm = 129;
            }
            if (isECC) {
                algorithm = keyAlg;
            }
            pe1 = (cEnrollInfo.getKeyUser() << 4) + cEnrollInfo.getPrivateKeyNumber();
            pe2 = (cEnrollInfo.getKeyUsage() << 4) + cEnrollInfo.getPublicKeyNumber();
            size = channel.startEnrollment(pe1, pe2, certsInfo.getWrappedChallenge(), certsInfo.getKeyCheck(), algorithm, cEnrollInfo.getKeySize(), 0);
            iobytes = new byte[]{-1, -1, -1, -1};
            iobuf = new TPSBuffer(iobytes);
            public_key_blob = channel.readObject(iobuf, 0, size);
            parsedPubKey = this.parsePublicKeyBlob(public_key_blob, isECC);
            parsedPubKey_ba = parsedPubKey.getEncoded();
        }
lbl93:
        // 4 sources

        TPSEnrollProcessor.logger.debug(method + ": enrollment begins");
        x509Cert = null;
        certStatus = TokenCertStatus.ACTIVE;
        cert_bytes = null;
        try {
            if (!isRecovery && !isRenewal) {
                caConnID = this.getCAConnectorID("keyGen", cEnrollInfo.getKeyType());
                caRH = new CARemoteRequestHandler(caConnID);
                encodedParsedPubKey = new TPSBuffer(parsedPubKey_ba);
                TPSEnrollProcessor.logger.debug(method + ": userid =" + this.userid + ", cuid=" + aInfo.getCUIDhexString());
                if (this.session.getExternalRegAttrs() != null && this.session.getExternalRegAttrs().getIsDelegation()) {
                    sanNum = 0;
                    urlSanExt = null;
                    TPSEnrollProcessor.logger.debug(method + ": isDelegation true");
                    nv = new LinkedHashMap<String, String>();
                    nv.put("cuid", aInfo.getCUIDhexStringPlain());
                    nv.put("msn", aInfo.getMSNString());
                    nv.put("userid", this.userid);
                    nv.put("auth.cn", this.userid);
                    nv.put("profileId", this.getSelectedTokenType());
                    TPSEnrollProcessor.logger.debug(method + ": fill in nv with authToken name/value pairs");
                    n = this.authToken.getElements();
                    while (n.hasMoreElements()) {
                        name = (String)n.nextElement();
                        TPSEnrollProcessor.logger.debug(method + ":name =" + name);
                        if (this.ldapStringAttrs == null || !this.ldapStringAttrs.contains(name)) continue;
                        vals = this.authToken.getInStringArray(name);
                        if (vals != null) {
                            TPSEnrollProcessor.logger.debug(method + ":val =" + vals[0]);
                            nv.put("auth." + name, vals[0]);
                            continue;
                        }
                        TPSEnrollProcessor.logger.debug(method + ":name not found in authToken:" + name);
                    }
                    subjectdn = "";
                    configStore = engine.getConfig();
                    configName = "op.enroll." + this.getSelectedTokenType() + ".keyGen." + cEnrollInfo.getKeyType() + ".dnpattern";
                    try {
                        dnpattern = configStore.getString(configName);
                        subjectdn = this.mapPattern(nv, dnpattern);
                    }
                    catch (EBaseException e) {
                        TPSEnrollProcessor.logger.warn(method + ": isDelegation dnpattern not set: " + e.getMessage(), (Throwable)e);
                    }
                    configName = "op.enroll." + this.getSelectedTokenType() + ".keyGen." + cEnrollInfo.getKeyType() + ".SANpattern";
                    try {
                        sanPattern = configStore.getString(configName);
                        for (String sanToken : sanToks = sanPattern.split(",")) {
                            TPSEnrollProcessor.logger.debug(method + ": isDelegation: sanToken:" + sanToken);
                            sanExt = this.mapPattern(nv, sanToken);
                            urlSanExt1 = Util.uriEncode((String)sanExt);
                            urlSanExt = urlSanExt == null ? "req_san_pattern_" + sanNum + "=" + urlSanExt1 : urlSanExt + "&req_san_pattern_" + sanNum + "=" + urlSanExt1;
                            TPSEnrollProcessor.logger.debug(method + ": isDelegation: urlSanExt1:" + urlSanExt1);
                            ++sanNum;
                        }
                    }
                    catch (EBaseException e) {
                        TPSEnrollProcessor.logger.warn(method + ": isDelegation sanPattern not set: " + e.getMessage(), (Throwable)e);
                    }
                    TPSEnrollProcessor.logger.debug(method + ": isDelegation: Before calling enrolCertificate");
                    caEnrollResp = caRH.enrollCertificate(encodedParsedPubKey, this.userid, subjectdn, sanNum, urlSanExt, aInfo.getCUIDHexStringHyphens(), this.getSelectedTokenType(), cEnrollInfo.getKeyType());
                } else {
                    TPSEnrollProcessor.logger.debug(method + ": not isDelegation: Before calling enrolCertificate");
                    caEnrollResp = caRH.enrollCertificate(encodedParsedPubKey, this.userid, aInfo.getCUIDHexStringHyphens(), this.getSelectedTokenType(), cEnrollInfo.getKeyType());
                }
                retCertB64 = caEnrollResp.getCertB64();
                if (retCertB64 == null) {
                    auditInfo = "new cert b64 not found";
                    TPSEnrollProcessor.logger.error(method + ": " + (String)auditInfo);
                    this.auditEnrollment(this.userid, "enrollment", aInfo, "failure", channel.getKeyInfoData().toHexStringPlain(), BigInteger.ZERO, caConnID, (String)auditInfo);
                    throw new TPSException(method + ": " + (String)auditInfo, EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
                }
                TPSEnrollProcessor.logger.debug(method + ": new cert b64 retrieved from caEnrollResp");
                cert_bytes = Utils.base64decode((String)retCertB64);
                TPSEnrollProcessor.logger.debug(method + ": retCertB64 base64decode done");
                x509Cert = caEnrollResp.getCert();
                if (x509Cert == null) {
                    TPSEnrollProcessor.logger.error(method + ": new cert not found");
                    throw new TPSException(method + ": new cert not found", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
                }
                TPSEnrollProcessor.logger.debug(method + ": new cert retrieved");
                this.auditEnrollment(this.userid, "enrollment", aInfo, "success", channel.getKeyInfoData().toHexStringPlain(), x509Cert.getSerialNumber(), caConnID, null);
            } else {
                caConnID = this.getCAConnectorID("keyGen", cEnrollInfo.getKeyType());
                TPSEnrollProcessor.logger.debug(method + ": Attempt to import cert data in recovery mode or renew mode!");
                if (isRecovery) {
                    certResp = cEnrollInfo.getRecoveredCertData();
                    if (certResp == null) {
                        throw new TPSException(method + ": In recovery mode, CARetieveCertResponse object not found!", EndOpMsg.TPSStatus.STATUS_ERROR_RECOVERY_FAILED);
                    }
                    retCertB64 = certResp.getCertB64();
                    if (retCertB64 == null) {
                        TPSEnrollProcessor.logger.error(method + ": recovering new cert b64 not found");
                        throw new TPSException(method + ": recovering: new cert b64 not found", EndOpMsg.TPSStatus.STATUS_ERROR_RECOVERY_FAILED);
                    }
                    TPSEnrollProcessor.logger.debug(method + ": recovering: new cert b64 not null");
                    TPSEnrollProcessor.logger.debug(method + ": recovering:  retCertB64 retrieved from certResp");
                    cert_bytes = Utils.base64decode((String)retCertB64);
                    TPSEnrollProcessor.logger.debug(method + ": recovering: retCertB64 base64decode done");
                    x509Cert = certResp.getCert();
                    if (x509Cert != null) {
                        TPSEnrollProcessor.logger.debug(method + ": recovering new cert retrieved");
                        certStatus = this.getRetrievedCertStatus((CARetrieveCertResponse)certResp);
                        this.auditEnrollment(this.userid, "retrieval", aInfo, "success", channel.getKeyInfoData().toHexStringPlain(), x509Cert.getSerialNumber(), certResp.getConnID(), null);
                    } else {
                        auditInfo = "recovering new cert not found";
                        TPSEnrollProcessor.logger.error(method + ": " + (String)auditInfo);
                        this.auditEnrollment(this.userid, "retrieval", aInfo, "failure", channel.getKeyInfoData().toHexStringPlain(), null, certResp.getConnID(), (String)auditInfo);
                        throw new TPSException(method + ": " + (String)auditInfo, EndOpMsg.TPSStatus.STATUS_ERROR_RECOVERY_FAILED);
                    }
                }
                if (isRenewal) {
                    certResp = cEnrollInfo.getRenewedCertData();
                    if (certResp == null) {
                        auditInfo = "In renewal mode, CARemewCertResponse object not found!";
                        this.auditEnrollment(this.userid, "renewal", aInfo, "failure", channel.getKeyInfoData().toHexStringPlain(), null, caConnID, (String)auditInfo);
                        throw new TPSException(method + ": " + (String)auditInfo, EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
                    }
                    retCertB64 = certResp.getRenewedCertB64();
                    if (retCertB64 == null) {
                        auditInfo = "renewing new cert b64 not found";
                        TPSEnrollProcessor.logger.error(method + ": " + (String)auditInfo);
                        this.auditEnrollment(this.userid, "renewal", aInfo, "failure", channel.getKeyInfoData().toHexStringPlain(), null, certResp.getConnID(), (String)auditInfo);
                        throw new TPSException(method + ": renewing: new cert b64 not found", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
                    }
                    TPSEnrollProcessor.logger.debug(method + ": renewing: new cert b64 retrieved");
                    cert_bytes = Utils.base64decode((String)retCertB64);
                    TPSEnrollProcessor.logger.debug(method + ": renewing: retCertB64 base64decode done");
                    x509Cert = certResp.getRenewedCert();
                    if (x509Cert != null) {
                        TPSEnrollProcessor.logger.debug(method + ": renewing new cert retrieved");
                        this.auditEnrollment(this.userid, "renewal", aInfo, "success", channel.getKeyInfoData().toHexStringPlain(), x509Cert.getSerialNumber(), certResp.getConnID(), null);
                    } else {
                        auditInfo = "renewing new cert not found";
                        TPSEnrollProcessor.logger.error(method + ": " + (String)auditInfo);
                        this.auditEnrollment(this.userid, "renewal", aInfo, "failure", channel.getKeyInfoData().toHexStringPlain(), null, certResp.getConnID(), (String)auditInfo);
                        throw new TPSException(method + ": " + (String)auditInfo, EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
                    }
                }
            }
            certsInfo.addCertificate(x509Cert);
            certsInfo.addKType(cEnrollInfo.getKeyType());
            if (isRecovery) {
                TPSEnrollProcessor.logger.debug(method + ": about to find origiinal cert record");
                origCertRec = tps.getTokendb().tdbGetOrigCertRecord(x509Cert);
                if (origCertRec != null) {
                    TPSEnrollProcessor.logger.debug(method + ": token origin found");
                    certsInfo.addTokenType(origCertRec.getType());
                    certsInfo.addOrigin(origCertRec.getOrigin());
                    certsInfo.addKType(origCertRec.getKeyType());
                } else {
                    TPSEnrollProcessor.logger.debug(method + ": cert origin not found");
                    recordToRecover = cEnrollInfo.getTokenToBeRecovered();
                    if (recordToRecover == null) {
                        throw new TPSException(method + ": TokenRecord of token to be recovered not found.", EndOpMsg.TPSStatus.STATUS_ERROR_RECOVERY_FAILED);
                    }
                    certsInfo.addOrigin(recordToRecover.getId());
                    certsInfo.addTokenType(recordToRecover.getType());
                }
            } else {
                certsInfo.addOrigin(aInfo.getCUIDhexStringPlain());
                certsInfo.addTokenType(this.selectedTokenType);
            }
            certsInfo.addCertStatus(certStatus);
            publicKeyInfo = null;
            label = null;
            keyid = null;
            modulus = null;
            exponent = null;
            if (!isRenewal) {
                try {
                    publicKeyInfo = serverSideKeyGen ? new SubjectPublicKeyInfo((PublicKey)parsedPK11PubKey) : new SubjectPublicKeyInfo(parsedPubKey);
                }
                catch (InvalidBERException e) {
                    TPSEnrollProcessor.logger.error(method + ": cant get publicKeyInfo object: " + e.getMessage(), (Throwable)e);
                    throw new TPSException(method + ": can't get publcKeyInfo object.", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
                }
                label = this.buildCertificateLabel(cEnrollInfo, aInfo);
                TPSEnrollProcessor.logger.debug(method + ": cert label: " + label);
                keyid = new TPSBuffer(this.makeKeyIDFromPublicKeyInfo(publicKeyInfo.getEncoded()));
                modulus = null;
                exponent = null;
                if (serverSideKeyGen) {
                    modulus = new TPSBuffer(((PK11RSAPublicKey)parsedPK11PubKey).getModulus().toByteArray());
                    exponent = new TPSBuffer(((PK11RSAPublicKey)parsedPK11PubKey).getPublicExponent().toByteArray());
                } else {
                    modulus = new TPSBuffer(parsedPubKey.getModulus().toByteArray());
                    exponent = new TPSBuffer(parsedPubKey.getPublicExponent().toByteArray());
                }
            }
            pkcs11Obj = certsInfo.getPKCS11Obj();
            certId = cEnrollInfo.getCertId();
            objid = ObjectSpec.createObjectID(certId);
            TPSEnrollProcessor.logger.debug(method + ":  cert objid long: " + objid);
            certObjSpec = ObjectSpec.parseFromTokenData(objid, new TPSBuffer(cert_bytes));
            pkcs11Obj.addObjectSpec(certObjSpec);
            if (!isRenewal) {
                certAttrId = cEnrollInfo.getCertAttrId();
                certAttrsBuffer = channel.createPKCS11CertAttrsBuffer(cEnrollInfo.getKeyTypeEnum(), certAttrId, label, keyid);
                objid = ObjectSpec.createObjectID(certAttrId);
                TPSEnrollProcessor.logger.debug(method + ":  cert attr objid long: " + objid);
                certAttrObjSpec = ObjectSpec.parseFromTokenData(objid, certAttrsBuffer);
                pkcs11Obj.addObjectSpec(certAttrObjSpec);
                priKeyAttrId = cEnrollInfo.getPrivateKeyAttrId();
                objid = ObjectSpec.createObjectID(priKeyAttrId);
                TPSEnrollProcessor.logger.debug(method + ": pri key objid long: " + objid);
                privKeyAttrsBuffer = channel.createPKCS11PriKeyAttrsBuffer(priKeyAttrId, label, keyid, modulus, cEnrollInfo.getKeyTypePrefix());
                priKeyObjSpec = ObjectSpec.parseFromTokenData(objid, privKeyAttrsBuffer);
                pkcs11obj.addObjectSpec(priKeyObjSpec);
                pubKeyAttrId = cEnrollInfo.getPublicKeyAttrId();
                objid = ObjectSpec.createObjectID(pubKeyAttrId);
                TPSEnrollProcessor.logger.debug(method + ": pub key objid long: " + objid);
                pubKeyAttrsBuffer = channel.createPKCS11PublicKeyAttrsBuffer(pubKeyAttrId, label, keyid, modulus, exponent, cEnrollInfo.getKeyTypePrefix());
                pubKeyObjSpec = ObjectSpec.parseFromTokenData(objid, pubKeyAttrsBuffer);
                pkcs11obj.addObjectSpec(pubKeyObjSpec);
            }
        }
        catch (EBaseException e) {
            TPSEnrollProcessor.logger.error(method + ":" + e.getMessage(), (Throwable)e);
            throw new TPSException(method + ": Exception thrown: " + e, EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        if (serverSideKeyGen || isRecovery) {
            TPSEnrollProcessor.logger.debug(method + ": About to inject private key");
            if (!isRecovery) {
                this.importPrivateKeyPKCS8(ssKeyGenResponse, cEnrollInfo, channel, isECC);
            } else {
                this.importPrivateKeyPKCS8(keyResp, cEnrollInfo, channel, isECC);
            }
        }
        TPSEnrollProcessor.logger.debug(method + ": enrollment ends");
        if (x509Cert != null && x509Cert.getSerialNumber() != null) {
            tps.tdb.tdbActivity("enrollment", this.session.getTokenRecord(), this.session.getIpAddress(), "certificate " + x509Cert.getSerialNumber().toString(16) + " stored on token", "success");
        }
        this.statusUpdate(cEnrollInfo.getEndProgressValue(), "PROGRESS_ENROLL_CERT");
        TPSEnrollProcessor.logger.debug(method + ": ends");
    }

    TokenCertStatus getRetrievedCertStatus(CARetrieveCertResponse certResponse) throws TPSException {
        String method = "TPSEnrollProcessor.getRetrievedCertStatus";
        logger.debug(method + " begins");
        if (certResponse == null) {
            throw new TPSException("TPSEnrollProcessor.getRetrievedCertStatus: invalid input data! certResponse cannot be null", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        TokenCertStatus ret = TokenCertStatus.ACTIVE;
        if (!certResponse.isCertValid()) {
            logger.debug(method + ": cert expired");
            ret = TokenCertStatus.EXPIRED;
        }
        if (certResponse.isCertRevoked()) {
            String revReason = certResponse.getRevocationReason();
            logger.debug(method + ": cert revoked; reason=" + revReason);
            ret = RevocationReason.valueOf((int)Integer.parseInt(revReason)) == RevocationReason.CERTIFICATE_HOLD ? TokenCertStatus.ONHOLD : TokenCertStatus.REVOKED;
        }
        return ret;
    }

    private void importPrivateKeyPKCS8(KRARecoverKeyResponse keyResp, CertEnrollInfo cEnrollInfo, SecureChannel channel, boolean isECC) throws TPSException, IOException {
        if (keyResp == null || cEnrollInfo == null || channel == null) {
            throw new TPSException("TPSEnrollProcessor.importPrivateKeyPKCS8: invalid input data!", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        this.importPrivateKeyPKCS8(keyResp.getWrappedPrivKey(), keyResp.getIVParam(), cEnrollInfo, channel, isECC);
    }

    private void importPrivateKeyPKCS8(KRAServerSideKeyGenResponse ssKeyGenResponse, CertEnrollInfo cEnrollInfo, SecureChannel channel, boolean isECC) throws TPSException, IOException {
        if (ssKeyGenResponse == null || cEnrollInfo == null || channel == null) {
            throw new TPSException("TPSEnrollProcessor.importPrivateKeyPKCS8: invalid input data!", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        this.importPrivateKeyPKCS8(ssKeyGenResponse.getWrappedPrivKey(), ssKeyGenResponse.getIVParam(), cEnrollInfo, channel, isECC);
    }

    private void importPrivateKeyPKCS8(String wrappedPrivKeyStr, String ivParams, CertEnrollInfo cEnrollInfo, SecureChannel channel, boolean isECC) throws TPSException, IOException {
        String method = "TPSEnrollProcessor.importPrivateKeyPKCS8";
        logger.debug(method + " entering..");
        if (wrappedPrivKeyStr == null || ivParams == null || cEnrollInfo == null || channel == null) {
            throw new TPSException(method + ": invalid input data!", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        byte[] objid = new byte[]{-1, 0, -1, -13};
        byte keytype = 9;
        int keysize = cEnrollInfo.getKeySize();
        TPSBuffer privKeyBlob = new TPSBuffer();
        privKeyBlob.add((byte)1);
        privKeyBlob.add(keytype);
        privKeyBlob.add((byte)(keysize / 256));
        privKeyBlob.add((byte)(keysize % 256));
        TPSBuffer privKeyBuff = new TPSBuffer(Util.uriDecodeFromHex((String)wrappedPrivKeyStr));
        privKeyBlob.add(privKeyBuff);
        byte[] perms = new byte[]{64, 0, 64, 0, 64, 0};
        TPSBuffer objIdBuff = new TPSBuffer(objid);
        channel.createObject(objIdBuff, new TPSBuffer(perms), privKeyBlob.size());
        channel.writeObject(objIdBuff, privKeyBlob);
        TPSBuffer keyCheck = channel.getKeyCheck();
        if (keyCheck == null) {
            keyCheck = new TPSBuffer();
        }
        logger.debug(method + ": got keyCheck");
        TPSBuffer ivParamsBuff = new TPSBuffer(Util.uriDecodeFromHex((String)ivParams));
        if (ivParamsBuff.size() == 0) {
            throw new TPSException(method + ": invalid iv vector!", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        TPSBuffer kekWrappedDesKey = channel.getKekDesKey();
        if (kekWrappedDesKey != null) {
            logger.debug(method + ": got keyWrappedDesKey");
        } else {
            logger.debug(method + ": null kekWrappedDesKey!");
        }
        byte alg = -128;
        if (kekWrappedDesKey != null && kekWrappedDesKey.size() > 0) {
            alg = -127;
        }
        TPSBuffer data = new TPSBuffer();
        data.add(objIdBuff);
        data.add(alg);
        data.add((byte)kekWrappedDesKey.size());
        data.add(kekWrappedDesKey);
        data.add((byte)keyCheck.size());
        if (keyCheck.size() > 0) {
            data.add(keyCheck);
        }
        data.add((byte)ivParamsBuff.size());
        data.add(ivParamsBuff);
        int pe1 = (cEnrollInfo.getKeyUser() << 4) + cEnrollInfo.getPrivateKeyNumber();
        int pe2 = (cEnrollInfo.getKeyUsage() << 4) + cEnrollInfo.getPublicKeyNumber();
        channel.importKeyEnc(pe1, pe2, data);
        logger.debug(method + " successful, leaving...");
    }

    private String buildCertificateLabel(CertEnrollInfo cEnrollInfo, AppletInfo ainfo) throws TPSException {
        String method = "TPSEnrollProcessor.buildCertificateLabel";
        logger.debug(method + " begins");
        if (cEnrollInfo == null) {
            throw new TPSException(method + ": Invalid input params!", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        String label = null;
        String pattern = null;
        String defaultLabel = cEnrollInfo.getKeyType() + " key for $userid$";
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String configValue = "op." + this.currentTokenOperation + "." + this.selectedTokenType + ".keyGen." + cEnrollInfo.getKeyType() + ".label";
        logger.debug(method + ": label config: " + configValue);
        try {
            pattern = configStore.getString(configValue, defaultLabel);
        }
        catch (EBaseException e) {
            throw new TPSException(method + ": Internal error finding config value: " + e, EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        LinkedHashMap<String, String> nv = new LinkedHashMap<String, String>();
        nv.put("cuid", ainfo.getCUIDhexString());
        nv.put("msn", ainfo.getMSNString());
        nv.put("userid", this.userid);
        nv.put("auth.cn", this.userid);
        nv.put("profileId", this.getSelectedTokenType());
        label = this.mapPattern(nv, pattern);
        logger.debug(method + ": returning: " + label);
        return label;
    }

    private RSAPublicKey parsePublicKeyBlob(TPSBuffer public_key_blob, boolean isECC) throws TPSException {
        String method = "TPSEnrollProcessor.parsePublicKeyBlob";
        RSAPublicKey parsedPubKey = null;
        if (public_key_blob == null) {
            throw new TPSException(method + ": Bad input data! Missing public_key_blob or challenge", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        logger.debug(method + ": parsing public key blob from token");
        int pkeyb_len_offset = 0;
        int pkeyb_len = public_key_blob.getIntFrom2Bytes(pkeyb_len_offset);
        logger.debug(method + ": pkeyb_len = " + pkeyb_len + ", isECC: " + isECC);
        TPSBuffer pkeyb = public_key_blob.substr(pkeyb_len_offset + 2, pkeyb_len);
        if (pkeyb == null) {
            logger.error(method + ": pkeyb null");
            throw new TPSException(method + ": Bad input data! pkeyb null", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        logger.debug(method + ": public key pkeyb extracted from blob");
        int proofb_len_offset = pkeyb_len_offset + 2 + pkeyb_len;
        int proofb_len = public_key_blob.getIntFrom2Bytes(proofb_len_offset);
        TPSBuffer proofb = public_key_blob.substr(proofb_len_offset + 2, proofb_len);
        if (proofb == null) {
            logger.error(method + ": proofb null");
            throw new TPSException(method + ": Bad input data! proofb null", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        logger.debug(method + ": proof proofb extracted from blob");
        int pkey_offset = 4;
        if (!isECC) {
            int mod_len = pkeyb.getIntFrom2Bytes(pkey_offset);
            logger.debug(method + ": mod_len= " + mod_len);
            int exp_len = pkeyb.getIntFrom2Bytes(pkey_offset + 2 + mod_len);
            logger.debug(method + ": exp_len= " + exp_len);
            TPSBuffer modb = pkeyb.substr(pkey_offset + 2, mod_len);
            if (modb == null) {
                logger.error(method + ": modb null");
                throw new TPSException(method + ": Bad input data! modb null", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
            }
            logger.debug(method + ": modulus modb extracted from blob");
            TPSBuffer expb = pkeyb.substr(pkey_offset + 2 + mod_len + 2, exp_len);
            if (expb == null) {
                logger.error(method + ": expb null");
                throw new TPSException(method + ": Bad input data! expb null", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
            }
            logger.debug(method + ":processing exponent expb extracted from blob");
            BigInt modb_bi = new BigInt(modb.toBytesArray());
            BigInt expb_bi = new BigInt(expb.toBytesArray());
            try {
                RSAPublicKey rsa_pub_key = new RSAPublicKey(modb_bi, expb_bi);
                logger.debug(method + ": public key blob converted to RSAPublicKey");
                if (rsa_pub_key != null) {
                    parsedPubKey = rsa_pub_key;
                }
            }
            catch (InvalidKeyException e) {
                logger.error(method + ":InvalidKeyException thrown: " + e.getMessage(), (Throwable)e);
                throw new TPSException(method + ": Exception thrown: " + e, EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
            }
        }
        if (parsedPubKey == null) {
            logger.error(method + ": parsedPubKey null");
            throw new TPSException(method + ": parsedPubKey null.", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        logger.debug(method + ": parsedPubKey not null");
        byte[] parsedPubKey_ba = parsedPubKey.getEncoded();
        if (parsedPubKey_ba == null) {
            logger.error(method + ": parsedPubKey_ba null");
            throw new TPSException(method + ": parsedPubKey encoding failure.", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        logger.debug(method + ": parsedPubKey getEncoded not null");
        return parsedPubKey;
    }

    private boolean checkForServerSideKeyGen(CertEnrollInfo cInfo) throws TPSException {
        if (cInfo == null) {
            throw new TPSException("TPSEnrollProcessor.checkForServerSideKeyGen: invalid cert info.", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        boolean serverSideKeygen = false;
        try {
            String configValue = cInfo.getKeyTypePrefix() + ".serverKeygen.enable";
            logger.debug("TPSEnrollProcessor.checkForServerSideKeyGen: config: " + configValue);
            serverSideKeygen = configStore.getBoolean(configValue, false);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSEnrollProcessor.checkForServerSideKeyGen: Internal error finding config value: " + e, EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        logger.debug("TPSProcess.checkForServerSideKeyGen: returning: " + serverSideKeygen);
        return serverSideKeygen;
    }

    private boolean checkForServerKeyArchival(CertEnrollInfo cInfo) throws TPSException {
        if (cInfo == null) {
            throw new TPSException("TPSEnrollProcessor.checkForServerKeyArchival: invalid cert info.", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        boolean serverKeyArchival = false;
        try {
            String configValue = cInfo.getKeyTypePrefix() + ".serverKeygen.archive";
            logger.debug("TPSEnrollProcessor.checkForServerKeyArchival: config: " + configValue);
            serverKeyArchival = configStore.getBoolean(configValue, false);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSEnrollProcessor.checkForServerKeyArchival: Internal error finding config value: " + e, EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        logger.debug("TPSProcess.checkForServerKeyArchival: returning: " + serverKeyArchival);
        return serverKeyArchival;
    }

    private boolean checkForObjectOverwrite(CertEnrollInfo cInfo) throws TPSException {
        if (cInfo == null) {
            throw new TPSException("TPSEnrollProcessor.checkForObjectOverwrite: invalid cert info.", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        boolean objectOverwrite = false;
        try {
            String configValue = "op.enroll." + this.getSelectedTokenType() + ".keyGen." + cInfo.getKeyType() + ".overwrite";
            logger.debug("TPSProcess.checkForObjectOverwrite: config: " + configValue);
            objectOverwrite = configStore.getBoolean(configValue, true);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSEnrollProcessor.checkForServerSideKeyGen: Internal error finding config value: " + e, EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        logger.debug("TPSProcess.checkForObjectOverwrite: returning: " + objectOverwrite);
        return objectOverwrite;
    }

    private String getConfiguredKeyType(int keyTypeIndex) throws TPSException {
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String keyType = null;
        try {
            String configValue = "op.enroll." + this.selectedTokenType + ".keyGen.keyType.value." + keyTypeIndex;
            keyType = configStore.getString(configValue, null);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSEnrollProcessor.getConfiguredKeyType: Internal error finding config value: " + e, EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        if (keyType == null) {
            throw new TPSException("TPSEnrollProcessor.getConfiguredKeyType: Internal error finding config value: ", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        logger.debug("TPSProcess.getConfiguredKeyType: returning: " + keyType);
        return keyType;
    }

    private String getDRMConnectorID(String keyType) throws TPSException {
        if (keyType == null || keyType.isEmpty()) {
            keyType = "encryption";
        }
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String id = null;
        String config = "op." + this.currentTokenOperation + "." + this.selectedTokenType + ".keyGen." + keyType + ".serverKeygen.drm.conn";
        logger.debug("TPSEnrollProcessor.getDRMConnectorID: config value: " + config);
        try {
            id = configStore.getString(config, "kra1");
        }
        catch (EBaseException e) {
            throw new TPSException("TPSEnrollProcessor.getDRMConnectorID: Internal error finding config value.", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        logger.debug("TPSEnrollProcessor.getDRMConectorID: returning: " + id);
        return id;
    }

    protected int getNumberCertsToEnroll() throws TPSException {
        String method = "TPSEnrollProcessor.getNumberCertsToEnroll:";
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        int keyTypeNum = 0;
        try {
            String configValue = "op.enroll." + this.selectedTokenType + ".keyGen.keyType.num";
            logger.debug(method + "getting config value for:" + configValue);
            keyTypeNum = configStore.getInteger(configValue, 0);
        }
        catch (EBaseException e) {
            String logMsg = "Internal error finding config value: " + e;
            throw new TPSException(method + logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        if (!this.isExternalReg && keyTypeNum == 0) {
            throw new TPSException(method + " invalid number of certificates configured!", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        logger.debug(method + " returning: " + keyTypeNum);
        return keyTypeNum;
    }

    protected int getEnrollmentAlg() throws TPSException {
        int enrollmentAlg;
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        try {
            String configValue = "op.enroll." + this.selectedTokenType + ".keyGen.encryption.alg";
            logger.debug("TPSProcess.getEnrollmentAlg: configValue: " + configValue);
            enrollmentAlg = configStore.getInteger(configValue, 2);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSEnrollProcessor.getEnrollmentAlg: Internal error finding config value: " + e, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        logger.debug("TPSProcess.getEnrollmentAlg: returning: " + enrollmentAlg);
        return enrollmentAlg;
    }

    protected String getRecoveryKeyTypeValue(String reason, int index) throws TPSException {
        String keyTypeValue;
        if (reason == null || index < 0) {
            throw new TPSException("TPSEnrollProcessor.getRecoveryKeyTypeValue: invalide input data!", EndOpMsg.TPSStatus.STATUS_ERROR_RECOVERY_FAILED);
        }
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        try {
            String configValue = "op.enroll." + this.selectedTokenType + ".keyGen.recovery." + reason + ".keyType.value." + index;
            logger.debug("TPSProcess.getRecoveryKeyTypeValue: configValue: " + configValue);
            keyTypeValue = configStore.getString(configValue, null);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSEnrollProcessor.getRecoveryKeyTypeValue: Internal error finding config value: " + e, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        if (keyTypeValue == null) {
            throw new TPSException("TPSEnrollProcessor.getRecoveryKeyTypeValue: Invalid keyTypeValue found! ", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        logger.debug("TPSProcess.getRecoveryKeyTypeValue: returning: " + keyTypeValue);
        return keyTypeValue;
    }

    protected String getRecoveryScheme(String reason, String keyTypeValue) throws TPSException {
        if (reason == null || keyTypeValue == null) {
            throw new TPSException("TPSEnrollProcessor.getRecoveryScheme: invalid input data!", EndOpMsg.TPSStatus.STATUS_ERROR_RECOVERY_FAILED);
        }
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String scheme = null;
        try {
            String configValue = "op.enroll." + this.selectedTokenType + ".keyGen." + keyTypeValue + ".recovery." + reason + ".scheme";
            logger.debug("TPSProcess.getRecoveryScheme: configValue: " + configValue);
            scheme = configStore.getString(configValue, null);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSEnrollProcessor.getRecoveryScheme: Internal error finding config value: " + e, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        if (scheme == null) {
            throw new TPSException("TPSEnrollProcessor.getRecoverScheme: Invalid scheme found! ", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        logger.debug("TPSProcess.getRecoveryScheme: returning: " + scheme);
        return scheme;
    }

    protected int getNumberCertsForRecovery(String reason) throws TPSException {
        if (reason == null) {
            throw new TPSException("TPSEnrollProcessor.getNumberCertsForRecovery: invlalid input data!", EndOpMsg.TPSStatus.STATUS_ERROR_RECOVERY_FAILED);
        }
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        int keyTypeNum = 0;
        try {
            String configValue = "op.enroll." + this.selectedTokenType + ".keyGen.recovery." + reason + ".keyType.num";
            logger.debug("TPSEnrollProcessor.getNumberCertsForRecovery: configValue: " + configValue);
            keyTypeNum = configStore.getInteger(configValue, 0);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSEnrollProcessor.getNumberCertsForRecovery: Internal error finding config value: " + e, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        if (keyTypeNum == 0) {
            throw new TPSException("TPSEnrollProcessor.getNumberCertsForRecovery: invalid number of certificates configured!", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        logger.debug("TPSProcess.getNumberCertsForRecovery: returning: " + keyTypeNum);
        return keyTypeNum;
    }

    private TPSBuffer makeKeyIDFromPublicKeyInfo(byte[] publicKeyInfo) throws TPSException {
        MessageDigest mozillaDigest;
        String alg = "SHA1";
        if (publicKeyInfo == null) {
            throw new TPSException("TPSEnrollProcessor.makeKeyIDFromPublicKeyInfo: invalid input data", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        TPSBuffer keyID = null;
        try {
            mozillaDigest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new TPSException("TPSEnrollProcessor.makeKeyIDFromPublicKeyInfo: " + e, EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        byte[] mozillaDigestOut = mozillaDigest.digest(publicKeyInfo);
        if (mozillaDigestOut.length != mozillaDigest.getDigestLength()) {
            throw new TPSException("ERROR: digest output size is " + mozillaDigestOut.length + ", should be " + mozillaDigest.getDigestLength(), EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        keyID = new TPSBuffer(mozillaDigestOut);
        return keyID;
    }

    public BigInteger serialNoToBigInt(String serialS) {
        if (serialS == null) {
            return new BigInteger("0", 16);
        }
        logger.debug("TPSEnrollProcessor.seralNoToBigInt: serial # =" + serialS);
        String serialhex = serialS.substring(2);
        BigInteger serialBI = new BigInteger(serialhex, 16);
        return serialBI;
    }

    private void auditEnrollment(String subjectID, String op, AppletInfo aInfo, String status, String keyVersion, BigInteger serial, String caConnId, String info) {
        TPSEngine engine = TPSEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String serialNum = "";
        if (serial != null && serial.compareTo(BigInteger.ZERO) > 0) {
            serialNum = serial.toString();
        }
        String auditType = "";
        switch (op) {
            case "retrieval": {
                auditType = "LOGGING_SIGNED_AUDIT_TOKEN_CERT_RETRIEVAL_9";
                break;
            }
            case "renewal": {
                auditType = "LOGGING_SIGNED_AUDIT_TOKEN_CERT_RENEWAL_9";
                break;
            }
            default: {
                auditType = "LOGGING_SIGNED_AUDIT_TOKEN_CERT_ENROLLMENT_9";
            }
        }
        String auditMessage = CMS.getLogMessage((String)auditType, (Object[])new Object[]{this.session != null ? this.session.getIpAddress() : null, subjectID, aInfo.getCUIDhexStringPlain(), status, this.getSelectedTokenType(), keyVersion, serialNum, caConnId, info});
        auditor.log(auditMessage);
    }

    private void auditRecovery(String subjectID, AppletInfo aInfo, String status, String keyVersion, BigInteger serial, String caConnId, String kraConnId, String info) {
        TPSEngine engine = TPSEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String serialNum = "";
        if (serial.compareTo(BigInteger.ZERO) > 0) {
            serialNum = serial.toString();
        }
        String auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_TOKEN_KEY_RECOVERY_10", (Object[])new Object[]{this.session != null ? this.session.getIpAddress() : null, subjectID, aInfo.getCUIDhexStringPlain(), status, this.getSelectedTokenType(), keyVersion, serialNum, caConnId, kraConnId, info});
        auditor.log(auditMessage);
    }

    private boolean checkUserAlreadyHasActiveToken(String userid) {
        String method = "TPSEnrollProcessor.checkUserAlreadyHasActiveToken: ";
        boolean result = false;
        TPSEngine engine = TPSEngine.getInstance();
        TPSSubsystem tps = (TPSSubsystem)engine.getSubsystem("tps");
        try {
            tps.tdb.tdbHasActiveToken(userid);
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        logger.debug(method + " user: " + userid + " has a token already: " + result);
        return result;
    }

    private boolean checkUserAlreadyHasOtherActiveToken(String userid, String cuid) {
        boolean result = false;
        String method = "TPSEnrollProcessor.checkUserAlreadyHasOtherActiveToken: ";
        TPSEngine engine = TPSEngine.getInstance();
        TPSSubsystem tps = (TPSSubsystem)engine.getSubsystem("tps");
        try {
            tps.tdb.tdbHasOtherActiveToken(userid, cuid);
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        logger.debug(method + " user: " + userid + " has an active token already: not cuid:  " + cuid + " : " + result);
        return result;
    }

    private boolean checkAllowMultiActiveTokensUser(boolean isExternalReg) {
        boolean allow = true;
        String method = "TPSEnrollProcessor.checkAllowMultiActiveTokensUser: ";
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        TokenDBConfig tdbConfig = configStore.getTokenDBConfig();
        String scheme = null;
        scheme = isExternalReg ? "externalReg" : "nonExternalReg";
        String allowMultiConfig = scheme + ".allowMultiActiveTokensUser";
        logger.debug(method + " trying config: tokendb." + allowMultiConfig);
        try {
            allow = tdbConfig.getBoolean(allowMultiConfig, false);
        }
        catch (EBaseException e) {
            allow = false;
        }
        logger.debug(method + "returning allow: " + allow);
        return allow;
    }

    public static void main(String[] args) {
    }
}

