# MNIST Training Integration Test

<!--* freshness: {
  owner: 'chuanhao'
  reviewed: '2021-05-13'
} *-->

<!-- TOC -->

The goal of this test is to showcase TFRT infrastructure's fundamental support
for training. This is a "hello-world" prototype for TFRT graph-mode training
support. Note that the prototype training program is entirely for demonstration
purpose and should not be viewed as the actual training implementation when TFRT
is integrated with TensorFlow.

## Test Setup

This test has the following components:

*   [mnist_training.mlir](https://github.com/tensorflow/runtime/blob/master/integrationtest/mnist/mnist_training.mlir),
    runs on TFRT. The program implements the forward pass and backward passes
    entirely in MLIR.

*   [test_data/mnist_metadata.btf](https://github.com/tensorflow/runtime/blob/master/integrationtest/mnist/test_data/mnist_metadata.btf),
    includes one training image, one one-hot training label, randomly
    initialized trainable variables, and the expected activation after training
    for 10 steps, stored in a [Binary Tensor Format](binary_tensor_format.md)
    (BTF) file.

*   [TFRT test kernels](https://github.com/tensorflow/runtime/blob/master/backends/cpu/lib/ops/test/),
    a set of kernels implemented in C++, which include gradient computation and
    weight updates, such as GradientDescent, ReluGrad.

### MNIST training in MLIR

The MLIR program implements both forward path and backward passes of the
two-layer MLP model. It uses the
[benchmark_kernel](https://github.com/tensorflow/runtime/blob/master/lib/test_kernels/benchmark_kernels.cc)
as the 'training loop' driver to train the model on one image for 10 steps, and
compares the prediction result with the one generated by TensorFlow. It uses
[DenseHostTensor](https://github.com/tensorflow/runtime/blob/master/tfrt/tensor/dense_host_tensor.h)
to hold and update trainable variables. In development, intermediate results,
including activations and gradients, are cross validated with the TensorFlow
Python training script to ensure numerical correctness.

### Kernel Implementations

Other than the kernels used in the forward pass, we implement kernels used in
backward pass, e.g. `tfrt_test.relu_grad_inplace`, which is implemented in
[mnist_tensor_kernels.cc](https://github.com/tensorflow/runtime/blob/master/backends/cpu/lib/ops/test/mnist_tensor_kernels.cc).

## Test Instructions

```shell
$ bazel test //integrationtest/mnist:mnist_training.mlir.test
```

The test reads the data from the BTF file, runs MNIST training for 10 steps and
checks that we get the numerically expected activation result from that image.

The softmax result after training for 10 steps: `dense shape = [1, 10], values =
[8.165978e-03, 6.411772e-03, 6.147404e-03, 1.058575e-02, 1.039157e-02,
9.196697e-01, 6.451619e-03, 1.061963e-02, 1.000697e-02, 1.154961e-02]`
