/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rcm;

import com.alibaba.management.ResourceContainerMXBean;
import com.alibaba.rcm.ResourceContainer;
import com.alibaba.rcm.ResourceContainerMonitor;
import com.alibaba.rcm.ResourceType;
import com.alibaba.rcm.internal.AbstractResourceContainer;
import java.util.List;
import java.util.stream.Collectors;
import javax.management.ObjectName;
import sun.management.Util;

public class ResourceContainerMXBeanImpl
implements ResourceContainerMXBean {
    private static final String TENANT_CONTAINER_MXBEAN_NAME = "com.alibaba.management:type=ResourceContainer";

    @Override
    public List<Long> getAllContainerIds() {
        return ResourceContainerMonitor.getAllContainerIds();
    }

    @Override
    public List<Long> getConstraintsById(long l) {
        return ResourceContainerMonitor.getConstraintsById(l).stream().map(constraint -> constraint.getValues()[0]).collect(Collectors.toList());
    }

    @Override
    public long getCPUResourceConsumedAmount(long l) {
        AbstractResourceContainer abstractResourceContainer = (AbstractResourceContainer)ResourceContainerMonitor.getContainerById(l);
        return abstractResourceContainer.getConsumedAmount(ResourceType.CPU_PERCENT);
    }

    @Override
    public ObjectName getObjectName() {
        return Util.newObjectName(TENANT_CONTAINER_MXBEAN_NAME);
    }

    @Override
    public long getCPUResourceLimitReachedCount(long l) {
        AbstractResourceContainer abstractResourceContainer = (AbstractResourceContainer)ResourceContainerMonitor.getContainerById(l);
        return abstractResourceContainer.getResourceLimitReachedCount(ResourceType.CPU_PERCENT);
    }

    @Override
    public List<Long> getActiveContainerThreadIds(long l) {
        if (l == ResourceContainer.root().getId()) {
            return ((AbstractResourceContainer)ResourceContainer.root()).getActiveContainerThreadIds();
        }
        AbstractResourceContainer abstractResourceContainer = (AbstractResourceContainer)ResourceContainerMonitor.getContainerById(l);
        return abstractResourceContainer.getActiveContainerThreadIds();
    }
}

