/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.border;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.beans.ConstructorProperties;
import javax.swing.border.AbstractBorder;

public class StrokeBorder
extends AbstractBorder {
    private final BasicStroke stroke;
    private final Paint paint;

    public StrokeBorder(BasicStroke basicStroke) {
        this(basicStroke, null);
    }

    @ConstructorProperties(value={"stroke", "paint"})
    public StrokeBorder(BasicStroke basicStroke, Paint paint) {
        if (basicStroke == null) {
            throw new NullPointerException("border's stroke");
        }
        this.stroke = basicStroke;
        this.paint = paint;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        float f = this.stroke.getLineWidth();
        if (f > 0.0f) {
            if ((graphics = graphics.create()) instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setStroke(this.stroke);
                graphics2D.setPaint((Paint)(this.paint != null ? this.paint : (component == null ? null : component.getForeground())));
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.draw(new Rectangle2D.Float((float)n + f / 2.0f, (float)n2 + f / 2.0f, (float)n3 - f, (float)n4 - f));
            }
            graphics.dispose();
        }
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        int n = (int)Math.ceil(this.stroke.getLineWidth());
        insets.set(n, n, n, n);
        return insets;
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    public Paint getPaint() {
        return this.paint;
    }
}

