/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.jar;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import sun.net.www.ParseUtil;
import sun.net.www.protocol.jar.JarURLConnection;

public class Handler
extends URLStreamHandler {
    private static final String separator = "!/";

    @Override
    protected URLConnection openConnection(URL uRL) throws IOException {
        return new JarURLConnection(uRL, this);
    }

    private static int indexOfBangSlash(String string) {
        int n = string.length();
        while ((n = string.lastIndexOf(33, n)) != -1) {
            if (n != string.length() - 1 && string.charAt(n + 1) == '/') {
                return n + 1;
            }
            --n;
        }
        return -1;
    }

    @Override
    protected boolean sameFile(URL uRL, URL uRL2) {
        String string;
        if (!uRL.getProtocol().equals("jar") || !uRL2.getProtocol().equals("jar")) {
            return false;
        }
        String string2 = uRL.getFile();
        String string3 = uRL2.getFile();
        int n = string2.indexOf(separator);
        int n2 = string3.indexOf(separator);
        if (n == -1 || n2 == -1) {
            return super.sameFile(uRL, uRL2);
        }
        String string4 = string2.substring(n + 2);
        if (!string4.equals(string = string3.substring(n2 + 2))) {
            return false;
        }
        URL uRL3 = null;
        URL uRL4 = null;
        try {
            uRL3 = new URL(string2.substring(0, n));
            uRL4 = new URL(string3.substring(0, n2));
        }
        catch (MalformedURLException malformedURLException) {
            return super.sameFile(uRL, uRL2);
        }
        return super.sameFile(uRL3, uRL4);
    }

    @Override
    protected int hashCode(URL uRL) {
        String string;
        int n;
        int n2 = 0;
        String string2 = uRL.getProtocol();
        if (string2 != null) {
            n2 += string2.hashCode();
        }
        if ((n = (string = uRL.getFile()).indexOf(separator)) == -1) {
            return n2 + string.hashCode();
        }
        URL uRL2 = null;
        String string3 = string.substring(0, n);
        try {
            uRL2 = new URL(string3);
            n2 += uRL2.hashCode();
        }
        catch (MalformedURLException malformedURLException) {
            n2 += string3.hashCode();
        }
        String string4 = string.substring(n + 2);
        return n2 += string4.hashCode();
    }

    public String checkNestedProtocol(String string) {
        if (string.regionMatches(true, 0, "jar:", 0, 4)) {
            return "Nested JAR URLs are not supported";
        }
        return null;
    }

    @Override
    protected void parseURL(URL uRL, String string, int n, int n2) {
        String string2;
        boolean bl;
        String string3 = null;
        String string4 = null;
        int n3 = string.indexOf(35, n2);
        boolean bl2 = bl = n3 == n;
        if (n3 > -1) {
            string4 = string.substring(n3 + 1, string.length());
            if (bl) {
                string3 = uRL.getFile();
            }
        }
        boolean bl3 = false;
        if (string.length() >= 4) {
            bl3 = string.substring(0, 4).equalsIgnoreCase("jar:");
        }
        if ((string2 = this.checkNestedProtocol(string = string.substring(n, n2))) != null) {
            throw new NullPointerException(string2);
        }
        if (bl3) {
            string3 = this.parseAbsoluteSpec(string);
        } else if (!bl) {
            string3 = this.parseContextSpec(uRL, string);
            int n4 = Handler.indexOfBangSlash(string3);
            String string5 = string3.substring(0, n4);
            String string6 = string3.substring(n4);
            ParseUtil parseUtil = new ParseUtil();
            string6 = parseUtil.canonizeString(string6);
            string3 = string5 + string6;
        }
        this.setURL(uRL, "jar", "", -1, string3, string4);
    }

    private String parseAbsoluteSpec(String string) {
        URL uRL = null;
        int n = -1;
        n = Handler.indexOfBangSlash(string);
        if (n == -1) {
            throw new NullPointerException("no !/ in spec");
        }
        try {
            String string2 = string.substring(0, n - 1);
            uRL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            throw new NullPointerException("invalid url: " + string + " (" + malformedURLException + ")");
        }
        return string;
    }

    private String parseContextSpec(URL uRL, String string) {
        int n;
        String string2 = uRL.getFile();
        if (string.startsWith("/")) {
            n = Handler.indexOfBangSlash(string2);
            if (n == -1) {
                throw new NullPointerException("malformed context url:" + uRL + ": no !/");
            }
            string2 = string2.substring(0, n);
        }
        if (!string2.endsWith("/") && !string.startsWith("/")) {
            n = string2.lastIndexOf(47);
            if (n == -1) {
                throw new NullPointerException("malformed context url:" + uRL);
            }
            string2 = string2.substring(0, n + 1);
        }
        return string2 + string;
    }
}

