"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.cherryPickTask = void 0;
const tslib_1 = require("tslib");
const githubClient_1 = tslib_1.__importDefault(require("../utils/githubClient"));
const task_1 = require("./task");
// https://github.com/lisposter/github-pagination/blob/master/lib/octopage.js
const pagingParser = (linkStr) => {
    return linkStr
        .split(',')
        .map((rel) => {
        //@ts-ignore
        return rel.split(';').map((curr, idx) => {
            if (idx === 0) {
                //@ts-ignore
                return /[^_]page=(\d+)/.exec(curr)[1];
            }
            if (idx === 1) {
                //@ts-ignore
                return /rel="(.+)"/.exec(curr)[1];
            }
        });
    })
        .reduce(function (obj, curr, i) {
        //@ts-ignore
        obj[curr[1]] = curr[0];
        return obj;
    }, {});
};
const getIssues = (client, page) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    const result = yield client.get('/issues', {
        params: {
            state: 'closed',
            per_page: 100,
            labels: 'cherry-pick needed',
            sort: 'closed',
            direction: 'asc',
            page,
        },
    });
    let data = result.data;
    if (!result.headers.link) {
        return data;
    }
    const pages = pagingParser(result.headers.link);
    if (pages.next) {
        const nextPage = yield getIssues(client, pages.next);
        data = data.concat(nextPage);
    }
    return data;
});
const cherryPickRunner = ({ enterprise }) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    const githubClient = new githubClient_1.default({ enterprise });
    const client = githubClient.client;
    const results = yield getIssues(client, '1');
    // sort by closed date ASC
    results.sort((a, b) => {
        return new Date(a.closed_at).getTime() - new Date(b.closed_at).getTime();
    });
    let commands = '';
    console.log('--------------------------------------------------------------------');
    console.log('Printing PRs with cherry-pick-needed, in ASC merge date order');
    console.log('--------------------------------------------------------------------');
    for (const item of results) {
        if (!item.milestone) {
            console.log(item.number + ' missing milestone!');
            continue;
        }
        const issueDetails = yield client.get(item.pull_request.url);
        if (!issueDetails.data.merged) {
            continue;
        }
        console.log(`* ${item.title}, (#${item.number}), merge-sha: ${issueDetails.data.merge_commit_sha}`);
        commands += `git cherry-pick -x ${issueDetails.data.merge_commit_sha}\n`;
    }
    console.log('--------------------------------------------------------------------');
    console.log('Commands (in order of how they should be executed)');
    console.log('--------------------------------------------------------------------');
    console.log(commands);
});
exports.cherryPickTask = new task_1.Task('Cherry pick task', cherryPickRunner);
//# sourceMappingURL=cherrypick.js.map