!function(global,factory){"object"==typeof exports&&"undefined"!=typeof module?factory(exports,require("@monaco-editor/loader"),require("react"),require("prop-types")):"function"==typeof define&&define.amd?define(["exports","@monaco-editor/loader","react","prop-types"],factory):factory((global="undefined"!=typeof globalThis?globalThis:global||self).monaco_react={},global.monaco_loader,global.React,global.PropTypes)}(this,(function(exports,loader,React,PropTypes){"use strict";function _interopDefaultLegacy(e){return e&&"object"==typeof e&&"default"in e?e:{default:e}}var loader__default=_interopDefaultLegacy(loader),React__default=_interopDefaultLegacy(React),PropTypes__default=_interopDefaultLegacy(PropTypes);function _extends(){return(_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source)Object.prototype.hasOwnProperty.call(source,key)&&(target[key]=source[key])}return target}).apply(this,arguments)}const loadingStyles={display:"flex",height:"100%",width:"100%",justifyContent:"center",alignItems:"center"};function Loading({content:content}){return React__default.default.createElement("div",{style:loadingStyles},content)}const styles_wrapper={display:"flex",position:"relative",textAlign:"initial"},styles_fullWidth={width:"100%"},styles_hide={display:"none"};function MonacoContainer({width:width,height:height,isEditorReady:isEditorReady,loading:loading,_ref:_ref,className:className,wrapperProps:wrapperProps}){return React__default.default.createElement("section",_extends({style:{...styles_wrapper,width:width,height:height}},wrapperProps),!isEditorReady&&React__default.default.createElement(Loading,{content:loading}),React__default.default.createElement("div",{ref:_ref,style:{...styles_fullWidth,...!isEditorReady&&styles_hide},className:className}))}MonacoContainer.propTypes={width:PropTypes__default.default.oneOfType([PropTypes__default.default.number,PropTypes__default.default.string]).isRequired,height:PropTypes__default.default.oneOfType([PropTypes__default.default.number,PropTypes__default.default.string]).isRequired,loading:PropTypes__default.default.oneOfType([PropTypes__default.default.element,PropTypes__default.default.string]).isRequired,isEditorReady:PropTypes__default.default.bool.isRequired,className:PropTypes__default.default.string,wrapperProps:PropTypes__default.default.object};var MonacoContainer$1=React.memo(MonacoContainer);function useMount(effect){React.useEffect(effect,[])}function useUpdate(effect,deps,applyChanges=!0){const isInitialMount=React.useRef(!0);React.useEffect(isInitialMount.current||!applyChanges?()=>{isInitialMount.current=!1}:effect,deps)}function noop(){}function getOrCreateModel(monaco,value,language,path){return function(monaco,path){return monaco.editor.getModel(createModelUri(monaco,path))}(monaco,path)||function(monaco,value,language,path){return monaco.editor.createModel(value,language,path&&createModelUri(monaco,path))}(monaco,value,language,path)}function createModelUri(monaco,path){return monaco.Uri.parse(path)}function DiffEditor({original:original,modified:modified,language:language,originalLanguage:originalLanguage,modifiedLanguage:modifiedLanguage,originalModelPath:originalModelPath,modifiedModelPath:modifiedModelPath,keepCurrentOriginalModel:keepCurrentOriginalModel,keepCurrentModifiedModel:keepCurrentModifiedModel,theme:theme,loading:loading,options:options,height:height,width:width,className:className,wrapperProps:wrapperProps,beforeMount:beforeMount,onMount:onMount}){const[isEditorReady,setIsEditorReady]=React.useState(!1),[isMonacoMounting,setIsMonacoMounting]=React.useState(!0),editorRef=React.useRef(null),monacoRef=React.useRef(null),containerRef=React.useRef(null),onMountRef=React.useRef(onMount),beforeMountRef=React.useRef(beforeMount);useMount((()=>{const cancelable=loader__default.default.init();return cancelable.then((monaco=>(monacoRef.current=monaco)&&setIsMonacoMounting(!1))).catch((error=>"cancelation"!==(null==error?void 0:error.type)&&console.error("Monaco initialization: error:",error))),()=>editorRef.current?function(){const models=editorRef.current.getModel();var _models$original,_models$modified;keepCurrentOriginalModel||null===(_models$original=models.original)||void 0===_models$original||_models$original.dispose();keepCurrentModifiedModel||null===(_models$modified=models.modified)||void 0===_models$modified||_models$modified.dispose();editorRef.current.dispose()}():cancelable.cancel()})),useUpdate((()=>{const modifiedEditor=editorRef.current.getModifiedEditor();modifiedEditor.getOption(monacoRef.current.editor.EditorOption.readOnly)?modifiedEditor.setValue(modified):modified!==modifiedEditor.getValue()&&(modifiedEditor.executeEdits("",[{range:modifiedEditor.getModel().getFullModelRange(),text:modified,forceMoveMarkers:!0}]),modifiedEditor.pushUndoStop())}),[modified],isEditorReady),useUpdate((()=>{editorRef.current.getModel().original.setValue(original)}),[original],isEditorReady),useUpdate((()=>{const{original:original,modified:modified}=editorRef.current.getModel();monacoRef.current.editor.setModelLanguage(original,originalLanguage||language),monacoRef.current.editor.setModelLanguage(modified,modifiedLanguage||language)}),[language,originalLanguage,modifiedLanguage],isEditorReady),useUpdate((()=>{monacoRef.current.editor.setTheme(theme)}),[theme],isEditorReady),useUpdate((()=>{editorRef.current.updateOptions(options)}),[options],isEditorReady);const setModels=React.useCallback((()=>{beforeMountRef.current(monacoRef.current);const originalModel=getOrCreateModel(monacoRef.current,original,originalLanguage||language,originalModelPath),modifiedModel=getOrCreateModel(monacoRef.current,modified,modifiedLanguage||language,modifiedModelPath);editorRef.current.setModel({original:originalModel,modified:modifiedModel})}),[language,modified,modifiedLanguage,original,originalLanguage,originalModelPath,modifiedModelPath]),createEditor=React.useCallback((()=>{editorRef.current=monacoRef.current.editor.createDiffEditor(containerRef.current,{automaticLayout:!0,...options}),setModels(),monacoRef.current.editor.setTheme(theme),setIsEditorReady(!0)}),[options,theme,setModels]);return React.useEffect((()=>{isEditorReady&&onMountRef.current(editorRef.current,monacoRef.current)}),[isEditorReady]),React.useEffect((()=>{!isMonacoMounting&&!isEditorReady&&createEditor()}),[isMonacoMounting,isEditorReady,createEditor]),React__default.default.createElement(MonacoContainer$1,{width:width,height:height,isEditorReady:isEditorReady,loading:loading,_ref:containerRef,className:className,wrapperProps:wrapperProps})}DiffEditor.propTypes={original:PropTypes__default.default.string,modified:PropTypes__default.default.string,language:PropTypes__default.default.string,originalLanguage:PropTypes__default.default.string,modifiedLanguage:PropTypes__default.default.string,originalModelPath:PropTypes__default.default.string,modifiedModelPath:PropTypes__default.default.string,keepCurrentOriginalModel:PropTypes__default.default.bool,keepCurrentModifiedModel:PropTypes__default.default.bool,theme:PropTypes__default.default.string,loading:PropTypes__default.default.oneOfType([PropTypes__default.default.element,PropTypes__default.default.string]),options:PropTypes__default.default.object,width:PropTypes__default.default.oneOfType([PropTypes__default.default.number,PropTypes__default.default.string]),height:PropTypes__default.default.oneOfType([PropTypes__default.default.number,PropTypes__default.default.string]),className:PropTypes__default.default.string,wrapperProps:PropTypes__default.default.object,beforeMount:PropTypes__default.default.func,onMount:PropTypes__default.default.func},DiffEditor.defaultProps={theme:"light",loading:"Loading...",options:{},keepCurrentOriginalModel:!1,keepCurrentModifiedModel:!1,width:"100%",height:"100%",wrapperProps:{},beforeMount:noop,onMount:noop};var index=React.memo(DiffEditor);const viewStates=new Map;function Editor({defaultValue:defaultValue,defaultLanguage:defaultLanguage,defaultPath:defaultPath,value:value,language:language,path:path,theme:theme,line:line,loading:loading,options:options,overrideServices:overrideServices,saveViewState:saveViewState,keepCurrentModel:keepCurrentModel,width:width,height:height,className:className,wrapperProps:wrapperProps,beforeMount:beforeMount,onMount:onMount,onChange:onChange,onValidate:onValidate}){const[isEditorReady,setIsEditorReady]=React.useState(!1),[isMonacoMounting,setIsMonacoMounting]=React.useState(!0),monacoRef=React.useRef(null),editorRef=React.useRef(null),containerRef=React.useRef(null),onMountRef=React.useRef(onMount),beforeMountRef=React.useRef(beforeMount),subscriptionRef=React.useRef(null),valueRef=React.useRef(value),previousPath=function(value){const ref=React.useRef();return React.useEffect((()=>{ref.current=value}),[value]),ref.current}(path);useMount((()=>{const cancelable=loader__default.default.init();return cancelable.then((monaco=>(monacoRef.current=monaco)&&setIsMonacoMounting(!1))).catch((error=>"cancelation"!==(null==error?void 0:error.type)&&console.error("Monaco initialization: error:",error))),()=>editorRef.current?function(){var _subscriptionRef$curr2,_editorRef$current$ge2;null===(_subscriptionRef$curr2=subscriptionRef.current)||void 0===_subscriptionRef$curr2||_subscriptionRef$curr2.dispose(),keepCurrentModel?saveViewState&&viewStates.set(path,editorRef.current.saveViewState()):null===(_editorRef$current$ge2=editorRef.current.getModel())||void 0===_editorRef$current$ge2||_editorRef$current$ge2.dispose();editorRef.current.dispose()}():cancelable.cancel()})),useUpdate((()=>{const model=getOrCreateModel(monacoRef.current,defaultValue||value,defaultLanguage||language,path);model!==editorRef.current.getModel()&&(saveViewState&&viewStates.set(previousPath,editorRef.current.saveViewState()),editorRef.current.setModel(model),saveViewState&&editorRef.current.restoreViewState(viewStates.get(path)))}),[path],isEditorReady),useUpdate((()=>{editorRef.current.updateOptions(options)}),[options],isEditorReady),useUpdate((()=>{editorRef.current.getOption(monacoRef.current.editor.EditorOption.readOnly)?editorRef.current.setValue(value):value!==editorRef.current.getValue()&&(editorRef.current.executeEdits("",[{range:editorRef.current.getModel().getFullModelRange(),text:value,forceMoveMarkers:!0}]),editorRef.current.pushUndoStop())}),[value],isEditorReady),useUpdate((()=>{monacoRef.current.editor.setModelLanguage(editorRef.current.getModel(),language)}),[language],isEditorReady),useUpdate((()=>{void 0!==line&&editorRef.current.revealLine(line)}),[line],isEditorReady),useUpdate((()=>{monacoRef.current.editor.setTheme(theme)}),[theme],isEditorReady);const createEditor=React.useCallback((()=>{beforeMountRef.current(monacoRef.current);const autoCreatedModelPath=path||defaultPath,defaultModel=getOrCreateModel(monacoRef.current,value||defaultValue,defaultLanguage||language,autoCreatedModelPath);editorRef.current=monacoRef.current.editor.create(containerRef.current,{model:defaultModel,automaticLayout:!0,...options},overrideServices),saveViewState&&editorRef.current.restoreViewState(viewStates.get(autoCreatedModelPath)),monacoRef.current.editor.setTheme(theme),setIsEditorReady(!0)}),[defaultValue,defaultLanguage,defaultPath,value,language,path,options,overrideServices,saveViewState,theme]);return React.useEffect((()=>{isEditorReady&&onMountRef.current(editorRef.current,monacoRef.current)}),[isEditorReady]),React.useEffect((()=>{!isMonacoMounting&&!isEditorReady&&createEditor()}),[isMonacoMounting,isEditorReady,createEditor]),valueRef.current=value,React.useEffect((()=>{var _subscriptionRef$curr,_editorRef$current;isEditorReady&&onChange&&(null===(_subscriptionRef$curr=subscriptionRef.current)||void 0===_subscriptionRef$curr||_subscriptionRef$curr.dispose(),subscriptionRef.current=null===(_editorRef$current=editorRef.current)||void 0===_editorRef$current?void 0:_editorRef$current.onDidChangeModelContent((event=>{const editorValue=editorRef.current.getValue();valueRef.current!==editorValue&&onChange(editorValue,event)})))}),[isEditorReady,onChange]),React.useEffect((()=>{if(isEditorReady){const changeMarkersListener=monacoRef.current.editor.onDidChangeMarkers((uris=>{var _editorRef$current$ge;const editorUri=null===(_editorRef$current$ge=editorRef.current.getModel())||void 0===_editorRef$current$ge?void 0:_editorRef$current$ge.uri;if(editorUri){if(uris.find((uri=>uri.path===editorUri.path))){const markers=monacoRef.current.editor.getModelMarkers({resource:editorUri});null==onValidate||onValidate(markers)}}}));return()=>{null==changeMarkersListener||changeMarkersListener.dispose()}}}),[isEditorReady,onValidate]),React__default.default.createElement(MonacoContainer$1,{width:width,height:height,isEditorReady:isEditorReady,loading:loading,_ref:containerRef,className:className,wrapperProps:wrapperProps})}Editor.propTypes={defaultValue:PropTypes__default.default.string,defaultPath:PropTypes__default.default.string,defaultLanguage:PropTypes__default.default.string,value:PropTypes__default.default.string,language:PropTypes__default.default.string,path:PropTypes__default.default.string,theme:PropTypes__default.default.string,line:PropTypes__default.default.number,loading:PropTypes__default.default.oneOfType([PropTypes__default.default.element,PropTypes__default.default.string]),options:PropTypes__default.default.object,overrideServices:PropTypes__default.default.object,saveViewState:PropTypes__default.default.bool,keepCurrentModel:PropTypes__default.default.bool,width:PropTypes__default.default.oneOfType([PropTypes__default.default.number,PropTypes__default.default.string]),height:PropTypes__default.default.oneOfType([PropTypes__default.default.number,PropTypes__default.default.string]),className:PropTypes__default.default.string,wrapperProps:PropTypes__default.default.object,beforeMount:PropTypes__default.default.func,onMount:PropTypes__default.default.func,onChange:PropTypes__default.default.func,onValidate:PropTypes__default.default.func},Editor.defaultProps={theme:"light",loading:"Loading...",options:{},overrideServices:{},saveViewState:!0,keepCurrentModel:!1,width:"100%",height:"100%",wrapperProps:{},beforeMount:noop,onMount:noop,onValidate:noop};var index$1=React.memo(Editor);Object.defineProperty(exports,"loader",{enumerable:!0,get:function(){return loader__default.default}}),exports.DiffEditor=index,exports.default=index$1,exports.useMonaco=function(){const[monaco,setMonaco]=React.useState(loader__default.default.__getMonacoInstance());return useMount((()=>{let cancelable;return monaco||(cancelable=loader__default.default.init(),cancelable.then((monaco=>{setMonaco(monaco)}))),()=>{var _cancelable;return null===(_cancelable=cancelable)||void 0===_cancelable?void 0:_cancelable.cancel()}})),monaco},Object.defineProperty(exports,"__esModule",{value:!0})}));
