/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.OIDMap;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;

public class HoldInstructionExtension
extends Extension
implements CertAttrSet {
    private static final long serialVersionUID = -6706557233070964984L;
    public static final String NAME = "HoldInstruction";
    public static final String HOLD_INSTRUCTION = "value";
    public static final String OID = "2.5.29.23";
    public static final String NONE_HOLD_INSTR_OID_STR = "1.2.840.10040.2.1";
    public static final ObjectIdentifier NONE_HOLD_INSTR_OID = new ObjectIdentifier("1.2.840.10040.2.1");
    public static final String CALL_ISSUER_HOLD_INSTR_OID_STR = "1.2.840.10040.2.2";
    public static final ObjectIdentifier CALL_ISSUER_HOLD_INSTR_OID = new ObjectIdentifier("1.2.840.10040.2.2");
    public static final String REJECT_HOLD_INSTR_OID_STR = "1.2.840.10040.2.3";
    public static final ObjectIdentifier REJECT_HOLD_INSTR_OID = new ObjectIdentifier("1.2.840.10040.2.3");
    private ObjectIdentifier[] holdInstructionCodeOIDs = new ObjectIdentifier[]{NONE_HOLD_INSTR_OID, CALL_ISSUER_HOLD_INSTR_OID, REJECT_HOLD_INSTR_OID};
    private ObjectIdentifier holdInstructionCodeOID = null;
    private String[] holdInstructionDescription = new String[]{"None", "Call Issuer", "Reject"};

    private int getHoldInstructionCodeFromOID(ObjectIdentifier oid) {
        for (int i = 0; i < this.holdInstructionCodeOIDs.length; ++i) {
            if (!oid.equals(this.holdInstructionCodeOIDs[i])) continue;
            return i + 1;
        }
        return 0;
    }

    private String getHoldInstructionDescription(ObjectIdentifier oid) {
        int i;
        String description = "Invalid";
        if (oid != null && (i = this.getHoldInstructionCodeFromOID(oid)) > 0 && i < 4) {
            description = this.holdInstructionDescription[i - 1];
        }
        return description;
    }

    private void encodeThis() throws IOException {
        if (this.holdInstructionCodeOID == null) {
            throw new IOException("Unintialized hold instruction extension");
        }
        try (DerOutputStream os = new DerOutputStream();){
            os.putOID(this.holdInstructionCodeOID);
            this.extensionValue = os.toByteArray();
        }
    }

    public HoldInstructionExtension(int code) throws IOException {
        if (code < 1 || code > 3) {
            throw new IOException("Invalid hold instruction code");
        }
        this.holdInstructionCodeOID = this.holdInstructionCodeOIDs[code - 1];
        this.extensionId = PKIXExtensions.HoldInstructionCode_Id;
        this.critical = false;
        this.encodeThis();
    }

    public HoldInstructionExtension(String oidStr) throws IOException {
        ObjectIdentifier oid = new ObjectIdentifier(oidStr);
        if (this.getHoldInstructionCodeFromOID(oid) == 0) {
            throw new IOException("Invalid hold instruction code");
        }
        this.holdInstructionCodeOID = oid;
        this.extensionId = PKIXExtensions.HoldInstructionCode_Id;
        this.critical = false;
        this.encodeThis();
    }

    public HoldInstructionExtension(ObjectIdentifier oid) throws IOException {
        if (this.getHoldInstructionCodeFromOID(oid) == 0) {
            throw new IOException("Invalid hold instruction code");
        }
        this.holdInstructionCodeOID = oid;
        this.extensionId = PKIXExtensions.HoldInstructionCode_Id;
        this.critical = false;
        this.encodeThis();
    }

    public HoldInstructionExtension(Boolean critical, int code) throws IOException {
        if (code < 1 || code > 3) {
            throw new IOException("Invalid hold instruction code");
        }
        this.holdInstructionCodeOID = this.holdInstructionCodeOIDs[code - 1];
        this.extensionId = PKIXExtensions.HoldInstructionCode_Id;
        this.critical = critical;
        this.encodeThis();
    }

    public HoldInstructionExtension(Boolean critical, String oidStr) throws IOException {
        ObjectIdentifier oid = new ObjectIdentifier(oidStr);
        if (this.getHoldInstructionCodeFromOID(oid) == 0) {
            throw new IOException("Invalid hold instruction code");
        }
        this.holdInstructionCodeOID = oid;
        this.extensionId = PKIXExtensions.HoldInstructionCode_Id;
        this.critical = critical;
        this.encodeThis();
    }

    public HoldInstructionExtension(Boolean critical, ObjectIdentifier oid) throws IOException {
        if (this.getHoldInstructionCodeFromOID(oid) == 0) {
            throw new IOException("Invalid hold instruction code");
        }
        this.holdInstructionCodeOID = oid;
        this.extensionId = PKIXExtensions.HoldInstructionCode_Id;
        this.critical = critical;
        this.encodeThis();
    }

    public HoldInstructionExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = PKIXExtensions.HoldInstructionCode_Id;
        this.critical = critical;
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        for (int i = 0; i < len; ++i) {
            extValue[i] = Array.getByte(value, i);
        }
        this.extensionValue = extValue;
        DerValue val = new DerValue(extValue);
        if (val.tag == 6) {
            DerInputStream derInputStream = new DerInputStream(val.toByteArray());
            this.holdInstructionCodeOID = derInputStream.getOID();
            if (this.getHoldInstructionCodeFromOID(this.holdInstructionCodeOID) == 0) {
                throw new IOException("Invalid encoding for HoldInstructionExtension");
            }
        } else {
            throw new IOException("Invalid encoding for HoldInstructionExtension");
        }
    }

    public ObjectIdentifier getHoldInstructionCode() {
        return this.holdInstructionCodeOID;
    }

    public String getHoldInstructionCodeDescription() {
        return this.getHoldInstructionDescription(this.holdInstructionCodeOID);
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (name.equalsIgnoreCase(HOLD_INSTRUCTION)) {
            if (!(obj instanceof ObjectIdentifier)) {
                throw new IOException("Attribute must be of type String.");
            }
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:HoldInstructionCode.");
        }
        this.holdInstructionCodeOID = (ObjectIdentifier)obj;
    }

    @Override
    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(HOLD_INSTRUCTION)) {
            return this.holdInstructionCodeOID;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:HoldInstructionCode.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (!name.equalsIgnoreCase(HOLD_INSTRUCTION)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:HoldInstructionCode.");
        }
        this.holdInstructionCodeOID = null;
    }

    @Override
    public String toString() {
        String s = super.toString() + "Hold Instruction Code: " + this.getHoldInstructionDescription(this.holdInstructionCodeOID) + "\n";
        return s;
    }

    @Override
    public void decode(InputStream in) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.HoldInstructionCode_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        Vector<String> elements = new Vector<String>();
        elements.addElement(HOLD_INSTRUCTION);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }

    static {
        try {
            OIDMap.addAttribute(HoldInstructionExtension.class.getName(), OID, NAME);
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
    }
}

