/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.Enumeration;
import javax.crypto.Mac;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.mozilla.jss.pkcs11.PK11Cert;
import org.mozilla.jss.provider.javax.crypto.JSSKeyManager;
import org.mozilla.jss.provider.javax.crypto.JSSTrustManager;

public class JSSProvider {
    public static String BASE_PACKAGE = "org.mozilla.jss.provider.";

    public static void shouldProvide(Provider p, String algo, String _type) {
        String item = (String)p.get(algo);
        assert (item != null);
        assert (item.startsWith(BASE_PACKAGE));
        assert (item.endsWith("." + _type));
    }

    public static void shouldNotProvide(Provider p, String algo) {
        assert (p.get(algo) == null);
    }

    public static void listProviders() {
        System.err.println("Providers:");
        for (Provider p : Security.getProviders()) {
            System.err.println(" - " + p);
        }
        System.err.println();
    }

    public static void main(String[] args) throws Exception {
        JSSProvider.listProviders();
        Provider p = Security.getProvider("Mozilla-JSS");
        assert (p != null);
        assert (p.getName().equals("Mozilla-JSS"));
        assert (p instanceof org.mozilla.jss.JSSProvider);
        JSSProvider.shouldNotProvide(p, "Charlie's Chocolate Factory");
        JSSProvider.shouldProvide(p, "KeyManagerFactory.NssX509", "JSSKeyManagerFactory");
        Mac m = Mac.getInstance("HmacSHA512");
        assert (m.getProvider().getName().equals(p.getName()));
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("NssX509");
        assert (kmf.getKeyManagers().length > 0);
        for (KeyManager km : kmf.getKeyManagers()) {
            System.out.println("got KeyManager: " + km);
            assert (km instanceof JSSKeyManager);
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("NssX509");
        assert (tmf.getTrustManagers().length > 0);
        for (TrustManager tm : tmf.getTrustManagers()) {
            System.out.println("got TrustManager: " + tm);
            assert (tm instanceof JSSTrustManager);
        }
        KeyStore ks = KeyStore.getInstance("PKCS11");
        ks.load(null, null);
        Enumeration<String> aliases = ks.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate cert = ks.getCertificate(alias);
            if (cert != null) assert (cert instanceof PK11Cert);
        }
    }
}

