/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import org.mozilla.jss.nss.Buffer;
import org.mozilla.jss.nss.BufferProxy;

public class TestBuffer {
    public static void TestCreateFree() {
        BufferProxy buf = Buffer.Create((long)100L);
        assert (buf != null);
        Buffer.Free((BufferProxy)buf);
    }

    public static void TestReadWrite() {
        BufferProxy buf = Buffer.Create((long)10L);
        byte[] data = new byte[]{1, 0, 2, 3};
        assert (buf != null);
        assert (Buffer.Write((BufferProxy)buf, (byte[])data) == 4L);
        byte[] out_data = Buffer.Read((BufferProxy)buf, (long)4L);
        assert (out_data.length == 4);
        assert (out_data[0] == data[0]);
        assert (out_data[1] == data[1]);
        assert (out_data[2] == data[2]);
        assert (out_data[3] == data[3]);
        Buffer.Free((BufferProxy)buf);
    }

    public static void TestCapacities() {
        BufferProxy buf = Buffer.Create((long)6L);
        byte[] data = new byte[]{0, 1, 2};
        assert (buf != null);
        assert (Buffer.Capacity((BufferProxy)buf) == 6L);
        assert (Buffer.ReadCapacity((BufferProxy)buf) == 0L);
        assert (Buffer.WriteCapacity((BufferProxy)buf) == 6L);
        assert (!Buffer.CanRead((BufferProxy)buf));
        assert (Buffer.CanWrite((BufferProxy)buf));
        assert (Buffer.Write((BufferProxy)buf, (byte[])data) == (long)data.length);
        assert (Buffer.CanRead((BufferProxy)buf));
        assert (Buffer.CanWrite((BufferProxy)buf));
        assert (Buffer.ReadCapacity((BufferProxy)buf) == 3L);
        assert (Buffer.WriteCapacity((BufferProxy)buf) == 3L);
        assert (Buffer.Write((BufferProxy)buf, (byte[])data) == (long)data.length);
        assert (Buffer.CanRead((BufferProxy)buf));
        assert (!Buffer.CanWrite((BufferProxy)buf));
        assert (Buffer.ReadCapacity((BufferProxy)buf) == 6L);
        assert (Buffer.WriteCapacity((BufferProxy)buf) == 0L);
        Buffer.Free((BufferProxy)buf);
    }

    public static void TestPutGet() {
        BufferProxy buf = Buffer.Create((long)2L);
        assert (buf != null);
        assert (Buffer.Put((BufferProxy)buf, (byte)0) == 0);
        assert (Buffer.Get((BufferProxy)buf) == 0);
        assert (Buffer.Get((BufferProxy)buf) == -1);
        assert (Buffer.Put((BufferProxy)buf, (byte)1) == 1);
        assert (Buffer.Put((BufferProxy)buf, (byte)2) == 2);
        assert (Buffer.Put((BufferProxy)buf, (byte)3) == -1);
        assert (Buffer.Get((BufferProxy)buf) == 1);
        assert (Buffer.Get((BufferProxy)buf) == 2);
        assert (Buffer.Get((BufferProxy)buf) == -1);
        Buffer.Free((BufferProxy)buf);
    }

    public static void main(String[] args) {
        System.loadLibrary("jss");
        System.out.println("Calling TestCreateFree()...");
        TestBuffer.TestCreateFree();
        System.out.println("Calling TestReadWrite()...");
        TestBuffer.TestReadWrite();
        System.out.println("Calling TestCapacities()...");
        TestBuffer.TestCapacities();
        System.out.println("Calling TestPutGet()...");
        TestBuffer.TestPutGet();
    }
}

