/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.CRLExtensions;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.OIDMap;
import org.mozilla.jss.netscape.security.x509.RevokedCertificate;
import org.mozilla.jss.netscape.security.x509.SerialNumber;
import org.mozilla.jss.netscape.security.x509.X509ExtensionException;

public class RevokedCertImpl
extends RevokedCertificate
implements Serializable {
    private static final long serialVersionUID = -3449642360223397701L;
    private SerialNumber serialNumber;
    private Date revocationDate;
    private CRLExtensions extensions = null;
    private byte[] revokedCert;
    private static final boolean isExplicit = false;

    public RevokedCertImpl() {
    }

    public RevokedCertImpl(BigInteger num, Date date) {
        this.serialNumber = new SerialNumber(num);
        this.revocationDate = date;
    }

    public RevokedCertImpl(BigInteger num, Date date, CRLExtensions crlEntryExts) {
        this.serialNumber = new SerialNumber(num);
        this.revocationDate = date;
        this.extensions = crlEntryExts;
    }

    @Override
    public byte[] getEncoded() throws CRLException {
        if (this.revokedCert == null) {
            DerOutputStream os = new DerOutputStream();
            try {
                this.encode(os);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.revokedCert = os.toByteArray();
        }
        return this.revokedCert;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return true;
    }

    public void setExtensions(CRLExtensions crlEntryExts) {
        this.extensions = crlEntryExts;
    }

    public RevokedCertImpl(byte[] revokedCert) throws CRLException, X509ExtensionException {
        try {
            DerValue derValue = new DerValue(revokedCert);
            this.parse(derValue);
        }
        catch (IOException e) {
            throw new CRLException("Parsing error: " + e.toString());
        }
    }

    public RevokedCertImpl(DerValue derValue) throws CRLException, X509ExtensionException {
        this.parse(derValue);
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null;
    }

    public void decode(InputStream inStrm) throws CRLException, X509ExtensionException {
        try {
            DerValue derValue = new DerValue(inStrm);
            this.parse(derValue);
        }
        catch (IOException e) {
            throw new CRLException("Parsing error: " + e.toString());
        }
    }

    public void encode(DerOutputStream outStrm) throws CRLException, X509ExtensionException {
        try (DerOutputStream seq = new DerOutputStream();){
            if (this.revokedCert == null) {
                DerOutputStream tmp = new DerOutputStream();
                this.serialNumber.encode(tmp);
                tmp.putUTCTime(this.revocationDate);
                if (this.extensions != null) {
                    this.extensions.encode(tmp, false);
                }
                seq.write((byte)48, tmp);
                this.revokedCert = seq.toByteArray();
            }
            outStrm.write(this.revokedCert);
        }
        catch (IOException e) {
            throw new CRLException("Encoding error: " + e.toString());
        }
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.serialNumber.getNumber().toBigInteger();
    }

    @Override
    public Date getRevocationDate() {
        return new Date(this.revocationDate.getTime());
    }

    @Override
    public CRLExtensions getExtensions() {
        return this.extensions;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(this.serialNumber.toString() + "  On: " + this.revocationDate.toString());
        if (this.extensions != null) {
            sb.append("\n");
            for (int i = 0; i < this.extensions.size(); ++i) {
                sb.append("Entry Extension[" + i + "]: " + ((Extension)this.extensions.elementAt(i)).toString());
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        LinkedHashSet<String> extSet = new LinkedHashSet<String>();
        Enumeration<Extension> e = this.extensions.getElements();
        while (e.hasMoreElements()) {
            Extension ex = e.nextElement();
            if (!ex.isCritical()) continue;
            extSet.add(ex.getExtensionId().toString());
        }
        return extSet;
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        LinkedHashSet<String> extSet = new LinkedHashSet<String>();
        Enumeration<Extension> e = this.extensions.getElements();
        while (e.hasMoreElements()) {
            Extension ex = e.nextElement();
            if (ex.isCritical()) continue;
            extSet.add(ex.getExtensionId().toString());
        }
        return extSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getExtensionValue(String oid) {
        if (this.extensions == null) {
            return null;
        }
        try (DerOutputStream out = new DerOutputStream();){
            byte[] byArray;
            ObjectIdentifier findOID;
            String extAlias = OIDMap.getName(new ObjectIdentifier(oid));
            Extension crlExt = null;
            if (extAlias == null) {
                findOID = new ObjectIdentifier(oid);
                Extension ex = null;
                Enumeration<Extension> e = this.extensions.getElements();
                while (e.hasMoreElements()) {
                    ex = e.nextElement();
                    ObjectIdentifier inCertOID = ex.getExtensionId();
                    if (!inCertOID.equals(findOID)) continue;
                    crlExt = ex;
                    break;
                }
            } else {
                crlExt = this.extensions.get(extAlias);
            }
            if (crlExt == null) {
                findOID = null;
                return findOID;
            }
            byte[] extData = crlExt.getExtensionValue();
            if (extData == null) {
                byArray = null;
                return byArray;
            }
            out.putOctetString(extData);
            byArray = out.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void parse(DerValue derVal) throws CRLException, X509ExtensionException {
        block11: {
            if (derVal.tag != 48) {
                throw new CRLException("Invalid encoded RevokedCertificate, starting sequence tag missing.");
            }
            if (derVal.data.available() == 0) {
                throw new CRLException("No data encoded for RevokedCertificates");
            }
            try {
                DerInputStream in = derVal.toDerInputStream();
                DerValue val = in.getDerValue();
                this.serialNumber = new SerialNumber(val);
            }
            catch (IOException e) {
                throw new CRLException("Parsing Serial Number error: " + e.toString());
            }
            try {
                int nextByte = derVal.data.peekByte();
                if ((byte)nextByte == 23) {
                    this.revocationDate = derVal.data.getUTCTime();
                    break block11;
                }
                if ((byte)nextByte == 24) {
                    this.revocationDate = derVal.data.getGeneralizedTime();
                    break block11;
                }
                throw new CRLException("Invalid encoding for RevokedCertificates");
            }
            catch (IOException e) {
                throw new CRLException("Parsing Revocation Date error: " + e.toString());
            }
        }
        if (derVal.data.available() == 0) {
            return;
        }
        try {
            this.extensions = new CRLExtensions(derVal.toDerInputStream());
        }
        catch (IOException e) {
            throw new CRLException("Parsing CRL Entry Extensions error: " + e.toString());
        }
    }

    private void writeObject(ObjectOutputStream stream) throws CRLException, X509ExtensionException, IOException {
        DerOutputStream dos = new DerOutputStream();
        this.encode(dos);
        dos.derEncode(stream);
    }

    private void readObject(ObjectInputStream stream) throws CRLException, X509ExtensionException {
        this.decode(stream);
    }
}

