/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.util.StringTokenizer;

public class LDAPFilter
implements Cloneable {
    private static final int DEFAULT_FILTER_LENGTH = 256;
    private String m_strFilter = null;
    private String m_strDescription;
    private int m_nScope;
    private boolean m_bIsExact;
    private String m_strMatchPattern;
    private String m_strDelimiter;
    private String m_strFilterTemplate;
    private int m_nLine;
    private String m_strSuffix;
    private String m_strPrefix;

    public LDAPFilter(String strMatchPattern, String strDelimiter, String strFilterTemplate, String strDescription, int nScope) throws IllegalArgumentException {
        this.m_strMatchPattern = this.convertMatchPattern(strMatchPattern);
        this.m_strDelimiter = strDelimiter;
        this.m_strFilterTemplate = strFilterTemplate;
        this.m_strDescription = strDescription;
        this.m_nScope = nScope;
    }

    public LDAPFilter(String strMatchPattern, String strDelimiter, String strFilterTemplate, String strDescription, String strScope) throws IllegalArgumentException {
        if (strScope.equals("base")) {
            this.m_nScope = 0;
        } else if (strScope.equals("onelevel")) {
            this.m_nScope = 1;
        } else if (strScope.equals("subtree")) {
            this.m_nScope = 2;
        }
        this.m_strMatchPattern = strMatchPattern;
        this.m_strDelimiter = strDelimiter;
        this.m_strFilterTemplate = strFilterTemplate;
        this.m_strDescription = strDescription;
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer(300);
        strBuf.append("      matchPtn: \"" + this.m_strMatchPattern + "\"\n");
        strBuf.append("      delim:    \"" + this.m_strDelimiter + "\"\n");
        strBuf.append("      filttmpl: \"" + this.m_strFilterTemplate + "\"\n");
        strBuf.append("      descript: \"" + this.m_strDescription + "\"\n");
        switch (this.m_nScope) {
            case 0: {
                strBuf.append("      scope: \"LDAPConnection.SCOPE_BASE\"\n");
                break;
            }
            case 1: {
                strBuf.append("      scope: \"LDAPConnection.SCOPE_ONE\"\n");
                break;
            }
            case 2: {
                strBuf.append("      scope: \"LDAPConnection.SCOPE_SUB\"\n");
            }
        }
        strBuf.append("      line:     \"" + this.m_nLine + "\"\n");
        strBuf.append("      FILTER:   \"" + this.m_strFilter + "\"\n");
        return strBuf.toString();
    }

    public void setupFilter(String strValue, String strPrefix, String strSuffix) {
        this.createFilterString(strValue, strPrefix, strSuffix);
    }

    public void setupFilter(String strValue) {
        this.createFilterString(strValue, null, null);
    }

    void createFilterString(String strValue, String strPrefix, String strSuffix) {
        StringTokenizer strTok = new StringTokenizer(strValue, this.m_strDelimiter);
        String[] aValues = new String[strTok.countTokens()];
        int nTokens = strTok.countTokens();
        for (int i = 0; i < nTokens; ++i) {
            aValues[i] = strTok.nextToken();
        }
        StringBuffer sbFilter = new StringBuffer(256);
        if (strPrefix != null) {
            sbFilter.append(strPrefix);
        }
        char[] cFilterTemplate = this.m_strFilterTemplate.toCharArray();
        block5: for (int i = 0; i < cFilterTemplate.length; ++i) {
            if (cFilterTemplate[i] == '%') {
                if (cFilterTemplate[++i] == 'v') {
                    if (i == cFilterTemplate.length - 1) {
                        sbFilter.append(strValue);
                        break;
                    }
                    switch (cFilterTemplate[++i]) {
                        case '$': {
                            sbFilter.append(aValues[aValues.length]);
                            break;
                        }
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            int nValue = Integer.parseInt(String.valueOf(cFilterTemplate[i]));
                            --nValue;
                            if (cFilterTemplate[++i] == '-') {
                                if (Character.isDigit(cFilterTemplate[++i])) {
                                    int nValue2 = Integer.parseInt(String.valueOf(cFilterTemplate[i]));
                                    --nValue2;
                                    for (int j = nValue; j <= nValue2; ++j) {
                                        sbFilter.append(aValues[j]);
                                        sbFilter.append(j == nValue2 ? "" : " ");
                                    }
                                    continue block5;
                                }
                                for (int j = nValue; j < aValues.length; ++j) {
                                    sbFilter.append(aValues[j]);
                                    sbFilter.append(j == aValues.length - 1 ? "" : " ");
                                }
                                sbFilter.append(cFilterTemplate[i]);
                                break;
                            }
                            sbFilter.append(aValues[nValue]);
                            sbFilter.append(cFilterTemplate[i]);
                            break;
                        }
                        default: {
                            sbFilter.append(strValue);
                            sbFilter.append(cFilterTemplate[i]);
                            break;
                        }
                    }
                    continue;
                }
                sbFilter.append("%");
                sbFilter.append(cFilterTemplate[i]);
                continue;
            }
            sbFilter.append(cFilterTemplate[i]);
        }
        if (strSuffix != null) {
            sbFilter.append(strSuffix);
        }
        this.m_strFilter = sbFilter.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    void setLine(int nLine) {
        this.m_nLine = nLine;
    }

    String convertMatchPattern(String strMatchPattern) {
        StringBuffer sb = new StringBuffer(strMatchPattern.length() + 1);
        char[] a_cMatchPattern = strMatchPattern.toCharArray();
        boolean bInBrackets = false;
        for (int i = 0; i < a_cMatchPattern.length; ++i) {
            if (a_cMatchPattern[i] == '.') {
                if (bInBrackets) {
                    sb.append("\\");
                }
            } else if (a_cMatchPattern[i] == '[') {
                bInBrackets = true;
            } else if (a_cMatchPattern[i] == ']') {
                bInBrackets = false;
            }
            sb.append(a_cMatchPattern[i]);
        }
        return sb.toString();
    }

    public String getFilter() {
        return this.m_strFilter;
    }

    public String getFilter(String strValue) {
        this.createFilterString(strValue, this.m_strPrefix, this.m_strSuffix);
        return this.m_strFilter;
    }

    public String getFilter(String strValue, String strPrefix, String strSuffix) {
        this.createFilterString(strValue, strPrefix, strSuffix);
        return this.m_strFilter;
    }

    public String getMatchPattern() {
        return this.m_strMatchPattern;
    }

    public String getDelimiter() {
        return this.m_strDelimiter;
    }

    public String getFilterTemplate() {
        return this.m_strFilterTemplate;
    }

    public String getDescription() {
        return this.m_strDescription;
    }

    public String getScope() {
        switch (this.m_nScope) {
            case 0: {
                return "base";
            }
            case 1: {
                return "onelevel";
            }
            case 2: {
                return "subtree";
            }
        }
        return "UNKNOWN!";
    }

    public String getLineNumber() {
        return Integer.toString(this.m_nLine);
    }

    public void setFilterAffixes(String strPrefix, String strSuffix) {
        this.m_strPrefix = strPrefix;
        this.m_strSuffix = strSuffix;
    }
}

