# Copyright (C) Jan 2020 Mellanox Technologies Ltd. All rights reserved.
# Copyright (c) 2021 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
#
# This software is available to you under a choice of one of two
# licenses.  You may choose to be licensed under the terms of the GNU
# General Public License (GPL) Version 2, available from the file
# COPYING in the main directory of this source tree, or the
# OpenIB.org BSD license below:
#
#     Redistribution and use in source and binary forms, with or
#     without modification, are permitted provided that the following
#     conditions are met:
#
#      - Redistributions of source code must retain the above
#        copyright notice, this list of conditions and the following
#        disclaimer.
#
#      - Redistributions in binary form must reproduce the above
#        copyright notice, this list of conditions and the following
#        disclaimer in the documentation and/or other materials
#        provided with the distribution.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
# BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
# ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.
# --


#######################################################
#
# Segment.py
# Python implementation of the Class Segment
# Generated by Enterprise Architect
# Created on:      14-Aug-2019 10:11:57 AM
# Original author: talve
#
#######################################################
from abc import ABC, abstractmethod


class Segment(ABC):
    """this class is responsible for holding segment data according to its type.
    """
    def __init__(self):
        """initialize the class by setting the class data.
        """
        self.size = 0
        self._parsed_data = []  # list of strings representing lines of parsed data

    def additional_title_info(self):
        """return index1 and index2 if exists in the segment.
        """
        return ""

    def get_size(self):
        return self.size

    @abstractmethod
    def get_data(self):
        """get the segment data.
        """
        pass

    @abstractmethod
    def get_type(self):
        """get the segment type.
        """
        pass

    def get_data_in_bytes(self):
        """This method get the segment data in a list of bytes
        include the header.
        """
        seg_bytes = []
        for dw in self.get_data():
            for byte in dw.to_bytes(4, byteorder='big'):
                seg_bytes.append(byte)
        return seg_bytes

    def add_parsed_data(self, parsed_line):
        self._parsed_data.append(parsed_line)

    def get_parsed_data(self):
        """get dictionary of parsed segment data.
        """
        return self._parsed_data
