/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"time"
)

// checks if the RpmPackageCategoryResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &RpmPackageCategoryResponse{}

// RpmPackageCategoryResponse PackageCategory serializer.
type RpmPackageCategoryResponse struct {
	PulpHref *string `json:"pulp_href,omitempty"`
	// Timestamp of creation.
	PulpCreated *time.Time `json:"pulp_created,omitempty"`
	// Category id.
	Id string `json:"id"`
	// Category name.
	Name string `json:"name"`
	// Category description.
	Description string `json:"description"`
	// Category display order.
	DisplayOrder NullableInt64 `json:"display_order"`
	// Category group list.
	GroupIds map[string]interface{} `json:"group_ids"`
	// Category description by language.
	DescByLang map[string]interface{} `json:"desc_by_lang"`
	// Category name by language.
	NameByLang map[string]interface{} `json:"name_by_lang"`
	// Category digest.
	Digest string `json:"digest"`
	AdditionalProperties map[string]interface{}
}

type _RpmPackageCategoryResponse RpmPackageCategoryResponse

// NewRpmPackageCategoryResponse instantiates a new RpmPackageCategoryResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewRpmPackageCategoryResponse(id string, name string, description string, displayOrder NullableInt64, groupIds map[string]interface{}, descByLang map[string]interface{}, nameByLang map[string]interface{}, digest string) *RpmPackageCategoryResponse {
	this := RpmPackageCategoryResponse{}
	this.Id = id
	this.Name = name
	this.Description = description
	this.DisplayOrder = displayOrder
	this.GroupIds = groupIds
	this.DescByLang = descByLang
	this.NameByLang = nameByLang
	this.Digest = digest
	return &this
}

// NewRpmPackageCategoryResponseWithDefaults instantiates a new RpmPackageCategoryResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewRpmPackageCategoryResponseWithDefaults() *RpmPackageCategoryResponse {
	this := RpmPackageCategoryResponse{}
	return &this
}

// GetPulpHref returns the PulpHref field value if set, zero value otherwise.
func (o *RpmPackageCategoryResponse) GetPulpHref() string {
	if o == nil || IsNil(o.PulpHref) {
		var ret string
		return ret
	}
	return *o.PulpHref
}

// GetPulpHrefOk returns a tuple with the PulpHref field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageCategoryResponse) GetPulpHrefOk() (*string, bool) {
	if o == nil || IsNil(o.PulpHref) {
		return nil, false
	}
	return o.PulpHref, true
}

// HasPulpHref returns a boolean if a field has been set.
func (o *RpmPackageCategoryResponse) HasPulpHref() bool {
	if o != nil && !IsNil(o.PulpHref) {
		return true
	}

	return false
}

// SetPulpHref gets a reference to the given string and assigns it to the PulpHref field.
func (o *RpmPackageCategoryResponse) SetPulpHref(v string) {
	o.PulpHref = &v
}

// GetPulpCreated returns the PulpCreated field value if set, zero value otherwise.
func (o *RpmPackageCategoryResponse) GetPulpCreated() time.Time {
	if o == nil || IsNil(o.PulpCreated) {
		var ret time.Time
		return ret
	}
	return *o.PulpCreated
}

// GetPulpCreatedOk returns a tuple with the PulpCreated field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageCategoryResponse) GetPulpCreatedOk() (*time.Time, bool) {
	if o == nil || IsNil(o.PulpCreated) {
		return nil, false
	}
	return o.PulpCreated, true
}

// HasPulpCreated returns a boolean if a field has been set.
func (o *RpmPackageCategoryResponse) HasPulpCreated() bool {
	if o != nil && !IsNil(o.PulpCreated) {
		return true
	}

	return false
}

// SetPulpCreated gets a reference to the given time.Time and assigns it to the PulpCreated field.
func (o *RpmPackageCategoryResponse) SetPulpCreated(v time.Time) {
	o.PulpCreated = &v
}

// GetId returns the Id field value
func (o *RpmPackageCategoryResponse) GetId() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *RpmPackageCategoryResponse) GetIdOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *RpmPackageCategoryResponse) SetId(v string) {
	o.Id = v
}

// GetName returns the Name field value
func (o *RpmPackageCategoryResponse) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *RpmPackageCategoryResponse) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *RpmPackageCategoryResponse) SetName(v string) {
	o.Name = v
}

// GetDescription returns the Description field value
func (o *RpmPackageCategoryResponse) GetDescription() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Description
}

// GetDescriptionOk returns a tuple with the Description field value
// and a boolean to check if the value has been set.
func (o *RpmPackageCategoryResponse) GetDescriptionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Description, true
}

// SetDescription sets field value
func (o *RpmPackageCategoryResponse) SetDescription(v string) {
	o.Description = v
}

// GetDisplayOrder returns the DisplayOrder field value
// If the value is explicit nil, the zero value for int64 will be returned
func (o *RpmPackageCategoryResponse) GetDisplayOrder() int64 {
	if o == nil || o.DisplayOrder.Get() == nil {
		var ret int64
		return ret
	}

	return *o.DisplayOrder.Get()
}

// GetDisplayOrderOk returns a tuple with the DisplayOrder field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RpmPackageCategoryResponse) GetDisplayOrderOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}
	return o.DisplayOrder.Get(), o.DisplayOrder.IsSet()
}

// SetDisplayOrder sets field value
func (o *RpmPackageCategoryResponse) SetDisplayOrder(v int64) {
	o.DisplayOrder.Set(&v)
}

// GetGroupIds returns the GroupIds field value
// If the value is explicit nil, the zero value for map[string]interface{} will be returned
func (o *RpmPackageCategoryResponse) GetGroupIds() map[string]interface{} {
	if o == nil {
		var ret map[string]interface{}
		return ret
	}

	return o.GroupIds
}

// GetGroupIdsOk returns a tuple with the GroupIds field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RpmPackageCategoryResponse) GetGroupIdsOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.GroupIds) {
		return map[string]interface{}{}, false
	}
	return o.GroupIds, true
}

// SetGroupIds sets field value
func (o *RpmPackageCategoryResponse) SetGroupIds(v map[string]interface{}) {
	o.GroupIds = v
}

// GetDescByLang returns the DescByLang field value
// If the value is explicit nil, the zero value for map[string]interface{} will be returned
func (o *RpmPackageCategoryResponse) GetDescByLang() map[string]interface{} {
	if o == nil {
		var ret map[string]interface{}
		return ret
	}

	return o.DescByLang
}

// GetDescByLangOk returns a tuple with the DescByLang field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RpmPackageCategoryResponse) GetDescByLangOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.DescByLang) {
		return map[string]interface{}{}, false
	}
	return o.DescByLang, true
}

// SetDescByLang sets field value
func (o *RpmPackageCategoryResponse) SetDescByLang(v map[string]interface{}) {
	o.DescByLang = v
}

// GetNameByLang returns the NameByLang field value
// If the value is explicit nil, the zero value for map[string]interface{} will be returned
func (o *RpmPackageCategoryResponse) GetNameByLang() map[string]interface{} {
	if o == nil {
		var ret map[string]interface{}
		return ret
	}

	return o.NameByLang
}

// GetNameByLangOk returns a tuple with the NameByLang field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RpmPackageCategoryResponse) GetNameByLangOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.NameByLang) {
		return map[string]interface{}{}, false
	}
	return o.NameByLang, true
}

// SetNameByLang sets field value
func (o *RpmPackageCategoryResponse) SetNameByLang(v map[string]interface{}) {
	o.NameByLang = v
}

// GetDigest returns the Digest field value
func (o *RpmPackageCategoryResponse) GetDigest() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Digest
}

// GetDigestOk returns a tuple with the Digest field value
// and a boolean to check if the value has been set.
func (o *RpmPackageCategoryResponse) GetDigestOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Digest, true
}

// SetDigest sets field value
func (o *RpmPackageCategoryResponse) SetDigest(v string) {
	o.Digest = v
}

func (o RpmPackageCategoryResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o RpmPackageCategoryResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.PulpHref) {
		toSerialize["pulp_href"] = o.PulpHref
	}
	if !IsNil(o.PulpCreated) {
		toSerialize["pulp_created"] = o.PulpCreated
	}
	toSerialize["id"] = o.Id
	toSerialize["name"] = o.Name
	toSerialize["description"] = o.Description
	toSerialize["display_order"] = o.DisplayOrder.Get()
	if o.GroupIds != nil {
		toSerialize["group_ids"] = o.GroupIds
	}
	if o.DescByLang != nil {
		toSerialize["desc_by_lang"] = o.DescByLang
	}
	if o.NameByLang != nil {
		toSerialize["name_by_lang"] = o.NameByLang
	}
	toSerialize["digest"] = o.Digest

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *RpmPackageCategoryResponse) UnmarshalJSON(bytes []byte) (err error) {
	varRpmPackageCategoryResponse := _RpmPackageCategoryResponse{}

	if err = json.Unmarshal(bytes, &varRpmPackageCategoryResponse); err == nil {
		*o = RpmPackageCategoryResponse(varRpmPackageCategoryResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "pulp_href")
		delete(additionalProperties, "pulp_created")
		delete(additionalProperties, "id")
		delete(additionalProperties, "name")
		delete(additionalProperties, "description")
		delete(additionalProperties, "display_order")
		delete(additionalProperties, "group_ids")
		delete(additionalProperties, "desc_by_lang")
		delete(additionalProperties, "name_by_lang")
		delete(additionalProperties, "digest")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableRpmPackageCategoryResponse struct {
	value *RpmPackageCategoryResponse
	isSet bool
}

func (v NullableRpmPackageCategoryResponse) Get() *RpmPackageCategoryResponse {
	return v.value
}

func (v *NullableRpmPackageCategoryResponse) Set(val *RpmPackageCategoryResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableRpmPackageCategoryResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableRpmPackageCategoryResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableRpmPackageCategoryResponse(val *RpmPackageCategoryResponse) *NullableRpmPackageCategoryResponse {
	return &NullableRpmPackageCategoryResponse{value: val, isSet: true}
}

func (v NullableRpmPackageCategoryResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableRpmPackageCategoryResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


